/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.solver.SolverDisposeListener;
import org.unitime.timetable.solver.exam.ExamSolver;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.jgroups.SolverContainer;
import org.unitime.timetable.solver.remote.BackupFileFilter;
import org.unitime.timetable.util.MemoryCounter;

public class ExaminationSolverContainer
implements SolverContainer<ExamSolverProxy> {
    private static Log sLog = LogFactory.getLog(ExaminationSolverContainer.class);
    protected Map<String, ExamSolver> iExamSolvers = new Hashtable<String, ExamSolver>();
    private PassivationThread iPassivation = null;

    @Override
    public Set<String> getSolvers() {
        return new HashSet<String>(this.iExamSolvers.keySet());
    }

    @Override
    public ExamSolverProxy getSolver(String user) {
        return this.iExamSolvers.get(user);
    }

    @Override
    public long getMemUsage(String user) {
        ExamSolverProxy solver = this.getSolver(user);
        return solver == null ? 0L : new MemoryCounter().estimate(solver);
    }

    @Override
    public ExamSolverProxy createSolver(String user, DataProperties config) {
        ExamSolver solver = new ExamSolver(config, new SolverOnDispose(user));
        this.iExamSolvers.put(user, solver);
        return solver;
    }

    @Override
    public void unloadSolver(String user) {
        ExamSolver solver = this.iExamSolvers.get(user);
        if (solver != null) {
            solver.dispose();
        }
    }

    @Override
    public boolean hasSolver(String user) {
        return this.iExamSolvers.containsKey(user);
    }

    @Override
    public int getUsage() {
        int ret = 0;
        for (ExamSolverProxy examSolverProxy : this.iExamSolvers.values()) {
            ++ret;
            if (!examSolverProxy.isPassivated()) {
                ++ret;
            }
            try {
                if (!examSolverProxy.isWorking()) continue;
                ++ret;
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    @Override
    public void start() throws Exception {
        this.iPassivation = new PassivationThread(ApplicationProperties.getPassivationFolder());
        this.iPassivation.start();
        File folder = ApplicationProperties.getRestoreFolder();
        if (!folder.exists() || !folder.isDirectory()) {
            return;
        }
        BackupFileFilter filter = new BackupFileFilter(SolverParameterGroup.SolverType.EXAM);
        File[] files = folder.listFiles(filter);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String user = filter.getUser(file);
            ExamSolver solver = new ExamSolver(new DataProperties(), new SolverOnDispose(user));
            if (!solver.restore(folder, user)) continue;
            if (ApplicationProperties.getPassivationFolder() != null) {
                solver.passivate(ApplicationProperties.getPassivationFolder(), user);
            }
            this.iExamSolvers.put(user, solver);
        }
    }

    @Override
    public void stop() throws Exception {
        File folder = ApplicationProperties.getRestoreFolder();
        if (folder.exists() && !folder.isDirectory()) {
            return;
        }
        folder.mkdirs();
        File[] old = folder.listFiles(new BackupFileFilter(SolverParameterGroup.SolverType.EXAM));
        for (int i = 0; i < old.length; ++i) {
            old[i].delete();
        }
        for (Map.Entry<String, ExamSolver> entry : this.iExamSolvers.entrySet()) {
            entry.getValue().backup(folder, entry.getKey());
        }
        this.iPassivation.destroy();
    }

    private class PassivationThread
    extends Thread {
        private File iFolder = null;
        public long iDelay = 30000L;
        public boolean iContinue = true;

        public PassivationThread(File folder) {
            this.iFolder = folder;
            this.setName("Passivation[Examination]");
            this.setDaemon(true);
            this.setPriority(1);
        }

        @Override
        public void run() {
            try {
                sLog.info((Object)"Solver passivation thread started.");
                while (this.iContinue) {
                    for (Map.Entry<String, ExamSolver> entry : ExaminationSolverContainer.this.iExamSolvers.entrySet()) {
                        entry.getValue().passivateIfNeeded(this.iFolder, entry.getKey());
                    }
                    try {
                        PassivationThread.sleep(this.iDelay);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                sLog.info((Object)"Solver passivation thread finished.");
            }
            catch (Exception e) {
                sLog.warn((Object)("Solver passivation thread failed, reason: " + e.getMessage()), (Throwable)e);
            }
        }

        public void destroy() {
            this.iContinue = false;
            if (this.isAlive()) {
                this.interrupt();
            }
        }
    }

    protected class SolverOnDispose
    implements SolverDisposeListener {
        String iUser = null;

        public SolverOnDispose(String user) {
            this.iUser = user;
        }

        @Override
        public void onDispose() {
            ExaminationSolverContainer.this.iExamSolvers.remove(this.iUser);
        }
    }
}

