/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.exams;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.util.HtmlUtils;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.exams.ExamsInterface;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamConflict;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.base.BasePreference;
import org.unitime.timetable.model.base.BaseRoomGroupPref;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.DistributionsTableBuilder;
import org.unitime.timetable.server.courses.SubpartDetailBackend;
import org.unitime.timetable.server.rooms.PeriodPreferencesBackend;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.JavascriptFunctions;
import org.unitime.timetable.webutil.Navigation;

@GwtRpcImplements(value=ExamsInterface.ExamDetailRequest.class)
public class ExamDetailBackend
implements GwtRpcImplementation<ExamsInterface.ExamDetailRequest, ExamsInterface.ExamDetailReponse> {
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    protected static final CourseMessages CMSG = Localization.create(CourseMessages.class);
    protected static final GwtMessages GWT = Localization.create(GwtMessages.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;

    @Override
    public ExamsInterface.ExamDetailReponse execute(ExamsInterface.ExamDetailRequest request, SessionContext context) {
        BackTracker.BackItem back;
        List<StudentAccomodation.AccommodationCounter> acc;
        ExamPeriod ep;
        Session hibSession = ExamDAO.getInstance().getSession();
        Exam exam = (Exam)ExamDAO.getInstance().get(request.getExamId(), hibSession);
        context.checkPermission(exam, Right.ExaminationDetail);
        if (exam == null) {
            throw new GwtRpcException(MSG.errorNoExamId());
        }
        if (request.getAction() == ExamsInterface.ExamDetailRequest.Action.DELETE) {
            context.checkPermission(exam, Right.ExaminationDelete);
            Transaction tx = null;
            try {
                tx = hibSession.beginTransaction();
                ChangeLog.addChange(hibSession, context, exam, ChangeLog.Source.EXAM_EDIT, ChangeLog.Operation.DELETE, exam.firstSubjectArea(), exam.firstDepartment());
                exam.deleteDependentObjects(hibSession, false);
                Iterator<ExamConflict> j = exam.getConflicts().iterator();
                while (j.hasNext()) {
                    ExamConflict conf = j.next();
                    for (Exam x : conf.getExams()) {
                        if (x.equals(exam)) continue;
                        x.getConflicts().remove(conf);
                    }
                    hibSession.remove((Object)conf);
                    j.remove();
                }
                hibSession.remove((Object)exam);
                tx.commit();
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            ExamsInterface.ExamDetailReponse response = new ExamsInterface.ExamDetailReponse();
            BackTracker.BackItem back2 = BackTracker.getBackItem(context, 2);
            if (back2 != null) {
                response.setUrl(back2.getUrl() + (back2.getUrl().indexOf(63) >= 0 ? "&" : "?") + "backId=-1&backType=PreferenceGroup");
            } else {
                response.setUrl("examinations");
            }
            return response;
        }
        BackTracker.markForBack(context, "examination?id=" + request.getExamId(), MSG.backExam(exam.getLabel()), true, false);
        ExamsInterface.ExamDetailReponse response = new ExamsInterface.ExamDetailReponse();
        response.setConfirms(JavascriptFunctions.isJsConfirm(context));
        response.setExamId(exam.getUniqueId());
        response.setExamName(exam.getLabel());
        if (exam.getName() != null && !exam.getName().isEmpty()) {
            response.addProperty(MSG.propExamName()).setText(exam.getName());
        } else {
            response.addProperty(MSG.propExamName()).setText(exam.getLabel()).addStyle("font-style: italic;");
        }
        response.addProperty(MSG.propExamType()).setText(exam.getExamType().getLabel());
        response.addProperty(MSG.propExamLength()).setText(exam.getLength());
        response.addProperty(MSG.propExamSeatingType()).setText(exam.getSeatingType() == 0 ? MSG.seatingNormal() : MSG.seatingExam());
        response.addProperty(MSG.propExamMaxRooms()).setText(exam.getMaxNbrRooms());
        response.addProperty(MSG.propExamSize()).setText(exam.getSize()).addStyle(exam.getExamSize() == null ? "font-style: italic;" : "");
        if (exam.getPrintOffset() != null && exam.getPrintOffset() != 0) {
            response.addProperty(MSG.propExamPrintOffset()).setText(exam.getPrintOffset()).add(" " + MSG.offsetUnitMinutes());
        }
        if (exam.getInstructors() != null && !exam.getInstructors().isEmpty()) {
            TableInterface table = new TableInterface();
            String nameFormat = UserProperty.NameFormat.get(context.getUser());
            for (DepartmentalInstructor instructor : new TreeSet<DepartmentalInstructor>(exam.getInstructors())) {
                TableInterface.LineInterface line = table.addLine();
                if (context.hasPermission(instructor, Right.InstructorDetail)) {
                    line.setURL("instructorDetail.action?instructorId=" + instructor.getUniqueId());
                }
                line.addCell(instructor.getName(nameFormat));
                if (instructor.getEmail() != null && !instructor.getEmail().isEmpty()) {
                    line.addCell(instructor.getEmail());
                    continue;
                }
                line.addCell();
            }
            response.addProperty(MSG.propExamInstructors()).setTable(table);
        }
        if (exam.getAvgPeriod() != null && (ep = exam.getAveragePeriod()) != null) {
            response.addProperty(MSG.propExamAvgPeriod()).setText(ep.getName());
        }
        if (CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.DisplayLastChanges))) {
            ChangeLog cl = ChangeLog.findLastChange(exam);
            if (cl != null) {
                response.addProperty(GWT.propLastChange()).add(cl.getShortLabel());
            } else {
                response.addProperty(GWT.propLastChange()).add(GWT.notApplicable()).addStyle("font-style: italic;");
            }
        }
        if (exam.getNote() != null && !exam.getNote().trim().isEmpty()) {
            response.addProperty(CMSG.propertyRequestsNotes()).setText(exam.getNote()).addStyle("white-space: pre-wrap;");
        }
        if ((acc = StudentAccomodation.getAccommodations(exam)) != null && !acc.isEmpty()) {
            TableInterface.CellInterface c = response.addProperty(MSG.propExamStudentAccommodations());
            TableInterface table = new TableInterface();
            for (StudentAccomodation.AccommodationCounter ac : acc) {
                table.addProperty(ac.getAccommodation().getName() + ":").setText(String.valueOf(ac.getCount()));
            }
            c.setTable(table);
        }
        response.setOwners(ExamDetailBackend.getOwnersTable(context, exam));
        response.setAssignment(this.getAssignmentTable(context, exam));
        response.setPreferences(this.getPreferenceTable(context, exam, Preference.Type.PERIOD, Preference.Type.ROOM_GROUP, Preference.Type.ROOM, Preference.Type.BUILDING, Preference.Type.ROOM_FEATURE));
        DistributionsTableBuilder distBuilder = new DistributionsTableBuilder(context, null, null);
        response.setDistributions(distBuilder.getDistPrefsTableForExam(exam));
        if (context.hasPermission(exam, Right.ExaminationEdit)) {
            response.addOperation("edit");
        }
        if (context.hasPermission(exam, Right.ExaminationClone)) {
            response.addOperation("clone");
        }
        if (context.hasPermission(exam, Right.DistributionPreferenceExam)) {
            if (ApplicationProperty.LegacyExamDistributions.isTrue()) {
                response.addOperation("add-distribution-legacy");
            } else {
                response.addOperation("add-distribution");
            }
        }
        if (context.hasPermission(exam, Right.ExaminationAssignment)) {
            response.addOperation("assign");
        }
        if (context.hasPermission(exam, Right.ExaminationDelete)) {
            response.addOperation("delete");
        }
        if ((back = BackTracker.getBackItem(context, 2)) != null) {
            response.addOperation("back");
            response.setBackTitle(back.getTitle());
            response.setBackUrl(back.getUrl() + (back.getUrl().indexOf(63) >= 0 ? "&" : "?") + "backId=" + exam.getUniqueId() + "&backType=PreferenceGroup");
        }
        response.setNextId(Navigation.getNext(context, Navigation.sInstructionalOfferingLevel, exam.getUniqueId()));
        response.setPreviousId(Navigation.getPrevious(context, Navigation.sInstructionalOfferingLevel, exam.getUniqueId()));
        if (response.getPreviousId() != null && context.hasPermission(response.getPreviousId(), "Exam", Right.ExaminationDetail)) {
            response.addOperation("previous");
        }
        if (response.getNextId() != null && context.hasPermission(response.getNextId(), "Exam", Right.ExaminationDetail)) {
            response.addOperation("next");
        }
        return response;
    }

    public static TableInterface getOwnersTable(SessionContext context, Exam exam) {
        TableInterface table = new TableInterface();
        table.setName(MSG.sectExamOwners());
        TableInterface.LineInterface header = table.addHeader();
        header.addCell(MSG.colExamOwnerObject());
        header.addCell(MSG.colExamOwnerType()).setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
        header.addCell(MSG.colExamOwnerTitle());
        header.addCell(MSG.colExamOwnerManager());
        header.addCell(MSG.colExamOwnerStudents()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        header.addCell(MSG.colExamOwnerLimit()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        header.addCell(MSG.colExamOwnerAssignment());
        for (TableInterface.CellInterface cell : header.getCells()) {
            cell.setClassName("WebTableHeader");
            cell.setText(cell.getText().replace("<br>", "\n"));
        }
        block7: for (ExamOwner owner : new TreeSet<ExamOwner>(exam.getOwners())) {
            TableInterface.LineInterface line = table.addLine();
            switch (owner.getOwnerType()) {
                case 3: {
                    Class_ clazz = (Class_)owner.getOwnerObject();
                    if (context.hasPermission(clazz, Right.ClassDetail)) {
                        line.setURL("classDetail.action?cid=" + clazz.getUniqueId());
                    }
                    line.addCell().setText(owner.getLabel());
                    line.addCell().setText(MSG.examTypeClass()).setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
                    String title = clazz.getSchedulePrintNote();
                    if (title == null || title.isEmpty()) {
                        title = clazz.getSchedulingSubpart().getControllingCourseOffering().getTitle();
                    }
                    line.addCell().setText(title);
                    line.addCell().setText(clazz.getManagingDept().getShortLabel());
                    line.addCell().setText(owner.countStudents()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                    line.addCell().setText(owner.getLimit()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                    if (clazz.getCommittedAssignment() != null) {
                        line.addCell().setText(clazz.getCommittedAssignment().getPlacement().getLongName(CONSTANTS.useAmPm()));
                    } else {
                        line.addCell();
                    }
                    if (!clazz.isCancelled().booleanValue()) break;
                    for (TableInterface.CellInterface cell : line.getCells()) {
                        cell.setColor("gray");
                        cell.addStyle("font-style: italic;");
                        cell.setTitle(CMSG.classNoteCancelled(clazz.getClassLabel()));
                    }
                    continue block7;
                }
                case 2: {
                    InstrOfferingConfig config = (InstrOfferingConfig)owner.getOwnerObject();
                    if (context.hasPermission(config.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                        line.setURL("instructionalOfferingDetail.action?io=" + config.getInstructionalOffering().getUniqueId());
                    }
                    line.addCell().setText(owner.getLabel());
                    line.addCell().setText(MSG.examTypeConfig()).setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
                    line.addCell().setText(config.getControllingCourseOffering().getTitle());
                    line.addCell().setText(config.getInstructionalOffering().getControllingCourseOffering().getDepartment().getShortLabel());
                    line.addCell().setText(owner.countStudents()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                    line.addCell().setText(owner.getLimit()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                    line.addCell();
                    break;
                }
                case 0: {
                    InstructionalOffering offering = (InstructionalOffering)owner.getOwnerObject();
                    if (context.hasPermission(offering, Right.InstructionalOfferingDetail)) {
                        line.setURL("instructionalOfferingDetail.action?io=" + offering.getUniqueId());
                    }
                    line.addCell().setText(owner.getLabel());
                    line.addCell().setText(MSG.examTypeOffering()).setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
                    line.addCell().setText(offering.getControllingCourseOffering().getTitle());
                    line.addCell().setText(offering.getControllingCourseOffering().getDepartment().getShortLabel());
                    line.addCell().setText(owner.countStudents()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                    line.addCell().setText(owner.getLimit()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                    line.addCell();
                    break;
                }
                case 1: {
                    CourseOffering course = (CourseOffering)owner.getOwnerObject();
                    if (context.hasPermission(course.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                        line.setURL("instructionalOfferingDetail.action?io=" + course.getInstructionalOffering().getUniqueId());
                    }
                    line.addCell().setText(owner.getLabel());
                    line.addCell().setText(MSG.examTypeCourse()).setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
                    line.addCell().setText(course.getTitle());
                    line.addCell().setText(course.getDepartment().getShortLabel());
                    line.addCell().setText(owner.countStudents()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                    line.addCell().setText(owner.getLimit()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                    line.addCell();
                }
            }
        }
        if (!table.hasLines()) {
            table.setErrorMessage(MSG.warnNoExamOwners());
        }
        return table;
    }

    public TableInterface getAssignmentTable(SessionContext context, Exam exam) {
        ExamAssignment ea = null;
        ExamAssignmentProxy examAssignment = this.examinationSolverService.getSolver();
        if (examAssignment != null && examAssignment.getExamTypeId().equals(exam.getExamType().getUniqueId())) {
            ea = examAssignment.getAssignmentInfo(exam.getUniqueId());
        } else if (exam.getAssignedPeriod() != null) {
            ea = new ExamAssignmentInfo(exam);
        }
        if (ea == null || ea.getPeriod() == null) {
            return null;
        }
        TableInterface table = new TableInterface();
        table.setName(MSG.sectExamAssignment());
        table.addProperty(MSG.propExamAssignedPeriod()).addItem(ea.getPeriodCell());
        if (!ea.getRooms().isEmpty()) {
            TableInterface.CellInterface cell = table.addProperty(ea.getRooms().size() > 1 ? MSG.propExamAssignedRooms() : MSG.propExamAssignedRoom());
            for (ExamRoomInfo room : ea.getRooms()) {
                cell.addItem(room.toCell().setInline(false));
            }
        }
        if (((ExamAssignmentInfo)ea).getNrDistributionConflicts() > 0) {
            table.addProperty(MSG.propExamViolatedDistConstraints()).setTable(((ExamAssignmentInfo)ea).generateDistributionConflictTable());
        }
        if (((ExamAssignmentInfo)ea).getHasConflicts()) {
            table.addProperty(MSG.propExamStudentConflicts()).setTable(((ExamAssignmentInfo)ea).generateConflictTable());
        }
        if (((ExamAssignmentInfo)ea).getHasInstructorConflicts()) {
            table.addProperty(MSG.propExamInstructorConflicts()).setTable(((ExamAssignmentInfo)ea).generateInstructorConflictTable());
        }
        return table;
    }

    public TableInterface getPreferenceTable(SessionContext context, Exam pg, Preference.Type ... types) {
        TableInterface table = new TableInterface();
        boolean hasNotAvailable = false;
        boolean excap = pg.getSeatingType() == 1;
        block7: for (Preference.Type type : types) {
            switch (type) {
                case ROOM_GROUP: {
                    Set roomGrouPrefs = pg.effectivePreferences(RoomGroupPref.class);
                    if (roomGrouPrefs.isEmpty()) continue block7;
                    TableInterface.CellInterface rpCell = table.addProperty(CMSG.propertyRoomGroups());
                    for (Object rp : roomGrouPrefs) {
                        TableInterface.CellInterface cell = rpCell.add(null).setInline(false);
                        if (((BasePreference)rp).getPrefLevel().getPrefId() != 4) {
                            cell.setColor(PreferenceLevel.prolog2color(((BasePreference)rp).getPrefLevel().getPrefProlog()));
                        }
                        cell.setText(((BaseRoomGroupPref)rp).getRoomGroup().getNameWithTitle());
                        String hint = HtmlUtils.htmlEscape((String)CMSG.prefTitleRoomGroup(((BasePreference)rp).getPrefLevel().getPrefName(), cell.getText()));
                        cell.setAria(CMSG.prefTitleRoomGroup(((BasePreference)rp).getPrefLevel().getPrefName(), cell.getText()));
                        cell.setMouseOver("$wnd.showGwtHint($wnd.lastMouseOverElement, '" + hint + "');");
                        cell.setMouseOut("$wnd.hideGwtHint();");
                    }
                    continue block7;
                }
                case ROOM: {
                    Object rp;
                    Set roomPrefs = pg.effectivePreferences(RoomPref.class);
                    if (roomPrefs.isEmpty()) continue block7;
                    TableInterface.CellInterface rpCell = table.addProperty(CMSG.propertyRooms());
                    rp = roomPrefs.iterator();
                    while (rp.hasNext()) {
                        RoomPref rp2 = (RoomPref)rp.next();
                        TableInterface.CellInterface cell = rpCell.add(null).setInline(false);
                        if (rp2.getPrefLevel().getPrefId() != 4) {
                            cell.setColor(PreferenceLevel.prolog2color(rp2.getPrefLevel().getPrefProlog()));
                        }
                        cell.setText(excap ? rp2.getRoom().getLabelWithExamCapacity() : rp2.getRoom().getLabelWithCapacity());
                        cell.setAria(CMSG.prefTitleRoom(rp2.getPrefLevel().getPrefName(), cell.getText()));
                        cell.setMouseOver("$wnd.showGwtRoomHint($wnd.lastMouseOverElement, '" + rp2.getRoom().getUniqueId() + "', '" + rp2.getPrefLevel().getPrefName() + " " + CMSG.prefRoom() + " {0} ({1})');");
                        cell.setMouseOut("$wnd.hideGwtRoomHint();");
                    }
                    continue block7;
                }
                case BUILDING: {
                    Set buildingPrefs = pg.effectivePreferences(BuildingPref.class);
                    if (buildingPrefs.isEmpty()) continue block7;
                    TableInterface.CellInterface rpCell = table.addProperty(CMSG.propertyBuildings());
                    for (BuildingPref rp : buildingPrefs) {
                        TableInterface.CellInterface cell = rpCell.add(null).setInline(false);
                        if (rp.getPrefLevel().getPrefId() != 4) {
                            cell.setColor(PreferenceLevel.prolog2color(rp.getPrefLevel().getPrefProlog()));
                        }
                        cell.setText(rp.getBuilding().getAbbrName());
                        cell.setAria(CMSG.prefTitleBuilding(rp.getPrefLevel().getPrefName(), cell.getText()));
                        cell.setMouseOver("$wnd.showGwtRoomHint($wnd.lastMouseOverElement, '-" + rp.getBuilding().getUniqueId() + "', '" + rp.getPrefLevel().getPrefName() + " " + CMSG.prefBuilding() + " {0}');");
                        cell.setMouseOut("$wnd.hideGwtRoomHint();");
                    }
                    continue block7;
                }
                case ROOM_FEATURE: {
                    Set roomFeaturePrefs = pg.effectivePreferences(RoomFeaturePref.class);
                    if (roomFeaturePrefs.isEmpty()) continue block7;
                    TableInterface.CellInterface rpCell = table.addProperty(CMSG.propertyRoomFeatures());
                    for (RoomFeaturePref rp : roomFeaturePrefs) {
                        TableInterface.CellInterface cell = rpCell.add(null).setInline(false);
                        if (rp.getPrefLevel().getPrefId() != 4) {
                            cell.setColor(PreferenceLevel.prolog2color(rp.getPrefLevel().getPrefProlog()));
                        }
                        cell.setText(rp.getRoomFeature().getLabelWithType());
                        cell.setAria(CMSG.prefTitleRoomFeature(rp.getPrefLevel().getPrefName(), cell.getText()));
                        String hint = HtmlUtils.htmlEscape((String)CMSG.prefTitleRoomFeature(rp.getPrefLevel().getPrefName(), cell.getText()));
                        cell.setMouseOver("$wnd.showGwtHint($wnd.lastMouseOverElement, '" + hint + "');");
                        cell.setMouseOut("$wnd.hideGwtHint();");
                    }
                    continue block7;
                }
                case PERIOD: {
                    RoomInterface.PeriodPreferenceModel model = new PeriodPreferencesBackend().loadExamPeriodPreferences(this.examinationSolverService.getSolver(), pg, pg.getExamType(), context);
                    if (model.hasNotAvailable()) {
                        hasNotAvailable = true;
                    }
                    table.addProperty(CMSG.propertyExaminationPeriods()).setPeriodPreference(model);
                }
            }
        }
        if (!table.hasProperties()) {
            return null;
        }
        table.addProperty(SubpartDetailBackend.getLegend(hasNotAvailable));
        return table;
    }
}

