/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.dao.InstructionalMethodDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=instructionalMethod]")
public class InstructionalMethods
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageInstructionalMethod(), MESSAGES.pageInstructionalMethods());
    }

    @Override
    @PreAuthorize(value="checkPermission('InstructionalMethods')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldVisible(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]));
        data.setSortBy(1);
        for (InstructionalMethod im : InstructionalMethodDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.addRecord(im.getUniqueId());
            r.setField(0, im.getReference());
            r.setField(1, im.getLabel());
            r.setField(2, im.isVisible() != false ? "true" : "false");
            int used = ((Number)hibSession.createQuery("select count(c) from InstrOfferingConfig c where c.instructionalMethod.uniqueId = :uniqueId", Number.class).setParameter("uniqueId", (Object)im.getUniqueId()).uniqueResult()).intValue();
            r.setDeletable(used == 0);
        }
        data.setEditable(context.hasPermission(Right.InstructionalMethodEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('InstructionalMethodEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (InstructionalMethod type : InstructionalMethodDAO.getInstance().findAll(hibSession)) {
            SimpleEditInterface.Record r = data.getRecord(type.getUniqueId());
            if (r == null) {
                this.delete(type, context, hibSession);
                continue;
            }
            this.update(type, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('InstructionalMethodEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        InstructionalMethod type = new InstructionalMethod();
        type.setReference(record.getField(0));
        type.setLabel(record.getField(1));
        type.setVisible("true".equals(record.getField(2)));
        hibSession.persist((Object)type);
        record.setUniqueId(type.getUniqueId());
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(InstructionalMethod type, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (type == null) {
            return;
        }
        if (ToolBox.equals((Object)type.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)type.getLabel(), (Object)record.getField(2)) && type.getVisible().booleanValue() == "true".equals(record.getField(2))) {
            return;
        }
        type.setReference(record.getField(0));
        type.setLabel(record.getField(1));
        type.setVisible("true".equals(record.getField(2)));
        hibSession.merge((Object)type);
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('InstructionalMethodEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((InstructionalMethod)InstructionalMethodDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(InstructionalMethod type, SessionContext context, Session hibSession) {
        if (type == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)type);
    }

    @Override
    @PreAuthorize(value="checkPermission('InstructionalMethodEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((InstructionalMethod)InstructionalMethodDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

