/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.io.Externalizable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparator;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.constraint.HardDistanceConflicts;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.interfaces.ExternalClassNameHelperInterface;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.advisors.AdvisorGetCourseRequests;
import org.unitime.timetable.onlinesectioning.custom.CustomClassAttendanceProvider;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseRequestsValidationHolder;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.SpecialRegistrationDashboardUrlProvider;
import org.unitime.timetable.onlinesectioning.custom.SpecialRegistrationProvider;
import org.unitime.timetable.onlinesectioning.custom.StudentEnrollmentProvider;
import org.unitime.timetable.onlinesectioning.custom.StudentHoldsCheckProvider;
import org.unitime.timetable.onlinesectioning.custom.WaitListValidationProvider;
import org.unitime.timetable.onlinesectioning.model.XClassEnrollment;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.model.XTime;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.updates.WaitlistedOnlineSectioningAction;
import org.unitime.timetable.reports.studentsct.UnasignedCourseRequests;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.solver.studentsct.StudentSolver;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;

public class GetAssignment
extends WaitlistedOnlineSectioningAction<ClassAssignmentInterface> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    private Long iStudentId;
    private List<StudentEnrollmentProvider.EnrollmentFailure> iMessages;
    private Set<ClassAssignmentInterface.ErrorMessage> iErrors;
    private boolean iIncludeRequest = false;
    private boolean iCustomCheck = false;
    private boolean iWaitListCheck = false;
    private boolean iIncludeAdvisorRequest = false;
    private boolean iCheckHolds = false;
    private boolean iGetSpecRegs = false;
    private OnlineSectioningInterface.WaitListMode iWaitListMode = null;
    private boolean iIncludeWaitListPosition = false;

    public GetAssignment forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public GetAssignment withMessages(List<StudentEnrollmentProvider.EnrollmentFailure> messages) {
        this.iMessages = messages;
        return this;
    }

    public GetAssignment withErrors(Set<ClassAssignmentInterface.ErrorMessage> errors) {
        this.iErrors = errors;
        return this;
    }

    public GetAssignment withRequest(boolean includeRequest) {
        this.iIncludeRequest = includeRequest;
        return this;
    }

    public GetAssignment withWaitListPosition(boolean includeWaitListPosition) {
        this.iIncludeWaitListPosition = includeWaitListPosition;
        return this;
    }

    public GetAssignment withAdvisorRequest(boolean includeRequest) {
        this.iIncludeAdvisorRequest = includeRequest;
        return this;
    }

    public GetAssignment withCustomCheck(boolean customCheck) {
        this.iCustomCheck = customCheck;
        return this;
    }

    public GetAssignment withWaitListCheck(boolean waitListCheck) {
        this.iWaitListCheck = waitListCheck;
        return this;
    }

    public GetAssignment checkHolds(boolean check) {
        this.iCheckHolds = check;
        return this;
    }

    public GetAssignment withSpecialRegistrations(boolean specReg) {
        this.iGetSpecRegs = specReg;
        return this;
    }

    public GetAssignment withWaitListMode(OnlineSectioningInterface.WaitListMode wlMode) {
        this.iWaitListMode = wlMode;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassAssignmentInterface execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        Object provider2;
        XStudent student = null;
        ClassAssignmentInterface ret = null;
        OnlineSectioningServer.Lock lock = server.readLock();
        try {
            student = server.getStudent(this.iStudentId);
            if (student == null) {
                ClassAssignmentInterface classAssignmentInterface = null;
                return classAssignmentInterface;
            }
            if (this.iWaitListMode == null) {
                this.iWaitListMode = student.getWaitListMode(helper);
            }
            ret = this.computeAssignment(server, helper, student, student.getRequests(), this.iMessages, this.iErrors, this.iIncludeRequest, this.iWaitListMode);
            if (this.iIncludeAdvisorRequest) {
                ret.setAdvisorRequest(AdvisorGetCourseRequests.getRequest(student, server, helper));
                ret.setAdvisorWaitListedCourseIds(student.getAdvisorWaitListedCourseIds(server));
                if (ret.hasAdvisorRequest()) {
                    for (OnlineSectioningLog.Request log : OnlineSectioningHelper.toProto(ret.getAdvisorRequest())) {
                        helper.getAction().addRecommendation(log);
                    }
                }
            }
        }
        finally {
            lock.release();
        }
        if (ret.hasRequest() && this.iCustomCheck && CustomCourseRequestsValidationHolder.hasProvider()) {
            CustomCourseRequestsValidationHolder.getProvider().check(server, helper, ret.getRequest());
        }
        if (ret.hasRequest() && this.iWaitListCheck && this.iWaitListMode == OnlineSectioningInterface.WaitListMode.WaitList && Customization.WaitListValidationProvider.hasProvider()) {
            WaitListValidationProvider wp = (WaitListValidationProvider)Customization.WaitListValidationProvider.getProvider();
            wp.check(server, helper, ret.getRequest());
        }
        if (this.iCheckHolds && ret.hasRequest() && Customization.StudentHoldsCheckProvider.hasProvider()) {
            try {
                provider2 = (StudentHoldsCheckProvider)Customization.StudentHoldsCheckProvider.getProvider();
                ret.getRequest().setErrorMessage(provider2.getStudentHoldError(server, helper, student));
            }
            catch (Exception provider2) {
                // empty catch block
            }
        }
        if (this.iCheckHolds && ret.hasRequest() && Customization.SpecialRegistrationDashboardUrlProvider.hasProvider()) {
            try {
                provider2 = (SpecialRegistrationDashboardUrlProvider)Customization.SpecialRegistrationDashboardUrlProvider.getProvider();
                ret.getRequest().setSpecRegDashboardUrl(provider2.getDashboardUrl(server, helper, student));
            }
            catch (Exception provider3) {
                // empty catch block
            }
        }
        if (this.iGetSpecRegs && Customization.SpecialRegistrationProvider.hasProvider()) {
            try {
                SpecialRegistrationProvider sp = (SpecialRegistrationProvider)Customization.SpecialRegistrationProvider.getProvider();
                ret.setSpecialRegistrations(sp.retrieveAllRegistrations(server, helper, student));
            }
            catch (Exception e) {
                helper.warn("Failed to retrieve special registrations: " + e.getMessage(), e);
            }
        }
        return ret;
    }

    public static List<CourseSection> fillUnavailabilitiesIn(ClassAssignmentInterface ret, XStudent student, OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningLog.Enrollment.Builder eb) {
        ArrayList<CourseSection> sections;
        block57: {
            List enrollments;
            block56: {
                Collection<XClassEnrollment> unavailabilities;
                if (server instanceof StudentSolver) {
                    return ((StudentSolver)server).fillUnavailabilitiesIn(ret, student.getStudentId());
                }
                if (student.getExternalId() == null || student.getExternalId().isEmpty()) {
                    return null;
                }
                sections = new ArrayList<CourseSection>();
                Collection<Long> offeringIds = server.getInstructedOfferings(student.getExternalId());
                if (offeringIds != null && !offeringIds.isEmpty()) {
                    TreeSet<XOffering> offerings = new TreeSet<XOffering>(new Comparator<XOffering>(){

                        @Override
                        public int compare(XOffering o1, XOffering o2) {
                            int cmp = o1.getName().compareTo(o2.getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return o1.getOfferingId().compareTo(o2.getOfferingId());
                        }
                    });
                    for (Long offeringId : offeringIds) {
                        XOffering offering = server.getOffering(offeringId);
                        if (offering == null) continue;
                        offerings.add(offering);
                    }
                    for (XOffering offering : offerings) {
                        ClassAssignmentInterface.CourseAssignment ca = new ClassAssignmentInterface.CourseAssignment();
                        XCourse course = offering.getControllingCourse();
                        XEnrollments enrollments2 = server.getEnrollments(offering.getOfferingId());
                        if (server.isOfferingLocked(course.getOfferingId())) {
                            ca.setLocked(true);
                        }
                        ca.setCanWaitList(offering.isWaitList());
                        ca.setAssigned(true);
                        ca.setCourseId(course.getCourseId());
                        ca.setParentCourseId(course.getParentCourseId());
                        ca.setSubject(course.getSubjectArea());
                        ca.setCourseNbr(course.getCourseNumber());
                        ca.setTitle(course.getTitle());
                        ca.setTeachingAssignment(true);
                        ca.setHasCrossList(offering.hasCrossList());
                        ca.setCanWaitList(offering.isWaitList());
                        HashSet<Long> added = new HashSet<Long>();
                        for (XConfig config : offering.getConfigs()) {
                            for (XSubpart subpart : config.getSubparts()) {
                                for (XSection section : subpart.getSections()) {
                                    if (section.isCancelled()) continue;
                                    for (XInstructor instructor : section.getAllInstructors()) {
                                        if (!student.getExternalId().equals(instructor.getExternalId()) || !added.add(section.getSectionId())) continue;
                                        if (eb != null) {
                                            eb.addSection(OnlineSectioningHelper.toProto(section, null));
                                        }
                                        ClassAssignmentInterface.ClassAssignment a = ca.addClassAssignment();
                                        a.setAlternative(false);
                                        a.setClassId(section.getSectionId());
                                        a.setSubpart(subpart.getName());
                                        a.setClassNumber(section.getName(-1L));
                                        a.setSection(section.getName(course.getCourseId()));
                                        a.setExternalId(section.getExternalId(course.getCourseId()));
                                        a.setCancelled(section.isCancelled());
                                        a.setLimit(new int[]{enrollments2.countEnrollmentsForSection(section.getSectionId()), section.getLimit()});
                                        if (section.getTime() != null) {
                                            for (DayCode d : DayCode.toDayCodes(section.getTime().getDays())) {
                                                a.addDay(d.getIndex());
                                            }
                                            a.setStart(section.getTime().getSlot());
                                            a.setLength(section.getTime().getLength());
                                            a.setBreakTime(section.getTime().getBreakTime());
                                            a.setDatePattern(section.getTime().getDatePatternName());
                                        }
                                        if (section.getRooms() != null) {
                                            for (XRoom room : section.getRooms()) {
                                                a.addRoom(room.getUniqueId(), room.getName());
                                            }
                                        }
                                        for (XInstructor instr : section.getInstructors()) {
                                            a.addInstructor(instr.getName());
                                            a.addInstructoEmail(instr.getEmail() == null ? "" : instr.getEmail());
                                        }
                                        if (section.getParentId() != null) {
                                            a.setParentSection(offering.getSection(section.getParentId()).getName(course.getCourseId()));
                                        }
                                        a.setSubpartId(section.getSubpartId());
                                        a.setHasAlternatives(false);
                                        a.addNote(course.getNote());
                                        a.addNote(section.getNote());
                                        a.setCredit(subpart.getCredit(course.getCourseId()));
                                        a.setCreditRange(Float.valueOf(subpart.getCreditMin(course.getCourseId())), Float.valueOf(subpart.getCreditMax(course.getCourseId())));
                                        Float creditOverride = section.getCreditOverride(course.getCourseId());
                                        if (creditOverride != null) {
                                            a.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                                        }
                                        a.setTeachingAssignment(true);
                                        a.setInstructing(instructor.isInstructing());
                                        sections.add(new CourseSection(course, section, instructor.isAllowOverlap(), true));
                                    }
                                }
                            }
                        }
                        ret.add(ca);
                    }
                }
                if (!server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessions", false)) break block56;
                SolverServer solverServer = SolverServerImplementation.getInstance();
                if (solverServer == null || (unavailabilities = solverServer.getUnavailabilitiesFromOtherSessions(server.getAcademicSession(), student.getExternalId())) == null) break block57;
                HashMap<Long, ClassAssignmentInterface.CourseAssignment> courses = new HashMap<Long, ClassAssignmentInterface.CourseAssignment>();
                for (XClassEnrollment e : unavailabilities) {
                    ClassAssignmentInterface.CourseAssignment course = (ClassAssignmentInterface.CourseAssignment)courses.get(e.getCourseId().getCourseId());
                    if (course == null) {
                        course = new ClassAssignmentInterface.CourseAssignment();
                        courses.put(e.getCourseId().getCourseId(), course);
                        ret.add(course);
                        course.setAssigned(true);
                        course.setCourseId(e.getCourseId().getCourseId());
                        course.setCourseNbr(e.getCourseId().getCourseNumber());
                        course.setSubject(e.getCourseId().getSubjectArea());
                        course.setTitle(e.getCourseId().getTitle());
                        course.setAssigned(true);
                        course.setTeachingAssignment(true);
                    }
                    if (eb != null) {
                        eb.addSection(OnlineSectioningHelper.toProto(e.getSection(), e.getCourseId(), null));
                    }
                    ClassAssignmentInterface.ClassAssignment a = course.addClassAssignment();
                    a.setAlternative(false);
                    a.setClassId(e.getSection().getSectionId());
                    a.setSubpart(e.getSection().getSubpartName());
                    a.setClassNumber(e.getSection().getName(-1L));
                    a.setSection(e.getSection().getName(e.getCourseId().getCourseId()));
                    a.setExternalId(e.getSection().getExternalId(e.getCourseId().getCourseId()));
                    a.setCancelled(e.getSection().isCancelled());
                    a.setLimit(new int[]{e.getEnrollment(), e.getSection().getLimit()});
                    if (e.getSection().getTime() != null) {
                        for (DayCode d : DayCode.toDayCodes(e.getSection().getTime().getDays())) {
                            a.addDay(d.getIndex());
                        }
                        a.setStart(e.getSection().getTime().getSlot());
                        a.setLength(e.getSection().getTime().getLength());
                        a.setBreakTime(e.getSection().getTime().getBreakTime());
                        a.setDatePattern(e.getSection().getTime().getDatePatternName());
                    }
                    if (e.getSection().getRooms() != null) {
                        for (XRoom room : e.getSection().getRooms()) {
                            a.addRoom(room.getUniqueId(), room.getName());
                        }
                    }
                    for (XInstructor instr : e.getSection().getInstructors()) {
                        a.addInstructor(instr.getName());
                        a.addInstructoEmail(instr.getEmail() == null ? "" : instr.getEmail());
                    }
                    if (e.getParentSectionName() != null) {
                        a.setParentSection(e.getParentSectionName());
                    }
                    a.setSubpartId(e.getSection().getSubpartId());
                    a.setHasAlternatives(false);
                    a.addNote(course.getNote());
                    a.addNote(e.getSection().getNote());
                    a.setCredit(e.getCredit());
                    a.setTeachingAssignment(true);
                    a.setEnrolledDate(e.getTimeStamp());
                    sections.add(new CourseSection(e.getCourseId(), e.getShiftedSection(), e.getSection().isAllowOverlap(), false));
                }
                break block57;
            }
            if (server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessionsUsingDatabase", false) && !(enrollments = helper.getHibSession().createQuery("select e2 from Student s1 inner join s1.session z1, StudentClassEnrollment e2 inner join e2.student s2 inner join s2.session z2 where s1.uniqueId = :studentId and s1.externalUniqueId = s2.externalUniqueId and z1 != z2 and z1.sessionBeginDateTime <= z2.classesEndDateTime and z2.sessionBeginDateTime <= z1.classesEndDateTime", StudentClassEnrollment.class).setParameter("studentId", (Object)student.getStudentId()).list()).isEmpty()) {
                HashMap<Long, ClassAssignmentInterface.CourseAssignment> courses = new HashMap<Long, ClassAssignmentInterface.CourseAssignment>();
                Comparator<StudentClassEnrollment> cmp = new Comparator<StudentClassEnrollment>(){

                    public boolean isParent(SchedulingSubpart s1, SchedulingSubpart s2) {
                        SchedulingSubpart p1 = s1.getParentSubpart();
                        if (p1 == null) {
                            return false;
                        }
                        if (p1.equals(s2)) {
                            return true;
                        }
                        return this.isParent(p1, s2);
                    }

                    @Override
                    public int compare(StudentClassEnrollment a, StudentClassEnrollment b) {
                        if (a.getCourseOffering().equals(b.getCourseOffering())) {
                            SchedulingSubpart s2;
                            SchedulingSubpart s1 = a.getClazz().getSchedulingSubpart();
                            if (this.isParent(s1, s2 = b.getClazz().getSchedulingSubpart())) {
                                return 1;
                            }
                            if (this.isParent(s2, s1)) {
                                return -1;
                            }
                            int cmp = s1.getItype().compareTo(s2.getItype());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return Double.compare(s1.getUniqueId().longValue(), s2.getUniqueId().longValue());
                        }
                        int cmp = a.getCourseOffering().getCourseName().compareTo(b.getCourseOffering().getCourseName());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return a.getCourseOffering().getUniqueId().compareTo(b.getCourseOffering().getUniqueId());
                    }
                };
                Collections.sort(enrollments, cmp);
                ExternalClassNameHelperInterface.HasGradableSubpart gs = null;
                if (ApplicationProperty.OnlineSchedulingGradableIType.isTrue() && Class_.getExternalClassNameHelper() != null && Class_.getExternalClassNameHelper() instanceof ExternalClassNameHelperInterface.HasGradableSubpart) {
                    gs = (ExternalClassNameHelperInterface.HasGradableSubpart)((Object)Class_.getExternalClassNameHelper());
                }
                CourseCreditUnitConfig credit = null;
                XCourse xc = null;
                for (StudentClassEnrollment enrollment : enrollments) {
                    Float creditOverride;
                    int maxLimit;
                    if (eb != null) {
                        eb.addSection(OnlineSectioningHelper.toProto(enrollment.getClazz(), enrollment.getCourseOffering()));
                    }
                    int shiftDays = DateUtils.daysBetween(server.getAcademicSession().getDatePatternFirstDate(), AcademicSessionInfo.getDatePatternFirstDay(enrollment.getCourseOffering().getInstructionalOffering().getSession()));
                    ClassAssignmentInterface.CourseAssignment course = (ClassAssignmentInterface.CourseAssignment)courses.get(enrollment.getCourseOffering().getUniqueId());
                    if (course == null) {
                        course = new ClassAssignmentInterface.CourseAssignment();
                        courses.put(enrollment.getCourseOffering().getUniqueId(), course);
                        ret.add(course);
                        course.setAssigned(true);
                        course.setCourseId(enrollment.getCourseOffering().getUniqueId());
                        course.setCourseNbr(enrollment.getCourseOffering().getCourseNbr());
                        course.setSubject(enrollment.getCourseOffering().getSubjectAreaAbbv());
                        course.setTitle(enrollment.getCourseOffering().getTitle());
                        course.setHasCrossList(enrollment.getCourseOffering().getInstructionalOffering().hasCrossList());
                        course.setCanWaitList(enrollment.getCourseOffering().getInstructionalOffering().effectiveWaitList());
                        course.setParentCourseId(enrollment.getCourseOffering().getParentOffering() == null ? null : enrollment.getCourseOffering().getParentOffering().getUniqueId());
                        course.setAssigned(true);
                        course.setTeachingAssignment(true);
                        credit = enrollment.getCourseOffering().getCredit();
                        xc = new XCourse(enrollment.getCourseOffering());
                    }
                    ClassAssignmentInterface.ClassAssignment clazz = course.addClassAssignment();
                    clazz.setClassId(enrollment.getClazz().getUniqueId());
                    clazz.setCourseId(enrollment.getCourseOffering().getUniqueId());
                    clazz.setCourseAssigned(true);
                    clazz.setCourseNbr(enrollment.getCourseOffering().getCourseNbr());
                    clazz.setTitle(enrollment.getCourseOffering().getTitle());
                    clazz.setSubject(enrollment.getCourseOffering().getSubjectAreaAbbv());
                    clazz.setSection(enrollment.getClazz().getClassSuffix(enrollment.getCourseOffering()));
                    if (clazz.getSection() == null) {
                        clazz.setSection(enrollment.getClazz().getSectionNumberString(helper.getHibSession()));
                    }
                    clazz.setExternalId(enrollment.getClazz().getExternalId(enrollment.getCourseOffering()));
                    clazz.setClassNumber(enrollment.getClazz().getSectionNumberString(helper.getHibSession()));
                    clazz.setSubpart(enrollment.getClazz().getSchedulingSubpart().getItypeDesc().trim());
                    if (enrollment.getClazz().getParentClass() != null) {
                        clazz.setParentSection(enrollment.getClazz().getParentClass().getClassSuffix(enrollment.getCourseOffering()));
                        if (clazz.getParentSection() == null) {
                            clazz.setParentSection(enrollment.getClazz().getParentClass().getSectionNumberString(helper.getHibSession()));
                        }
                    }
                    if (enrollment.getCourseOffering().getScheduleBookNote() != null) {
                        clazz.addNote(enrollment.getCourseOffering().getScheduleBookNote());
                    }
                    if (enrollment.getClazz().getSchedulePrintNote() != null) {
                        clazz.addNote(enrollment.getClazz().getSchedulePrintNote());
                    }
                    Placement placement = enrollment.getClazz().getCommittedAssignment() == null ? null : enrollment.getClazz().getCommittedAssignment().getPlacement();
                    int minLimit = enrollment.getClazz().getExpectedCapacity();
                    int limit = maxLimit = enrollment.getClazz().getMaxExpectedCapacity().intValue();
                    if (minLimit < maxLimit && placement != null) {
                        int roomLimit = (int)Math.floor((float)placement.getRoomSize() / (enrollment.getClazz().getRoomRatio() == null ? 1.0f : enrollment.getClazz().getRoomRatio().floatValue()));
                        limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
                    }
                    if (enrollment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue() || limit >= 9999) {
                        limit = -1;
                    }
                    clazz.setCancelled(enrollment.getClazz().isCancelled());
                    clazz.setLimit(new int[]{enrollment.getClazz().getEnrollment(), limit});
                    clazz.setEnrolledDate(enrollment.getTimestamp());
                    if (placement != null) {
                        if (placement.getTimeLocation() != null) {
                            for (DayCode d : DayCode.toDayCodes(placement.getTimeLocation().getDayCode())) {
                                clazz.addDay(d.getIndex());
                            }
                            clazz.setStart(placement.getTimeLocation().getStartSlot());
                            clazz.setLength(placement.getTimeLocation().getLength());
                            clazz.setBreakTime(placement.getTimeLocation().getBreakTime());
                            clazz.setDatePattern(XTime.datePatternName(enrollment.getClazz().getCommittedAssignment(), helper.getDatePatternFormat()));
                        }
                        if (enrollment.getClazz().getCommittedAssignment() != null) {
                            for (Location loc : enrollment.getClazz().getCommittedAssignment().getRooms()) {
                                clazz.addRoom(loc.getUniqueId(), loc.getLabelWithDisplayName());
                            }
                        }
                    } else {
                        for (RoomPref rp : enrollment.getClazz().effectivePreferences(RoomPref.class)) {
                            if (!PreferenceLevel.sRequired.equals(rp.getPrefLevel().getPrefProlog())) continue;
                            clazz.addRoom(rp.getRoom().getUniqueId(), rp.getRoom().getLabel());
                        }
                        DatePattern pattern = enrollment.getClazz().effectiveDatePattern();
                        if (pattern != null) {
                            clazz.setDatePattern(GetAssignment.datePatternName(pattern, helper.getDatePatternFormat()));
                        }
                    }
                    if (enrollment.getClazz().getDisplayInstructor().booleanValue()) {
                        for (ClassInstructor ci : enrollment.getClazz().getClassInstructors()) {
                            if (!ci.isLead().booleanValue()) continue;
                            clazz.addInstructor(helper.getInstructorNameFormat().format(ci.getInstructor()));
                            clazz.addInstructoEmail(ci.getInstructor().getEmail() == null ? "" : ci.getInstructor().getEmail());
                        }
                    }
                    if (credit != null && gs != null && gs.isGradableSubpart(enrollment.getClazz().getSchedulingSubpart(), enrollment.getCourseOffering(), helper.getHibSession())) {
                        clazz.setCredit(credit.creditAbbv() + "|" + credit.creditText());
                        clazz.setCreditRange(Float.valueOf(credit.getMinCredit()), Float.valueOf(credit.getMaxCredit()));
                        credit = null;
                    } else if (credit != null && gs == null) {
                        clazz.setCredit(credit.creditAbbv() + "|" + credit.creditText());
                        clazz.setCreditRange(Float.valueOf(credit.getMinCredit()), Float.valueOf(credit.getMaxCredit()));
                        credit = null;
                    }
                    if (enrollment.getClazz().getSchedulingSubpart().getCredit() != null) {
                        clazz.setCredit(enrollment.getClazz().getSchedulingSubpart().getCredit().creditAbbv() + "|" + enrollment.getClazz().getSchedulingSubpart().getCredit().creditText());
                        clazz.setCreditRange(Float.valueOf(enrollment.getClazz().getSchedulingSubpart().getCredit().getMinCredit()), Float.valueOf(enrollment.getClazz().getSchedulingSubpart().getCredit().getMaxCredit()));
                        credit = null;
                    }
                    if ((creditOverride = enrollment.getClazz().getCredit(enrollment.getCourseOffering())) != null) {
                        clazz.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                    }
                    if (clazz.getParentSection() == null) {
                        clazz.setParentSection(enrollment.getCourseOffering().getConsentType() == null ? null : enrollment.getCourseOffering().getConsentType().getLabel());
                    }
                    clazz.setTeachingAssignment(true);
                    XSection section = new XSection(enrollment.getClazz(), helper);
                    if (shiftDays != 0 && section.getTime() != null) {
                        section.getTime().datePatternShiftDays(shiftDays);
                    }
                    sections.add(new CourseSection(xc, section, enrollment.getClazz().getSchedulingSubpart().isStudentAllowOverlap(), false));
                }
            }
        }
        return sections;
    }

    /*
     * WARNING - void declaration
     */
    public ClassAssignmentInterface computeAssignment(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, List<XRequest> studentRequests, List<StudentEnrollmentProvider.EnrollmentFailure> messages, Set<ClassAssignmentInterface.ErrorMessage> errors, boolean includeRequest, OnlineSectioningInterface.WaitListMode wlMode) {
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_REQUEST);
        DistanceMetric m = server.getDistanceMetric();
        DistanceMetric um = server.getUnavailabilityDistanceMetric();
        OverExpectedCriterion overExp = server.getOverExpectedCriterion();
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student.getStudentId()));
        action.getStudentBuilder().setExternalId(student.getExternalId());
        action.getStudentBuilder().setName(student.getName());
        ClassAssignmentInterface ret = new ClassAssignmentInterface();
        int nrUnassignedCourses = 0;
        int nrAssignedAlt = 0;
        OnlineSectioningLog.Enrollment.Builder stored = OnlineSectioningLog.Enrollment.newBuilder();
        stored.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
        boolean setReadOnly = ApplicationProperty.OnlineSchedulingMakeAssignedRequestReadOnly.isTrue();
        if (helper.getUser() != null && helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER) {
            setReadOnly = ApplicationProperty.OnlineSchedulingMakeAssignedRequestReadOnlyIfAdmin.isTrue();
        }
        boolean showWaitListPosition = this.iIncludeWaitListPosition || ApplicationProperty.OnlineSchedulingShowWaitListPosition.isTrue();
        List<CourseSection> unavailabilities = GetAssignment.fillUnavailabilitiesIn(ret, student, server, helper, stored);
        CustomClassAttendanceProvider provider = (CustomClassAttendanceProvider)Customization.CustomClassAttendanceProvider.getProvider();
        CustomClassAttendanceProvider.StudentClassAttendance attendance = provider == null ? null : provider.getCustomClassAttendanceForStudent((Student)StudentDAO.getInstance().get(student.getStudentId(), helper.getHibSession()), helper, null);
        HashMap wlOverlaps = null;
        StudentQuality sq = new StudentQuality(server.getDistanceMetric(), server.getConfig());
        float credit = 0.0f;
        if (student.getMaxCredit() != null) {
            for (XRequest xRequest : studentRequests) {
                Float c;
                XOffering offering;
                XCourse xCourse;
                XCourseRequest r;
                XEnrollment enrollment;
                if (!(xRequest instanceof XCourseRequest) || (enrollment = (r = (XCourseRequest)xRequest).getEnrollment()) == null || (xCourse = (offering = server.getOffering(enrollment.getOfferingId())).getCourse(enrollment)) == null || (c = xCourse.getMinCredit()) == null) continue;
                credit += c.floatValue();
            }
        }
        for (XRequest xRequest : studentRequests) {
            action.addRequest(OnlineSectioningHelper.toProto(xRequest));
            ClassAssignmentInterface.CourseAssignment ca = new ClassAssignmentInterface.CourseAssignment();
            if (xRequest instanceof XCourseRequest) {
                r = (XCourseRequest)xRequest;
                XEnrollment enrollment = ((XCourseRequest)r).getEnrollment();
                XEnrollment xEnrollment = enrollment == null ? ((XCourseRequest)r).getCourseIds().get(0) : enrollment;
                XOffering offering = server.getOffering(xEnrollment.getOfferingId());
                XExpectations expectations = server.getExpectations(xEnrollment.getOfferingId());
                Iterator<DayCode> course = offering.getCourse(xEnrollment);
                if (xRequest.isAlternative() && nrAssignedAlt >= nrUnassignedCourses && enrollment == null) continue;
                if (xRequest.isAlternative() && enrollment != null) {
                    ++nrAssignedAlt;
                }
                if (server.isOfferingLocked(((XCourseId)((Object)course)).getOfferingId())) {
                    ca.setLocked(true);
                }
                ca.setCanWaitList(offering.isWaitList());
                ca.setAssigned(enrollment != null);
                ca.setCourseId(((XCourseId)((Object)course)).getCourseId());
                ca.setParentCourseId(((XCourse)((Object)course)).getParentCourseId());
                ca.setSubject(((XCourseId)((Object)course)).getSubjectArea());
                ca.setCourseNbr(((XCourseId)((Object)course)).getCourseNumber());
                ca.setTitle(((XCourseId)((Object)course)).getTitle());
                ca.setEnrollmentMessage(((XCourseRequest)r).getEnrollmentMessage());
                ca.setRequestedDate(((XCourseRequest)r).getTimeStamp());
                if (offering.isWaitList() && ((XCourseRequest)r).isWaitlist(wlMode)) {
                    ca.setWaitListedDate(((XCourseRequest)r).getWaitListedTimeStamp());
                }
                ca.setHasCrossList(offering.hasCrossList());
                if (enrollment == null) {
                    if (((XCourseRequest)r).isWaitlist(wlMode) && offering.isWaitList()) {
                        AssignmentMap assignment = new AssignmentMap();
                        CourseRequest courseRequest = SectioningRequest.convert((Assignment<Request, Enrollment>)assignment, (XCourseRequest)r, server, wlMode, helper);
                        List list = courseRequest.getEnrollmentsSkipSameTime((Assignment)assignment);
                        for (Course course2 : courseRequest.getCourses()) {
                            Object enrl22;
                            XOffering off = course2.getId() == xEnrollment.getCourseId().longValue() ? offering : server.getOffering(course2.getOffering().getId());
                            if (off == null || !off.isWaitList()) continue;
                            TreeSet<Enrollment> overlap = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                                @Override
                                public int compare(Enrollment o1, Enrollment o2) {
                                    return o1.getRequest().compareTo(o2.getRequest());
                                }
                            });
                            TreeSet<String> other = new TreeSet<String>();
                            Hashtable<CourseRequest, TreeSet<Section>> overlapingSections = new Hashtable<CourseRequest, TreeSet<Section>>();
                            Object noConfEnrl = null;
                            int nbrEnrl = 0;
                            for (Object enrl22 : list) {
                                if (!course2.equals((Object)enrl22.getCourse())) continue;
                                ++nbrEnrl;
                                boolean overlaps = false;
                                for (Request q : enrl22.getStudent().getRequests()) {
                                    if (q.equals((Object)enrl22.getRequest())) continue;
                                    Enrollment x = (Enrollment)assignment.getValue((Variable)q);
                                    if (q instanceof FreeTimeRequest) {
                                        if (!GetAssignment.isFreeTimeOverlapping((FreeTimeRequest)q, (Enrollment)enrl22)) continue;
                                        overlaps = true;
                                        overlap.add(((FreeTimeRequest)q).createEnrollment());
                                        continue;
                                    }
                                    if (x == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                                    for (SctAssignment a : x.getAssignments()) {
                                        if (!a.isOverlapping(enrl22.getAssignments()) && !HardDistanceConflicts.inConflict((StudentQuality)sq, (SctAssignment)a, (Enrollment)enrl22)) continue;
                                        overlaps = true;
                                        overlap.add(x);
                                        if (!(x.getRequest() instanceof CourseRequest)) continue;
                                        CourseRequest cr = (CourseRequest)x.getRequest();
                                        TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                                        if (ss == null) {
                                            ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator((Assignment)assignment));
                                            overlapingSections.put(cr, ss);
                                        }
                                        ss.add((Section)a);
                                    }
                                }
                                block6: for (Unavailability unavailability : courseRequest.getStudent().getUnavailabilities()) {
                                    for (SctAssignment section : enrl22.getAssignments()) {
                                        if (!HardDistanceConflicts.inConflict((StudentQuality)sq, (Section)((Section)section), (Unavailability)unavailability)) continue;
                                        overlaps = true;
                                        String ov = MSG.teachingAssignment(unavailability.getSection().getName());
                                        other.add(ov);
                                        continue block6;
                                    }
                                }
                                if (overlaps || noConfEnrl != null) continue;
                                noConfEnrl = enrl22;
                            }
                            if (noConfEnrl != null) continue;
                            if (wlOverlaps == null) {
                                wlOverlaps = new HashMap();
                            }
                            TreeSet<Object> overlaps = new TreeSet<Object>((SortedSet<Object>)other);
                            wlOverlaps.put(course2.getId(), overlaps);
                            enrl22 = overlap.iterator();
                            while (enrl22.hasNext()) {
                                Enrollment q = (Enrollment)enrl22.next();
                                if (q.getRequest() instanceof FreeTimeRequest) {
                                    String ov = OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest());
                                    overlaps.add(ov);
                                    if (course2.getId() != ((XCourseId)((Object)course)).getCourseId().longValue()) continue;
                                    ca.addOverlap(ov);
                                    continue;
                                }
                                CourseRequest cr = (CourseRequest)q.getRequest();
                                Course o = q.getCourse();
                                Object ov = MSG.course(o.getSubjectArea(), o.getCourseNumber());
                                if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                                    Iterator i = ((TreeSet)overlapingSections.get(cr)).iterator();
                                    while (i.hasNext()) {
                                        Section s = (Section)i.next();
                                        ov = (String)ov + " " + s.getSubpart().getName();
                                        if (!i.hasNext()) continue;
                                        ov = (String)ov + ",";
                                    }
                                }
                                overlaps.add(ov);
                                if (course2.getId() != ((XCourseId)((Object)course)).getCourseId().longValue()) continue;
                                ca.addOverlap((String)ov);
                            }
                            if (nbrEnrl != 0) continue;
                            enrl22 = courseRequest.getStudent().getUnavailabilities().iterator();
                            block10: while (enrl22.hasNext()) {
                                Unavailability unavailability = (Unavailability)enrl22.next();
                                for (Config config : course2.getOffering().getConfigs()) {
                                    for (Subpart subpart : config.getSubparts()) {
                                        for (Section section : subpart.getSections()) {
                                            if (!unavailability.isOverlapping((SctAssignment)section)) continue;
                                            String ov = MSG.teachingAssignment(unavailability.getSection().getName());
                                            overlaps.add(ov);
                                            if (course2.getId() != ((XCourseId)((Object)course)).getCourseId().longValue()) continue block10;
                                            ca.addOverlap(ov);
                                            continue block10;
                                        }
                                    }
                                }
                            }
                        }
                        if (student.getMaxCredit() != null) {
                            Float minCred = ((XCourse)((Object)course)).getMinCredit();
                            for (XCourseId altCourseId : ((XCourseRequest)r).getCourseIds()) {
                                XOffering altOffering;
                                XCourse altCourse;
                                Float altMinCred;
                                if (altCourseId.equals(xEnrollment) || (altMinCred = (altCourse = (altOffering = server.getOffering(altCourseId.getOfferingId())).getCourse(altCourseId)).getMinCredit()) == null || minCred != null && !(minCred.floatValue() > altMinCred.floatValue())) continue;
                                minCred = altMinCred;
                            }
                            if (minCred != null && credit + minCred.floatValue() > student.getMaxCredit().floatValue()) {
                                ca.setOverMaxCredit(student.getMaxCredit());
                            }
                        }
                    } else {
                        Object ov;
                        TreeSet<Enrollment> overlap = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                            @Override
                            public int compare(Enrollment o1, Enrollment o2) {
                                return o1.getRequest().compareTo(o2.getRequest());
                            }
                        });
                        Hashtable overlapingSections = new Hashtable();
                        AssignmentMap assignmentMap = new AssignmentMap();
                        CourseRequest crq = SectioningRequest.convert((Assignment<Request, Enrollment>)assignmentMap, (XCourseRequest)r, server, wlMode, helper);
                        List list = crq.getAvaiableEnrollmentsSkipSameTime((Assignment)assignmentMap);
                        for (Enrollment enrl : list) {
                            Object x;
                            for (Request q : enrl.getStudent().getRequests()) {
                                if (q.equals((Object)enrl.getRequest()) || (x = (Enrollment)assignmentMap.getValue((Variable)q)) == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                                for (SctAssignment a : x.getAssignments()) {
                                    if (!a.isOverlapping(enrl.getAssignments()) && !HardDistanceConflicts.inConflict((StudentQuality)sq, (SctAssignment)a, (Enrollment)enrl)) continue;
                                    overlap.add((Enrollment)x);
                                    if (!(x.getRequest() instanceof CourseRequest)) continue;
                                    CourseRequest cr = (CourseRequest)x.getRequest();
                                    TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                                    if (ss == null) {
                                        ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator((Assignment)assignmentMap));
                                        overlapingSections.put(cr, ss);
                                    }
                                    ss.add((Section)a);
                                }
                            }
                            block18: for (Unavailability unavailability : crq.getStudent().getUnavailabilities()) {
                                x = enrl.getAssignments().iterator();
                                while (x.hasNext()) {
                                    SctAssignment section = (SctAssignment)x.next();
                                    if (!HardDistanceConflicts.inConflict((StudentQuality)sq, (Section)((Section)section), (Unavailability)unavailability)) continue;
                                    String ov2 = MSG.teachingAssignment(unavailability.getSection().getName());
                                    ca.addOverlap(ov2);
                                    continue block18;
                                }
                            }
                        }
                        for (Enrollment q : overlap) {
                            if (q.getRequest() instanceof FreeTimeRequest) {
                                ca.addOverlap(OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest()));
                                continue;
                            }
                            CourseRequest cr = (CourseRequest)q.getRequest();
                            Course o = q.getCourse();
                            ov = MSG.course(o.getSubjectArea(), o.getCourseNumber());
                            if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                                Iterator i = ((TreeSet)overlapingSections.get(cr)).iterator();
                                while (i.hasNext()) {
                                    Section s = (Section)i.next();
                                    ov = ov + " " + s.getSubpart().getName();
                                    if (!i.hasNext()) continue;
                                    ov = (String)ov + ",";
                                }
                            }
                            ca.addOverlap((String)ov);
                        }
                        block22: for (Unavailability unavailability : crq.getStudent().getUnavailabilities()) {
                            for (Config config : crq.getCourse(((XCourseId)((Object)course)).getCourseId().longValue()).getOffering().getConfigs()) {
                                for (Subpart subpart : config.getSubparts()) {
                                    for (Section section : subpart.getSections()) {
                                        if (section.getLimit() <= 0 || !unavailability.isOverlapping((SctAssignment)section)) continue;
                                        ca.addOverlap(MSG.teachingAssignment(unavailability.getSection().getName()));
                                        continue block22;
                                    }
                                }
                            }
                        }
                        if (list.isEmpty()) {
                            ca.setNotAvailable(true);
                            int offeringLimit = offering.getLimit();
                            if (offeringLimit >= 0 || ((XCourse)((Object)course)).getLimit() >= 0) {
                                Collection<XCourseRequest> requests = server.getRequests(((XCourseId)((Object)course)).getOfferingId());
                                int courseEnrl = 0;
                                int offerEnrl = 0;
                                if (requests != null) {
                                    ov = requests.iterator();
                                    while (ov.hasNext()) {
                                        XCourseRequest x = (XCourseRequest)ov.next();
                                        if (x.getEnrollment() != null && x.getEnrollment().getCourseId().equals(((XCourseId)((Object)course)).getCourseId())) {
                                            ++courseEnrl;
                                        }
                                        if (x.getEnrollment() == null || !x.getEnrollment().getOfferingId().equals(((XCourseId)((Object)course)).getOfferingId())) continue;
                                        ++offerEnrl;
                                    }
                                }
                                ca.setFull(offeringLimit >= 0 && offerEnrl >= offeringLimit || ((XCourse)((Object)course)).getLimit() >= 0 && courseEnrl >= ((XCourse)((Object)course)).getLimit());
                                if (ca.isFull() && ApplicationProperty.OnlineSchedulingFullCanRequestOverride.isTrue()) {
                                    ca.setCanRequestOverride(((XCourse)((Object)course)).areSpaceConflictOverridesAllowed());
                                }
                            }
                            ca.setHasIncompReqs(SectioningRequest.hasInconsistentRequirements(crq, ((XCourseId)((Object)course)).getCourseId()));
                            ca.setConflictMessage(UnasignedCourseRequests.getNoAvailableMessage(crq, (Assignment<Request, Enrollment>)assignmentMap));
                        }
                        if (student.getMaxCredit() != null) {
                            Float minCred = ((XCourse)((Object)course)).getMinCredit();
                            for (XCourseId altCourseId : ((XCourseRequest)r).getCourseIds()) {
                                XOffering altOffering;
                                XCourse altCourse;
                                Float altMinCred;
                                if (altCourseId.equals(xEnrollment) || (altMinCred = (altCourse = (altOffering = server.getOffering(altCourseId.getOfferingId())).getCourse(altCourseId)).getMinCredit()) == null || minCred != null && !(minCred.floatValue() > altMinCred.floatValue())) continue;
                                minCred = altMinCred;
                            }
                            if (minCred != null && credit + minCred.floatValue() > student.getMaxCredit().floatValue()) {
                                ca.setOverMaxCredit(student.getMaxCredit());
                            }
                        }
                    }
                    if (!((XCourseRequest)r).isWaitListOrNoSub(wlMode)) {
                        // empty if block
                    }
                    int alt = ++nrUnassignedCourses;
                    for (XRequest xRequest2 : studentRequests) {
                        XEnrollment otherEnrollment;
                        if (!(xRequest2 instanceof XCourseRequest) || xRequest2.equals(xRequest) || (otherEnrollment = ((XCourseRequest)xRequest2).getEnrollment()) == null || !xRequest2.isAlternative() || --alt != 0) continue;
                        XOffering xOffering = server.getOffering(otherEnrollment.getOfferingId());
                        XCourse otherCourse = xOffering.getCourse(otherEnrollment.getCourseId());
                        ca.setInstead(MSG.course(otherCourse.getSubjectArea(), otherCourse.getCourseNumber()));
                        break;
                    }
                } else {
                    Object subpart2;
                    List<XSection> sections = offering.getSections(enrollment);
                    boolean hasAlt = false;
                    if (((XCourseRequest)r).getCourseIds().size() > 1) {
                        hasAlt = true;
                    } else if (offering.getConfigs().size() > 1) {
                        hasAlt = true;
                    } else {
                        for (Object subpart2 : offering.getConfigs().get(0).getSubparts()) {
                            if (((XSubpart)subpart2).getSections().size() <= 1) continue;
                            hasAlt = true;
                            break;
                        }
                    }
                    XEnrollments xEnrollments = server.getEnrollments(offering.getOfferingId());
                    subpart2 = sections.iterator();
                    while (subpart2.hasNext()) {
                        String consent;
                        XSection xSection = subpart2.next();
                        stored.addSection(OnlineSectioningHelper.toProto(xSection, enrollment));
                        ClassAssignmentInterface.ClassAssignment a = ca.addClassAssignment();
                        a.setAlternative(r.isAlternative());
                        a.setClassId(xSection.getSectionId());
                        Iterator<Externalizable> subpart3 = offering.getSubpart(xSection.getSubpartId());
                        a.setSubpart(((XSubpart)((Object)subpart3)).getName());
                        a.setClassNumber(xSection.getName(-1L));
                        a.setSection(xSection.getName(((XCourseId)((Object)course)).getCourseId()));
                        a.setExternalId(xSection.getExternalId(((XCourseId)((Object)course)).getCourseId()));
                        a.setCancelled(xSection.isCancelled());
                        a.setLimit(new int[]{xEnrollments.countEnrollmentsForSection(xSection.getSectionId()), xSection.getLimit()});
                        if (xSection.getTime() != null) {
                            for (DayCode d : DayCode.toDayCodes(xSection.getTime().getDays())) {
                                a.addDay(d.getIndex());
                            }
                            a.setStart(xSection.getTime().getSlot());
                            a.setLength(xSection.getTime().getLength());
                            a.setBreakTime(xSection.getTime().getBreakTime());
                            a.setDatePattern(xSection.getTime().getDatePatternName());
                        }
                        if (xSection.getRooms() != null) {
                            for (XRoom room : xSection.getRooms()) {
                                a.addRoom(room.getUniqueId(), room.getName());
                            }
                        }
                        for (XInstructor instructor : xSection.getInstructors()) {
                            a.addInstructor(instructor.getName());
                            a.addInstructoEmail(instructor.getEmail() == null ? "" : instructor.getEmail());
                        }
                        if (xSection.getParentId() != null) {
                            a.setParentSection(offering.getSection(xSection.getParentId()).getName(((XCourseId)((Object)course)).getCourseId()));
                        }
                        a.setSubpartId(xSection.getSubpartId());
                        a.setHasAlternatives(hasAlt);
                        a.addNote(((XCourse)((Object)course)).getNote());
                        a.addNote(xSection.getNote());
                        if (attendance != null) {
                            a.addNote(attendance.getClassNote(xSection.getExternalId(((XCourseId)((Object)course)).getCourseId())));
                        }
                        a.setCredit(((XSubpart)((Object)subpart3)).getCredit(((XCourseId)((Object)course)).getCourseId()));
                        a.setCreditRange(Float.valueOf(((XSubpart)((Object)subpart3)).getCreditMin(((XCourseId)((Object)course)).getCourseId())), Float.valueOf(((XSubpart)((Object)subpart3)).getCreditMax(((XCourseId)((Object)course)).getCourseId())));
                        Float creditOverride = xSection.getCreditOverride(((XCourseId)((Object)course)).getCourseId());
                        if (creditOverride != null) {
                            a.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                        }
                        a.setEnrolledDate(enrollment.getTimeStamp());
                        int dist = 0;
                        Object from = null;
                        TreeSet<String> overlap = new TreeSet<String>();
                        for (XRequest q : studentRequests) {
                            XEnrollment otherEnrollment;
                            if (!(q instanceof XCourseRequest) || (otherEnrollment = ((XCourseRequest)q).getEnrollment()) == null) continue;
                            XOffering otherOffering = server.getOffering(otherEnrollment.getOfferingId());
                            for (XSection otherSection : otherOffering.getSections(otherEnrollment)) {
                                if (otherSection.equals(xSection) || otherSection.getTime() == null) continue;
                                int d = otherSection.getDistanceInMinutes(xSection, m);
                                if (d > dist) {
                                    dist = d;
                                    from = "";
                                    Iterator<XRoom> k = otherSection.getRooms().iterator();
                                    while (k.hasNext()) {
                                        from = (String)from + k.next().getName() + (k.hasNext() ? ", " : "");
                                    }
                                    from = (String)from + " (" + otherEnrollment.getCourseName() + " " + otherSection.getSubpartName() + " " + otherSection.getName(otherEnrollment.getCourseId()) + ")";
                                }
                                if (otherSection.isDistanceConflict(student, xSection, m)) {
                                    a.setDistanceConflict(true);
                                    a.setLongDistanceConflict(otherSection.isLongDistanceConflict(student, otherSection, m));
                                }
                                if (xSection.getTime() == null || !xSection.getTime().hasIntersection(otherSection.getTime()) || xSection.isToIgnoreStudentConflictsWith(offering.getDistributions(), otherSection.getSectionId())) continue;
                                XCourse otherCourse = otherOffering.getCourse(otherEnrollment.getCourseId());
                                XSubpart otherSubpart = otherOffering.getSubpart(otherSection.getSubpartId());
                                overlap.add(MSG.clazz(otherCourse.getSubjectArea(), otherCourse.getCourseNumber(), otherSubpart.getName(), otherSection.getName(otherCourse.getCourseId())));
                            }
                        }
                        if (unavailabilities != null) {
                            for (CourseSection cs : unavailabilities) {
                                if (xSection.getTime() != null && xSection.getTime().hasIntersection(cs.getSection().getTime())) {
                                    overlap.add(MSG.teachingAssignment(MSG.clazz(cs.getCourse().getSubjectArea(), cs.getCourse().getCourseNumber(), cs.getSection().getSubpartName(), cs.getSection().getName(cs.getCourse().getCourseId()))));
                                }
                                if (!xSection.isUnavailabilityDistanceConflict(student, cs.getSection(), um)) continue;
                                a.setDistanceConflict(true);
                                a.setLongDistanceConflict(xSection.isUnavailabilityLongDistanceConflict(student, cs.getSection(), um));
                                from = "";
                                Iterator<XRoom> k = cs.getSection().getRooms().iterator();
                                while (k.hasNext()) {
                                    from = (String)from + k.next().getName() + (k.hasNext() ? ", " : "");
                                }
                                from = (String)from + " (" + cs.getCourse().getCourseName() + " " + cs.getSection().getSubpartName() + " " + cs.getSection().getName(cs.getCourse().getCourseId()) + ")";
                                dist = xSection.getDistanceInMinutes(um, cs.getSection().getRooms());
                            }
                        }
                        if (!overlap.isEmpty()) {
                            Object note = null;
                            Iterator j = overlap.iterator();
                            while (j.hasNext()) {
                                String n = (String)j.next();
                                if (note == null) {
                                    note = MSG.noteAllowedOverlapFirst(n);
                                    continue;
                                }
                                if (j.hasNext()) {
                                    note = (String)note + MSG.noteAllowedOverlapMiddle(n);
                                    continue;
                                }
                                note = (String)note + MSG.noteAllowedOverlapLast(n);
                            }
                            a.setOverlapNote((String)note);
                        }
                        a.setBackToBackDistance(dist);
                        a.setBackToBackRooms((String)from);
                        a.setSaved(true);
                        if (a.getParentSection() == null && (consent = server.getCourse(((XCourseId)((Object)course)).getCourseId()).getConsentLabel()) != null) {
                            if (enrollment.getApproval() != null) {
                                a.setParentSection(MSG.consentApproved(df.format(enrollment.getApproval().getTimeStamp())));
                            } else {
                                a.setParentSection(MSG.consentWaiting(consent.toLowerCase()));
                            }
                        }
                        a.setExpected(overExp.getExpected(xSection.getLimit(), expectations.getExpectedSpace(xSection.getSectionId()).doubleValue()));
                    }
                }
                if (messages != null) {
                    XEnrollments enrollments = server.getEnrollments(offering.getOfferingId());
                    block40: for (StudentEnrollmentProvider.EnrollmentFailure enrollmentFailure : messages) {
                        XSection section2 = enrollmentFailure.getSection();
                        if (!enrollmentFailure.getCourse().getCourseId().equals(ca.getCourseId())) continue;
                        for (ClassAssignmentInterface.ClassAssignment a : ca.getClassAssignments()) {
                            if (!enrollmentFailure.getSection().getSectionId().equals(a.getClassId())) continue;
                            if (enrollmentFailure.isError()) {
                                a.addError(enrollmentFailure.getMessage());
                                continue block40;
                            }
                            if (enrollmentFailure.isWarning()) {
                                a.addWarn(enrollmentFailure.getMessage());
                                continue block40;
                            }
                            a.addInfo(enrollmentFailure.getMessage());
                            continue block40;
                        }
                        ca.setAssigned(true);
                        ClassAssignmentInterface.ClassAssignment classAssignment = ca.addClassAssignment();
                        classAssignment.setAlternative(r.isAlternative());
                        classAssignment.setClassId(section2.getSectionId());
                        XSubpart subpart = offering.getSubpart(section2.getSubpartId());
                        classAssignment.setSubpart(subpart.getName());
                        classAssignment.setClassNumber(section2.getName(-1L));
                        classAssignment.setSection(section2.getName(((XCourseId)((Object)course)).getCourseId()));
                        classAssignment.setExternalId(section2.getExternalId(((XCourseId)((Object)course)).getCourseId()));
                        classAssignment.setCancelled(section2.isCancelled());
                        classAssignment.setLimit(new int[]{enrollments.countEnrollmentsForSection(section2.getSectionId()), section2.getLimit()});
                        if (section2.getTime() != null) {
                            for (DayCode d : DayCode.toDayCodes(section2.getTime().getDays())) {
                                classAssignment.addDay(d.getIndex());
                            }
                            classAssignment.setStart(section2.getTime().getSlot());
                            classAssignment.setLength(section2.getTime().getLength());
                            classAssignment.setBreakTime(section2.getTime().getBreakTime());
                            classAssignment.setDatePattern(section2.getTime().getDatePatternName());
                        }
                        if (section2.getRooms() != null) {
                            for (XRoom room : section2.getRooms()) {
                                classAssignment.addRoom(room.getUniqueId(), room.getName());
                            }
                        }
                        for (XInstructor instructor : section2.getInstructors()) {
                            classAssignment.addInstructor(instructor.getName());
                            classAssignment.addInstructoEmail(instructor.getEmail() == null ? "" : instructor.getEmail());
                        }
                        if (section2.getParentId() != null) {
                            classAssignment.setParentSection(offering.getSection(section2.getParentId()).getName(((XCourseId)((Object)course)).getCourseId()));
                        }
                        classAssignment.setSubpartId(section2.getSubpartId());
                        classAssignment.addNote(((XCourse)((Object)course)).getNote());
                        classAssignment.addNote(section2.getNote());
                        if (attendance != null) {
                            classAssignment.addNote(attendance.getClassNote(section2.getExternalId(((XCourseId)((Object)course)).getCourseId())));
                        }
                        classAssignment.setCredit(subpart.getCredit(((XCourseId)((Object)course)).getCourseId()));
                        classAssignment.setCreditRange(Float.valueOf(subpart.getCreditMin(((XCourseId)((Object)course)).getCourseId())), Float.valueOf(subpart.getCreditMax(((XCourseId)((Object)course)).getCourseId())));
                        Float creditOverride = section2.getCreditOverride(((XCourseId)((Object)course)).getCourseId());
                        if (creditOverride != null) {
                            classAssignment.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                        }
                        int dist = 0;
                        String from = null;
                        classAssignment.setBackToBackDistance(dist);
                        classAssignment.setBackToBackRooms(from);
                        classAssignment.setSaved(false);
                        classAssignment.setDummy(true);
                        if (enrollmentFailure.isError()) {
                            classAssignment.setError(enrollmentFailure.getMessage());
                        } else if (enrollmentFailure.isWarning()) {
                            classAssignment.setWarn(enrollmentFailure.getMessage());
                        } else {
                            classAssignment.setInfo(enrollmentFailure.getMessage());
                        }
                        classAssignment.setExpected(overExp.getExpected(section2.getLimit(), expectations.getExpectedSpace(section2.getSectionId()).doubleValue()));
                    }
                }
                if (errors != null) {
                    for (ClassAssignmentInterface.ErrorMessage f : errors) {
                        if (!ca.getCourseName().equals(f.getCourse())) continue;
                        for (ClassAssignmentInterface.ClassAssignment a : ca.getClassAssignments()) {
                            if (!a.getExternalId().equals(f.getSection())) continue;
                            a.addError(f.getMessage());
                        }
                    }
                }
            } else if (xRequest instanceof XFreeTimeRequest) {
                r = (XFreeTimeRequest)xRequest;
                ca.setCourseId(null);
                ca.setParentCourseId(null);
                for (XRequest xRequest3 : studentRequests) {
                    XEnrollment otherEnrollment;
                    if (!(xRequest3 instanceof XCourseRequest) || (otherEnrollment = ((XCourseRequest)xRequest3).getEnrollment()) == null) continue;
                    XOffering otherOffering = server.getOffering(otherEnrollment.getOfferingId());
                    for (XSection otherSection : otherOffering.getSections(otherEnrollment)) {
                        if (otherSection.getTime() == null || !otherSection.getTime().hasIntersection(((XFreeTimeRequest)r).getTime())) continue;
                        XCourse otherCourse = otherOffering.getCourse(otherEnrollment.getCourseId());
                        XSubpart xSubpart = otherOffering.getSubpart(otherSection.getSubpartId());
                        ca.addOverlap(MSG.clazz(otherCourse.getSubjectArea(), otherCourse.getCourseNumber(), xSubpart.getName(), otherSection.getName(otherCourse.getCourseId())));
                    }
                }
                ca.setAssigned(ca.getOverlaps() == null);
                ClassAssignmentInterface.ClassAssignment a = ca.addClassAssignment();
                a.setAlternative(r.isAlternative());
                for (DayCode d : DayCode.toDayCodes(((XFreeTimeRequest)r).getTime().getDays())) {
                    a.addDay(d.getIndex());
                }
                a.setStart(((XFreeTimeRequest)r).getTime().getSlot());
                a.setLength(((XFreeTimeRequest)r).getTime().getLength());
            }
            ret.add(ca);
        }
        action.addEnrollment(stored);
        if (errors != null) {
            for (ClassAssignmentInterface.ErrorMessage errorMessage : errors) {
                ret.addError(errorMessage);
            }
        }
        if (messages != null) {
            HashSet<CallSite> added = new HashSet<CallSite>();
            for (StudentEnrollmentProvider.EnrollmentFailure f : messages) {
                if (f.hasErrors()) {
                    for (StudentEnrollmentProvider.EnrollmentError err : f.getErrors()) {
                        ret.addError(new ClassAssignmentInterface.ErrorMessage(f.getCourse().getCourseName(), f.getSection().getExternalId(f.getCourse().getCourseId()), err.getCode(), err.getMessage()));
                    }
                }
                for (String fm : f.getMessage().split("\n")) {
                    String message = MSG.clazz(f.getCourse().getSubjectArea(), f.getCourse().getCourseNumber(), f.getSection().getSubpartName(), f.getSection().getName(f.getCourse().getCourseId())) + ": " + fm;
                    if (!added.add((CallSite)((Object)message))) continue;
                    ret.addMessage(message);
                }
            }
        }
        if (includeRequest) {
            CourseRequestInterface request = new CourseRequestInterface();
            request.setStudentId(student.getStudentId());
            request.setSaved(true);
            request.setAcademicSessionId(server.getAcademicSession().getUniqueId());
            request.setMaxCredit(student.getMaxCredit());
            request.setWaitListMode(wlMode);
            if (student.getMaxCreditOverride() != null) {
                request.setMaxCreditOverride(student.getMaxCreditOverride().getValue());
                request.setMaxCreditOverrideExternalId(student.getMaxCreditOverride().getExternalId());
                request.setMaxCreditOverrideTimeStamp(student.getMaxCreditOverride().getTimeStamp());
                Integer n = student.getMaxCreditOverride().getStatus();
                if (n == null) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
                } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED);
                } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED);
                } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_CHECKED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED);
                } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_NEEDED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NOT_NEEDED);
                } else {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
                }
            }
            Object var27_36 = null;
            int lastRequestPriority = -1;
            for (XRequest cd : studentRequests) {
                XEnrollment enrollment;
                Object var31_54 = null;
                if (cd instanceof XFreeTimeRequest) {
                    void var27_37;
                    Iterator<CourseRequestInterface.RequestedCourse> ftr = (XFreeTimeRequest)cd;
                    CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime();
                    ft.setStart(((XFreeTimeRequest)((Object)ftr)).getTime().getSlot());
                    ft.setLength(((XFreeTimeRequest)((Object)ftr)).getTime().getLength());
                    for (DayCode day : DayCode.toDayCodes(((XFreeTimeRequest)((Object)ftr)).getTime().getDays())) {
                        ft.addDay(day.getIndex());
                    }
                    if (var27_37 != null && lastRequestPriority == cd.getPriority() && var27_37.hasRequestedCourse() && var27_37.getRequestedCourse(0).isFreeTime()) {
                        var27_37.getRequestedCourse(0).addFreeTime(ft);
                        continue;
                    }
                    CourseRequestInterface.Request request2 = new CourseRequestInterface.Request();
                    CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                    request2.addRequestedCourse(rc);
                    rc.addFreeTime(ft);
                    if (cd.isAlternative()) {
                        request.getAlternatives().add(request2);
                    } else {
                        request.getCourses().add(request2);
                    }
                    CourseRequestInterface.Request request3 = request2;
                    lastRequestPriority = cd.getPriority();
                    rc.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                    continue;
                }
                if (!(cd instanceof XCourseRequest)) continue;
                CourseRequestInterface.Request request4 = new CourseRequestInterface.Request();
                for (XCourseId courseId : ((XCourseRequest)cd).getCourseIds()) {
                    boolean isEnrolled;
                    XCourse c = server.getCourse(courseId.getCourseId());
                    if (c == null) continue;
                    CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                    rc.setCourseId(c.getCourseId());
                    rc.setCourseName(c.getSubjectArea() + " " + c.getCourseNumber() + (String)(c.hasUniqueName() && !CONSTANTS.showCourseTitle() ? "" : " - " + c.getTitle()));
                    rc.setCourseTitle(c.getTitle());
                    rc.setCredit(c.getMinCredit(), c.getMaxCredit());
                    rc.setParentCourseId(c.getParentCourseId());
                    boolean bl = isEnrolled = ((XCourseRequest)cd).getEnrollment() != null && c.getCourseId().equals(((XCourseRequest)cd).getEnrollment().getCourseId());
                    if (setReadOnly && isEnrolled) {
                        rc.setReadOnly(true);
                    }
                    if (isEnrolled) {
                        rc.setStatus(CourseRequestInterface.RequestedCourseStatus.ENROLLED);
                    } else {
                        Integer n = ((XCourseRequest)cd).getOverrideStatus(courseId);
                        if (n == null) {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                        } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal()) {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED);
                        } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal()) {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                        } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal()) {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED);
                        } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_CHECKED.ordinal()) {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED);
                        } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_NEEDED.ordinal()) {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NOT_NEEDED);
                        } else {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
                        }
                    }
                    XOffering xOffering = server.getOffering(c.getOfferingId());
                    rc.setCanWaitList(xOffering != null && xOffering.isWaitList());
                    rc.setOverrideExternalId(((XCourseRequest)cd).getOverrideExternalId(courseId));
                    rc.setOverrideTimeStamp(((XCourseRequest)cd).getOverrideTimeStamp(courseId));
                    ((XCourseRequest)cd).fillPreferencesIn(rc, courseId);
                    request4.addRequestedCourse(rc);
                    if (!showWaitListPosition || !rc.isCanWaitList() || !((XCourseRequest)cd).isWaitlist()) continue;
                    rc.setWaitListPosition(this.getWaitListPosition(xOffering, student, (XCourseRequest)cd, courseId, server, helper));
                }
                request4.setWaitList(((XCourseRequest)cd).isWaitlist(wlMode));
                request4.setNoSub(((XCourseRequest)cd).isNoSub(wlMode));
                request4.setCritical(((XCourseRequest)cd).getCritical());
                request4.setTimeStamp(((XCourseRequest)cd).getTimeStamp());
                if (request4.isWaitList()) {
                    request4.setWaitListedTimeStamp(((XCourseRequest)cd).getWaitListedTimeStamp());
                }
                request4.setWaitListSwapWithCourseOfferingId(((XCourseRequest)cd).getWaitListSwapWithCourseOffering() == null ? null : ((XCourseRequest)cd).getWaitListSwapWithCourseOffering().getCourseId());
                if (request4.hasRequestedCourse()) {
                    if (cd.isAlternative()) {
                        request.getAlternatives().add(request4);
                    } else {
                        request.getCourses().add(request4);
                    }
                }
                CourseRequestInterface.Request request5 = request4;
                lastRequestPriority = cd.getPriority();
                if (!request4.isWaitList()) continue;
                for (CourseRequestInterface.RequestedCourse rc : request4.getRequestedCourse()) {
                    Set overlaps = wlOverlaps == null || rc.getCourseId() == null ? null : (Set)wlOverlaps.get(rc.getCourseId());
                    if (overlaps == null || overlaps.isEmpty()) continue;
                    Object message = null;
                    Iterator i = overlaps.iterator();
                    while (i.hasNext()) {
                        String string = (String)i.next();
                        if (message == null) {
                            message = MSG.conflictWithFirst(string);
                            continue;
                        }
                        if (i.hasNext()) {
                            message = (String)message + MSG.conflictWithMiddle(string);
                            continue;
                        }
                        message = (String)message + MSG.conflictWithLast(string);
                    }
                    request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "WL-OVERLAP", message + ".", 0);
                }
                if (!request4.isWaitList() || request4.getWaitListSwapWithCourseOfferingId() == null || !request4.hasRequestedCourse() || (enrollment = ((XCourseRequest)cd).getEnrollment()) == null || !enrollment.getCourseId().equals(request4.getWaitListSwapWithCourseOfferingId())) continue;
                boolean before = true;
                for (CourseRequestInterface.RequestedCourse rc : request4.getRequestedCourse()) {
                    if (request4.getWaitListSwapWithCourseOfferingId().equals(rc.getCourseId())) {
                        if (((XCourseRequest)cd).isRequired(enrollment, server.getOffering(enrollment.getOfferingId()))) {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.WAITLIST_INACTIVE);
                            request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "WL-INACTIVE", MSG.waitListRequirementsMet(), 0);
                        }
                        before = false;
                        continue;
                    }
                    if (before) continue;
                    rc.setStatus(CourseRequestInterface.RequestedCourseStatus.WAITLIST_INACTIVE);
                    request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "WL-INACTIVE", MSG.waitListLowPriority(), 0);
                }
            }
            ret.setRequest(request);
        }
        return ret;
    }

    @Override
    public String name() {
        return "get-assignment";
    }

    public static boolean isFreeTimeOverlapping(FreeTimeRequest r, Enrollment e) {
        if (r.isAlternative() || r.getPriority() >= e.getRequest().getPriority()) {
            return false;
        }
        if (r.getTime() == null) {
            return false;
        }
        for (SctAssignment assignment : e.getAssignments()) {
            if (assignment.isAllowOverlap() || assignment.getTime() == null) continue;
            if (assignment instanceof FreeTimeRequest) {
                return false;
            }
            if (!r.getTime().hasIntersection(assignment.getTime())) continue;
            return true;
        }
        return false;
    }

    protected static String datePatternName(DatePattern pattern, String datePatternFormat) {
        if ("never".equals(datePatternFormat)) {
            return pattern.getName();
        }
        if ("extended".equals(datePatternFormat) && !pattern.isExtended()) {
            return pattern.getName();
        }
        if ("alternate".equals(datePatternFormat) && pattern.isAlternate()) {
            return pattern.getName();
        }
        Formats.Format<Date> dpf = Formats.getDateFormat(Formats.Pattern.DATE_PATTERN);
        Date first = pattern.getStartDate();
        Date last = pattern.getEndDate();
        return dpf.format(first) + (String)(first.equals(last) ? "" : " - " + dpf.format(last));
    }

    public static class CourseSection
    implements Comparable<CourseSection> {
        XCourseId iCourse;
        XSection iSection;
        private boolean iAllowOverlap = false;
        private boolean iTeachingAssignment = true;

        public CourseSection(XCourseId course, XSection section) {
            this.iCourse = course;
            this.iSection = section;
        }

        public CourseSection(XCourseId course, XSection section, boolean allowOverlap, boolean teachingAssignment) {
            this.iCourse = course;
            this.iSection = section;
            this.iAllowOverlap = allowOverlap;
            this.iTeachingAssignment = teachingAssignment;
        }

        public XCourseId getCourse() {
            return this.iCourse;
        }

        public XSection getSection() {
            return this.iSection;
        }

        public boolean isAllowOverlap() {
            return this.iAllowOverlap;
        }

        public void setAllowOverlap(boolean allowOverlap) {
            this.iAllowOverlap = allowOverlap;
        }

        public boolean isTeachingAssignment() {
            return this.iTeachingAssignment;
        }

        public void setTeachingAssignment(boolean teachingAssignment) {
            this.iTeachingAssignment = teachingAssignment;
        }

        public String toString() {
            return this.getCourse().getCourseName() + " " + this.getSection().getSubpartName() + " " + this.getSection().getName(this.getCourse().getCourseId());
        }

        @Override
        public int compareTo(CourseSection o) {
            int cmp = this.getCourse().compareTo(o.getCourse());
            if (cmp != 0) {
                return cmp;
            }
            return this.getSection().compareTo(o.getSection());
        }

        public int hashCode() {
            return this.getCourse().hashCode() ^ this.getSection().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CourseSection)) {
                return false;
            }
            return this.getCourse().equals(((CourseSection)o).getCourse()) && this.getSection().equals(((CourseSection)o).getSection());
        }
    }
}

