/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.RefTableEntry;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;

@MappedSuperclass
public abstract class BaseStudentSectioningStatus
extends RefTableEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer iStatus;
    private String iMessage;
    private Date iEffectiveStartDate;
    private Date iEffectiveStopDate;
    private Integer iEffectiveStartPeriod;
    private Integer iEffectiveStopPeriod;
    private Integer iNotifications;
    private StudentSectioningStatus iFallBackStatus;
    private Session iSession;
    private Set<CourseType> iTypes;

    public BaseStudentSectioningStatus() {
    }

    public BaseStudentSectioningStatus(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="status", nullable=false)
    public Integer getStatus() {
        return this.iStatus;
    }

    public void setStatus(Integer status) {
        this.iStatus = status;
    }

    @Column(name="message", nullable=true, length=500)
    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    @Column(name="start_date", nullable=true)
    public Date getEffectiveStartDate() {
        return this.iEffectiveStartDate;
    }

    public void setEffectiveStartDate(Date effectiveStartDate) {
        this.iEffectiveStartDate = effectiveStartDate;
    }

    @Column(name="stop_date", nullable=true)
    public Date getEffectiveStopDate() {
        return this.iEffectiveStopDate;
    }

    public void setEffectiveStopDate(Date effectiveStopDate) {
        this.iEffectiveStopDate = effectiveStopDate;
    }

    @Column(name="start_slot", nullable=true)
    public Integer getEffectiveStartPeriod() {
        return this.iEffectiveStartPeriod;
    }

    public void setEffectiveStartPeriod(Integer effectiveStartPeriod) {
        this.iEffectiveStartPeriod = effectiveStartPeriod;
    }

    @Column(name="stop_slot", nullable=true)
    public Integer getEffectiveStopPeriod() {
        return this.iEffectiveStopPeriod;
    }

    public void setEffectiveStopPeriod(Integer effectiveStopPeriod) {
        this.iEffectiveStopPeriod = effectiveStopPeriod;
    }

    @Column(name="notifications", nullable=true)
    public Integer getNotifications() {
        return this.iNotifications;
    }

    public void setNotifications(Integer notifications) {
        this.iNotifications = notifications;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="fallback_id", nullable=true)
    public StudentSectioningStatus getFallBackStatus() {
        return this.iFallBackStatus;
    }

    public void setFallBackStatus(StudentSectioningStatus fallBackStatus) {
        this.iFallBackStatus = fallBackStatus;
    }

    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="session_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="sectioning_course_types", joinColumns={@JoinColumn(name="sectioning_status_id")}, inverseJoinColumns={@JoinColumn(name="course_type_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<CourseType> getTypes() {
        return this.iTypes;
    }

    public void setTypes(Set<CourseType> types) {
        this.iTypes = types;
    }

    public void addToTypes(CourseType courseType) {
        if (this.iTypes == null) {
            this.iTypes = new HashSet<CourseType>();
        }
        this.iTypes.add(courseType);
    }

    @Deprecated
    public void addTotypes(CourseType courseType) {
        this.addToTypes(courseType);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof StudentSectioningStatus)) {
            return false;
        }
        if (this.getUniqueId() == null || ((StudentSectioningStatus)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((StudentSectioningStatus)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "StudentSectioningStatus[" + this.getUniqueId() + " " + this.getLabel() + "]";
    }

    @Override
    public String toDebugString() {
        return "StudentSectioningStatus[\n\tEffectiveStartDate: " + String.valueOf(this.getEffectiveStartDate()) + "\n\tEffectiveStartPeriod: " + this.getEffectiveStartPeriod() + "\n\tEffectiveStopDate: " + String.valueOf(this.getEffectiveStopDate()) + "\n\tEffectiveStopPeriod: " + this.getEffectiveStopPeriod() + "\n\tFallBackStatus: " + String.valueOf(this.getFallBackStatus()) + "\n\tLabel: " + this.getLabel() + "\n\tMessage: " + this.getMessage() + "\n\tNotifications: " + this.getNotifications() + "\n\tReference: " + this.getReference() + "\n\tSession: " + String.valueOf(this.getSession()) + "\n\tStatus: " + this.getStatus() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

