/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.RoomFeature;

@MappedSuperclass
public abstract class BaseDepartmentRoomFeature
extends RoomFeature
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Department iDepartment;

    public BaseDepartmentRoomFeature() {
    }

    public BaseDepartmentRoomFeature(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="department_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Department getDepartment() {
        return this.iDepartment;
    }

    public void setDepartment(Department department) {
        this.iDepartment = department;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof DepartmentRoomFeature)) {
            return false;
        }
        if (this.getUniqueId() == null || ((DepartmentRoomFeature)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((DepartmentRoomFeature)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "DepartmentRoomFeature[" + this.getUniqueId() + " " + this.getLabel() + "]";
    }

    @Override
    public String toDebugString() {
        return "DepartmentRoomFeature[\n\tAbbv: " + this.getAbbv() + "\n\tDepartment: " + String.valueOf(this.getDepartment()) + "\n\tDescription: " + this.getDescription() + "\n\tFeatureType: " + String.valueOf(this.getFeatureType()) + "\n\tLabel: " + this.getLabel() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

