/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.FlushMode;
import org.unitime.commons.NaturalOrderComparator;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.ExternalDepartmentStatusType;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributeType;
import org.unitime.timetable.model.RoomSharingModel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.base.BaseDepartment;
import org.unitime.timetable.model.base.BaseRoomDept;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.UserQualifier;
import org.unitime.timetable.security.rights.Right;

@Entity
@Table(name="department")
public class Department
extends BaseDepartment
implements Comparable<Department>,
Qualifiable {
    private static final long serialVersionUID = 1L;
    public static String DEPT_ATTR_NAME = "deptsList";
    public static String EXTERNAL_DEPT_ATTR_NAME = "externalDepartments";

    public Department() {
    }

    public Department(Long uniqueId) {
        super(uniqueId);
    }

    public static TreeSet<Department> findAll(Long sessionId) {
        return new TreeSet<Department>(DepartmentDAO.getInstance().getSession().createQuery("select distinct d from Department as d where d.session.uniqueId=:sessionId", Department.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list());
    }

    public static TreeSet<Department> findAllExternal(Long sessionId) {
        return new TreeSet<Department>(DepartmentDAO.getInstance().getSession().createQuery("select distinct d from Department as d where d.externalManager=true and d.session.uniqueId=:sessionId", Department.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list());
    }

    public static TreeSet<Department> findAllNonExternal(Long sessionId) {
        return new TreeSet<Department>(DepartmentDAO.getInstance().getSession().createQuery("select distinct d from Department as d where d.externalManager=false and d.session.uniqueId=:sessionId", Department.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list());
    }

    public static Department findByDeptCode(String deptCode, Long sessionId) {
        return Department.findByDeptCode(deptCode, sessionId, DepartmentDAO.getInstance().getSession());
    }

    public static Department findByDeptCode(String deptCode, Long sessionId, org.hibernate.Session hibSession) {
        return (Department)hibSession.createQuery("select distinct d from Department as d where d.deptCode=:deptCode and d.session.uniqueId=:sessionId", Department.class).setParameter("sessionId", (Object)sessionId).setParameter("deptCode", (Object)deptCode).setCacheable(true).setHibernateFlushMode(FlushMode.MANUAL).uniqueResult();
    }

    @Override
    public int compareTo(Department d) {
        int cmp = Double.compare(this.isExternalManager() == null ? 0.0 : (this.isExternalManager() != false ? 1.0 : 0.0), d.isExternalManager() == null ? 0.0 : (d.isExternalManager() != false ? 1.0 : 0.0));
        if (cmp != 0) {
            return cmp;
        }
        cmp = new NaturalOrderComparator().compare(this.getDeptCode() == null ? "" : this.getDeptCode(), d.getDeptCode() == null ? "" : d.getDeptCode());
        if (cmp != 0) {
            return cmp;
        }
        cmp = new NaturalOrderComparator().compare(this.getAbbreviation() == null ? "" : this.getAbbreviation(), d.getAbbreviation() == null ? "" : d.getAbbreviation());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(d.getUniqueId() == null ? -1L : d.getUniqueId());
    }

    @Override
    public String htmlLabel() {
        return this.getDeptCode() + " - " + this.getName();
    }

    @Transient
    public String getHtmlTitle() {
        return this.getDeptCode() + " - " + this.getName() + (String)(this.isExternalManager() != false ? " (" + this.getExternalMgrLabel() + ")" : "");
    }

    @Transient
    public String getShortLabel() {
        if (this.isExternalManager().booleanValue()) {
            return this.getExternalMgrAbbv().trim();
        }
        if (this.getAbbreviation() != null && this.getAbbreviation().trim().length() > 0) {
            return this.getAbbreviation().trim();
        }
        return this.getDeptCode();
    }

    public String htmlShortLabel() {
        return "<span style='color:#" + this.getRoomSharingColor(null) + ";font-weight:bold;' title='" + this.getHtmlTitle() + "'>" + this.getShortLabel() + "</span>";
    }

    @Override
    public String toString() {
        return this.getDeptCode() + " - " + this.getName();
    }

    @Transient
    public String getLabel() {
        return this.getDeptCode() + " - " + this.getName() + (String)(this.isExternalManager() != false ? " ( EXT: " + this.getExternalMgrLabel() + " )" : "");
    }

    public static String color2hex(Color color) {
        return (color.getRed() < 16 ? "0" : "") + Integer.toHexString(color.getRed()) + (color.getGreen() < 16 ? "0" : "") + Integer.toHexString(color.getGreen()) + (color.getBlue() < 16 ? "0" : "") + Integer.toHexString(color.getBlue());
    }

    public static Color hex2color(String hex) {
        if (hex == null || hex.length() != 6) {
            return null;
        }
        return new Color(Integer.parseInt(hex.substring(0, 2), 16), Integer.parseInt(hex.substring(2, 4), 16), Integer.parseInt(hex.substring(4, 6), 16));
    }

    private static int distance(String color1, String color2) {
        if (color1.equals(color2)) {
            return 0;
        }
        Color c1 = Department.hex2color(color1);
        Color c2 = Department.hex2color(color2);
        return (int)Math.sqrt((c1.getRed() - c2.getRed()) * (c1.getRed() - c2.getRed()) + (c1.getGreen() - c2.getGreen()) * (c1.getGreen() - c2.getGreen()) + (c1.getBlue() - c2.getBlue()) * (c1.getBlue() - c2.getBlue()));
    }

    public boolean isRoomSharingColorConflicting(String color) {
        if (this.getUniqueId() == null) {
            return false;
        }
        boolean ret = false;
        for (String other : DepartmentDAO.getInstance().getSession().createQuery("select distinct x.department.roomSharingColor from Department d inner join d.roomDepts rd inner join rd.room.roomDepts x where d.uniqueId = :uniqueId and d != x.department", String.class).setParameter("uniqueId", (Object)this.getUniqueId()).setCacheable(true).list()) {
            if (other == null || Department.distance(color, other) >= 50) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean isRoomSharingColorConflicting(String color, Collection<Object> otherDepartments) {
        if (this.isRoomSharingColorConflicting(color)) {
            return true;
        }
        if (otherDepartments != null && !otherDepartments.isEmpty()) {
            for (Object o : otherDepartments) {
                BaseDepartment d = null;
                if (o instanceof BaseDepartment) {
                    d = (BaseDepartment)o;
                } else if (o instanceof BaseRoomDept) {
                    d = ((BaseRoomDept)o).getDepartment();
                } else if (o instanceof Long) {
                    d = (BaseDepartment)DepartmentDAO.getInstance().get((Long)o);
                }
                if (d == null || d.equals(this) || !color.equals(d.getRoomSharingColor())) continue;
                return true;
            }
        }
        return false;
    }

    public void fixRoomSharingColor(Collection<Object> otherDepartments) {
        String color = this.getRoomSharingColor();
        if (this.isRoomSharingColorConflicting(color, otherDepartments)) {
            int idx = 0;
            color = Department.color2hex(RoomSharingModel.sDepartmentColors[idx]);
            while (this.isRoomSharingColorConflicting(color, otherDepartments)) {
                if (++idx >= RoomSharingModel.sDepartmentColors.length) {
                    color = Department.color2hex(new Color((int)(256.0 * Math.random()), (int)(256.0 * Math.random()), (int)(256.0 * Math.random())));
                    continue;
                }
                color = Department.color2hex(RoomSharingModel.sDepartmentColors[idx]);
            }
            this.setRoomSharingColor(color);
            DepartmentDAO.getInstance().getSession().merge((Object)this);
            DepartmentDAO.getInstance().getSession().flush();
        }
    }

    public String getRoomSharingColor(Collection otherDepartments) {
        if (this.getRoomSharingColor() == null) {
            this.setRoomSharingColor(Department.color2hex(RoomSharingModel.sDepartmentColors[0]));
        }
        this.fixRoomSharingColor(otherDepartments);
        return this.getRoomSharingColor();
    }

    @Transient
    public String getManagingDeptLabel() {
        if (this.isExternalManager().booleanValue()) {
            return this.getExternalMgrLabel();
        }
        return this.getDeptCode() + " - " + this.getName();
    }

    @Transient
    public String getManagingDeptAbbv() {
        return "<span title='" + this.getHtmlTitle() + "'>" + this.getShortLabel() + "</span>";
    }

    @Transient
    public Collection<Class_> getClasses() {
        return DepartmentDAO.getInstance().getSession().createQuery("select distinct c from Class_ as c where c.managingDept.uniqueId=:departmentId or (c.managingDept is null and c.controllingDept.uniqueId=:departmentId)", Class_.class).setParameter("departmentId", (Object)this.getUniqueId()).list();
    }

    @Transient
    public Collection<Class_> getClassesFetchWithStructure() {
        return DepartmentDAO.getInstance().getSession().createQuery("select distinct c from Class_ as c left join fetch c.childClasses as cc left join fetch c.schedulingSubpart as ss left join fetch ss.childSubparts as css left join fetch ss.instrOfferingConfig as ioc left join fetch ioc.instructionalOffering as io left join fetch io.courseOfferings as cox where c.managingDept.uniqueId=:departmentId or (c.managingDept is null and c.controllingDept.uniqueId=:departmentId)", Class_.class).setParameter("departmentId", (Object)this.getUniqueId()).list();
    }

    public Collection<Class_> getNotAssignedClasses(Solution solution) {
        return DepartmentDAO.getInstance().getSession().createQuery("select distinct c from Class_ as c where (c.managingDept.uniqueId=:departmentId or (c.managingDept is null and c.controllingDept.uniqueId=:departmentId)) and not exists (from c.assignments as a where a.solution.uniqueId=:solutionId)", Class_.class).setParameter("departmentId", (Object)this.getUniqueId()).setParameter("solutionId", (Object)solution.getUniqueId()).list();
    }

    public static TreeSet<Department> findAllBeingUsed(Long sessionId) {
        TreeSet<Department> ret = new TreeSet<Department>(DepartmentDAO.getInstance().getSession().createQuery("select distinct d from Department as d inner join d.timetableManagers as m where d.session.uniqueId=:sessionId", Department.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list());
        ret.addAll(DepartmentDAO.getInstance().getSession().createQuery("select distinct d from Department as d inner join d.roomDepts as r where d.session.uniqueId=:sessionId", Department.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list());
        ret.addAll(DepartmentDAO.getInstance().getSession().createQuery("select distinct d from Department as d inner join d.subjectAreas as r where d.session.uniqueId=:sessionId", Department.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list());
        return ret;
    }

    public DepartmentStatusType effectiveStatusType() {
        DepartmentStatusType t = this.getStatusType();
        if (t != null) {
            return t;
        }
        return this.getSession().getStatusType();
    }

    public DepartmentStatusType effectiveStatusType(Department controllingDepartment) {
        if (this.isExternalManager().booleanValue() && controllingDepartment != null && this.getExternalStatusTypes() != null) {
            for (ExternalDepartmentStatusType t : this.getExternalStatusTypes()) {
                if (!controllingDepartment.equals(t.getDepartment())) continue;
                return t.getStatusType();
            }
        }
        return this.effectiveStatusType();
    }

    public DepartmentStatusType effectiveStatusType(UserContext cx) {
        if (this.isExternalManager().booleanValue() && this.getExternalStatusTypes() != null && !cx.hasDepartment(this.getUniqueId())) {
            Integer status = null;
            for (ExternalDepartmentStatusType t : this.getExternalStatusTypes()) {
                if (!cx.hasDepartment(t.getDepartment().getUniqueId())) continue;
                if (status == null) {
                    status = t.getStatusType().getStatus();
                    continue;
                }
                status = status | t.getStatusType().getStatus();
            }
            if (status != null) {
                DepartmentStatusType ret = new DepartmentStatusType();
                ret.setStatus(status);
                return ret;
            }
        }
        return this.effectiveStatusType();
    }

    @Transient
    public Long getSessionId() {
        if (this.getSession() != null) {
            return this.getSession().getUniqueId();
        }
        return null;
    }

    public Object clone() {
        Department d = new Department();
        d.setSession(this.getSession());
        d.setAbbreviation(this.getAbbreviation());
        d.setAllowReqRoom(this.isAllowReqRoom());
        d.setAllowReqTime(this.isAllowReqTime());
        d.setAllowReqDistribution(this.isAllowReqDistribution());
        d.setDeptCode(this.getDeptCode());
        d.setDistributionPrefPriority(this.getDistributionPrefPriority());
        d.setExternalManager(this.isExternalManager());
        d.setExternalMgrAbbv(this.getExternalMgrAbbv());
        d.setExternalMgrLabel(this.getExternalMgrLabel());
        d.setExternalUniqueId(this.getExternalUniqueId());
        d.setName(this.getName());
        d.setStatusType(this.getStatusType());
        d.setAllowEvents(this.isAllowEvents());
        d.setInheritInstructorPreferences(this.isInheritInstructorPreferences());
        d.setAllowStudentScheduling(this.isAllowStudentScheduling());
        d.setExternalFundingDept(this.getExternalFundingDept());
        return d;
    }

    public Department findSameDepartmentInSession(Long newSessionId) {
        return this.findSameDepartmentInSession(newSessionId, DepartmentDAO.getInstance().getSession());
    }

    public Department findSameDepartmentInSession(Long newSessionId, org.hibernate.Session hibSession) {
        List l;
        if (newSessionId == null) {
            return null;
        }
        Department newDept = Department.findByDeptCode(this.getDeptCode(), newSessionId, hibSession);
        if (newDept == null && this.getExternalUniqueId() != null && (l = hibSession.createQuery("from Department where externalUniqueId = :externalUniqueId and session.uniqueId = :newSessionId", Department.class).setParameter("externalUniqueId", (Object)this.getExternalUniqueId()).setParameter("newSessionId", (Object)newSessionId).setHibernateFlushMode(FlushMode.MANUAL).setCacheable(true).list()).size() == 1) {
            newDept = (Department)l.get(0);
        }
        return newDept;
    }

    public Department findSameDepartmentInSession(Session newSession) {
        if (newSession != null) {
            return this.findSameDepartmentInSession(newSession.getUniqueId());
        }
        return null;
    }

    @Override
    @Transient
    public Serializable getQualifierId() {
        return this.getUniqueId();
    }

    @Override
    @Transient
    public String getQualifierType() {
        return this.getClass().getSimpleName();
    }

    @Override
    @Transient
    public String getQualifierReference() {
        return this.getDeptCode();
    }

    @Override
    @Transient
    public String getQualifierLabel() {
        return this.getName();
    }

    public static TreeSet<Department> getUserDepartments(UserContext user) {
        TreeSet<Department> departments = new TreeSet<Department>();
        if (user == null || user.getCurrentAuthority() == null) {
            return departments;
        }
        if (user.getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
            departments.addAll(Department.findAllBeingUsed(user.getCurrentAcademicSessionId()));
        } else {
            for (UserQualifier userQualifier : user.getCurrentAuthority().getQualifiers("Department")) {
                departments.add((Department)DepartmentDAO.getInstance().get((Long)userQualifier.getQualifierId()));
            }
        }
        return departments;
    }

    @Override
    @Transient
    public Department getDepartment() {
        return this;
    }

    @Override
    @Transient
    public Set<InstructorAttributeType> getAvailableAttributeTypes() {
        return new TreeSet<InstructorAttributeType>(DepartmentDAO.getInstance().getSession().createQuery("select distinct t from InstructorAttribute a inner join a.type t where a.session.uniqueId = :sessionId and (a.department is null or a.department.uniqueId = :departmentId)", InstructorAttributeType.class).setParameter("sessionId", (Object)this.getSessionId()).setParameter("departmentId", (Object)this.getUniqueId()).setCacheable(true).list());
    }

    @Override
    @Transient
    public Set<InstructorAttribute> getAvailableAttributes() {
        return new TreeSet<InstructorAttribute>(DepartmentDAO.getInstance().getSession().createQuery("select a from InstructorAttribute a where a.session.uniqueId = :sessionId and (a.department is null or a.department.uniqueId = :departmentId)", InstructorAttribute.class).setParameter("sessionId", (Object)this.getSessionId()).setParameter("departmentId", (Object)this.getUniqueId()).setCacheable(true).list());
    }

    public static boolean isInstructorSchedulingCommitted(Long departmentId) {
        Number oc = (Number)DepartmentDAO.getInstance().getSession().createQuery("select count(oc) from OfferingCoordinator oc where oc.teachingRequest is not null and oc.instructor.department.uniqueId = :departmentId", Number.class).setParameter("departmentId", (Object)departmentId).setCacheable(true).uniqueResult();
        if (oc.intValue() > 0) {
            return true;
        }
        Number ci = (Number)DepartmentDAO.getInstance().getSession().createQuery("select count(ci) from ClassInstructor ci where ci.teachingRequest is not null and ci.instructor.department.uniqueId = :departmentId", Number.class).setParameter("departmentId", (Object)departmentId).setCacheable(true).uniqueResult();
        return ci.intValue() > 0;
    }
}

