/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.gwt.shared.TableInterface;

public class SuggestionsInterface
implements IsSerializable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static int[] sDayCode2Order = new int[]{0, 127, 125, 126, 121, 124, 122, 123, 113, 120, 118, 119, 114, 117, 115, 116, 97, 112, 110, 111, 106, 109, 107, 108, 98, 105, 103, 104, 99, 102, 100, 101, 65, 96, 94, 95, 90, 93, 91, 92, 82, 89, 87, 88, 83, 86, 84, 85, 66, 81, 79, 80, 75, 78, 76, 77, 67, 74, 72, 73, 68, 71, 69, 70, 1, 64, 62, 63, 58, 61, 59, 60, 50, 57, 55, 56, 51, 54, 52, 53, 34, 49, 47, 48, 43, 46, 44, 45, 35, 42, 40, 41, 36, 39, 37, 38, 2, 33, 31, 32, 27, 30, 28, 29, 19, 26, 24, 25, 20, 23, 21, 22, 3, 18, 16, 17, 12, 15, 13, 14, 4, 11, 9, 10, 5, 8, 6, 7};

    public static class ConflictBasedStatisticsRequest
    implements GwtRpcRequest<GwtRpcResponseList<CBSNode>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iClassId;
        private boolean iVariableOriented = true;
        private double iLimit = 100.0;

        public ConflictBasedStatisticsRequest() {
        }

        public ConflictBasedStatisticsRequest(Long classId) {
            this.setClassId(classId);
        }

        public boolean hasClassId() {
            return this.iClassId != null;
        }

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public boolean isVariableOriented() {
            return this.iVariableOriented;
        }

        public void setVariableOriented(boolean variableOriented) {
            this.iVariableOriented = variableOriented;
        }

        public double getLimit() {
            return this.iLimit;
        }

        public void setLimit(double limit) {
            this.iLimit = limit;
        }
    }

    public static class CBSNode
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int iCount = 0;
        private String iName;
        private String iHTML;
        private String iLink;
        private String iPref;
        private List<CBSNode> iNodes = null;
        private Long iClassId = null;
        private SelectedAssignment iSelection = null;

        public int getCount() {
            return this.iCount;
        }

        public void setCount(int count) {
            this.iCount = count;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getHTML() {
            return this.iHTML;
        }

        public void setHTML(String html) {
            this.iHTML = html;
        }

        public String getPref() {
            return this.iPref;
        }

        public void setPref(String pref) {
            this.iPref = pref;
        }

        public boolean hasLink() {
            return this.iLink != null && !this.iLink.isEmpty();
        }

        public String getLink() {
            return this.iLink;
        }

        public void setLink(String link) {
            this.iLink = link;
        }

        public boolean hasClassId() {
            return this.iClassId != null;
        }

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public boolean hasSelection() {
            return this.iSelection != null;
        }

        public void setSelection(SelectedAssignment selection) {
            this.iSelection = selection;
        }

        public SelectedAssignment getSelection() {
            return this.iSelection;
        }

        public boolean hasNodes() {
            return this.iNodes != null && !this.iNodes.isEmpty();
        }

        public List<CBSNode> getNodes() {
            return this.iNodes;
        }

        public void addNode(CBSNode node) {
            if (this.iNodes == null) {
                this.iNodes = new ArrayList<CBSNode>();
            }
            this.iNodes.add(node);
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String indent) {
            String ret = indent + this.getCount() + "x " + this.getName();
            if (this.hasNodes()) {
                ret = ret + " [";
                for (CBSNode node : this.getNodes()) {
                    ret = ret + "\n" + node.toString(indent + "  ");
                }
                ret = ret + "\n" + indent + "]";
            }
            return ret;
        }
    }

    public static class ComputeConflictTableRequest
    implements GwtRpcRequest<GwtRpcResponseList<ClassAssignmentDetails>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iClassId;

        public ComputeConflictTableRequest() {
        }

        public ComputeConflictTableRequest(Long classId) {
            this.setClassId(classId);
        }

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }

        public Long getClassId() {
            return this.iClassId;
        }
    }

    public static class SuggestionsFilterRpcRequest
    extends EventInterface.FilterRpcRequest {
        private static final long serialVersionUID = 1L;
        private Long iClassId = null;

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }

        public Long getClassId() {
            return this.iClassId;
        }
    }

    public static class Suggestions
    implements GwtRpcResponse,
    Serializable {
        private static final long serialVersionUID = 1L;
        private TreeSet<Suggestion> iSuggestions = new TreeSet();
        private boolean iTimeoutReached = false;
        private int iNrCombinationsConsidered = 0;
        private int iNrSolutions = 0;
        private int iDepth = 2;
        private int iLimit = 20;
        private int iTimeLimit = 5000;
        private Long iClassId = null;
        private boolean iAllowBreakHard = false;
        private boolean iSameRoom = false;
        private boolean iSameTime = false;
        private boolean iPlacements = false;
        private Suggestion iBaseSuggestion;
        private String iFilter = null;

        public Suggestions() {
        }

        public Suggestions(ComputeSuggestionsRequest request) {
            this.iLimit = request.getLimit();
            this.iTimeLimit = request.getTimeLimit();
            this.iDepth = request.getDepth();
            this.iClassId = request.getClassId();
            this.iAllowBreakHard = request.isAllowBreakHard();
            this.iSameRoom = request.isSameRoom();
            this.iSameTime = request.isSameTime();
            this.iPlacements = request.isPlacements();
            this.iFilter = request.getFilter();
        }

        public TreeSet<Suggestion> getSuggestions() {
            return this.iSuggestions;
        }

        public int size() {
            return this.iSuggestions.size();
        }

        public Suggestion last() {
            return this.iSuggestions.last();
        }

        public void addSuggestion(Suggestion suggestion) {
            this.iSuggestions.add(suggestion);
            if (this.iSuggestions.size() > this.iLimit) {
                this.iSuggestions.remove(this.iSuggestions.last());
            }
        }

        public void setTimeoutReached(boolean timeoutReached) {
            this.iTimeoutReached = timeoutReached;
        }

        public boolean isTimeoutReached() {
            return this.iTimeoutReached;
        }

        public void setNrCombinationsConsidered(int nrCombinationsConsidered) {
            this.iNrCombinationsConsidered = nrCombinationsConsidered;
        }

        public int getNrCombinationsConsidered() {
            return this.iNrCombinationsConsidered;
        }

        public void setNrSolutions(int nrSolutions) {
            this.iNrSolutions = nrSolutions;
        }

        public int getNrSolutions() {
            return this.iNrSolutions;
        }

        public void setLimit(int limit) {
            this.iLimit = limit;
        }

        public int getLimit() {
            return this.iLimit;
        }

        public void setTimeLimit(int timeLimit) {
            this.iTimeLimit = timeLimit;
        }

        public int getTimeLimit() {
            return this.iTimeLimit;
        }

        public void setDepth(int depth) {
            this.iDepth = depth;
        }

        public int getDepth() {
            return this.iDepth;
        }

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public void setAllowBreakHard(boolean allowBreakHard) {
            this.iAllowBreakHard = allowBreakHard;
        }

        public boolean isAllowBreakHard() {
            return this.iAllowBreakHard;
        }

        public void setSameRoom(boolean sameRoom) {
            this.iSameRoom = sameRoom;
        }

        public boolean isSameRoom() {
            return this.iSameRoom;
        }

        public void setSameTime(boolean sameTime) {
            this.iSameTime = sameTime;
        }

        public boolean isSameTime() {
            return this.iSameTime;
        }

        public void setPlacements(boolean placements) {
            this.iPlacements = placements;
        }

        public boolean isPlacements() {
            return this.iPlacements;
        }

        public Suggestion getBaseSuggestion() {
            return this.iBaseSuggestion;
        }

        public void setBaseSuggestion(Suggestion suggestion) {
            this.iBaseSuggestion = suggestion;
        }

        public void setFilter(String filter) {
            this.iFilter = filter;
        }

        public String getFilter() {
            return this.iFilter;
        }

        public boolean hasFilter() {
            return this.iFilter != null && !this.iFilter.isEmpty();
        }
    }

    public static class ComputeSuggestionsRequest
    implements GwtRpcRequest<Suggestions>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iClassId;
        private List<SelectedAssignment> iAssignments;
        private int iDepth = 2;
        private int iLimit = 20;
        private int iTimeLimit = 5000;
        private boolean iAllowBreakHard = false;
        private boolean iSameRoom = false;
        private boolean iSameTime = false;
        private boolean iPlacements = false;
        private String iFilter = null;

        public ComputeSuggestionsRequest() {
        }

        public ComputeSuggestionsRequest(Long classId) {
            this.setClassId(classId);
        }

        public ComputeSuggestionsRequest(Long classId, List<SelectedAssignment> assignments) {
            this.setClassId(classId);
            this.iAssignments = assignments;
        }

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public boolean hasAssignments() {
            return this.iAssignments != null && !this.iAssignments.isEmpty();
        }

        public void addAssignment(SelectedAssignment a) {
            if (this.iAssignments == null) {
                this.iAssignments = new ArrayList<SelectedAssignment>();
            }
            Iterator<SelectedAssignment> i = this.iAssignments.iterator();
            while (i.hasNext()) {
                SelectedAssignment other = i.next();
                if (!other.equals(a)) continue;
                i.remove();
            }
            this.iAssignments.add(a);
        }

        public SelectedAssignment removeAssignment(Long classId) {
            if (this.iAssignments == null) {
                return null;
            }
            Iterator<SelectedAssignment> i = this.iAssignments.iterator();
            while (i.hasNext()) {
                SelectedAssignment other = i.next();
                if (!other.getClassId().equals(classId)) continue;
                i.remove();
                return other;
            }
            return null;
        }

        public List<SelectedAssignment> getAssignments() {
            return this.iAssignments;
        }

        public void setDepth(int depth) {
            this.iDepth = depth;
        }

        public int getDepth() {
            return this.iDepth;
        }

        public void setLimit(int limit) {
            this.iLimit = limit;
        }

        public int getLimit() {
            return this.iLimit;
        }

        public void setTimeLimit(int timeLimit) {
            this.iTimeLimit = timeLimit;
        }

        public int getTimeLimit() {
            return this.iTimeLimit;
        }

        public void setAllowBreakHard(boolean allowBreakHard) {
            this.iAllowBreakHard = allowBreakHard;
        }

        public boolean isAllowBreakHard() {
            return this.iAllowBreakHard;
        }

        public void setSameRoom(boolean sameRoom) {
            this.iSameRoom = sameRoom;
        }

        public boolean isSameRoom() {
            return this.iSameRoom;
        }

        public void setSameTime(boolean sameTime) {
            this.iSameTime = sameTime;
        }

        public boolean isSameTime() {
            return this.iSameTime;
        }

        public void setPlacements(boolean placements) {
            this.iPlacements = placements;
        }

        public boolean isPlacements() {
            return this.iPlacements;
        }

        public void setFilter(String filter) {
            this.iFilter = filter;
        }

        public String getFilter() {
            return this.iFilter;
        }

        public boolean hasFilter() {
            return this.iFilter != null && !this.iFilter.isEmpty();
        }
    }

    public static class MakeAssignmentRequest
    implements GwtRpcRequest<GwtRpcResponseNull>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private List<SelectedAssignment> iAssignments;

        public MakeAssignmentRequest() {
        }

        public MakeAssignmentRequest(List<SelectedAssignment> assignments) {
            this.iAssignments = assignments;
        }

        public boolean hasAssignments() {
            return this.iAssignments != null && !this.iAssignments.isEmpty();
        }

        public void addAssignment(SelectedAssignment a) {
            if (this.iAssignments == null) {
                this.iAssignments = new ArrayList<SelectedAssignment>();
            }
            Iterator<SelectedAssignment> i = this.iAssignments.iterator();
            while (i.hasNext()) {
                SelectedAssignment other = i.next();
                if (!other.equals(a)) continue;
                i.remove();
            }
            this.iAssignments.add(a);
        }

        public SelectedAssignment removeAssignment(Long classId) {
            if (this.iAssignments == null) {
                return null;
            }
            Iterator<SelectedAssignment> i = this.iAssignments.iterator();
            while (i.hasNext()) {
                SelectedAssignment other = i.next();
                if (!other.getClassId().equals(classId)) continue;
                i.remove();
                return other;
            }
            return null;
        }

        public List<SelectedAssignment> getAssignments() {
            return this.iAssignments;
        }
    }

    public static class Suggestion
    implements GwtRpcResponse,
    Serializable,
    Comparable<Suggestion> {
        private static final long serialVersionUID = 1L;
        private double iValue = 0.0;
        private int iUnassignedVariables = 0;
        private List<ClassAssignmentDetails> iUnresolvedConflicts = null;
        private List<ClassAssignmentDetails> iDifferentAssignments = null;
        private List<DistributionInfo> iDistributionConflicts = null;
        private List<BtbInstructorInfo> iBtbInstructorConflicts = null;
        private List<StudentConflictInfo> iStudentConflicts = null;
        private boolean iCanAssign = true;
        private ClassAssignmentDetails iPlacement = null;
        private ClassAssignmentDetails iSelectedPlacement = null;
        private double iBaseValue = 0.0;
        private int iBaseUnassignedVariables = 0;
        private TableInterface.TableCellMulti iStudentConflictSummary = null;
        private Map<String, Double> iCriteria = new HashMap<String, Double>();
        private Map<String, Double> iBaseCriteria = new HashMap<String, Double>();

        public boolean hasUnresolvedConflicts() {
            return this.iUnresolvedConflicts != null && !this.iUnresolvedConflicts.isEmpty();
        }

        public List<ClassAssignmentDetails> getUnresolvedConflicts() {
            return this.iUnresolvedConflicts;
        }

        public void addUnresolvedConflict(ClassAssignmentDetails conflict) {
            if (this.iUnresolvedConflicts == null) {
                this.iUnresolvedConflicts = new ArrayList<ClassAssignmentDetails>();
            }
            this.iUnresolvedConflicts.add(conflict);
        }

        public boolean hasDifferentAssignments() {
            return this.iDifferentAssignments != null && !this.iDifferentAssignments.isEmpty();
        }

        public List<ClassAssignmentDetails> getDifferentAssignments() {
            return this.iDifferentAssignments;
        }

        public void addDifferentAssignment(ClassAssignmentDetails assignment) {
            if (this.iDifferentAssignments == null) {
                this.iDifferentAssignments = new ArrayList<ClassAssignmentDetails>();
            }
            this.iDifferentAssignments.add(assignment);
        }

        public boolean hasBtbInstructorConflicts() {
            return this.iBtbInstructorConflicts != null && !this.iBtbInstructorConflicts.isEmpty();
        }

        public void addBtbInstructorConflict(BtbInstructorInfo conf) {
            if (this.iBtbInstructorConflicts == null) {
                this.iBtbInstructorConflicts = new ArrayList<BtbInstructorInfo>();
            }
            this.iBtbInstructorConflicts.add(conf);
        }

        public List<BtbInstructorInfo> getBtbInstructorConflicts() {
            return this.iBtbInstructorConflicts;
        }

        public boolean hasStudentConflicts() {
            return this.iStudentConflicts != null && !this.iStudentConflicts.isEmpty();
        }

        public void addStudentConflict(StudentConflictInfo conf) {
            if (this.iStudentConflicts == null) {
                this.iStudentConflicts = new ArrayList<StudentConflictInfo>();
            }
            this.iStudentConflicts.add(conf);
        }

        public List<StudentConflictInfo> getStudentConflicts() {
            return this.iStudentConflicts;
        }

        public int countStudentConflicts() {
            if (this.iStudentConflicts == null) {
                return 0;
            }
            int ret = 0;
            for (StudentConflictInfo c : this.iStudentConflicts) {
                ret += c.getInfo().getJenrl();
            }
            return ret;
        }

        public boolean hasDistributionConflicts() {
            return this.iDistributionConflicts != null && !this.iDistributionConflicts.isEmpty();
        }

        public void addDistributionConflict(DistributionInfo conf) {
            if (this.iDistributionConflicts == null) {
                this.iDistributionConflicts = new ArrayList<DistributionInfo>();
            }
            this.iDistributionConflicts.add(conf);
        }

        public List<DistributionInfo> getDistributionConflicts() {
            return this.iDistributionConflicts;
        }

        public boolean hasViolatedDistributionConflicts() {
            if (this.iDistributionConflicts == null) {
                return false;
            }
            for (DistributionInfo di : this.iDistributionConflicts) {
                if (di.getInfo().isSatisfied()) continue;
                return true;
            }
            return false;
        }

        public boolean isCanAssign() {
            return this.iCanAssign;
        }

        public void setCanAssign(boolean canAssign) {
            this.iCanAssign = canAssign;
        }

        public double getValue() {
            return this.iValue;
        }

        public void setValue(double value) {
            this.iValue = value;
        }

        public int getUnassignedVariables() {
            return this.iUnassignedVariables;
        }

        public void setUnassignedVariables(int unassignedVariables) {
            this.iUnassignedVariables = unassignedVariables;
        }

        public ClassAssignmentDetails getPlacement() {
            return this.iPlacement;
        }

        public void setPlacement(ClassAssignmentDetails placement) {
            this.iPlacement = placement;
        }

        public ClassAssignmentDetails getSelectedPlacement() {
            return this.iSelectedPlacement;
        }

        public void setSelectedPlacement(ClassAssignmentDetails placement) {
            this.iSelectedPlacement = placement;
        }

        public double getBaseValue() {
            return this.iBaseValue;
        }

        public void setBaseValue(double value) {
            this.iBaseValue = value;
        }

        public int getBaseUnassignedVariables() {
            return this.iBaseUnassignedVariables;
        }

        public void setBaseUnassignedVariables(int unassignedVariables) {
            this.iBaseUnassignedVariables = unassignedVariables;
        }

        public void setCriterion(String name, Double value) {
            this.iCriteria.put(name, value);
        }

        public Map<String, Double> getCriteria() {
            return this.iCriteria;
        }

        public double getCriterion(String name) {
            Double value = this.iCriteria.get(name);
            return value == null ? 0.0 : value;
        }

        public void setBaseCriterion(String name, Double value) {
            this.iBaseCriteria.put(name, value);
        }

        public Map<String, Double> getBaseCriteria() {
            return this.iBaseCriteria;
        }

        public double getBaseCriterion(String name) {
            Double value = this.iBaseCriteria.get(name);
            return value == null ? 0.0 : value;
        }

        public SelectedAssignment getAssignment(Long classId) {
            if (classId == null) {
                return null;
            }
            if (this.hasDifferentAssignments()) {
                for (ClassAssignmentDetails detail : this.getDifferentAssignments()) {
                    if (!classId.equals(detail.getClazz().getClassId())) continue;
                    return detail.getAssignedSelection();
                }
            }
            return null;
        }

        public List<SelectedAssignment> getAssignment(boolean conflicts) {
            ArrayList<SelectedAssignment> ret = new ArrayList<SelectedAssignment>();
            if (this.hasDifferentAssignments()) {
                for (ClassAssignmentDetails detail : this.getDifferentAssignments()) {
                    ret.add(detail.getAssignedSelection());
                }
            }
            if (conflicts && this.hasUnresolvedConflicts()) {
                for (ClassAssignmentDetails detail : this.getUnresolvedConflicts()) {
                    ret.add(new SelectedAssignment(detail.getClazz().getClassId()));
                }
            }
            return ret;
        }

        @Override
        public int compareTo(Suggestion other) {
            int cmp = Double.compare(this.getValue(), other.getValue());
            if (cmp != 0) {
                return cmp;
            }
            return TableInterface.NaturalOrderComparator.compare(this.getDifferentAssignments() == null ? "" : this.getDifferentAssignments().toString(), other.getDifferentAssignments() == null ? "" : other.getDifferentAssignments().toString());
        }

        public boolean hasStudentConflictSummary() {
            return this.iStudentConflictSummary != null;
        }

        public void setStudentConflictSummary(TableInterface.TableCellMulti cell) {
            this.iStudentConflictSummary = cell;
        }

        public TableInterface.TableCellMulti getStudentConflictSummary() {
            return this.iStudentConflictSummary;
        }
    }

    public static class SelectedAssignmentsRequest
    implements GwtRpcRequest<Suggestion>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iClassId;
        private List<SelectedAssignment> iAssignments;

        public SelectedAssignmentsRequest() {
        }

        public SelectedAssignmentsRequest(Long classId) {
            this.setClassId(classId);
        }

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public boolean hasAssignments() {
            return this.iAssignments != null && !this.iAssignments.isEmpty();
        }

        public void addAssignment(SelectedAssignment a) {
            if (this.iAssignments == null) {
                this.iAssignments = new ArrayList<SelectedAssignment>();
            }
            Iterator<SelectedAssignment> i = this.iAssignments.iterator();
            while (i.hasNext()) {
                SelectedAssignment other = i.next();
                if (!other.equals(a)) continue;
                i.remove();
            }
            this.iAssignments.add(a);
        }

        public SelectedAssignment removeAssignment(Long classId) {
            if (this.iAssignments == null) {
                return null;
            }
            Iterator<SelectedAssignment> i = this.iAssignments.iterator();
            while (i.hasNext()) {
                SelectedAssignment other = i.next();
                if (!other.getClassId().equals(classId)) continue;
                i.remove();
                return other;
            }
            return null;
        }

        public List<SelectedAssignment> getAssignments() {
            return this.iAssignments;
        }
    }

    public static class SelectedAssignment
    implements GwtRpcResponse,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iClassId;
        private int iDays = 0;
        private int iStartSlot = 0;
        private List<Long> iRoomIds;
        private Long iPatternId;
        private Long iDatePatternId;

        public SelectedAssignment() {
        }

        public SelectedAssignment(Long classId) {
            this.iClassId = classId;
        }

        public SelectedAssignment(Long classId, int days, int startSlot, List<Long> roomIds, Long patternId, Long datePatternId) {
            this.iClassId = classId;
            this.iDays = days;
            this.iStartSlot = startSlot;
            this.iRoomIds = roomIds;
            this.iPatternId = patternId;
            this.iDatePatternId = datePatternId;
        }

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public void setDays(int days) {
            this.iDays = days;
        }

        public int getDays() {
            return this.iDays;
        }

        public void setStartSlot(int slot) {
            this.iStartSlot = slot;
        }

        public int getStartSlot() {
            return this.iStartSlot;
        }

        public void setRoomIds(List<Long> roomIds) {
            this.iRoomIds = roomIds;
        }

        public void addRoomId(Long roomId) {
            if (this.iRoomIds == null) {
                this.iRoomIds = new ArrayList<Long>();
            }
            this.iRoomIds.add(roomId);
        }

        public List<Long> getRoomIds() {
            return this.iRoomIds;
        }

        public String getRoomIds(String separator) {
            if (this.iRoomIds == null) {
                return "";
            }
            Object ret = "";
            for (Long id : this.iRoomIds) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : separator) + id;
            }
            return ret;
        }

        public Long getRoomId(int index) {
            if (this.iRoomIds == null || index >= this.iRoomIds.size()) {
                return null;
            }
            return this.iRoomIds.get(index);
        }

        public void setPatternId(Long patternId) {
            this.iPatternId = patternId;
        }

        public Long getPatternId() {
            return this.iPatternId;
        }

        public void setDatePatternId(Long patternId) {
            this.iDatePatternId = patternId;
        }

        public Long getDatePatternId() {
            return this.iDatePatternId;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof SelectedAssignment)) {
                return false;
            }
            return this.iClassId.equals(((SelectedAssignment)o).getClassId());
        }

        public int hashCode() {
            return this.iClassId.hashCode();
        }

        public String toString() {
            return "SelectedAssignment{class=" + this.getClassId() + ", days=" + this.getDays() + ", slot=" + this.getStartSlot() + ", rooms=" + String.valueOf(this.getRoomIds()) + "}";
        }
    }

    public static class SuggestionPropertiesRequest
    implements GwtRpcRequest<SuggestionProperties>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iHistoryId;

        public SuggestionPropertiesRequest() {
        }

        public SuggestionPropertiesRequest(Long historyId) {
            this.iHistoryId = historyId;
        }

        public boolean hasHistoryId() {
            return this.iHistoryId != null;
        }

        public Long getHistoryId() {
            return this.iHistoryId;
        }

        public void setHistoryId(Long id) {
            this.iHistoryId = id;
        }
    }

    public static class SuggestionProperties
    implements GwtRpcResponse,
    Serializable {
        private static final long serialVersionUID = 1L;
        private List<PreferenceInterface> iPreferences = new ArrayList<PreferenceInterface>();
        private boolean iSolver = false;
        private List<SelectedAssignment> iSelectedAssignments = null;
        private Integer iFirstDay;

        public void addPreference(PreferenceInterface preference) {
            this.iPreferences.add(preference);
        }

        public List<PreferenceInterface> getPreferences() {
            return this.iPreferences;
        }

        public PreferenceInterface getPreference(String prefProlog) {
            for (PreferenceInterface p : this.iPreferences) {
                if (!p.getCode().equals(prefProlog)) continue;
                return p;
            }
            return null;
        }

        public PreferenceInterface getPreference(int intPref) {
            if (intPref >= 50) {
                return this.getPreference("P");
            }
            if (intPref >= 4) {
                return this.getPreference("2");
            }
            if (intPref > 0) {
                return this.getPreference("1");
            }
            if (intPref <= -50) {
                return this.getPreference("R");
            }
            if (intPref <= -4) {
                return this.getPreference("-2");
            }
            if (intPref < 0) {
                return this.getPreference("-1");
            }
            return this.getPreference("0");
        }

        public boolean isSolver() {
            return this.iSolver;
        }

        public void setSolver(boolean solver) {
            this.iSolver = solver;
        }

        public boolean hasSelectedAssignments() {
            return this.iSelectedAssignments != null && !this.iSelectedAssignments.isEmpty();
        }

        public List<SelectedAssignment> getSelectedAssignments() {
            return this.iSelectedAssignments;
        }

        public void addSelectedAssignment(SelectedAssignment assignment) {
            if (this.iSelectedAssignments == null) {
                this.iSelectedAssignments = new ArrayList<SelectedAssignment>();
            }
            this.iSelectedAssignments.add(assignment);
        }

        public void setFirstDay(Integer firstDay) {
            this.iFirstDay = firstDay;
        }

        public Integer getFirstDay() {
            return this.iFirstDay;
        }
    }

    public static class PreferenceInterface
    extends RoomInterface.PreferenceInterface
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int iPreference;

        public PreferenceInterface() {
        }

        public PreferenceInterface(Long id, String color, String code, String name, String abbv, int preference) {
            super(id, color, code, name, abbv, true);
            this.iPreference = preference;
        }

        public int getPreference() {
            return this.iPreference;
        }

        public void setPreference(int preference) {
            this.iPreference = preference;
        }
    }

    public static class ClassAssignmentDetails
    implements GwtRpcResponse,
    Serializable {
        private static final long serialVersionUID = 1L;
        private ClassInfo iClass = null;
        private TimeInfo iTime = null;
        private List<RoomInfo> iRoom = null;
        private List<InstructorInfo> iInstructor = null;
        private TimeInfo iInitialTime = null;
        private List<RoomInfo> iInitialRoom = null;
        private TimeInfo iAssignedTime = null;
        private List<RoomInfo> iAssignedRoom = null;
        private List<RoomInfo> iRooms = null;
        private List<TimeInfo> iTimes = null;
        private List<StudentConflictInfo> iStudentConflicts = null;
        private List<DistributionInfo> iDistributionConflicts = null;
        private List<BtbInstructorInfo> iBtbInstructorConflicts = null;
        private String iConflict = null;
        private Map<String, Double> iObjectives = null;
        private Map<String, Double> iAssignedObjectives = null;
        private boolean iCanUnassign = false;

        public void setClazz(ClassInfo clazz) {
            this.iClass = clazz;
        }

        public ClassInfo getClazz() {
            return this.iClass;
        }

        public void setTime(TimeInfo time) {
            this.iTime = time;
        }

        public TimeInfo getTime() {
            return this.iTime;
        }

        public int getNrRooms() {
            return this.iRoom == null ? 0 : this.iRoom.size();
        }

        public void setRoom(RoomInfo room) {
            if (this.iRoom == null) {
                this.iRoom = new ArrayList<RoomInfo>();
            }
            this.iRoom.add(room);
        }

        public List<RoomInfo> getRoom() {
            return this.iRoom;
        }

        public int getNrInstructors() {
            return this.iInstructor == null ? 0 : this.iInstructor.size();
        }

        public void setInstructor(InstructorInfo instructor) {
            if (this.iInstructor == null) {
                this.iInstructor = new ArrayList<InstructorInfo>();
            }
            this.iInstructor.add(instructor);
        }

        public List<InstructorInfo> getInstructor() {
            return this.iInstructor;
        }

        public void setInitialTime(TimeInfo time) {
            this.iInitialTime = time;
        }

        public TimeInfo getInitialTime() {
            return this.iInitialTime;
        }

        public int getNrInitialRooms() {
            return this.iInitialRoom == null ? 0 : this.iInitialRoom.size();
        }

        public void setInitialRoom(RoomInfo room) {
            if (this.iInitialRoom == null) {
                this.iInitialRoom = new ArrayList<RoomInfo>();
            }
            this.iInitialRoom.add(room);
        }

        public List<RoomInfo> getInitialRoom() {
            return this.iInitialRoom;
        }

        public void setAssignedTime(TimeInfo time) {
            this.iAssignedTime = time;
        }

        public TimeInfo getAssignedTime() {
            return this.iAssignedTime;
        }

        public int getNrAssignedRooms() {
            return this.iAssignedRoom == null ? 0 : this.iAssignedRoom.size();
        }

        public void setAssignedRoom(RoomInfo room) {
            if (this.iAssignedRoom == null) {
                this.iAssignedRoom = new ArrayList<RoomInfo>();
            }
            this.iAssignedRoom.add(room);
        }

        public List<RoomInfo> getAssignedRoom() {
            return this.iAssignedRoom;
        }

        public boolean hasRooms() {
            return this.iRooms != null && !this.iRooms.isEmpty();
        }

        public void addRoom(RoomInfo room) {
            if (this.iRooms == null) {
                this.iRooms = new ArrayList<RoomInfo>();
            }
            this.iRooms.add(room);
        }

        public List<RoomInfo> getRooms() {
            return this.iRooms;
        }

        public boolean hasTimes() {
            return this.iTimes != null && !this.iTimes.isEmpty();
        }

        public void addTime(TimeInfo time) {
            if (this.iTimes == null) {
                this.iTimes = new ArrayList<TimeInfo>();
            }
            this.iTimes.add(time);
        }

        public List<TimeInfo> getTimes() {
            return this.iTimes;
        }

        public boolean isCanUnassign() {
            return this.iCanUnassign;
        }

        public void setCanUnassign(boolean canUnassign) {
            this.iCanUnassign = canUnassign;
        }

        public SelectedAssignment getSelection() {
            if (this.getTime() == null) {
                return null;
            }
            SelectedAssignment selection = new SelectedAssignment();
            selection.setClassId(this.getClazz().getClassId());
            selection.setDatePatternId(this.getTime().getDatePatternId());
            selection.setDays(this.getTime().getDays());
            selection.setPatternId(this.getTime().getPatternId());
            selection.setStartSlot(this.getTime().getStartSlot());
            if (this.getRoom() != null) {
                for (RoomInfo room : this.getRoom()) {
                    selection.addRoomId(room.getId());
                }
            }
            return selection;
        }

        public SelectedAssignment getAssignedSelection() {
            if (this.getAssignedTime() == null) {
                return null;
            }
            SelectedAssignment selection = new SelectedAssignment();
            selection.setClassId(this.getClazz().getClassId());
            selection.setDatePatternId(this.getAssignedTime().getDatePatternId());
            selection.setDays(this.getAssignedTime().getDays());
            selection.setPatternId(this.getAssignedTime().getPatternId());
            selection.setStartSlot(this.getAssignedTime().getStartSlot());
            if (this.getAssignedRoom() != null) {
                for (RoomInfo room : this.getAssignedRoom()) {
                    selection.addRoomId(room.getId());
                }
            }
            return selection;
        }

        public boolean hasStudentConflicts() {
            return this.iStudentConflicts != null && !this.iStudentConflicts.isEmpty();
        }

        public void addStudentConflict(StudentConflictInfo conf) {
            if (this.iStudentConflicts == null) {
                this.iStudentConflicts = new ArrayList<StudentConflictInfo>();
            }
            this.iStudentConflicts.add(conf);
        }

        public List<StudentConflictInfo> getStudentConflicts() {
            return this.iStudentConflicts;
        }

        public int countStudentConflicts() {
            if (this.iStudentConflicts == null) {
                return 0;
            }
            int ret = 0;
            for (StudentConflictInfo c : this.iStudentConflicts) {
                ret += c.getInfo().getJenrl();
            }
            return ret;
        }

        public boolean hasDistributionConflicts() {
            return this.iDistributionConflicts != null && !this.iDistributionConflicts.isEmpty();
        }

        public void addDistributionConflict(DistributionInfo conf) {
            if (this.iDistributionConflicts == null) {
                this.iDistributionConflicts = new ArrayList<DistributionInfo>();
            }
            this.iDistributionConflicts.add(conf);
        }

        public List<DistributionInfo> getDistributionConflicts() {
            return this.iDistributionConflicts;
        }

        public boolean hasViolatedDistributionConflicts() {
            if (this.iDistributionConflicts == null) {
                return false;
            }
            for (DistributionInfo di : this.iDistributionConflicts) {
                if (di.getInfo().isSatisfied()) continue;
                return true;
            }
            return false;
        }

        public double countDistributionConflicts() {
            if (this.iDistributionConflicts == null) {
                return 0.0;
            }
            double ret = 0.0;
            for (DistributionInfo c : this.iDistributionConflicts) {
                if (!c.getInfo().hasValue()) continue;
                ret += c.getInfo().getValue().doubleValue();
            }
            return ret;
        }

        public boolean hasBtbInstructorConflicts() {
            return this.iBtbInstructorConflicts != null && !this.iBtbInstructorConflicts.isEmpty();
        }

        public void addBtbInstructorConflict(BtbInstructorInfo conf) {
            if (this.iBtbInstructorConflicts == null) {
                this.iBtbInstructorConflicts = new ArrayList<BtbInstructorInfo>();
            }
            this.iBtbInstructorConflicts.add(conf);
        }

        public List<BtbInstructorInfo> getBtbInstructorConflicts() {
            return this.iBtbInstructorConflicts;
        }

        public boolean isInitial() {
            return this.getAssignedTime() != null && this.getAssignedRoom() != null && this.getAssignedTime().equals(this.getInitialTime()) && this.getAssignedRoom().equals(this.getInitialRoom());
        }

        public int getNrDates() {
            HashSet<Long> dates = new HashSet<Long>();
            if (this.getTimes() != null) {
                for (TimeInfo time : this.getTimes()) {
                    dates.add(time.getDatePatternId());
                }
            }
            return dates.size();
        }

        public String getConflict() {
            return this.iConflict;
        }

        public void setConflict(String conflict) {
            this.iConflict = conflict;
        }

        public boolean hasConflict() {
            return this.iConflict != null && !this.iConflict.isEmpty();
        }

        public String toString() {
            Object ret;
            block3: {
                block2: {
                    Object object = ret = this.getClazz() == null ? "" : this.getClazz().toString();
                    ret = this.getAssignedTime() != null ? (String)ret + ": " + String.valueOf(this.getAssignedTime()) : (this.getTime() != null ? (String)ret + ": " + String.valueOf(this.getTime()) : (String)ret + ": Not Assigned");
                    if (this.getAssignedRoom() == null) break block2;
                    for (int i = 0; i < this.getAssignedRoom().size(); ++i) {
                        ret = (String)ret + (i == 0 ? "" : ", ") + String.valueOf(this.getAssignedRoom().get(i));
                    }
                    break block3;
                }
                if (this.getRoom() == null) break block3;
                for (int i = 0; i < this.getRoom().size(); ++i) {
                    ret = (String)ret + (i == 0 ? "" : ", ") + String.valueOf(this.getRoom().get(i));
                }
            }
            return ret;
        }

        public boolean hasObjectives() {
            return this.iObjectives != null;
        }

        public void setObjective(String name, Double value) {
            if (this.iObjectives == null) {
                this.iObjectives = new HashMap<String, Double>();
            }
            this.iObjectives.put(name, value);
        }

        public Map<String, Double> getObjectives() {
            return this.iObjectives;
        }

        public double getObjective(String name) {
            if (this.iObjectives == null) {
                return 0.0;
            }
            Double value = this.iObjectives.get(name);
            return value == null ? 0.0 : value;
        }

        public boolean hasAssignedObjectives() {
            return this.iAssignedObjectives != null;
        }

        public void setAssignedObjective(String name, Double value) {
            if (this.iAssignedObjectives == null) {
                this.iAssignedObjectives = new HashMap<String, Double>();
            }
            this.iAssignedObjectives.put(name, value);
        }

        public Map<String, Double> getAssignedObjectives() {
            return this.iAssignedObjectives;
        }

        public double getAssignedObjective(String name) {
            if (this.iAssignedObjectives == null) {
                return 0.0;
            }
            Double value = this.iAssignedObjectives.get(name);
            return value == null ? 0.0 : value;
        }
    }

    public static class ClassAssignmentDetailsRequest
    implements GwtRpcRequest<ClassAssignmentDetails>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iClassId;
        private List<SelectedAssignment> iAssignments;

        public ClassAssignmentDetailsRequest() {
        }

        public ClassAssignmentDetailsRequest(Long classId) {
            this.setClassId(classId);
        }

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public boolean hasAssignments() {
            return this.iAssignments != null && !this.iAssignments.isEmpty();
        }

        public void addAssignment(SelectedAssignment a) {
            if (this.iAssignments == null) {
                this.iAssignments = new ArrayList<SelectedAssignment>();
            }
            Iterator<SelectedAssignment> i = this.iAssignments.iterator();
            while (i.hasNext()) {
                SelectedAssignment other = i.next();
                if (!other.equals(a)) continue;
                i.remove();
            }
            this.iAssignments.add(a);
        }

        public SelectedAssignment removeAssignment(Long classId) {
            if (this.iAssignments == null) {
                return null;
            }
            Iterator<SelectedAssignment> i = this.iAssignments.iterator();
            while (i.hasNext()) {
                SelectedAssignment other = i.next();
                if (!other.getClassId().equals(classId)) continue;
                i.remove();
                return other;
            }
            return null;
        }
    }

    public static class BtbInstructorInfo
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private ClassAssignmentDetails iOther = null;
        private ClassAssignmentDetails iAnother = null;
        private int iPref;

        public BtbInstructorInfo() {
        }

        public BtbInstructorInfo(ClassAssignmentDetails other, int pref) {
            this.iOther = other;
            this.iPref = pref;
        }

        public void setOther(ClassAssignmentDetails other) {
            this.iOther = other;
        }

        public ClassAssignmentDetails getOther() {
            return this.iOther;
        }

        public void setAnother(ClassAssignmentDetails another) {
            this.iAnother = another;
        }

        public ClassAssignmentDetails getAnother() {
            return this.iAnother;
        }

        public void setPreference(int preference) {
            this.iPref = preference;
        }

        public int getPreference() {
            return this.iPref;
        }
    }

    public static class DistributionInfo
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private GroupConstraintInfo iInfo;
        private List<ClassAssignmentDetails> iOther = new ArrayList<ClassAssignmentDetails>();

        public DistributionInfo() {
        }

        public DistributionInfo(GroupConstraintInfo info) {
            this.iInfo = info;
        }

        public void setInfo(GroupConstraintInfo info) {
            this.iInfo = info;
        }

        public GroupConstraintInfo getInfo() {
            return this.iInfo;
        }

        public void addClass(ClassAssignmentDetails other) {
            this.iOther.add(other);
        }

        public List<ClassAssignmentDetails> getOtherClasses() {
            return this.iOther;
        }
    }

    public static class GroupConstraintInfo
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        public String iPreference = "0";
        public boolean iIsSatisfied = false;
        public String iName = null;
        public String iType = null;
        public Double iValue = null;

        public String getPreference() {
            return this.iPreference;
        }

        public void setPreference(String preference) {
            this.iPreference = preference;
        }

        public boolean isSatisfied() {
            return this.iIsSatisfied;
        }

        public void setIsSatisfied(boolean isSatisfied) {
            this.iIsSatisfied = isSatisfied;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getType() {
            return this.iType;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public boolean hasValue() {
            return this.iValue != null;
        }

        public Double getValue() {
            return this.iValue;
        }

        public void setValue(Double value) {
            this.iValue = value;
        }
    }

    public static class StudentConflictInfo
    implements IsSerializable,
    Serializable,
    Comparable<StudentConflictInfo> {
        private static final long serialVersionUID = 1L;
        private JenrlInfo iInfo;
        private ClassAssignmentDetails iOther = null;
        private ClassAssignmentDetails iAnother = null;

        public StudentConflictInfo() {
        }

        public StudentConflictInfo(JenrlInfo jenrl, ClassAssignmentDetails other) {
            this.iInfo = jenrl;
            this.iOther = other;
        }

        public void setOther(ClassAssignmentDetails other) {
            this.iOther = other;
        }

        public ClassAssignmentDetails getOther() {
            return this.iOther;
        }

        public void setAnother(ClassAssignmentDetails another) {
            this.iAnother = another;
        }

        public ClassAssignmentDetails getAnother() {
            return this.iAnother;
        }

        public void setInfo(JenrlInfo info) {
            this.iInfo = info;
        }

        public JenrlInfo getInfo() {
            return this.iInfo;
        }

        @Override
        public int compareTo(StudentConflictInfo o) {
            if (this.getInfo().getJenrl() != o.getInfo().getJenrl()) {
                return this.getInfo().getJenrl() > o.getInfo().getJenrl() ? -1 : 1;
            }
            int cmp = this.getOther().getClazz().getName().compareTo(o.getOther().getClazz().getName());
            if (cmp != 0) {
                return cmp;
            }
            return this.getOther().getClazz().compareTo(o.getOther().getClazz());
        }
    }

    public static class JenrlInfo
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        public int iJenrl = 0;
        public boolean iIsSatisfied = false;
        public boolean iIsHard = false;
        public boolean iIsDistance = false;
        public boolean iIsFixed = false;
        public boolean iIsCommited = false;
        public boolean iIsImportant = false;
        public boolean iIsInstructor = false;
        public boolean iIsWorkDay = false;
        public double iDistance = 0.0;
        private TreeSet<CurriculumInfo> iCurriculum2nrStudents = null;

        public int getJenrl() {
            return this.iJenrl;
        }

        public void setJenrl(int jenrl) {
            this.iJenrl = jenrl;
        }

        public boolean isSatisfied() {
            return this.iIsSatisfied;
        }

        public void setIsSatisfied(boolean isSatisfied) {
            this.iIsSatisfied = isSatisfied;
        }

        public boolean isHard() {
            return this.iIsHard;
        }

        public void setIsHard(boolean isHard) {
            this.iIsHard = isHard;
        }

        public boolean isDistance() {
            return this.iIsDistance;
        }

        public void setIsDistance(boolean isDistance) {
            this.iIsDistance = isDistance;
        }

        public boolean isFixed() {
            return this.iIsFixed;
        }

        public void setIsFixed(boolean isFixed) {
            this.iIsFixed = isFixed;
        }

        public boolean isCommited() {
            return this.iIsCommited;
        }

        public void setIsCommited(boolean isCommited) {
            this.iIsCommited = isCommited;
        }

        public boolean isImportant() {
            return this.iIsImportant;
        }

        public void setIsImportant(boolean isImportant) {
            this.iIsImportant = isImportant;
        }

        public boolean isWorkDay() {
            return this.iIsWorkDay;
        }

        public void setIsWorkDay(boolean isWorkDay) {
            this.iIsWorkDay = isWorkDay;
        }

        public boolean isInstructor() {
            return this.iIsInstructor;
        }

        public void setIsInstructor(boolean isInstructor) {
            this.iIsInstructor = isInstructor;
        }

        public double getDistance() {
            return this.iDistance;
        }

        public void setDistance(double distance) {
            this.iDistance = distance;
        }

        public boolean hasCurricula() {
            return this.iCurriculum2nrStudents != null;
        }

        public void addCurriculum(CurriculumInfo info) {
            if (this.iCurriculum2nrStudents == null) {
                this.iCurriculum2nrStudents = new TreeSet();
            }
            this.iCurriculum2nrStudents.add(info);
        }

        public Set<CurriculumInfo> getCurricula() {
            return this.iCurriculum2nrStudents;
        }
    }

    public static class CurriculumInfo
    implements IsSerializable,
    Serializable,
    Comparable<CurriculumInfo> {
        private static final long serialVersionUID = 1L;
        private String iName;
        private double iNrStudents;

        public CurriculumInfo() {
        }

        public CurriculumInfo(String name, double nrStudents) {
            this.iName = name;
            this.iNrStudents = nrStudents;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }

        public void setNrStudents(double nrStudents) {
            this.iNrStudents = nrStudents;
        }

        public double getNrStudents() {
            return this.iNrStudents;
        }

        @Override
        public int compareTo(CurriculumInfo i) {
            if (this.getNrStudents() != i.getNrStudents()) {
                return this.getNrStudents() > i.getNrStudents() ? -1 : 1;
            }
            return this.getName().compareTo(i.getName());
        }
    }

    public static class InstructorInfo
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iName;
        private Long iInstructorId;

        public InstructorInfo() {
        }

        public InstructorInfo(String name, Long instructorId) {
            this.iName = name;
            this.iInstructorId = instructorId;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }

        public void setId(Long id) {
            this.iInstructorId = id;
        }

        public Long getId() {
            return this.iInstructorId;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof InstructorInfo)) {
                return false;
            }
            return this.getId().equals(((InstructorInfo)o).getId());
        }
    }

    public static class TimeInfo
    implements IsSerializable,
    Serializable,
    Comparable<TimeInfo> {
        private static final long serialVersionUID = 1L;
        private int iDays;
        private int iStartSlot;
        private int iMin;
        private int iPref;
        private boolean iStrike = false;
        private Long iPatternId = null;
        private DateInfo iDatePattern = null;

        public TimeInfo() {
        }

        public TimeInfo(int days, int startSlot, int pref, int min, String datePatternName, Long patternId, Long datePatternId, int datePatternPref) {
            this.iDays = days;
            this.iStartSlot = startSlot;
            this.iPref = pref;
            this.iStrike = this.iPref > 500;
            this.iMin = min;
            this.iDatePattern = new DateInfo(datePatternId, datePatternName, datePatternPref);
            this.iPatternId = patternId;
        }

        public TimeInfo(SelectedAssignment assignment) {
            this.iDays = assignment.getDays();
            this.iStartSlot = assignment.getStartSlot();
            this.iPatternId = assignment.getPatternId();
            this.iDatePattern = new DateInfo(assignment);
        }

        public void setDays(int days) {
            this.iDays = days;
        }

        public int getDays() {
            return this.iDays;
        }

        public int getDaysOrder(Integer firstWorkDay) {
            int days = this.iDays;
            if (firstWorkDay != null && firstWorkDay != 0) {
                days = this.iDays << firstWorkDay;
                days = (days & 0x7F) + (days >> 7);
            }
            return sDayCode2Order[days];
        }

        public void setStartSlot(int startSlot) {
            this.iStartSlot = startSlot;
        }

        public int getStartSlot() {
            return this.iStartSlot;
        }

        public void setPref(int pref) {
            this.iPref = pref;
        }

        public int getPref() {
            return this.iPref;
        }

        public void setMin(int min) {
            this.iMin = min;
        }

        public int getMin() {
            return this.iMin;
        }

        public void setDatePatternName(String dpName) {
            if (this.iDatePattern == null) {
                this.iDatePattern = new DateInfo();
            }
            this.iDatePattern.setDatePatternName(dpName);
        }

        public String getDatePatternName() {
            return this.iDatePattern == null ? null : this.iDatePattern.getDatePatternName();
        }

        public void setStriked(boolean striked) {
            this.iStrike = striked;
        }

        public boolean isStriked() {
            return this.iStrike;
        }

        public void setPatternId(Long patternId) {
            this.iPatternId = patternId;
        }

        public Long getPatternId() {
            return this.iPatternId;
        }

        public void setDatePatternId(Long dpId) {
            if (this.iDatePattern == null) {
                this.iDatePattern = new DateInfo();
            }
            this.iDatePattern.setDatePatternId(dpId);
        }

        public Long getDatePatternId() {
            return this.iDatePattern == null ? null : this.iDatePattern.getDatePatternId();
        }

        public void setDatePatternPreference(int dpPref) {
            if (this.iDatePattern == null) {
                this.iDatePattern = new DateInfo();
            }
            this.iDatePattern.setDatePatternPreference(dpPref);
        }

        public int getDatePatternPreference() {
            return this.iDatePattern == null ? null : Integer.valueOf(this.iDatePattern.getDatePatternPreference());
        }

        public DateInfo getDatePattern() {
            return this.iDatePattern;
        }

        public boolean hasDatePattern() {
            return this.iDatePattern != null;
        }

        public String getDaysName(Integer firstDay, GwtConstants CONSTANTS) {
            return this.getDaysName(firstDay, CONSTANTS.shortDays());
        }

        public String getDaysName(Integer firstDay, String[] shortDays) {
            if (shortDays == null) {
                shortDays = new String[]{"M", "T", "W", "Th", "F", "S", "Su"};
            }
            Object ret = "";
            for (int i = 0; i < DayCode.values().length; ++i) {
                int idx = firstDay == null ? i : (i + firstDay) % 7;
                DayCode dc = DayCode.values()[idx];
                if ((dc.getCode() & this.iDays) == 0) continue;
                ret = (String)ret + shortDays[dc.ordinal()];
            }
            return ret;
        }

        public String getDaysName() {
            return this.getDaysName(null, new String[]{"M", "T", "W", "Th", "F", "S", "Su"});
        }

        public static String slot2time(int timeSinceMidnight, boolean useAmPm) {
            int hour = timeSinceMidnight / 60;
            int min = timeSinceMidnight % 60;
            if (useAmPm) {
                return (hour == 0 ? 12 : (hour > 12 ? hour - 12 : hour)) + ":" + (min < 10 ? "0" : "") + min + (hour < 24 && hour >= 12 ? "p" : "a");
            }
            return hour + ":" + (min < 10 ? "0" : "") + min;
        }

        public static String slot2time(int timeSinceMidnight) {
            int hour = timeSinceMidnight / 60;
            int min = timeSinceMidnight % 60;
            return hour + (min < 10 ? "0" : "") + min;
        }

        public String getStartTime(GwtConstants CONSTANTS) {
            return TimeInfo.slot2time(5 * this.iStartSlot, CONSTANTS.useAmPm());
        }

        public String getEndTime(GwtConstants CONSTANTS) {
            return TimeInfo.slot2time(5 * this.iStartSlot + this.iMin, CONSTANTS.useAmPm());
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof TimeInfo)) {
                return false;
            }
            TimeInfo t = (TimeInfo)o;
            return t.getDays() == this.getDays() && t.getStartSlot() == this.getStartSlot() && t.getPatternId().equals(this.getPatternId()) && t.getDatePatternId().equals(this.getDatePatternId());
        }

        public String getName(Integer firstDay, boolean endTime, GwtConstants CONSTANTS) {
            return this.getDaysName(firstDay, CONSTANTS) + " " + this.getStartTime(CONSTANTS) + (String)(endTime ? " - " + this.getEndTime(CONSTANTS) : "");
        }

        public int compareTo(TimeInfo t, Integer firstDay) {
            if (this.isStriked() && !t.isStriked()) {
                return 1;
            }
            if (!this.isStriked() && t.isStriked()) {
                return -1;
            }
            int cmp = TableInterface.NaturalOrderComparator.compare(this.getDatePatternName(), t.getDatePatternName());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Double.compare(this.getDaysOrder(firstDay), t.getDaysOrder(firstDay));
            if (cmp != 0) {
                return cmp;
            }
            cmp = Double.compare(this.getStartSlot(), t.getStartSlot());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Double.compare(this.getMin(), t.getMin());
            return cmp;
        }

        @Override
        public int compareTo(TimeInfo t) {
            return this.compareTo(t, null);
        }

        public String toString() {
            return (String)(this.hasDatePattern() ? this.getDatePatternName() + " " : "") + this.getDaysName(null, new String[]{"A", "B", "C", "D", "E", "F", "G"}) + " " + TimeInfo.slot2time(5 * this.iStartSlot) + " - " + TimeInfo.slot2time(5 * this.iStartSlot + this.iMin);
        }
    }

    public static class DateInfo
    implements IsSerializable,
    Serializable,
    Comparable<DateInfo> {
        private static final long serialVersionUID = 1L;
        private String iDatePatternName;
        private int iDatePatternPref;
        private Long iDatePatternId;

        public DateInfo() {
        }

        public DateInfo(Long id, String name, int pref) {
            this.iDatePatternId = id;
            this.iDatePatternName = name;
            this.iDatePatternPref = pref;
        }

        public DateInfo(SelectedAssignment assignment) {
            this.iDatePatternId = assignment.getDatePatternId();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof DateInfo)) {
                return false;
            }
            DateInfo d = (DateInfo)o;
            if (this.getDatePatternId() != null && d.getDatePatternId() != null) {
                return this.getDatePatternId().equals(d.getDatePatternId());
            }
            return this.getDatePatternName().equals(d.getDatePatternName());
        }

        public int hashCode() {
            return this.getDatePatternId() == null ? this.getDatePatternName().hashCode() : this.getDatePatternId().hashCode();
        }

        public void setDatePatternName(String dpName) {
            this.iDatePatternName = dpName;
        }

        public String getDatePatternName() {
            return this.iDatePatternName;
        }

        public void setDatePatternId(Long dpId) {
            this.iDatePatternId = dpId;
        }

        public Long getDatePatternId() {
            return this.iDatePatternId;
        }

        public void setDatePatternPreference(int dpPref) {
            this.iDatePatternPref = dpPref;
        }

        public int getDatePatternPreference() {
            return this.iDatePatternPref;
        }

        @Override
        public int compareTo(DateInfo d) {
            int cmp = TableInterface.NaturalOrderComparator.compare(this.getDatePatternName(), d.getDatePatternName());
            if (cmp != 0) {
                return cmp;
            }
            return this.getDatePatternId().compareTo(d.getDatePatternId());
        }
    }

    public static enum DayCode {
        MON(64),
        TUE(32),
        WED(16),
        THU(8),
        FRI(4),
        SAT(2),
        SUN(1);

        private int iCode;

        private DayCode(int code) {
            this.iCode = code;
        }

        public int getCode() {
            return this.iCode;
        }
    }

    public static class RoomInfo
    implements IsSerializable,
    Serializable,
    Comparable<RoomInfo> {
        private static final long serialVersionUID = 1L;
        private String iName;
        private Long iRoomId;
        private int iPref;
        private int iSize;
        private boolean iStrike;

        public RoomInfo() {
        }

        public RoomInfo(String name, Long roomId, int size, int pref) {
            this.iName = name;
            this.iRoomId = roomId;
            this.iPref = pref;
            this.iSize = size;
            this.iStrike = this.iPref > 500;
        }

        public RoomInfo(Long roomId) {
            this.iRoomId = roomId;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }

        public void setId(Long id) {
            this.iRoomId = id;
        }

        public Long getId() {
            return this.iRoomId;
        }

        public void setPref(int pref) {
            this.iPref = pref;
        }

        public int getPref() {
            return this.iPref;
        }

        public void setStriked(boolean striked) {
            this.iStrike = striked;
        }

        public boolean isStriked() {
            return this.iStrike;
        }

        public void setSize(int size) {
            this.iSize = size;
        }

        public int getSize() {
            return this.iSize;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof RoomInfo)) {
                return false;
            }
            return this.getId().equals(((RoomInfo)o).getId());
        }

        @Override
        public int compareTo(RoomInfo r) {
            if (this.isStriked() && !r.isStriked()) {
                return 1;
            }
            if (!this.isStriked() && r.isStriked()) {
                return -1;
            }
            return TableInterface.NaturalOrderComparator.compare(this.getName(), r.getName());
        }

        public String toString() {
            return this.getName() == null ? this.getId().toString() : this.getName();
        }
    }

    public static class ClassInfo
    implements IsSerializable,
    Serializable,
    Comparable<ClassInfo> {
        private static final long serialVersionUID = 1L;
        private String iName;
        private Long iClassId;
        private String iPref;
        private int iRoomCap;
        private int iNrRooms;
        private int iOrd = -1;
        private String iNote;

        public ClassInfo() {
        }

        public ClassInfo(String name, Long classId, int nrRooms, String pref, int roomCapacity, int ord, String note) {
            this.iName = name;
            this.iClassId = classId;
            this.iPref = pref;
            this.iNrRooms = nrRooms;
            this.iRoomCap = roomCapacity;
            this.iOrd = ord;
            this.iNote = note;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public void setRoomCapacity(int roomCap) {
            this.iRoomCap = roomCap;
        }

        public int getRoomCapacity() {
            return this.iRoomCap;
        }

        public void setPref(String pref) {
            this.iPref = pref;
        }

        public String getPref() {
            return this.iPref;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNrRooms(int nrRooms) {
            this.iNrRooms = nrRooms;
        }

        public int nrRooms() {
            return this.iNrRooms;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ClassInfo)) {
                return false;
            }
            return this.getClassId().equals(((ClassInfo)o).getClassId());
        }

        @Override
        public int compareTo(ClassInfo ci) {
            int cmp;
            if (this.iOrd >= 0 && ci.iOrd >= 0 && (cmp = Double.compare(this.iOrd, ci.iOrd)) != 0) {
                return cmp;
            }
            cmp = TableInterface.NaturalOrderComparator.compare(this.getName(), ci.getName());
            if (cmp != 0) {
                return cmp;
            }
            return this.getClassId().compareTo(ci.getClassId());
        }

        public String toString() {
            return this.getName() == null ? this.getClassId().toString() : this.getName();
        }
    }
}

