/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.DistributionPref;

public class DistributionPrefsForm
implements UniTimeForm {
    private static final long serialVersionUID = 6316876654471770646L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    public static final String SUBJ_AREA_ATTR_LIST = "subjectAreaList";
    public static final String CRS_NUM_ATTR_LIST = "courseNbrList";
    public static final String ITYPE_ATTR_LIST = "itypeList";
    public static final String CLASS_NUM_ATTR_LIST = "classNumList";
    public static final String ALL_CLASSES_SELECT = "-1";
    public static final String LIST_SIZE_ATTR = "listSize";
    private String op;
    private String distType;
    private String prefLevel;
    private String owner;
    private String distPrefId;
    private List<String> subjectArea;
    private List<String> courseNbr;
    private List<String> itype;
    private List<String> classNumber;
    private String description;
    private String groupingDescription;
    private String grouping;
    private String filterSubjectAreaId;
    private Collection filterSubjectAreas;
    private String filterCourseNbr;

    public DistributionPrefsForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (this.distType == null || this.distType.equals("-")) {
            action.addFieldError("distType", MSG.errorSelectDistributionType());
        }
        if (this.prefLevel == null || this.prefLevel.equals("-")) {
            action.addFieldError("prefLevel", MSG.errorSelectDistributionPreferenceLevel());
        }
        if (!this.checkClasses()) {
            action.addFieldError("classes", MSG.errorInvalidClassSelectionDP());
        }
        if (this.op.equals(MSG.accessSaveNewDistributionPreference()) || this.op.equals(MSG.accessUpdateDistributionPreference())) {
            if (this.subjectArea.size() == 0) {
                action.addFieldError("classes", MSG.errorInvalidClassSelectionDPSubpart());
            }
            if (this.subjectArea.size() == 1 && !this.classNumber.get(0).toString().equals(ALL_CLASSES_SELECT)) {
                action.addFieldError("classes", MSG.errorInvalidClassSelectionDPMinTwoClasses());
            }
            if (this.subjectArea.size() > 1) {
                HashMap<String, String> mapSubparts = new HashMap<String, String>();
                HashMap<String, String> mapClasses = new HashMap<String, String>();
                for (int i = 0; i < this.subjectArea.size(); ++i) {
                    String subpart = this.itype.get(i).toString();
                    String classNum = this.classNumber.get(i).toString();
                    if (classNum.equals(ALL_CLASSES_SELECT)) {
                        if (mapClasses.get(subpart) != null) {
                            action.addFieldError("classes", MSG.errorInvalidClassSelectionDPIndividualClass());
                            break;
                        }
                        mapSubparts.put(subpart, classNum);
                        continue;
                    }
                    if (mapSubparts.get(subpart) != null) {
                        action.addFieldError("classes", MSG.errorInvalidClassSelectionDPIndividualClass());
                        break;
                    }
                    mapClasses.put(subpart, classNum);
                }
            }
        }
    }

    public boolean checkClasses() {
        HashMap<CallSite, String> map = new HashMap<CallSite, String>();
        for (int i = 0; i < this.subjectArea.size(); ++i) {
            if (this.subjectArea.get(i) == null || this.subjectArea.get(i).toString().equals("-")) {
                return false;
            }
            if (this.courseNbr.get(i) == null || this.courseNbr.get(i).toString().equals("-")) {
                return false;
            }
            if (this.itype.get(i) == null || this.itype.get(i).toString().equals("-")) {
                return false;
            }
            if (this.classNumber.get(i) == null || this.classNumber.get(i).toString().equals("-")) {
                return false;
            }
            String str = this.subjectArea.get(i).toString() + this.courseNbr.get(i).toString() + this.itype.get(i).toString() + this.classNumber.get(i).toString();
            if (map.get(str) != null) {
                return false;
            }
            map.put((CallSite)((Object)str), "1");
        }
        return true;
    }

    @Override
    public void reset() {
        this.op = "";
        this.distPrefId = null;
        this.distType = "-";
        this.prefLevel = "-";
        this.owner = "";
        this.description = "";
        this.groupingDescription = "";
        this.subjectArea = new ArrayList<String>();
        this.courseNbr = new ArrayList<String>();
        this.itype = new ArrayList<String>();
        this.classNumber = new ArrayList<String>();
        this.grouping = "-";
        this.filterSubjectAreaId = null;
        this.filterCourseNbr = null;
        this.filterSubjectAreas = new ArrayList();
    }

    public String getDistPrefId() {
        return this.distPrefId;
    }

    public void setDistPrefId(String distPrefId) {
        this.distPrefId = distPrefId;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getPrefLevel() {
        return this.prefLevel;
    }

    public void setPrefLevel(String prefLevel) {
        this.prefLevel = prefLevel;
    }

    public String getDistType() {
        return this.distType;
    }

    public void setDistType(String distType) {
        this.distType = distType;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List<String> getSubjectArea() {
        return this.subjectArea;
    }

    public void setSubjectArea(List<String> subjectArea) {
        this.subjectArea = subjectArea;
    }

    public String getSubjectArea(int key) {
        return this.subjectArea.get(key);
    }

    public void setSubjectArea(int key, String value) {
        this.subjectArea.set(key, value);
    }

    public void addToSubjectArea(String value) {
        this.subjectArea.add(value);
    }

    public List<String> getCourseNbr() {
        return this.courseNbr;
    }

    public void setCourseNbr(List<String> courseNbr) {
        this.courseNbr = courseNbr;
    }

    public String getCourseNbr(int key) {
        return this.courseNbr.get(key);
    }

    public void setCourseNbr(int key, String value) {
        this.courseNbr.set(key, value);
    }

    public void addToCourseNbr(String value) {
        this.courseNbr.add(value);
    }

    public List<String> getItype() {
        return this.itype;
    }

    public void setItype(List<String> itype) {
        this.itype = itype;
    }

    public String getItype(int key) {
        return this.itype.get(key);
    }

    public void setItype(int key, String value) {
        this.itype.set(key, value);
    }

    public void addToItype(String value) {
        this.itype.add(value);
    }

    public List<String> getClassNumber() {
        return this.classNumber;
    }

    public void setClassNumber(List<String> classNumber) {
        this.classNumber = classNumber;
    }

    public String getClassNumber(int key) {
        return this.classNumber.get(key);
    }

    public void setClassNumber(int key, String value) {
        this.classNumber.set(key, value);
    }

    public void addToClassNumber(String value) {
        this.classNumber.add(value);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGroupingDescription() {
        return this.groupingDescription;
    }

    public void setGroupingDescription(String groupingDescription) {
        this.groupingDescription = groupingDescription;
    }

    public String getGrouping() {
        return this.grouping;
    }

    public DistributionPref.Structure getStructure() {
        for (DistributionPref.Structure structure : DistributionPref.Structure.values()) {
            if (!structure.getName().equals(this.grouping)) continue;
            return structure;
        }
        return DistributionPref.Structure.AllClasses;
    }

    public void setGrouping(String grouping) {
        this.grouping = grouping;
    }

    public void setStructure(DistributionPref.Structure structure) {
        this.grouping = structure == null ? DistributionPref.Structure.AllClasses.getName() : structure.getName();
    }

    public String[] getGroupings() {
        String[] ret = new String[DistributionPref.Structure.values().length];
        for (int i = 0; i < DistributionPref.Structure.values().length; ++i) {
            ret[i] = DistributionPref.Structure.values()[i].getName();
        }
        return ret;
    }

    public void addNewClass(String subjectAreaId) {
        if (subjectAreaId == null || subjectAreaId.trim().length() == 0) {
            this.addToSubjectArea("-");
        } else {
            this.addToSubjectArea(subjectAreaId);
        }
        this.addToCourseNbr("-");
        this.addToItype("-");
        this.addToClassNumber("-");
    }

    public void removeFromLists(int key) {
        this.subjectArea.remove(key);
        this.courseNbr.remove(key);
        this.itype.remove(key);
        this.classNumber.remove(key);
    }

    public void swap(int index, int index2) {
        String objSa = this.subjectArea.get(index);
        String objCo = this.courseNbr.get(index);
        String objIt = this.itype.get(index);
        String objCl = this.classNumber.get(index);
        String objSa2 = this.subjectArea.get(index2);
        String objCo2 = this.courseNbr.get(index2);
        String objIt2 = this.itype.get(index2);
        String objCl2 = this.classNumber.get(index2);
        this.subjectArea.set(index, objSa2);
        this.subjectArea.set(index2, objSa);
        this.courseNbr.set(index, objCo2);
        this.courseNbr.set(index2, objCo);
        this.itype.set(index, objIt2);
        this.itype.set(index2, objIt);
        this.classNumber.set(index, objCl2);
        this.classNumber.set(index2, objCl);
    }

    public String getFilterSubjectAreaId() {
        return this.filterSubjectAreaId;
    }

    public void setFilterSubjectAreaId(String filterSubjectAreaId) {
        this.filterSubjectAreaId = filterSubjectAreaId;
    }

    public String getFilterCourseNbr() {
        return this.filterCourseNbr;
    }

    public void setFilterCourseNbr(String filterCourseNbr) {
        this.filterCourseNbr = filterCourseNbr;
    }

    public Collection getFilterSubjectAreas() {
        return this.filterSubjectAreas;
    }

    public void setFilterSubjectAreas(Collection filterSubjectAreas) {
        this.filterSubjectAreas = filterSubjectAreas;
    }
}

