/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.security.UserContext;

public class PageAccessFilter
implements Filter {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private static Log sLog = LogFactory.getLog(PageAccessFilter.class);
    private static DecimalFormat sDF = new DecimalFormat("0.00");
    private long debugTime = 30000L;
    private long dumpTime = 300000L;
    private boolean dumpSessionAttribues = false;

    public void init(FilterConfig cfg) throws ServletException {
        if (cfg.getInitParameter("debug-time") != null) {
            this.debugTime = Long.parseLong(cfg.getInitParameter("debug-time"));
        }
        if (cfg.getInitParameter("dump-time") != null) {
            this.dumpTime = Long.parseLong(cfg.getInitParameter("dump-time"));
        }
        if (cfg.getInitParameter("session-attributes") != null) {
            this.dumpSessionAttribues = Boolean.parseBoolean(cfg.getInitParameter("session-attributes"));
        }
    }

    private UserContext getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof UserContext) {
            return (UserContext)authentication.getPrincipal();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest r;
            long t0 = System.currentTimeMillis();
            UserContext user = this.getUser();
            if (user != null) {
                ApplicationProperties.setSessionId(user.getCurrentAcademicSessionId());
            }
            Throwable exception = null;
            try {
                chain.doFilter(request, response);
            }
            catch (Throwable t) {
                exception = t;
            }
            long t1 = System.currentTimeMillis();
            if (request instanceof HttpServletRequest && (t1 - t0 > this.debugTime || exception != null)) {
                r = (HttpServletRequest)request;
                String message = "Page " + r.getRequestURI() + " took " + sDF.format((double)(t1 - t0) / 1000.0) + " s.";
                if (exception != null) {
                    message = String.valueOf(exception) + " seen on page " + r.getRequestURI() + " (page took " + sDF.format((double)(t1 - t0) / 1000.0) + " s).";
                }
                if (exception == null && t1 - t0 <= this.dumpTime) {
                    u = this.getUser();
                    message = u == null ? message + "  (User: no user)" : message + "  (User: " + u.getUsername() + (String)(u.getCurrentAuthority() != null ? " (" + String.valueOf(u.getCurrentAuthority()) + ")" : "");
                } else {
                    String n;
                    u = null;
                    try {
                        u = this.getUser();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    message = u == null ? message + "\n  User: no user" : message + "\n  User: " + u.getUsername() + (String)(u.getCurrentAuthority() != null ? " (" + String.valueOf(u.getCurrentAuthority()) + ")" : "");
                    message = message + "\n  Request parameters:";
                    Enumeration e = r.getParameterNames();
                    while (e.hasMoreElements()) {
                        n = (String)e.nextElement();
                        if ("password".equals(n) || "form.password".equals(n)) continue;
                        message = message + "\n    " + n + "=" + r.getParameter(n);
                    }
                    try {
                        if (this.dumpSessionAttribues && r.getSession() != null) {
                            message = message + "\n  Session attributes:";
                            e = r.getSession().getAttributeNames();
                            while (e.hasMoreElements()) {
                                n = (String)e.nextElement();
                                message = message + "\n    " + n + "=" + String.valueOf(r.getSession().getAttribute(n));
                            }
                        }
                    }
                    catch (IllegalStateException e2) {
                        message = message + "\n    INVALID SESSION";
                    }
                }
                if (exception != null) {
                    sLog.warn((Object)message);
                } else {
                    sLog.info((Object)message);
                }
            }
            if (exception == null) return;
            if (exception instanceof PageAccessException && request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                r = (HttpServletRequest)request;
                HttpServletResponse x = (HttpServletResponse)response;
                String message = exception.getMessage();
                if (message == null || message.isEmpty()) {
                    HttpSession s = r.getSession();
                    message = this.getUser() == null ? (s.isNew() ? MESSAGES.authenticationExpired() : MESSAGES.authenticationRequired()) : MESSAGES.authenticationInsufficient();
                }
                x.sendRedirect(x.encodeURL(r.getContextPath() + "/loginRequired.action?message=" + message));
                return;
            }
            if (exception instanceof ServletException) {
                throw (ServletException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (!(exception instanceof RuntimeException)) throw new ServletException(exception);
            throw (RuntimeException)exception;
        }
        finally {
            ApplicationProperties.setSessionId(null);
        }
    }

    public void destroy() {
    }
}

