/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.tags;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.restlet.resource.ClientResource;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.QueryLog;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;

public class Registration
extends BodyTagSupport {
    private static final long serialVersionUID = 6840487122075978529L;
    private static Log sLog = LogFactory.getLog(Registration.class);
    private static String sMessage = null;
    private static String sKey = null;
    private static boolean sRegistered = false;
    private static String sNote = null;
    private Method iMethod = Method.status;
    private boolean iUpdate = false;
    private static long sLastRefresh = -1L;

    public String getMethod() {
        return this.iMethod.toString();
    }

    public void setMethod(String method) {
        this.iMethod = Method.valueOf(method);
    }

    public void setUpdate(boolean update) {
        this.iUpdate = update;
    }

    public boolean isUpdate() {
        return this.iUpdate;
    }

    public SessionContext getSessionContext() {
        return HttpSessionContext.getSessionContext(this.pageContext.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init() {
        sLastRefresh = System.currentTimeMillis();
        try {
            File regFile = new File(ApplicationProperties.getDataFolder(), "unitime.reg");
            if (sKey == null && regFile.exists()) {
                Properties reg = new Properties();
                try (FileInputStream in = new FileInputStream(regFile);){
                    reg.load(in);
                }
                sKey = reg.getProperty("key");
            }
            HashMap<String, Object> registration = new HashMap<String, Object>();
            if (sKey != null) {
                registration.put("key", sKey);
            } else {
                sLog.debug((Object)"No registration key found...");
            }
            registration.put("version", Constants.getVersion());
            registration.put("sessions", String.valueOf(QueryLog.getNrSessions(31)));
            registration.put("users", String.valueOf(QueryLog.getNrActiveUsers(31)));
            registration.put("url", this.pageContext.getRequest().getScheme() + "://" + this.pageContext.getRequest().getServerName() + ":" + this.pageContext.getRequest().getServerPort() + ((HttpServletRequest)this.pageContext.getRequest()).getContextPath());
            sLog.debug((Object)("Sending the following registration info: " + String.valueOf(registration)));
            Document input = DocumentHelper.createDocument();
            Element regEl = input.addElement("registration");
            for (Map.Entry entry : registration.entrySet()) {
                regEl.addElement((String)entry.getKey()).setText((String)entry.getValue());
            }
            sLog.debug((Object)"Contacting registration service...");
            ClientResource cr = new ClientResource("http://register.unitime.org/xml");
            StringWriter w = new StringWriter();
            new XMLWriter((Writer)w, OutputFormat.createPrettyPrint()).write(input);
            w.flush();
            w.close();
            String result = (String)cr.post((Object)w.toString(), String.class);
            sLog.info((Object)"Registration information received.");
            try {
                cr.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            StringReader r = new StringReader(result);
            Document output = new SAXReader().read((Reader)r);
            r.close();
            HashMap<String, String> ret = new HashMap<String, String>();
            for (Element e : output.getRootElement().elements()) {
                ret.put(e.getName(), e.getText());
            }
            String newKey = (String)ret.get("key");
            if (!newKey.equals(sKey)) {
                sKey = newKey;
                sLog.debug((Object)"New registration key received...");
                Properties reg = new Properties();
                reg.setProperty("key", sKey);
                try (FileOutputStream out = new FileOutputStream(regFile);){
                    reg.store(out, "UniTime " + Constants.VERSION + " registration file, please do not delete or modify.");
                    out.flush();
                }
            }
            sMessage = (String)ret.get("message");
            sNote = (String)ret.get("note");
            sRegistered = "1".equals(ret.get("registered"));
        }
        catch (Exception e) {
            sLog.error((Object)("Validation failed: " + e.getMessage()), (Throwable)e);
        }
    }

    private void refresh() {
        if ("1".equals(this.pageContext.getRequest().getParameter("refresh")) || System.currentTimeMillis() - sLastRefresh > 3600000L) {
            this.init();
        }
    }

    public int doStartTag() throws JspException {
        if (sLastRefresh < 0L) {
            this.init();
        }
        switch (this.iMethod) {
            case hasMessage: {
                if (!this.getSessionContext().hasPermission(Right.Registration)) {
                    return 0;
                }
                try {
                    this.refresh();
                    if (sNote != null && !sNote.isEmpty()) {
                        return 1;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return 0;
            }
        }
        return 2;
    }

    public int doEndTag() throws JspException {
        switch (this.iMethod) {
            case hasMessage: {
                return 6;
            }
            case message: {
                try {
                    if (sNote != null) {
                        this.pageContext.getOut().println(sNote);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return 6;
            }
            case status: {
                if (sMessage == null) {
                    return 6;
                }
                try {
                    this.pageContext.getOut().println(sMessage);
                    if (this.isUpdate()) {
                        Obtrusiveness obtrusiveness = Obtrusiveness.valueOf(ApplicationProperty.RegistrationPopupObtrusiveness.value());
                        if (this.getSessionContext().hasPermission(Right.Registration)) {
                            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
                            String uri = request.getRequestURL().toString().replaceFirst("/layouts/.*jsp", "/main.action?refresh=1");
                            String backUrl = URLEncoder.encode(uri, "ISO-8859-1");
                            this.pageContext.getOut().println("<br><span style=\"font-size: x-small;\">Click <a onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\" onClick=\"showGwtDialog('UniTime " + Constants.VERSION + " Registration', 'https://register.unitime.org?key=" + sKey + "&back=" + backUrl + "', '750px', '75%');\" title='UniTime " + Constants.VERSION + " Registration'>here</a> to " + (sRegistered ? "update the current registration" : "register") + ".</span>");
                            switch (obtrusiveness) {
                                case low: {
                                    if (sRegistered) break;
                                }
                                case high: 
                                case medium: {
                                    this.pageContext.getOut().println("<script>function gwtOnLoad() { gwtShowMessage(\"" + sMessage + "<br><span style='font-size: x-small;'>Click <a onMouseOver=\\\"this.style.cursor='hand';this.style.cursor='pointer';\\\" onCLick=\\\"showGwtDialog('UniTime " + Constants.VERSION + " Registration', 'https://register.unitime.org?key=" + sKey + "&back=" + backUrl + "', '750px', '75%');\\\" title='UniTime " + Constants.VERSION + " Registration'>here</a> to " + (sRegistered ? "update the current registration" : "register") + ".</span>\"); }</script>");
                                }
                            }
                        } else {
                            switch (obtrusiveness) {
                                case medium: {
                                    if (sRegistered) break;
                                }
                                case high: {
                                    this.pageContext.getOut().println("<script>function gwtOnLoad() { gwtShowMessage(\"" + sMessage + "\"); }</script>");
                                }
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return 6;
            }
        }
        return 6;
    }

    private static enum Method {
        hasMessage,
        message,
        status;

    }

    private static enum Obtrusiveness {
        high,
        medium,
        low,
        none;

    }
}

