/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.interfaces.ExternalClassEditAction;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.InstructorCoursePref;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.model.TimePatternTime;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseDatePatternPref;
import org.unitime.timetable.model.base.BaseDistributionPref;
import org.unitime.timetable.model.base.BaseInstructorCoursePref;
import org.unitime.timetable.model.comparators.DepartmentalInstructorComparator;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.DistributionTypeDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.PreferenceLevelDAO;
import org.unitime.timetable.model.dao.RoomFeatureDAO;
import org.unitime.timetable.model.dao.RoomGroupDAO;
import org.unitime.timetable.model.dao.TeachingResponsibilityDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.ClassDetailBackend;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.RequiredTimeTable;

@GwtRpcImplements(value=PrefGroupEditInterface.ClassEditRequest.class)
public class ClassEditBackend
implements GwtRpcImplementation<PrefGroupEditInterface.ClassEditRequest, PrefGroupEditInterface.ClassEditResponse> {
    protected static final CourseMessages CMSG = Localization.create(CourseMessages.class);

    @Override
    public PrefGroupEditInterface.ClassEditResponse execute(PrefGroupEditInterface.ClassEditRequest request, SessionContext context) {
        Session hibSession = Class_DAO.getInstance().getSession();
        Class_ clazz = (Class_)Class_DAO.getInstance().get(request.getId());
        context.checkPermission(clazz, Right.ClassEdit);
        TeachingResponsibility defaultTR = TeachingResponsibility.getDefaultInstructorTeachingResponsibility();
        if (request.getOperation() != null) {
            switch (request.getOperation()) {
                case CLEAR_CLASS_PREFS: {
                    context.checkPermission(clazz, Right.ClassEditClearPreferences);
                    ClassEditBackend.doClear(clazz.getPreferences(), Preference.Type.TIME, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING, Preference.Type.DATE);
                    hibSession.merge((Object)clazz);
                    hibSession.flush();
                    ChangeLog.addChange(null, context, clazz, ChangeLog.Source.CLASS_EDIT, ChangeLog.Operation.CLEAR_PREF, clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), clazz.getManagingDept());
                    PrefGroupEditInterface.ClassEditResponse ret = new PrefGroupEditInterface.ClassEditResponse();
                    ret.setUrl("clazz?id=" + clazz.getUniqueId());
                    return ret;
                }
                case UPDATE: 
                case NEXT: 
                case PREVIOUS: {
                    Transaction tx = hibSession.beginTransaction();
                    try {
                        PrefGroupEditInterface.ClassEditResponse data = (PrefGroupEditInterface.ClassEditResponse)request.getPayLoad();
                        clazz.setDisplayInstructor(data.isDisplayInstructors());
                        clazz.setEnabledForStudentScheduling(data.isStudentScheduling());
                        clazz.setSchedulePrintNote(data.getScheduleNote());
                        clazz.setNotes(data.getRequestNote());
                        clazz.setDatePattern(data.getDatePatternId() == null ? null : (DatePattern)DatePatternDAO.getInstance().get(data.getDatePatternId()));
                        boolean assignTeachingRequest = Department.isInstructorSchedulingCommitted(clazz.getControllingDept().getUniqueId());
                        HashSet<ClassInstructor> classInstrs = new HashSet<ClassInstructor>(clazz.getClassInstructors());
                        if (data.hasClassInstructors()) {
                            for (PrefGroupEditInterface.ClassInstr classInstr : data.getClassInstructors()) {
                                if (classInstr.getInstructorId() == null) continue;
                                DepartmentalInstructor deptInstr = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(classInstr.getInstructorId());
                                ClassInstructor classInstr2 = null;
                                Iterator<Object> j = classInstrs.iterator();
                                while (j.hasNext()) {
                                    ClassInstructor adept = (ClassInstructor)j.next();
                                    if (!adept.getInstructor().equals(deptInstr)) continue;
                                    classInstr2 = adept;
                                    j.remove();
                                    break;
                                }
                                if (classInstr2 == null) {
                                    classInstr2 = new ClassInstructor();
                                    classInstr2.setClassInstructing(clazz);
                                    classInstr2.setInstructor(deptInstr);
                                    deptInstr.getClasses().add(classInstr2);
                                    clazz.getClassInstructors().add(classInstr2);
                                    if (assignTeachingRequest) {
                                        for (TeachingClassRequest tcr : clazz.getTeachingRequests()) {
                                            if (!tcr.getAssignInstructor().booleanValue() || !tcr.getTeachingRequest().getAssignedInstructors().contains(deptInstr)) continue;
                                            classInstr2.setTeachingRequest(tcr.getTeachingRequest());
                                            break;
                                        }
                                    }
                                }
                                classInstr2.setLead(classInstr.isCheckConflicts());
                                classInstr2.setPercentShare(classInstr.getPercentShare());
                                classInstr2.setResponsibility(classInstr.getResponsibilityId() == null ? defaultTR : (TeachingResponsibility)TeachingResponsibilityDAO.getInstance().get(classInstr.getResponsibilityId()));
                            }
                        }
                        for (ClassInstructor classInstructor : classInstrs) {
                            DepartmentalInstructor instr = classInstructor.getInstructor();
                            instr.getClasses().remove(classInstructor);
                            clazz.getClassInstructors().remove(classInstructor);
                            hibSession.merge((Object)instr);
                            hibSession.remove((Object)classInstructor);
                        }
                        ClassEditBackend.doUpdate(clazz, clazz.getPreferences(), data, Preference.Type.TIME, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING, Preference.Type.DATE);
                        hibSession.merge((Object)clazz);
                        ChangeLog.addChange(null, context, clazz, ChangeLog.Source.CLASS_EDIT, ChangeLog.Operation.UPDATE, clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), clazz.getManagingDept());
                        String string = ApplicationProperty.ExternalActionClassEdit.value();
                        if (string != null && string.trim().length() > 0) {
                            ExternalClassEditAction externalClassEditAction = (ExternalClassEditAction)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            externalClassEditAction.performExternalClassEditAction(clazz, hibSession);
                        }
                        tx.commit();
                        tx = null;
                    }
                    catch (Exception e) {
                        if (tx != null) {
                            tx.rollback();
                        }
                        throw new GwtRpcException(e.getMessage(), e);
                    }
                    PrefGroupEditInterface.ClassEditResponse ret = new PrefGroupEditInterface.ClassEditResponse();
                    if (request.getOperation() == PrefGroupEditInterface.Operation.PREVIOUS && ((PrefGroupEditInterface.ClassEditResponse)request.getPayLoad()).getPreviousId() != null) {
                        ret.setUrl("classEdit?id=" + ((PrefGroupEditInterface.ClassEditResponse)request.getPayLoad()).getPreviousId());
                    } else if (request.getOperation() == PrefGroupEditInterface.Operation.NEXT && ((PrefGroupEditInterface.ClassEditResponse)request.getPayLoad()).getNextId() != null) {
                        ret.setUrl("classEdit?id=" + ((PrefGroupEditInterface.ClassEditResponse)request.getPayLoad()).getNextId());
                    } else {
                        ret.setUrl("clazz?id=" + clazz.getUniqueId());
                    }
                    return ret;
                }
                case DATE_PATTERN: {
                    PrefGroupEditInterface.ClassEditResponse ret = (PrefGroupEditInterface.ClassEditResponse)request.getPayLoad();
                    DatePattern datePattern = (DatePattern)DatePatternDAO.getInstance().get(ret.getDatePatternId());
                    if (datePattern == null) {
                        datePattern = clazz.getSchedulingSubpart().effectiveDatePattern();
                    }
                    List<PrefGroupEditInterface.Selection> dateSelections = ret.getDatePreferences() == null ? null : ret.getDatePreferences().getSelections();
                    ClassEditBackend.fillInDatePreferences(ret, clazz, null, datePattern, context, false);
                    if (ret.getDatePreferences() != null && dateSelections != null) {
                        for (PrefGroupEditInterface.Selection selection : dateSelections) {
                            if (ret.getDatePreferences().getItem(selection.getItem()) == null) continue;
                            ret.getDatePreferences().addSelection(selection);
                        }
                    }
                    List<PrefGroupEditInterface.TimeSelection> timeSelections = ret.getTimePreferences() == null ? null : ret.getTimePreferences().getSelections();
                    ClassEditBackend.fillInTimePreferences(ret, clazz, null, datePattern, context, false);
                    if (ret.getTimePreferences() != null && timeSelections != null) {
                        for (PrefGroupEditInterface.TimeSelection timeSelection : timeSelections) {
                            TimePattern tp;
                            PrefGroupEditInterface.TimePatternModel m = ret.getTimePreferences().getItem(timeSelection.getItem());
                            if (m == null && (tp = (TimePattern)TimePatternDAO.getInstance().get(timeSelection.getItem())) != null) {
                                m = ClassEditBackend.createTimePatternModel(clazz, tp, context);
                                m.setValid(false);
                                ret.getTimePreferences().addItem(m);
                            }
                            if (m == null) continue;
                            ret.getTimePreferences().addSelection(timeSelection);
                        }
                    }
                    return ret;
                }
                case INSTRUCTORS: {
                    PrefGroupEditInterface.ClassEditResponse ret = (PrefGroupEditInterface.ClassEditResponse)request.getPayLoad();
                    DatePattern datePattern = clazz.getSchedulingSubpart().effectiveDatePattern();
                    if (ret.getDatePatternId() != null && ret.getDatePatternId() >= 0L) {
                        datePattern = (DatePattern)DatePatternDAO.getInstance().get(ret.getDatePatternId());
                    }
                    Vector<DepartmentalInstructor> vector = new Vector<DepartmentalInstructor>();
                    if (ret.hasClassInstructors()) {
                        for (PrefGroupEditInterface.ClassInstr ci : ret.getClassInstructors()) {
                            DepartmentalInstructor di;
                            if (ci.getInstructorId() == null || !ci.isCheckConflicts() || (di = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(ci.getInstructorId())) == null) continue;
                            vector.add(di);
                        }
                    }
                    ClassEditBackend.fillInTimePreferences(ret, clazz, vector, datePattern, context, true);
                    ClassEditBackend.fillInRoomPreferences(ret, clazz, vector, context, true, false);
                    return ret;
                }
            }
        }
        PrefGroupEditInterface.ClassEditResponse ret = new PrefGroupEditInterface.ClassEditResponse();
        ret.setId(request.getId());
        ret.setName(clazz.getClassLabel());
        ret.setNbrRooms(clazz.getNbrRooms());
        ret.setDisplayInstructors(clazz.isDisplayInstructor());
        ret.setStudentScheduling(clazz.isEnabledForStudentScheduling());
        ret.setScheduleNote(clazz.getSchedulePrintNote());
        ret.setRequestNote(clazz.getNotes());
        Class_ next = clazz.getNextClass(context, Right.ClassEdit);
        ret.setNextId(next == null ? null : next.getUniqueId());
        Class_ previous = clazz.getPreviousClass(context, Right.ClassEdit);
        ret.setPreviousId(previous == null ? null : previous.getUniqueId());
        ret.setCanClearPrefs(context.hasPermission(clazz, Right.ClassEditClearPreferences));
        ret.setProperties(ClassDetailBackend.getProperties(clazz, context));
        List<StudentAccomodation.AccommodationCounter> acc = StudentAccomodation.getAccommodations(clazz);
        if (acc != null && !acc.isEmpty()) {
            TableInterface.CellInterface c = ret.getProperties().addProperty(CMSG.propertyAccommodations());
            TableInterface tableInterface = new TableInterface();
            for (StudentAccomodation.AccommodationCounter ac : acc) {
                tableInterface.addProperty(ac.getAccommodation().getName() + ":").setText(String.valueOf(ac.getCount()));
            }
            c.setTable(tableInterface);
        }
        DatePattern dp = clazz.getDatePattern();
        DatePattern datePattern = clazz.getSchedulingSubpart().effectiveDatePattern();
        ret.setSearchableDatePattern(ApplicationProperty.ClassEditSearcheableDatePattern.isTrue());
        if (dp != null) {
            ret.setDatePatternId(dp.getUniqueId());
        } else if (datePattern != null) {
            ret.setDatePatternId(-datePattern.getUniqueId().longValue());
        }
        if (datePattern != null) {
            ret.addDatePattern(-datePattern.getUniqueId().longValue(), CMSG.dropDefaultDatePattern() + " (" + datePattern.getName() + ")", datePattern.getDatePatternType() == DatePattern.DatePatternType.PatternSet ? null : datePattern.getPatternText());
        }
        for (DatePattern p : DatePattern.findAll(clazz.getSessionId(), context.getUser().getCurrentAuthority().hasRight(Right.ExtendedDatePatterns), clazz.getManagingDept(), dp)) {
            ret.addDatePattern(p.getUniqueId(), p.getName(), p.getDatePatternType() == DatePattern.DatePatternType.PatternSet ? null : p.getPatternText());
        }
        ClassEditBackend.fillInPreferences(ret, clazz, context, false);
        for (ClassInstructor ci : new TreeSet<ClassInstructor>(clazz.getClassInstructors())) {
            Iterator<TeachingResponsibility> i = new PrefGroupEditInterface.ClassInstr();
            ((PrefGroupEditInterface.ClassInstr)((Object)i)).setId(ci.getUniqueId());
            ((PrefGroupEditInterface.ClassInstr)((Object)i)).setInstructorId(ci.getInstructor().getUniqueId());
            ((PrefGroupEditInterface.ClassInstr)((Object)i)).setResponsibilityId(ci.getResponsibility() == null ? null : ci.getResponsibility().getUniqueId());
            ((PrefGroupEditInterface.ClassInstr)((Object)i)).setPercentShare(ci.getPercentShare());
            ((PrefGroupEditInterface.ClassInstr)((Object)i)).setCheckConflicts(ci.isLead());
            ret.addClassInstructor((PrefGroupEditInterface.ClassInstr)((Object)i));
        }
        NameFormat nameFormat = NameFormat.fromReference(UserProperty.NameFormat.get(context.getUser()));
        List instructors = Class_DAO.getInstance().getSession().createQuery("from DepartmentalInstructor where department.uniqueId = :deptId", DepartmentalInstructor.class).setParameter("deptId", (Object)clazz.getControllingDept().getUniqueId()).list();
        if (ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue()) {
            Collections.sort(instructors, new DepartmentalInstructorComparator(nameFormat));
        } else {
            Collections.sort(instructors, new DepartmentalInstructorComparator());
        }
        for (DepartmentalInstructor instructor : instructors) {
            ret.addInstructor(instructor.getUniqueId(), nameFormat.format(instructor), instructor.hasPreferences() ? "1" : "0");
        }
        for (TeachingResponsibility tr : TeachingResponsibility.getInstructorTeachingResponsibilities()) {
            ret.addResponsibility(tr.getUniqueId(), tr.getLabel(), tr.getAbbreviation());
        }
        ret.setDefaultResponsibilityId(defaultTR == null ? null : defaultTR.getUniqueId());
        String inheritInstructorPrefs = UserProperty.InheritInstructorPrefs.get(context.getUser());
        if (CommonValues.Never.eq(inheritInstructorPrefs)) {
            ret.setInheritInstructorPrefs(PrefGroupEditInterface.InheritInstructorPrefs.NEVER);
        } else if (CommonValues.Always.eq(inheritInstructorPrefs)) {
            ret.setInheritInstructorPrefs(PrefGroupEditInterface.InheritInstructorPrefs.ALWAYS);
        } else if (CommonValues.Ask.eq(inheritInstructorPrefs)) {
            ret.setInheritInstructorPrefs(PrefGroupEditInterface.InheritInstructorPrefs.ASK);
        }
        BackTracker.markForBack(context, "clazz?id=" + clazz.getUniqueId(), CMSG.backClass(clazz.getClassLabel()), true, false);
        return ret;
    }

    public static void fillInPreferences(PrefGroupEditInterface.PrefGroupEditResponse response, PreferenceGroup pg, SessionContext context) {
        ClassEditBackend.fillInPreferences(response, pg, context, false);
    }

    public static void fillInPreferences(PrefGroupEditInterface.PrefGroupEditResponse response, PreferenceGroup pg, SessionContext context, boolean examSeating) {
        ClassEditBackend.fillInPreferenceLevels(response, pg, context);
        ClassEditBackend.fillInTimePreferences(response, pg, null, pg.effectiveDatePattern(), context, true);
        ClassEditBackend.fillInRoomPreferences(response, pg, null, context, true, examSeating);
        ClassEditBackend.fillInDatePreferences(response, pg, null, pg.effectiveDatePattern(), context, true);
    }

    public static void fillInPreferenceLevels(PrefGroupEditInterface.PrefGroupEditResponse response, PreferenceGroup pg, SessionContext context) {
        if (response.getPrefLevels() != null) {
            response.getPrefLevels().clear();
        }
        List<PreferenceLevel> preferences = PreferenceLevel.getPreferenceLevelList(false);
        for (PreferenceLevel pref : preferences) {
            response.addPrefLevel(new PrefGroupEditInterface.PrefLevel(pref.getUniqueId(), pref.getPrefProlog(), pref.getAbbreviation(), pref.getPrefName(), pref.prefcolor(), PreferenceLevel.prolog2char(pref.getPrefProlog())));
        }
    }

    public static PrefGroupEditInterface.TimePatternModel createTimePatternModel(PreferenceGroup pg, TimePattern tp, SessionContext context) {
        boolean allowHardTime = context.hasPermission(pg, Right.CanUseHardTimePrefs);
        final PrefGroupEditInterface.TimePatternModel model = new PrefGroupEditInterface.TimePatternModel();
        model.setId(tp.getUniqueId());
        model.setName(tp.getName());
        model.setExactTime(tp.isExactTime());
        model.setDayOffset(ApplicationProperty.TimePatternFirstDayOfWeek.intValue());
        model.setAllowHard(allowHardTime);
        model.setReqConfirmation(CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.ConfirmationDialogs)));
        if (!model.isExactTime()) {
            model.setLength(5 * tp.getSlotsPerMtg() - tp.getBreakTime());
            for (TimePatternDays days : tp.getDays()) {
                model.addDays(days.getDayCode());
            }
            Collections.sort(model.getDays(), new Comparator<Integer>(){

                @Override
                public int compare(Integer d1, Integer d2) {
                    if (model.getDayOffset() == 0) {
                        return -d1.compareTo(d2);
                    }
                    for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                        boolean b;
                        int idx = (i + model.getDayOffset()) % 7;
                        boolean a = (d1 & Constants.DAY_CODES[idx]) != 0;
                        boolean bl = b = (d2 & Constants.DAY_CODES[idx]) != 0;
                        if (a == b) continue;
                        return a ? -1 : 1;
                    }
                    return 0;
                }
            });
            for (TimePatternTime time : tp.getTimes()) {
                model.addTime(time.getStartSlot());
            }
            Collections.sort(model.getTimes());
        }
        return model;
    }

    public static PrefGroupEditInterface.TimePatternModel createTimePatternModel(TimePref tp, SessionContext context) {
        PrefGroupEditInterface.TimePatternModel model = ClassEditBackend.createTimePatternModel(tp.getOwner(), tp.getTimePattern(), context);
        model.setPreference(tp.getPreference());
        List<PreferenceLevel> preferences = PreferenceLevel.getPreferenceLevelList(false);
        for (PreferenceLevel pref : preferences) {
            model.addPrefLevel(new PrefGroupEditInterface.PrefLevel(pref.getUniqueId(), pref.getPrefProlog(), pref.getAbbreviation(), pref.getPrefName(), pref.prefcolor(), PreferenceLevel.prolog2char(pref.getPrefProlog())));
        }
        model.setHorizontal(!CommonValues.VerticalGrid.eq(UserProperty.GridOrientation.get(context.getUser())));
        return model;
    }

    public static void fillInTimePreferences(PrefGroupEditInterface.PrefGroupEditResponse response, PreferenceGroup pg, Vector<DepartmentalInstructor> leadInstructors, DatePattern datePattern, SessionContext context, boolean fillPrefs) {
        List<TimePattern> timePatterns = null;
        if (pg instanceof Class_) {
            Class_ c = (Class_)pg;
            timePatterns = TimePattern.findApplicable(context.getUser(), c.getSchedulingSubpart().getMinutesPerWk(), datePattern, c.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel(), true, c.getManagingDept());
        } else if (pg instanceof SchedulingSubpart) {
            SchedulingSubpart ss = (SchedulingSubpart)pg;
            timePatterns = TimePattern.findApplicable(context.getUser(), ss.getMinutesPerWk(), datePattern, ss.getInstrOfferingConfig().getDurationModel(), false, ss.getManagingDept());
        } else if (pg instanceof DepartmentalInstructor) {
            Iterator<TimePref> ss = pg.effectivePreferences(TimePref.class).iterator();
            if (ss.hasNext()) {
                TimePref tp = ss.next();
                response.setInstructorTimePrefereneces(tp.getPreference());
            }
            if (!response.hasInstructorTimePrefereneces()) {
                response.setInstructorTimePrefereneces("2");
            }
            return;
        }
        if (timePatterns != null) {
            PrefGroupEditInterface.TimePreferences timePrefs = new PrefGroupEditInterface.TimePreferences(-5L, CMSG.propertyTime());
            timePrefs.setHorizontal(!RequiredTimeTable.getTimeGridVertical(context.getUser()));
            for (TimePattern timePattern : timePatterns) {
                timePrefs.addItem(ClassEditBackend.createTimePatternModel(pg, timePattern, context));
            }
            if (fillPrefs) {
                for (TimePref timePref : pg.effectivePreferences(TimePref.class, leadInstructors, false)) {
                    if (timePref.getTimePattern() == null) continue;
                    PrefGroupEditInterface.TimePatternModel m = timePrefs.getItem(timePref.getTimePattern().getUniqueId());
                    if (m == null) {
                        m = ClassEditBackend.createTimePatternModel(pg, timePref.getTimePattern(), context);
                        m.setValid(false);
                        timePrefs.addItem(m);
                    }
                    if (timePref.getTimePattern().isExactTime()) {
                        PrefGroupEditInterface.TimeSelection selection = timePrefs.getSelection(timePref.getTimePattern().getUniqueId());
                        if (selection == null) {
                            timePrefs.addSelection(new PrefGroupEditInterface.TimeSelection(timePref.getTimePattern().getUniqueId(), timePref.getPrefLevel().getUniqueId(), timePref.getPreference()));
                            continue;
                        }
                        selection.setPreference(selection.getPreference() + ";" + timePref.getPreference());
                        continue;
                    }
                    timePrefs.addSelection(new PrefGroupEditInterface.TimeSelection(timePref.getTimePattern().getUniqueId(), timePref.getPrefLevel().getUniqueId(), timePref.getPreference()));
                }
            }
            response.setTimePreferences(timePrefs);
        } else {
            response.setTimePreferences(null);
        }
    }

    protected static void fillInDatePreferences(PrefGroupEditInterface.PrefGroupEditResponse response, PreferenceGroup pg, Vector<DepartmentalInstructor> leadInstructors, DatePattern datePattern, SessionContext context, boolean fillPrefs) {
        boolean allowHardTime = context.hasPermission(pg, Right.CanUseHardTimePrefs);
        if (datePattern != null && datePattern.getDatePatternType() == DatePattern.DatePatternType.PatternSet) {
            TreeSet<DatePattern> datePatterns = new TreeSet<DatePattern>(datePattern.getChildren());
            if (!datePatterns.isEmpty()) {
                PrefGroupEditInterface.Preferences datePrefs = new PrefGroupEditInterface.Preferences(PrefGroupEditInterface.PreferenceType.DATE);
                datePrefs.setAllowHard(allowHardTime);
                for (DatePattern datePattern2 : datePatterns) {
                    datePrefs.addItem(datePattern2.getUniqueId(), datePattern2.getName(), datePattern2.getPatternString());
                }
                if (fillPrefs) {
                    for (DatePatternPref datePatternPref : pg.effectivePreferences(DatePatternPref.class, leadInstructors)) {
                        PrefGroupEditInterface.Selection selection = new PrefGroupEditInterface.Selection(datePatternPref.getDatePattern().getUniqueId(), datePatternPref.getPrefLevel().getUniqueId());
                        datePrefs.addSelection(selection);
                    }
                }
                response.setDatePreferences(datePrefs);
            } else {
                response.setDatePreferences(null);
            }
        } else {
            response.setDatePreferences(null);
        }
    }

    protected static void fillInRoomPreferences(PrefGroupEditInterface.PrefGroupEditResponse response, PreferenceGroup pg, Vector<DepartmentalInstructor> leadInstructors, SessionContext context, boolean fillPrefs, boolean examSeating) {
        Set<RoomGroup> set;
        Set<RoomFeature> roomFeatures;
        Set<Building> buildings;
        boolean allowHardRoom = context.hasPermission(pg, Right.CanUseHardRoomPrefs);
        Set<Location> rooms = pg.getAvailableRooms();
        if (response.getRoomPreferences() != null) {
            response.getRoomPreferences().clear();
        }
        if (!rooms.isEmpty()) {
            PrefGroupEditInterface.Preferences roomPrefs = new PrefGroupEditInterface.Preferences(PrefGroupEditInterface.PreferenceType.ROOM);
            roomPrefs.setAllowHard(allowHardRoom);
            for (Location location : rooms) {
                roomPrefs.addItem(location.getUniqueId(), examSeating ? location.getLabelWithExamCapacity() : location.getLabelWithCapacity(), location.getDisplayName());
            }
            if (fillPrefs) {
                for (RoomPref roomPref : pg.effectivePreferences(RoomPref.class, leadInstructors)) {
                    PrefGroupEditInterface.Selection selection = new PrefGroupEditInterface.Selection(roomPref.getRoom().getUniqueId(), roomPref.getPrefLevel().getUniqueId());
                    if (response.hasMultipleRooms()) {
                        selection.setRoomIndex(roomPref.getRoomIndex());
                    }
                    roomPrefs.addSelection(selection);
                }
            }
            response.addRoomPreference(roomPrefs);
        }
        if (!(buildings = pg.getAvailableBuildings()).isEmpty() && response.getNbrRooms() != null && response.getNbrRooms() > 0) {
            PrefGroupEditInterface.Preferences bldgPrefs = new PrefGroupEditInterface.Preferences(PrefGroupEditInterface.PreferenceType.BUILDING);
            bldgPrefs.setAllowHard(allowHardRoom);
            for (Building building : buildings) {
                bldgPrefs.addItem(building.getUniqueId(), building.getAbbrName(), null);
            }
            if (fillPrefs) {
                for (BuildingPref buildingPref : pg.effectivePreferences(BuildingPref.class, leadInstructors)) {
                    PrefGroupEditInterface.Selection selection = new PrefGroupEditInterface.Selection(buildingPref.getBuilding().getUniqueId(), buildingPref.getPrefLevel().getUniqueId());
                    if (response.hasMultipleRooms()) {
                        selection.setRoomIndex(buildingPref.getRoomIndex());
                    }
                    bldgPrefs.addSelection(selection);
                }
            }
            response.addRoomPreference(bldgPrefs);
        }
        if (!(roomFeatures = pg.getAvailableRoomFeatures()).isEmpty() && response.getNbrRooms() != null && response.getNbrRooms() > 0) {
            PrefGroupEditInterface.Preferences preferences = new PrefGroupEditInterface.Preferences(PrefGroupEditInterface.PreferenceType.ROOM_FEATURE);
            preferences.setAllowHard(allowHardRoom);
            for (RoomFeature roomFeature : roomFeatures) {
                preferences.addItem(roomFeature.getUniqueId(), roomFeature.getLabelWithType(), roomFeature.getDescription());
            }
            if (fillPrefs) {
                for (RoomFeaturePref fp : pg.effectivePreferences(RoomFeaturePref.class, leadInstructors)) {
                    PrefGroupEditInterface.Selection selection = new PrefGroupEditInterface.Selection(fp.getRoomFeature().getUniqueId(), fp.getPrefLevel().getUniqueId());
                    if (response.hasMultipleRooms()) {
                        selection.setRoomIndex(fp.getRoomIndex());
                    }
                    preferences.addSelection(selection);
                }
            }
            response.addRoomPreference(preferences);
        }
        if (!(set = pg.getAvailableRoomGroups()).isEmpty() && response.getNbrRooms() != null && response.getNbrRooms() > 0) {
            PrefGroupEditInterface.Preferences preferences = new PrefGroupEditInterface.Preferences(PrefGroupEditInterface.PreferenceType.ROOM_GROUP);
            preferences.setAllowHard(allowHardRoom);
            for (RoomGroup group : set) {
                preferences.addItem(group.getUniqueId(), group.getNameWithTitle(), group.getDescription());
            }
            if (fillPrefs) {
                for (RoomGroupPref gp : pg.effectivePreferences(RoomGroupPref.class, leadInstructors)) {
                    PrefGroupEditInterface.Selection selection = new PrefGroupEditInterface.Selection(gp.getRoomGroup().getUniqueId(), gp.getPrefLevel().getUniqueId());
                    if (response.hasMultipleRooms()) {
                        selection.setRoomIndex(gp.getRoomIndex());
                    }
                    preferences.addSelection(selection);
                }
            }
            response.addRoomPreference(preferences);
        }
    }

    public static void doClear(Set<Preference> s, Preference.Type ... typesArray) {
        int types = Preference.Type.toInt(typesArray);
        Iterator<Preference> i = s.iterator();
        while (i.hasNext()) {
            Preference p = i.next();
            if (!p.getType().in(types)) continue;
            i.remove();
        }
    }

    public static void doUpdate(PreferenceGroup pg, Set<Preference> s, PrefGroupEditInterface.PrefGroupEditResponse form, Preference.Type ... typesArray) throws Exception {
        Object prefs;
        Preference dp;
        Object prefs2;
        Preference p;
        pg.setPreferences(s);
        int types = Preference.Type.toInt(typesArray);
        Iterator<Preference> i2 = s.iterator();
        while (i2.hasNext()) {
            Preference p2 = i2.next();
            if (!p2.getType().in(types)) continue;
            i2.remove();
        }
        if (Preference.Type.TIME.in(types)) {
            if (pg instanceof DepartmentalInstructor) {
                if (form.hasInstructorTimePrefereneces() && !form.getInstructorTimePrefereneces().matches("2+")) {
                    TimePref tp = new TimePref();
                    tp.setOwner(pg);
                    tp.setPreference(form.getInstructorTimePrefereneces());
                    tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                    tp.setTimePattern(null);
                    s.add(tp);
                }
            } else {
                Set<TimePref> parentTimePrefs = pg.effectivePreferences(TimePref.class, false);
                if (form.hasTimePreferences() && form.getTimePreferences().hasSelections()) {
                    for (PrefGroupEditInterface.TimeSelection timeSelection : form.getTimePreferences().getSelections()) {
                        TimePattern timePattern = (TimePattern)TimePatternDAO.getInstance().get(timeSelection.getItem());
                        if (timePattern == null) continue;
                        if (timePattern.isExactTime()) {
                            for (String preference : timeSelection.getPreference().split(";")) {
                                if (preference.isEmpty()) continue;
                                TimePref tp = new TimePref();
                                tp.setOwner(pg);
                                tp.setPreference(preference);
                                tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                                tp.setTimePattern((TimePattern)TimePatternDAO.getInstance().get(timeSelection.getItem()));
                                s.add(tp);
                            }
                            continue;
                        }
                        TimePref tp = new TimePref();
                        tp.setOwner(pg);
                        tp.setPreference(timeSelection.getPreference());
                        tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                        tp.setTimePattern((TimePattern)TimePatternDAO.getInstance().get(timeSelection.getItem()));
                        TimePref sameParentTimePref = null;
                        if (parentTimePrefs != null && !parentTimePrefs.isEmpty()) {
                            Iterator<TimePref> i3 = parentTimePrefs.iterator();
                            while (i3.hasNext()) {
                                TimePref parentTimePref = i3.next();
                                if (!parentTimePref.isSame(tp, pg)) continue;
                                if (parentTimePref.getPreference().equals(tp.getPreference()) && parentTimePref.getPrefLevel().equals(tp.getPrefLevel())) {
                                    sameParentTimePref = parentTimePref;
                                }
                                i3.remove();
                                break;
                            }
                        }
                        if (sameParentTimePref != null) continue;
                        s.add(tp);
                    }
                }
                if (parentTimePrefs != null && !parentTimePrefs.isEmpty()) {
                    Iterator<TimePref> i4 = parentTimePrefs.iterator();
                    while (i4.hasNext()) {
                        TimePref timePref = (TimePref)i4.next().clone();
                        timePref.setOwner(pg);
                        timePref.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                        s.add(timePref);
                    }
                }
            }
        }
        if (Preference.Type.ROOM.in(types)) {
            Set<RoomPref> parentRoomPrefs = pg.effectivePreferences(RoomPref.class);
            PrefGroupEditInterface.Preferences prefs22 = form.getRoomPreference(PrefGroupEditInterface.PreferenceType.ROOM);
            if (prefs22 != null && prefs22.hasSelections()) {
                for (PrefGroupEditInterface.Selection selection : prefs22.getSelections()) {
                    RoomPref rp = new RoomPref();
                    rp.setOwner(pg);
                    rp.setPrefLevel((PreferenceLevel)PreferenceLevelDAO.getInstance().get(selection.getLevel()));
                    rp.setRoom((Location)LocationDAO.getInstance().get(selection.getItem()));
                    rp.setRoomIndex(selection.getRoomIndex());
                    RoomPref sameParentRp = null;
                    Iterator<RoomPref> j = parentRoomPrefs.iterator();
                    while (j.hasNext()) {
                        p = j.next();
                        if (!((RoomPref)p).isSame(rp, pg)) continue;
                        if (p.getPrefLevel().equals(rp.getPrefLevel())) {
                            sameParentRp = rp;
                        }
                        j.remove();
                        break;
                    }
                    if (sameParentRp != null) continue;
                    s.add(rp);
                }
            }
            if (parentRoomPrefs != null && !parentRoomPrefs.isEmpty()) {
                Iterator<RoomPref> iterator = parentRoomPrefs.iterator();
                while (iterator.hasNext()) {
                    RoomPref rp = (RoomPref)iterator.next().clone();
                    rp.setOwner(pg);
                    rp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(rp);
                }
            }
        }
        if (Preference.Type.BUILDING.in(types)) {
            Set<BuildingPref> parentBuildingPrefs = pg.effectivePreferences(BuildingPref.class);
            prefs2 = form.getRoomPreference(PrefGroupEditInterface.PreferenceType.BUILDING);
            if (prefs2 != null && ((PrefGroupEditInterface.Preferences)prefs2).hasSelections()) {
                for (PrefGroupEditInterface.Selection selection : ((PrefGroupEditInterface.Preferences)prefs2).getSelections()) {
                    BuildingPref bp = new BuildingPref();
                    bp.setOwner(pg);
                    bp.setPrefLevel((PreferenceLevel)PreferenceLevelDAO.getInstance().get(selection.getLevel()));
                    bp.setBuilding((Building)BuildingDAO.getInstance().get(selection.getItem()));
                    bp.setRoomIndex(selection.getRoomIndex());
                    BuildingPref sameParentRp = null;
                    Iterator<BuildingPref> j = parentBuildingPrefs.iterator();
                    while (j.hasNext()) {
                        p = j.next();
                        if (!((BuildingPref)p).isSame(bp, pg)) continue;
                        if (p.getPrefLevel().equals(bp.getPrefLevel())) {
                            sameParentRp = bp;
                        }
                        j.remove();
                        break;
                    }
                    if (sameParentRp != null) continue;
                    s.add(bp);
                }
            }
            if (parentBuildingPrefs != null && !parentBuildingPrefs.isEmpty()) {
                Iterator<BuildingPref> iterator = parentBuildingPrefs.iterator();
                while (iterator.hasNext()) {
                    BuildingPref bp = (BuildingPref)iterator.next().clone();
                    bp.setOwner(pg);
                    bp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(bp);
                }
            }
        }
        if (Preference.Type.ROOM_FEATURE.in(types)) {
            Set<RoomFeaturePref> parentRoomFeaturePrefs = pg.effectivePreferences(RoomFeaturePref.class);
            prefs2 = form.getRoomPreference(PrefGroupEditInterface.PreferenceType.ROOM_FEATURE);
            if (prefs2 != null && ((PrefGroupEditInterface.Preferences)prefs2).hasSelections()) {
                for (PrefGroupEditInterface.Selection selection : ((PrefGroupEditInterface.Preferences)prefs2).getSelections()) {
                    RoomFeaturePref fp = new RoomFeaturePref();
                    fp.setOwner(pg);
                    fp.setPrefLevel((PreferenceLevel)PreferenceLevelDAO.getInstance().get(selection.getLevel()));
                    fp.setRoomFeature((RoomFeature)RoomFeatureDAO.getInstance().get(selection.getItem()));
                    fp.setRoomIndex(selection.getRoomIndex());
                    RoomFeaturePref sameParentFp = null;
                    Iterator<RoomFeaturePref> j = parentRoomFeaturePrefs.iterator();
                    while (j.hasNext()) {
                        p = j.next();
                        if (!((RoomFeaturePref)p).isSame(fp, pg)) continue;
                        if (p.getPrefLevel().equals(fp.getPrefLevel())) {
                            sameParentFp = fp;
                        }
                        j.remove();
                        break;
                    }
                    if (sameParentFp != null) continue;
                    s.add(fp);
                }
            }
            if (parentRoomFeaturePrefs != null && !parentRoomFeaturePrefs.isEmpty()) {
                Iterator<RoomFeaturePref> iterator = parentRoomFeaturePrefs.iterator();
                while (iterator.hasNext()) {
                    RoomFeaturePref fp = (RoomFeaturePref)iterator.next().clone();
                    fp.setOwner(pg);
                    fp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(fp);
                }
            }
        }
        if (Preference.Type.ROOM_GROUP.in(types)) {
            Set<RoomGroupPref> parentRoomGroupPrefs = pg.effectivePreferences(RoomGroupPref.class);
            prefs2 = form.getRoomPreference(PrefGroupEditInterface.PreferenceType.ROOM_GROUP);
            if (prefs2 != null && ((PrefGroupEditInterface.Preferences)prefs2).hasSelections()) {
                for (PrefGroupEditInterface.Selection selection : ((PrefGroupEditInterface.Preferences)prefs2).getSelections()) {
                    RoomGroupPref gp = new RoomGroupPref();
                    gp.setOwner(pg);
                    gp.setPrefLevel((PreferenceLevel)PreferenceLevelDAO.getInstance().get(selection.getLevel()));
                    gp.setRoomGroup((RoomGroup)RoomGroupDAO.getInstance().get(selection.getItem()));
                    gp.setRoomIndex(selection.getRoomIndex());
                    RoomGroupPref sameParentGp = null;
                    Iterator<RoomGroupPref> j = parentRoomGroupPrefs.iterator();
                    while (j.hasNext()) {
                        p = j.next();
                        if (!((RoomGroupPref)p).isSame(gp, pg)) continue;
                        if (p.getPrefLevel().equals(gp.getPrefLevel())) {
                            sameParentGp = gp;
                        }
                        j.remove();
                        break;
                    }
                    if (sameParentGp != null) continue;
                    s.add(gp);
                }
            }
            if (parentRoomGroupPrefs != null && !parentRoomGroupPrefs.isEmpty()) {
                Iterator<RoomGroupPref> iterator = parentRoomGroupPrefs.iterator();
                while (iterator.hasNext()) {
                    RoomGroupPref gp = (RoomGroupPref)iterator.next().clone();
                    gp.setOwner(pg);
                    gp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(gp);
                }
            }
        }
        if (Preference.Type.DATE.in(types)) {
            Set<DatePatternPref> parentDatePatPrefs = pg.effectivePreferences(DatePatternPref.class);
            prefs2 = form.getDatePreferences();
            if (prefs2 != null && ((PrefGroupEditInterface.Preferences)prefs2).hasSelections()) {
                for (PrefGroupEditInterface.Selection selection : ((PrefGroupEditInterface.Preferences)prefs2).getSelections()) {
                    DatePatternPref dp2 = new DatePatternPref();
                    dp2.setOwner(pg);
                    dp2.setPrefLevel((PreferenceLevel)PreferenceLevelDAO.getInstance().get(selection.getLevel()));
                    dp2.setDatePattern((DatePattern)DatePatternDAO.getInstance().get(selection.getItem()));
                    DatePatternPref sameParentDp = null;
                    Iterator<DatePatternPref> j = parentDatePatPrefs.iterator();
                    while (j.hasNext()) {
                        p = j.next();
                        if (!p.isSame(dp2, pg)) continue;
                        if (p.getPrefLevel().equals(dp2.getPrefLevel())) {
                            sameParentDp = dp2;
                        }
                        j.remove();
                        break;
                    }
                    if (sameParentDp != null) continue;
                    s.add(dp2);
                }
            }
            if (parentDatePatPrefs != null && !parentDatePatPrefs.isEmpty()) {
                Iterator<DatePatternPref> iterator = parentDatePatPrefs.iterator();
                while (iterator.hasNext()) {
                    dp = (DatePatternPref)iterator.next().clone();
                    if (!pg.effectiveDatePattern().findChildren().contains(((BaseDatePatternPref)dp).getDatePattern())) continue;
                    dp.setOwner(pg);
                    dp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(dp);
                }
            }
        }
        if (Preference.Type.DISTRIBUTION.in(types) && (prefs = form.getDistributionPreferences()) != null && ((PrefGroupEditInterface.Preferences)prefs).hasSelections()) {
            for (PrefGroupEditInterface.Selection selection : ((PrefGroupEditInterface.Preferences)prefs).getSelections()) {
                dp = new DistributionPref();
                dp.setOwner(pg);
                dp.setPrefLevel((PreferenceLevel)PreferenceLevelDAO.getInstance().get(selection.getLevel()));
                ((BaseDistributionPref)dp).setDistributionType((DistributionType)DistributionTypeDAO.getInstance().get(selection.getItem()));
                s.add(dp);
            }
        }
        if (Preference.Type.COURSE.in(types) && (prefs = form.getCoursePreferences()) != null && ((PrefGroupEditInterface.Preferences)prefs).hasSelections()) {
            for (PrefGroupEditInterface.Selection selection : ((PrefGroupEditInterface.Preferences)prefs).getSelections()) {
                dp = new InstructorCoursePref();
                dp.setOwner(pg);
                dp.setPrefLevel((PreferenceLevel)PreferenceLevelDAO.getInstance().get(selection.getLevel()));
                ((BaseInstructorCoursePref)dp).setCourse((CourseOffering)CourseOfferingDAO.getInstance().get(selection.getItem()));
                s.add(dp);
            }
        }
        if (Preference.Type.PERIOD.in(types) && pg instanceof Exam) {
            prefs = form.getPeriodPreferences();
            Exam exam = (Exam)pg;
            if (prefs != null) {
                for (ExamPeriod period : ExamPeriod.findAll(exam.getSession().getUniqueId(), exam.getExamType())) {
                    RoomInterface.PreferenceInterface pref = ((RoomInterface.PeriodPreferenceModel)prefs).getPreference(period.getDateOffset(), period.getStartSlot());
                    if (pref == null || PreferenceLevel.sNeutral.equals(pref.getCode())) continue;
                    ExamPeriodPref pp = new ExamPeriodPref();
                    pp.setExamPeriod(period);
                    pp.setPrefLevel(PreferenceLevel.getPreferenceLevel(pref.getCode()));
                    pp.setOwner(exam);
                    s.add(pp);
                }
            }
        }
        pg.setPreferences(s);
    }
}

