/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.solver.PageFilter;
import org.unitime.timetable.gwt.client.tables.TableWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.InstructorInterface;

public class InstructorsPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final CourseMessages COURSE = (CourseMessages)GWT.create(CourseMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimplePanel iRootPanel;
    private SimpleForm iPanel;
    private PageFilter iFilter = new PageFilter();
    private UniTimeHeaderPanel iFooter;
    private InstructorInterface.InstructorsFilterResponse iConfig;

    public InstructorsPage() {
        this.iFilter.getHeader().setCollapsible("1".equals(ToolBox.getSessionCookie("Instructors.Filter")));
        this.iFilter.getHeader().addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                ToolBox.setSessionCookie("Instructors.Filter", (Boolean)event.getValue() != false ? "1" : "0");
            }
        });
        this.iPanel = new SimpleForm(2);
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iPanel.addRow((Widget)this.iFilter);
        this.iFilter.getFooter().addButton("search", COURSE.actionSearchInstructors(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                String token = InstructorsPage.this.iFilter.getQuery();
                if (!History.getToken().equals(token)) {
                    History.newItem((String)token, (boolean)false);
                }
                InstructorsPage.this.search(null);
            }
        });
        this.iFilter.getFooter().setEnabled("search", false);
        this.iFilter.getFooter().getButton("search").setAccessKey(COURSE.accessSearchInstructors().charAt(0));
        this.iFilter.getFooter().getButton("search").setTitle(COURSE.titleSearchInstructors(COURSE.accessSearchInstructors()));
        this.iFilter.setSubmitCommand(new Command(){

            public void execute() {
                if (InstructorsPage.this.iFilter.getFooter().isEnabled("search").booleanValue()) {
                    InstructorsPage.this.iFilter.getFooter().getButton("search").click();
                }
            }
        });
        this.iFilter.getFooter().addButton("exportCsv", COURSE.actionExportCsv(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorsPage.this.export("instructors.csv");
            }
        });
        this.iFilter.getFooter().getButton("exportCsv").setAccessKey(COURSE.accessExportCsv().charAt(0));
        this.iFilter.getFooter().getButton("exportCsv").setTitle(COURSE.titleExportCsv(COURSE.accessExportCsv()));
        this.iFilter.getFooter().setEnabled("exportCsv", false);
        this.iFilter.getFooter().addButton("exportXls", COURSE.actionExportXls(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorsPage.this.export("instructors.xls");
            }
        });
        this.iFilter.getFooter().getButton("exportXls").setAccessKey(COURSE.accessExportXls().charAt(0));
        this.iFilter.getFooter().getButton("exportXls").setTitle(COURSE.titleExportXls(COURSE.accessExportXls()));
        this.iFilter.getFooter().setEnabled("exportXls", false);
        this.iFilter.getFooter().addButton("exportPdf", COURSE.actionExportPdf(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorsPage.this.export("instructors.pdf");
            }
        });
        this.iFilter.getFooter().getButton("exportPdf").setAccessKey(COURSE.accessExportPdf().charAt(0));
        this.iFilter.getFooter().getButton("exportPdf").setTitle(COURSE.titleExportPdf(COURSE.accessExportPdf()));
        this.iFilter.getFooter().setEnabled("exportPdf", false);
        this.iFilter.getFooter().addButton("surveyXls", COURSE.actionExportSurveysXLS(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorsPage.this.export("instructor-surveys.xls");
            }
        });
        this.iFilter.getFooter().setEnabled("surveyXls", false);
        this.iFilter.getFooter().addButton("manage-instructors", COURSE.actionManageInstructorList(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                FilterInterface filter = InstructorsPage.this.iFilter.getValue();
                LoadingWidget.showLoading(MESSAGES.waitLoadingPage());
                String subjectId = filter.getParameterValue("subjectArea", "");
                if (subjectId.indexOf(44) > 0) {
                    subjectId = subjectId.substring(0, subjectId.indexOf(44));
                }
                ToolBox.open(GWT.getHostPageBaseURL() + "instructorListUpdate.action");
            }
        });
        this.iFilter.getFooter().getButton("manage-instructors").setAccessKey(COURSE.accessManageInstructorList().charAt(0));
        this.iFilter.getFooter().getButton("manage-instructors").setTitle(COURSE.titleManageInstructorList(COURSE.accessManageInstructorList()));
        this.iFilter.getFooter().setEnabled("manage-instructors", false);
        this.iFilter.getFooter().addButton("add", COURSE.actionAddNewInstructor(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                FilterInterface filter = InstructorsPage.this.iFilter.getValue();
                LoadingWidget.showLoading(MESSAGES.waitLoadingPage());
                String subjectId = filter.getParameterValue("subjectArea", "");
                if (subjectId.indexOf(44) > 0) {
                    subjectId = subjectId.substring(0, subjectId.indexOf(44));
                }
                ToolBox.open(GWT.getHostPageBaseURL() + "instructorAdd.action");
            }
        });
        this.iFilter.getFooter().getButton("add").setAccessKey(COURSE.accessAddNewInstructor().charAt(0));
        this.iFilter.getFooter().getButton("add").setTitle(COURSE.titleAddNewInstructor(COURSE.accessAddNewInstructor()));
        this.iFilter.getFooter().setEnabled("add", false);
        this.iFooter = this.iFilter.getFooter().clonePanel();
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-InstructorsPage");
        this.initWidget((Widget)this.iRootPanel);
        this.init();
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                String token = (String)event.getValue();
                if (((String)event.getValue()).startsWith("A") || ((String)event.getValue()).equals("back")) {
                    token = "";
                }
                InstructorsPage.this.iFilter.setQuery(token, true);
                if (InstructorsPage.this.iPanel.getRowCount() > 1) {
                    InstructorsPage.this.search(null);
                }
            }
        });
    }

    protected void init() {
        RPC.execute(new InstructorInterface.InstructorsFilterRequest(), new AsyncCallback<InstructorInterface.InstructorsFilterResponse>(){

            public void onFailure(Throwable caught) {
                InstructorsPage.this.iFilter.getFooter().setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(InstructorInterface.InstructorsFilterResponse result) {
                InstructorsPage.this.iConfig = result;
                for (FilterInterface.FilterParameterInterface p : result.getParameters()) {
                    String v = Window.Location.getParameter((String)p.getName());
                    if (v == null) continue;
                    p.setValue(v);
                }
                InstructorsPage.this.iFilter.getFooter().clearMessage();
                InstructorsPage.this.iFilter.setValue(result);
                String token = History.getToken();
                if (token != null && !token.startsWith("A") && !token.equals("back")) {
                    InstructorsPage.this.iFilter.setQuery(token, true);
                }
                InstructorsPage.this.iFilter.getFooter().setEnabled("search", true);
                InstructorsPage.this.iFilter.getFooter().setEnabled("add", false);
                InstructorsPage.this.iFilter.getFooter().setEnabled("exportCsv", false);
                InstructorsPage.this.iFilter.getFooter().setEnabled("exportXls", false);
                InstructorsPage.this.iFilter.getFooter().setEnabled("exportPdf", false);
                InstructorsPage.this.iFilter.getFooter().setEnabled("surveyXls", false);
                InstructorsPage.this.iFilter.getFooter().setEnabled("manage-instructors", false);
                if (!InstructorsPage.this.iFilter.getValue().getParameterValue("deptId", "").isEmpty()) {
                    InstructorsPage.this.search(null);
                }
            }
        });
    }

    protected void search(final AsyncCallback<Boolean> callback) {
        InstructorInterface.InstructorsRequest request = new InstructorInterface.InstructorsRequest();
        request.setBackId(Window.Location.getParameter((String)"backId"));
        request.setBackType(Window.Location.getParameter((String)"backType"));
        request.setFilter(this.iFilter.getValue());
        this.iFilter.getFooter().clearMessage();
        for (int row = this.iPanel.getRowCount() - 1; row > 0; --row) {
            this.iPanel.removeRow(row);
        }
        this.iFilter.getFooter().showLoading();
        this.iFilter.getFooter().setEnabled("search", false);
        this.iFilter.getFooter().setEnabled("add", false);
        this.iFilter.getFooter().setEnabled("exportCsv", false);
        this.iFilter.getFooter().setEnabled("exportXls", false);
        this.iFilter.getFooter().setEnabled("exportPdf", false);
        this.iFilter.getFooter().setEnabled("surveyXls", false);
        this.iFilter.getFooter().setEnabled("manage-instructors", false);
        LoadingWidget.showLoading(MESSAGES.waitLoadingData());
        RPC.execute(request, new AsyncCallback<InstructorInterface.InstructorsResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.hideLoading();
                InstructorsPage.this.iFilter.getFooter().setErrorMessage(caught.getMessage());
                UniTimeNotifications.error(caught.getMessage(), caught);
                InstructorsPage.this.iFilter.getFooter().setEnabled("search", true);
                if (callback != null) {
                    callback.onFailure(caught);
                }
            }

            public void onSuccess(InstructorInterface.InstructorsResponse result) {
                LoadingWidget.hideLoading();
                InstructorsPage.this.iFilter.getFooter().clearMessage();
                if (result.getTable() != null) {
                    UniTimeHeaderPanel header = new UniTimeHeaderPanel(result.getTable().getName());
                    InstructorsPage.this.iPanel.addHeaderRow((Widget)header);
                    P p = new P(InstructorsPage.this.iConfig.isSticky() ? "unitime-StickyTable" : "unitime-ScrollTable");
                    p.getElement().getStyle().clearPosition();
                    p.getElement().getStyle().clearOverflow();
                    p.add((Widget)new TableWidget(result.getTable()));
                    InstructorsPage.this.iPanel.addRow((Widget)p);
                    InstructorsPage.this.iPanel.addBottomRow((Widget)InstructorsPage.this.iFooter);
                }
                InstructorsPage.this.iFilter.getFooter().setEnabled("search", true);
                InstructorsPage.this.iFilter.getFooter().setEnabled("add", result.hasOperation("add-instructor"));
                InstructorsPage.this.iFilter.getFooter().setEnabled("exportCsv", result.hasOperation("export"));
                InstructorsPage.this.iFilter.getFooter().setEnabled("exportXls", result.hasOperation("export"));
                InstructorsPage.this.iFilter.getFooter().setEnabled("exportPdf", result.hasOperation("export"));
                InstructorsPage.this.iFilter.getFooter().setEnabled("surveyXls", result.hasOperation("export-surveys"));
                InstructorsPage.this.iFilter.getFooter().setEnabled("manage-instructors", result.hasOperation("manage-instructors"));
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        Element e;
                        String token = Window.Location.getHash();
                        if (token != null && (token.startsWith("#A") || token.equals("#back")) && (e = Document.get().getElementById(token.substring(1))) != null) {
                            ToolBox.scrollToElement(e);
                        }
                        if ((e = Document.get().getElementById("back")) != null) {
                            ToolBox.scrollToElement(e);
                        }
                    }
                });
                if (callback != null) {
                    callback.onSuccess((Object)(result.getTable() != null ? 1 : 0));
                }
            }
        });
    }

    protected void export(String format) {
        String sort = ToolBox.getSessionCookie("Instructors.Sort");
        ToolBox.open(GWT.getHostPageBaseURL() + "export?output=" + format + "&sid=" + this.iConfig.getSessionId() + (String)(sort == null || sort.isEmpty() ? "" : "&sort=" + URL.encodeQueryString((String)sort)) + this.iFilter.getFullQuery());
    }
}

