/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.BacktrackNeighbourSelection;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.heuristics.RouletteWheelSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.SimpleNeighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.RequestGroup;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;

public class ShuffleStudentsSelection
implements NeighbourSelection<Request, Enrollment> {
    private Queue<Shuffle> iQueue = null;
    private ShuffleBacktrackNeighbourSelection iBacktrack;

    public ShuffleStudentsSelection(DataProperties properties) {
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        StudentSectioningModel model = (StudentSectioningModel)solver.currentSolution().getModel();
        this.iQueue = new LinkedList<Shuffle>();
        Assignment<Request, Enrollment> assignment = solver.currentSolution().getAssignment();
        RouletteWheelSelection<RequestGroup> groups = new RouletteWheelSelection<RequestGroup>();
        for (Offering offering : model.getOfferings()) {
            if (offering.isDummy()) continue;
            for (Course course : offering.getCourses()) {
                for (RequestGroup requestGroup : course.getRequestGroups()) {
                    double spread = requestGroup.getAverageSpread(solver.currentSolution().getAssignment());
                    if (spread >= 1.0) continue;
                    groups.add(requestGroup, 1.0 - spread);
                }
            }
        }
        if (groups.hasMoreElements()) {
            RequestGroup group = (RequestGroup)groups.nextElement();
            RouletteWheelSelection<Subpart> subparts = new RouletteWheelSelection<Subpart>();
            for (CourseRequest cr : group.getRequests()) {
                Enrollment e = assignment.getValue(cr);
                if (e == null) continue;
                for (Section section : e.getSections()) {
                    if (!(group.getSectionSpread(assignment, section) < 1.0)) continue;
                    subparts.addExisting(section.getSubpart(), 1.0);
                }
            }
            if (subparts.hasMoreElements()) {
                Subpart subpart = (Subpart)subparts.nextElement();
                RouletteWheelSelection<Section> sections = new RouletteWheelSelection<Section>();
                block7: for (Section section : subpart.getSections()) {
                    for (CourseRequest courseRequest : group.getRequests()) {
                        boolean match = false;
                        for (Enrollment e : courseRequest.values(assignment)) {
                            if (!e.getSections().contains(section)) continue;
                            match = true;
                            break;
                        }
                        if (match) continue;
                        continue block7;
                    }
                    int nrConflicts = 0;
                    if (!section.isAllowOverlap()) {
                        block10: for (CourseRequest cr2 : group.getRequests()) {
                            for (Request r : cr2.getStudent().getRequests()) {
                                Enrollment e;
                                if (r.equals(cr2) || (e = assignment.getValue(r)) == null || e.isAllowOverlap() || !section.isOverlapping(e.getSections())) continue;
                                ++nrConflicts;
                                continue block10;
                            }
                        }
                    }
                    sections.add(section, 1 + group.getRequests().size() - nrConflicts);
                }
                HashSet<Section> filter = new HashSet<Section>();
                double d = 0.0;
                while (sections.hasMoreElements()) {
                    Section section = (Section)sections.nextElement();
                    if (filter.add(section)) {
                        if (section.getLimit() < 0) break;
                        d += (double)section.getLimit();
                    }
                    if (!(d >= group.getTotalWeight())) continue;
                    break;
                }
                for (CourseRequest cr : group.getRequests()) {
                    Enrollment e;
                    Shuffle shuffle = new Shuffle(group, cr, filter);
                    e = assignment.getValue(cr);
                    if (e != null && shuffle.matchFilter(e)) continue;
                    this.iQueue.add(shuffle);
                }
            } else {
                for (CourseRequest cr : group.getRequests()) {
                    this.iQueue.add(new Shuffle(group, cr, null));
                }
            }
        }
        Collections.shuffle((LinkedList)this.iQueue);
        if (this.iBacktrack == null) {
            try {
                this.iBacktrack = new ShuffleBacktrackNeighbourSelection(solver.getProperties());
                this.iBacktrack.init(solver);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        Progress.getInstance(solver.currentSolution().getModel()).setPhase("Shuffling students along request groups...", this.iQueue.size());
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        Shuffle shuffle = null;
        while ((shuffle = this.iQueue.poll()) != null) {
            Progress.getInstance(solution.getModel()).incProgress();
            Neighbour<Request, Enrollment> n = this.iBacktrack.selectNeighbour(solution, shuffle);
            if (n != null) {
                return n;
            }
            ArrayList<Enrollment> adepts = new ArrayList<Enrollment>();
            for (Enrollment e : shuffle.getRequest().values(solution.getAssignment())) {
                if (!shuffle.matchFilter(e)) continue;
                adepts.add(e);
            }
            if (adepts.isEmpty()) continue;
            return new SimpleNeighbour<CourseRequest, Value>(shuffle.getRequest(), (Value)ToolBox.random(adepts));
        }
        return null;
    }

    public static class ShuffleBacktrackNeighbourSelection
    extends BacktrackNeighbourSelection<Request, Enrollment> {
        ShuffleBacktrackNeighbourSelection(DataProperties properties) throws Exception {
            super(properties);
            this.setTimeout(properties.getPropertyInt("Shuffle.BackTrackTimeout", this.getTimeout()));
            this.setDepth(properties.getPropertyInt("Shuffle.BackTrackDepth", this.getDepth()));
            this.setMaxIters(properties.getPropertyInt("Shuffle.BackTrackMaxIters", this.getMaxIters()));
        }

        @Override
        protected Iterator<Enrollment> values(BacktrackNeighbourSelection.BacktrackNeighbourSelectionContext context, Request variable) {
            Shuffle shuffle = ((ShuffleBacktrackNeighbourSelectionContext)context).getShuffle();
            if (shuffle.matchRequest(variable) && shuffle.hasFilter()) {
                ArrayList<Enrollment> values = new ArrayList<Enrollment>();
                Iterator i = super.values(context, variable);
                while (i.hasNext()) {
                    Enrollment e = (Enrollment)i.next();
                    if (!shuffle.matchFilter(e)) continue;
                    values.add(e);
                }
                return values.iterator();
            }
            return super.values(context, variable);
        }

        @Override
        protected Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution, Shuffle shuffle) {
            ShuffleBacktrackNeighbourSelectionContext context = new ShuffleBacktrackNeighbourSelectionContext(solution, shuffle);
            this.selectNeighbour(solution, shuffle.getRequest(), context);
            return context.getBackTrackNeighbour();
        }

        private class ShuffleBacktrackNeighbourSelectionContext
        extends BacktrackNeighbourSelection.BacktrackNeighbourSelectionContext {
            private Shuffle iShuffle;

            private ShuffleBacktrackNeighbourSelectionContext(Solution<Request, Enrollment> solution, Shuffle shuffle) {
                super(solution);
                this.iShuffle = null;
                this.iShuffle = shuffle;
            }

            private Shuffle getShuffle() {
                return this.iShuffle;
            }
        }
    }

    private static class Shuffle {
        RequestGroup iGroup;
        CourseRequest iRequest;
        Set<Section> iFilter;

        Shuffle(RequestGroup group, CourseRequest request, Set<Section> filter) {
            this.iGroup = group;
            this.iRequest = request;
            this.iFilter = filter;
        }

        public CourseRequest getRequest() {
            return this.iRequest;
        }

        public boolean hasFilter() {
            return this.iFilter != null && !this.iFilter.isEmpty();
        }

        public boolean matchRequest(Request variable) {
            return variable instanceof CourseRequest && ((CourseRequest)variable).getCourses().contains(this.iGroup.getCourse());
        }

        public boolean matchFilter(Enrollment e) {
            if (this.iFilter == null || this.iFilter.isEmpty()) {
                return true;
            }
            for (Section s : e.getSections()) {
                if (!this.iFilter.contains(s)) continue;
                return true;
            }
            return false;
        }
    }
}

