/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.duration;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.util.duration.SemesterMinutes;

public class SemesterHours
extends SemesterMinutes {
    private Integer iMinutesPerHour = 50;

    public SemesterHours(String parameter) {
        super(parameter);
        Matcher matcher;
        if (parameter != null && (matcher = Pattern.compile(this.getParamterFormat()).matcher(parameter)).find()) {
            this.iMinutesPerHour = Integer.parseInt(matcher.group(1));
        }
    }

    @Override
    public boolean isValidCombination(int semesterHours, DatePattern datePattern, TimePattern timePattern) {
        if (datePattern == null) {
            return false;
        }
        if (timePattern.isExactTime()) {
            return true;
        }
        if (datePattern.isPatternSet()) {
            for (DatePattern child : datePattern.findChildren()) {
                if (!this.isValidCombination(semesterHours, child, timePattern)) continue;
                return true;
            }
            return false;
        }
        return (float)(semesterHours * this.iMinutesPerHour) == datePattern.getEffectiveNumberOfWeeks() * (float)timePattern.getNrMeetings().intValue() * (float)timePattern.getMinPerMtg().intValue();
    }

    @Override
    public String getParamterFormat() {
        return "([0-9]+)";
    }

    @Override
    public int getExactTimeMinutesPerMeeting(int semesterHours, DatePattern datePattern, int dayCode) {
        Iterator<DatePattern> iterator;
        if (datePattern == null) {
            return 0;
        }
        if (datePattern.isPatternSet() && (iterator = datePattern.findChildren().iterator()).hasNext()) {
            DatePattern child = iterator.next();
            return Math.round((float)(this.iMinutesPerHour * semesterHours) / ((float)DayCode.nrDays(dayCode) * child.getEffectiveNumberOfWeeks()));
        }
        return Math.round((float)(this.iMinutesPerHour * semesterHours) / ((float)DayCode.nrDays(dayCode) * datePattern.getEffectiveNumberOfWeeks()));
    }

    @Override
    public Integer getArrangedHours(int semesterHours, DatePattern datePattern) {
        Iterator<DatePattern> iterator;
        if (semesterHours <= 0 || datePattern == null) {
            return null;
        }
        if (datePattern.isPatternSet() && (iterator = datePattern.findChildren().iterator()).hasNext()) {
            DatePattern child = iterator.next();
            return Math.round((float)semesterHours / child.getEffectiveNumberOfWeeks());
        }
        return Math.round((float)semesterHours / datePattern.getEffectiveNumberOfWeeks());
    }
}

