/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.preference.MinMaxPreferenceCombination;
import org.cpsolver.coursett.preference.PreferenceCombination;
import org.cpsolver.coursett.preference.SumPreferenceCombination;
import org.hibernate.LazyInitializationException;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.events.RoomFilterBackend;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.ClassAssignmentPageInterface;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.TableInterface;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.ExactTimeMins;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.RoomSharingModel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseLocation;
import org.unitime.timetable.model.base.BasePreferenceLevel;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.RoomDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.ClassDetailBackend;
import org.unitime.timetable.solver.course.ui.ClassAssignment;
import org.unitime.timetable.solver.course.ui.ClassAssignmentInfo;
import org.unitime.timetable.solver.course.ui.ClassDateInfo;
import org.unitime.timetable.solver.course.ui.ClassInfo;
import org.unitime.timetable.solver.course.ui.ClassInstructorInfo;
import org.unitime.timetable.solver.course.ui.ClassProposedChange;
import org.unitime.timetable.solver.course.ui.ClassRoomInfo;
import org.unitime.timetable.solver.course.ui.ClassTimeInfo;
import org.unitime.timetable.util.DefaultRoomAvailabilityService;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.util.duration.DurationModel;

@GwtRpcImplements(value=ClassAssignmentPageInterface.ClassAssignmentPageRequest.class)
public class ClassAssigmmentPageBackend
implements GwtRpcImplementation<ClassAssignmentPageInterface.ClassAssignmentPageRequest, ClassAssignmentPageInterface.ClassAssignmentPageResponse> {
    private static Log sLog = LogFactory.getLog(ClassAssigmmentPageBackend.class);
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public ClassAssignmentPageInterface.ClassAssignmentPageResponse execute(ClassAssignmentPageInterface.ClassAssignmentPageRequest request, SessionContext context) {
        String[] dm;
        ClassAssignment initial;
        if (!request.hasChanges()) {
            context.checkPermission(request.getSelectedClassId(), Right.ClassAssignment);
        }
        if (request.getOfferingId() != null && request.getOperation() == ClassAssignmentPageInterface.Operation.LOCK) {
            InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(request.getOfferingId());
            context.checkPermission(offering, Right.OfferingCanLock);
            offering.getSession().lockOffering(offering.getUniqueId());
        }
        if (request.isShowStudentConflicts() == null) {
            request.setShowStudentConflicts(ApplicationProperty.ClassAssignmentShowStudentConflicts.isTrue());
        }
        if (request.isUseRealStudents() == null) {
            request.setUseRealStudents(StudentClassEnrollment.sessionHasEnrollments(context.getUser().getCurrentAcademicSessionId()));
        }
        EventDateMapping.Class2EventDateMap class2eventDates = EventDateMapping.getMapping(context.getUser().getCurrentAcademicSessionId());
        ClassProposedChange proposed = null;
        if (request.hasChanges()) {
            proposed = new ClassProposedChange();
            proposed.setSelected(request.getSelectedClassId());
            for (ClassAssignmentPageInterface.ChangeInterface ch : request.getChanges()) {
                void var12_15;
                Class_ clazz = (Class_)Class_DAO.getInstance().get(ch.getClassId());
                if (clazz == null) continue;
                initial = null;
                Map<ClassAssignment, Set<Long>> conflicts = null;
                if (request.isShowStudentConflicts().booleanValue() && ApplicationProperty.ClassAssignmentPrefetchConflicts.isTrue()) {
                    conflicts = ClassInfo.findAllRelatedAssignments(clazz.getUniqueId(), request.isUseRealStudents());
                }
                if (clazz.getCommittedAssignment() != null) {
                    initial = new ClassAssignmentInfo(clazz.getCommittedAssignment(), request.isUseRealStudents(), conflicts);
                }
                ClassTimeInfo time = null;
                ClassDateInfo date = null;
                Object var12_16 = null;
                if (ch.hasDate()) {
                    DatePattern dp = (DatePattern)DatePatternDAO.getInstance().get(Long.valueOf(ch.getDate()));
                    int datePref = 0;
                    for (DatePatternPref p : clazz.effectivePreferences(DatePatternPref.class)) {
                        if (!p.getDatePattern().equals(dp)) continue;
                        datePref = PreferenceLevel.prolog2int(p.getPrefLevel().getPrefProlog());
                    }
                    if (dp != null) {
                        date = new ClassDateInfo(dp.getUniqueId(), clazz.getUniqueId(), dp.getName(), dp.getPatternBitSet(), datePref);
                    }
                }
                if (!"null".equals(ch.getTime()) && ch.hasTime()) {
                    dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
                    String[] timeId = ch.getTime().split(":");
                    DatePattern dp = (DatePattern)DatePatternDAO.getInstance().get(Long.valueOf(timeId[0]));
                    if (date != null) {
                        dp = date.getDatePattern();
                    } else if (dp != null && dp.getDatePatternType() != DatePattern.DatePatternType.PatternSet) {
                        int datePref = 0;
                        for (DatePatternPref p : clazz.effectivePreferences(DatePatternPref.class)) {
                            if (!p.getDatePattern().equals(dp)) continue;
                            datePref = PreferenceLevel.prolog2int(p.getPrefLevel().getPrefProlog());
                        }
                        date = new ClassDateInfo(dp.getUniqueId(), clazz.getUniqueId(), dp.getName(), dp.getPatternBitSet(), datePref);
                    }
                    TimePattern tp = (TimePattern)TimePatternDAO.getInstance().get(Long.valueOf(timeId[1]));
                    int dayCode = Integer.valueOf(timeId[2]);
                    int startTime = Integer.valueOf(timeId[3]);
                    if (dp != null && tp != null) {
                        int length = tp.getSlotsPerMtg();
                        int minsPerMeeting = tp.getMinPerMtg();
                        int breakTime = tp.getBreakTime();
                        int timePref = 0;
                        for (TimePref p : clazz.effectivePreferences(TimePref.class)) {
                            if (!p.getTimePattern().equals(tp)) continue;
                            TimePatternModel model = p.getTimePatternModel();
                            if (tp.isExactTime()) {
                                if (model.getExactDays() != dayCode || model.getExactStartSlot() != startTime) continue;
                                timePref = PreferenceLevel.prolog2int(p.getPrefLevel().getPrefProlog());
                                continue;
                            }
                            for (int d = 0; d < model.getNrDays(); ++d) {
                                if (model.getDayCode(d) != dayCode) continue;
                                for (int t = 0; t < model.getNrTimes(); ++t) {
                                    if (model.getStartSlot(t) != startTime) continue;
                                    timePref = PreferenceLevel.prolog2int(model.getPreference(d, t));
                                }
                            }
                        }
                        if (tp.isExactTime()) {
                            minsPerMeeting = dm.getExactTimeMinutesPerMeeting(clazz.getSchedulingSubpart().getMinutesPerWk(), dp, dayCode);
                            length = ExactTimeMins.getNrSlotsPerMtg(minsPerMeeting);
                            breakTime = ExactTimeMins.getBreakTime(minsPerMeeting);
                        }
                        List<Date> dates = dm.getDates(clazz.getSchedulingSubpart().getMinutesPerWk(), dp, dayCode, minsPerMeeting, class2eventDates);
                        time = new ClassTimeInfo(clazz.getUniqueId(), dayCode, startTime, length, minsPerMeeting, timePref, tp, date != null ? date : new ClassDateInfo(dp.getUniqueId(), clazz.getUniqueId(), dp.getName(), dp.getPatternBitSet(), 0), breakTime, dates);
                    }
                }
                if (ch.hasRoom()) {
                    TreeSet<ClassRoomInfo> treeSet = new TreeSet<ClassRoomInfo>();
                    for (String token : ch.getRoom().split(":")) {
                        Location location;
                        if (token.trim().isEmpty() || (location = (Location)LocationDAO.getInstance().get(Long.valueOf(token))) == null) continue;
                        treeSet.add(new ClassRoomInfo(location, 0));
                    }
                }
                if (ch.getClassId().equals(request.getSelectedClassId()) && initial != null && !"null".equals(ch.getTime())) {
                    if (time == null) {
                        time = initial.getTime();
                    }
                    if (date == null) {
                        date = initial.getDate();
                    }
                }
                proposed.addChange(new ClassAssignmentInfo(clazz, time, date, (Collection<ClassRoomInfo>)var12_15, proposed.getAssignmentTable(), request.isUseRealStudents(), conflicts), initial);
            }
        }
        Class_ clazz = (Class_)Class_DAO.getInstance().get(request.getSelectedClassId());
        ClassInfo classInfo = null;
        Map<ClassAssignment, Set<Long>> conflicts = null;
        if (request.isShowStudentConflicts().booleanValue() && ApplicationProperty.ClassAssignmentPrefetchConflicts.isTrue()) {
            conflicts = ClassInfo.findAllRelatedAssignments(clazz.getUniqueId(), request.isUseRealStudents());
        }
        classInfo = clazz.getCommittedAssignment() != null ? new ClassAssignmentInfo(clazz.getCommittedAssignment(), request.isUseRealStudents(), conflicts) : new ClassInfo(clazz);
        if (!request.hasChange(clazz.getUniqueId()) && classInfo instanceof ClassAssignment) {
            initial = (ClassAssignment)classInfo;
            if (proposed == null) {
                proposed = new ClassProposedChange();
                proposed.setSelected(request.getSelectedClassId());
            }
            ClassDateInfo date = initial.getDate();
            DatePattern dp = clazz.effectiveDatePattern();
            if (dp != null) {
                if (dp.getDatePatternType() != DatePattern.DatePatternType.PatternSet) {
                    date = new ClassDateInfo(dp.getUniqueId(), clazz.getUniqueId(), dp.getName(), dp.getPatternBitSet(), 0);
                } else {
                    Set<DatePatternPref> datePatternPrefs = clazz.effectivePreferences(DatePatternPref.class);
                    for (DatePattern child : dp.findChildren()) {
                        String pr = PreferenceLevel.sNeutral;
                        for (DatePatternPref p : datePatternPrefs) {
                            if (!p.getDatePattern().equals(child)) continue;
                            pr = p.getPrefLevel().getPrefProlog();
                        }
                        if (PreferenceLevel.sRequired.equals(pr)) {
                            date = new ClassDateInfo(child.getUniqueId(), clazz.getUniqueId(), child.getName(), child.getPatternBitSet(), 0);
                            break;
                        }
                        if (PreferenceLevel.sProhibited.equals(pr) || date != null) continue;
                        date = new ClassDateInfo(child.getUniqueId(), clazz.getUniqueId(), child.getName(), child.getPatternBitSet(), PreferenceLevel.prolog2int(pr));
                    }
                    if (date == null) {
                        for (DatePattern child : dp.findChildren()) {
                            date = new ClassDateInfo(child.getUniqueId(), clazz.getUniqueId(), child.getName(), child.getPatternBitSet(), 100);
                        }
                    }
                }
            }
            Object modified = initial;
            if (date != null && !date.equals(initial.getDate())) {
                ClassTimeInfo classTimeInfo = initial.getTime();
                dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
                List<Date> dates = dm.getDates(clazz.getSchedulingSubpart().getMinutesPerWk(), date.getDatePattern(), classTimeInfo.getDayCode(), classTimeInfo.getMinutesPerMeeting(), class2eventDates);
                modified = new ClassAssignment(clazz, new ClassTimeInfo(classTimeInfo, date, dates), date, initial.getRooms());
            }
            proposed.addChange(new ClassAssignmentInfo(clazz, ((ClassAssignment)modified).getTime(), ((ClassAssignment)modified).getDate(), null, proposed.getAssignmentTable(), request.isUseRealStudents(), conflicts), initial);
        }
        this.update(proposed, classInfo, request.isKeepConflictingAssignments() == false, request.isUseRealStudents());
        ClassAssignmentPageInterface.ClassAssignmentPageResponse response = new ClassAssignmentPageInterface.ClassAssignmentPageResponse();
        response.setKeepConflictingAssignments(request.isKeepConflictingAssignments());
        response.setShowStudentConflicts(request.isShowStudentConflicts());
        response.setUseRealStudents(request.isUseRealStudents());
        response.setSelectedClassId(classInfo.getClassId());
        response.setManagingDeptCode(clazz.getManagingDept().getDeptCode());
        response.setSessionId(clazz.getManagingDept().getSessionId());
        response.setMinRoomCapacity(clazz.getMinRoomLimit());
        response.setNbrRooms(clazz.getNbrRooms());
        response.setRoomSplitAttendance(clazz.isRoomsSplitAttendance());
        response.setClassName(classInfo.getClassName());
        response.setProperties(ClassDetailBackend.getProperties(clazz, context));
        String nameFormat = UserProperty.NameFormat.get(context.getUser());
        if (!clazz.getClassInstructors().isEmpty()) {
            TableInterface.CellInterface cell = new TableInterface.CellInterface();
            for (ClassInstructor classInstructor : new TreeSet<ClassInstructor>(clazz.getClassInstructors())) {
                if (!classInstructor.isLead().booleanValue()) continue;
                cell.add(classInstructor.getInstructor().getName(nameFormat)).setInline(false);
            }
            if (cell.hasItems()) {
                response.addProperty(MSG.properyConflictCheckedInstructors(), cell);
            }
        }
        if (classInfo instanceof ClassAssignmentInfo) {
            ClassAssignmentInfo initial2 = (ClassAssignmentInfo)classInfo;
            if (initial2.getDate() != null) {
                response.addProperty(MSG.properyAssignedDates(), initial2.getDate().toCell());
            }
            if (initial2.getTime() != null) {
                response.addProperty(MSG.filterAssignedTime(), initial2.getTime().toLongCell());
            }
            if (initial2.getRooms() != null && !initial2.getRooms().isEmpty()) {
                c = response.addProperty(MSG.filterAssignedRoom());
                for (ClassRoomInfo r : initial2.getRooms()) {
                    ((TableInterface.CellInterface)c).addItem(r.toCell().setInline(false));
                }
            }
        } else {
            DatePattern datePattern = clazz.effectiveDatePattern();
            if (datePattern != null) {
                c = response.addProperty(MSG.propertyDatePattern()).add(datePattern.getName()).add("");
                if (datePattern.getDatePatternType() != DatePattern.DatePatternType.PatternSet) {
                    ((TableInterface.CellInterface)c).addClick().setTitle(MSG.sectPreviewOfDatePattern(datePattern.getName())).addWidget().setId("UniTimeGWT:DatePattern").setContent(datePattern.getPatternText());
                    ((TableInterface.CellInterface)c).setImage().setSource("images/calendar.png").addStyle("cursor: pointer; padding-left: 5px; vertical-align: bottom;");
                }
            }
        }
        ClassAssignmentInfo current = null;
        if (proposed != null) {
            for (ClassAssignmentInfo classAssignmentInfo : proposed.getAssignments()) {
                if (!classAssignmentInfo.getClassId().equals(clazz.getUniqueId())) continue;
                current = classAssignmentInfo;
                if (classAssignmentInfo.getDate() != null) {
                    response.addProperty(MSG.properySelectedDates(), classAssignmentInfo.getDate().toCell());
                }
                if (classAssignmentInfo.getTime() != null) {
                    response.addProperty(MSG.properySelectedTime(), classAssignmentInfo.getTime().toLongCell());
                }
                if (classAssignmentInfo.getRooms() == null || classAssignmentInfo.getRooms().isEmpty()) continue;
                Iterator<ClassAssignment> c = response.addProperty(MSG.properySelectedRoom());
                for (ClassRoomInfo r : classAssignmentInfo.getRooms()) {
                    ((TableInterface.CellInterface)((Object)c)).addItem(r.toCell().setInline(false));
                }
            }
            response.setAssignments(this.generateAssigmentsTable(proposed, context));
            response.setStudentConflicts(this.generateStudentConflicts(proposed));
        }
        try {
            Collection<ClassAssignment> dates = this.getDates(classInfo, response.isShowStudentConflicts(), response.isUseRealStudents(), conflicts);
            if (dates == null) {
                response.addDatesErrorMessage(MSG.messageClassHasNoDatePatternSelected(classInfo.getClassName()));
            } else if (dates.size() > 1) {
                ClassAssignment classAssignment = classInfo instanceof ClassAssignment ? (ClassAssignment)classInfo : null;
                for (ClassAssignment date : dates) {
                    ClassAssignmentPageInterface.DomainItem item = new ClassAssignmentPageInterface.DomainItem();
                    item.setId(date.getDateId());
                    item.setCell(date.getDate().toCell());
                    if (response.isShowStudentConflicts()) {
                        item.setExtra(new TableInterface.CellInterface().setText((String)(date instanceof ClassAssignmentInfo ? "" + ((ClassAssignmentInfo)date).getNrStudentCounflicts() : "")));
                    }
                    item.setValue(date instanceof ClassAssignmentInfo ? ((ClassAssignmentInfo)date).getNrStudentCounflicts() : 0);
                    item.setAssigned(classAssignment != null && classAssignment.getDateId().equals(date.getDateId()));
                    item.setSelected(current != null && date.getDateId().equals(current.getDateId()));
                    response.addDate(item);
                }
            }
        }
        catch (GwtRpcException e) {
            sLog.error((Object)("Failed to enumerate possible dates: " + e.getMessage()), (Throwable)e);
            response.addDatesErrorMessage(e.getMessage());
        }
        try {
            Collection<ClassAssignment> times = this.getTimes(classInfo, current == null ? null : current.getDate(), response.isShowStudentConflicts(), response.isUseRealStudents(), conflicts, proposed);
            if (times == null) {
                response.addTimesErrorMessage(MSG.messageClassHasNoTimePatternSelected(classInfo.getClassName()));
            } else if (times.isEmpty()) {
                response.addTimesErrorMessage(MSG.messageClassHasNoAvailableTime(classInfo.getClassName()));
            } else {
                ClassAssignment classAssignment = classInfo instanceof ClassAssignment ? (ClassAssignment)classInfo : null;
                for (ClassAssignment time : times) {
                    ClassAssignmentPageInterface.DomainItem item = new ClassAssignmentPageInterface.DomainItem();
                    item.setId(time.getTimeId());
                    item.setCell(time.getTime().toLongCell());
                    if (response.isShowStudentConflicts()) {
                        item.setExtra(new TableInterface.CellInterface().setText((String)(time instanceof ClassAssignmentInfo ? "" + ((ClassAssignmentInfo)time).getNrStudentCounflicts() : "")));
                    }
                    item.setValue(time instanceof ClassAssignmentInfo ? ((ClassAssignmentInfo)time).getNrStudentCounflicts() : 0);
                    item.setAssigned(classAssignment != null && classAssignment.getTimeId().equals(time.getTimeId()));
                    item.setSelected(current != null && time.getTimeId().equals(current.getTimeId()));
                    response.addTime(item);
                }
                if (current != null && current.getTimeId() != null) {
                    ClassAssignmentPageInterface.DomainItem item = new ClassAssignmentPageInterface.DomainItem();
                    item.setId("null");
                    item.setCell(new TableInterface.CellInterface().add(MSG.notAssigned()).setColor(PreferenceLevel.prolog2color("P")).addStyle("font-style: italic;"));
                    if (response.isShowStudentConflicts()) {
                        item.setExtra(new TableInterface.CellInterface().setText(""));
                    }
                    response.addTime(item);
                }
            }
        }
        catch (GwtRpcException e) {
            sLog.error((Object)("Failed to enumerate possible times: " + e.getMessage()), (Throwable)e);
            response.addTimesErrorMessage(e.getMessage());
        }
        if (current != null && current.getTime() != null) {
            try {
                Collection<ClassRoomInfo> collection;
                EventInterface.RoomFilterRpcRequest filter = request.getRoomFilter();
                if (filter == null) {
                    filter = new EventInterface.RoomFilterRpcRequest();
                    filter.setOption("department", clazz.getManagingDept().getDeptCode());
                    if (clazz.getNbrRooms() == 1 || !Boolean.TRUE.equals(clazz.isRoomsSplitAttendance())) {
                        filter.setOption("size", ">=" + clazz.getMinRoomLimit());
                    }
                } else if (request.getPreviousClassId() == null || !request.getPreviousClassId().equals(request.getSelectedClassId())) {
                    Class_ class_;
                    Class_ class_2 = class_ = request.getPreviousClassId() == null ? null : (Class_)Class_DAO.getInstance().get(request.getPreviousClassId());
                    if (class_ == null || !class_.getManagingDept().equals(clazz.getManagingDept()) && filter.hasOption("department")) {
                        filter.setOption("department", clazz.getManagingDept().getDeptCode());
                    }
                    if (clazz.getNbrRooms() == 1 || !Boolean.TRUE.equals(clazz.isRoomsSplitAttendance())) {
                        filter.setOption("size", ">=" + clazz.getMinRoomLimit());
                    } else {
                        filter.setOption("size", null);
                    }
                }
                if ((collection = this.getRooms(classInfo, current.getTime(), request.isRoomAllowConflicts(), filter, context, proposed, request.getRoomOrder())) != null) {
                    ClassAssignment ia2 = classInfo instanceof ClassAssignment ? (ClassAssignment)classInfo : null;
                    TableInterface table = new TableInterface();
                    table.setName(MSG.sectionTitleAvailableRoomsForClass(classInfo.getClassName()));
                    for (ClassRoomInfo room : collection) {
                        ClassAssignmentPageInterface.DomainItem item = new ClassAssignmentPageInterface.DomainItem();
                        item.setId(room.getLocationId().toString());
                        item.setCell(room.toCell());
                        item.setExtra(new TableInterface.CellInterface().setText("" + room.getCapacity()));
                        item.setValue(room.getCapacity());
                        item.setAssigned(ia2 != null && ia2.hasRoom(room.getLocationId()));
                        item.setSelected(current != null && current.hasRoom(room.getLocationId()));
                        response.addRoom(item);
                    }
                    if (collection.isEmpty()) {
                        response.addRoomsErrorMessage(MSG.messageNoMatchingRoomFound());
                    }
                }
            }
            catch (GwtRpcException e) {
                sLog.error((Object)("Failed to enumerate possible rooms: " + e.getMessage()), (Throwable)e);
                response.addRoomsErrorMessage(e.getMessage());
            }
        }
        if (request.getOperation() == ClassAssignmentPageInterface.Operation.ASSIGN && this.getCanAssign(proposed, context)) {
            String error = this.assign(proposed, context);
            if (error != null) {
                if (response.getAssignments() != null) {
                    response.getAssignments().setErrorMessage(error);
                } else {
                    response.setErrorMessage(error);
                }
            } else {
                response.setUrl("clazz?id=" + request.getSelectedClassId());
            }
        }
        response.setCanAssign(this.getCanAssign(proposed, context));
        return response;
    }

    public TableInterface generateAssigmentsTable(ClassProposedChange proposed, SessionContext context) {
        TableInterface.CellInterface c;
        TableInterface table = new TableInterface();
        table.setName(MSG.sectionTitleNewAssignments());
        TableInterface.LineInterface header = table.addHeader();
        header.addCell(MSG.columnClass());
        header.addCell(MSG.columnInstructor());
        header.addCell(MSG.columnDateChange());
        header.addCell(MSG.columnTimeChange());
        header.addCell(MSG.columnRoomChange());
        for (TableInterface.CellInterface h : header.getCells()) {
            h.setClassName("WebTableHeader");
        }
        for (ClassAssignmentInfo assignment : proposed.getAssignments()) {
            boolean canAssign;
            ClassAssignment initial = proposed.getInitial(assignment);
            TableInterface.LineInterface line = table.addLine();
            line.setURL("#id=" + assignment.getClassId());
            if (assignment.getClassId().equals(proposed.getSelectedClassId())) {
                line.setBgColor("rgb(168,187,225)");
            }
            c = line.addCell();
            if (proposed.getAssignments().size() > 1) {
                c.add("").setUrl("#delete=" + assignment.getClassId()).setImage().setSource("images/action_delete.png").addStyle("cursor: pointer; padding-right: 5px; vertical-align: bottom;");
            }
            if (!(canAssign = context.hasPermission(assignment.getClazz(), Right.ClassAssignment)) && context.hasPermission(assignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering(), Right.OfferingCanLock)) {
                c.add("").setUrl("#lock=" + assignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId()).setImage().setSource("images/error.png").addStyle("cursor: pointer; padding-right: 5px; vertical-align: bottom;").setTitle(MSG.titleCourseNotLocked(assignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseName()));
            }
            c.add(assignment.getClassName()).setTitle(assignment.getClassTitle());
            line.addCell(assignment.getLeadingInstructorNames(", "));
            TableInterface.CellInterface d = line.addCell();
            d.setNoWrap(true);
            if (initial != null && !initial.getDateId().equals(assignment.getDateId())) {
                d.addItem(initial.getDate().toCell()).add(" \u2192 ");
            }
            if (initial == null && assignment.getClazz().effectiveDatePattern().getDatePatternType() == DatePattern.DatePatternType.PatternSet) {
                d.add(MSG.notAssigned()).setColor(PreferenceLevel.prolog2color("P")).addStyle("font-style: italic;").add(" \u2192 ");
            }
            if (assignment.getDate() == null) {
                d.add(MSG.notAssigned()).setColor(PreferenceLevel.prolog2color("P")).addStyle("font-style: italic;");
            } else {
                d.addItem(assignment.getDate().toCell());
            }
            TableInterface.CellInterface t = line.addCell();
            t.setNoWrap(true);
            if (initial != null && !initial.getTimeId().equals(assignment.getTimeId())) {
                t.addItem(initial.getTime().toCell()).add(" \u2192 ");
            }
            if (initial == null && assignment.getTime() != null) {
                t.add(MSG.notAssigned()).setColor(PreferenceLevel.prolog2color("P")).addStyle("font-style: italic;").add(" \u2192 ");
            }
            if (assignment.getTime() == null) {
                t.add(MSG.notAssigned()).setColor(PreferenceLevel.prolog2color("P")).addStyle("font-style: italic;");
            } else {
                t.addItem(assignment.getTime().toCell());
            }
            TableInterface.CellInterface r = line.addCell();
            r.setNoWrap(true);
            if (initial != null && !initial.getRoomIds().equals(assignment.getRoomIds())) {
                r.addItem(initial.toRoomCell()).add(" \u2192 ");
            }
            if (initial == null && assignment.getNrRooms() > 0 && assignment.getNumberOfRooms() > 0) {
                r.add(MSG.notAssigned()).setColor(PreferenceLevel.prolog2color("P")).addStyle("font-style: italic;").add(" \u2192 ");
            }
            r.addItem(assignment.toRoomCell());
            if (assignment.getNumberOfRooms() > 0 && assignment.getNrRooms() == 0 && assignment.getTime() == null) {
                r.add(MSG.notAssigned()).setColor(PreferenceLevel.prolog2color("P")).addStyle("font-style: italic;");
            } else if (assignment.getNrRooms() != assignment.getNumberOfRooms()) {
                if (assignment.getClassId().equals(proposed.getSelectedClassId())) {
                    r.add(MSG.assignmentRoomSelectBelow()).addStyle("font-style: italic;");
                } else {
                    r.add(MSG.assignmentRoomNotSelected()).setColor("red").addStyle("font-style: italic;");
                }
            }
            if (assignment.getNumberOfRooms() != 0) continue;
            r.add(MSG.notApplicable()).addStyle("font-style: italic;");
        }
        for (ClassAssignment conflict : proposed.getConflicts()) {
            TableInterface.LineInterface line = table.addLine();
            if (conflict.getClassId().equals(proposed.getSelectedClassId())) {
                line.setBgColor("rgb(168,187,225)");
            }
            line.setURL("#id=" + conflict.getClassId());
            boolean canAssign = context.hasPermission(conflict.getClazz(), Right.ClassAssignment);
            if (!canAssign && context.hasPermission(conflict.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering(), Right.OfferingCanLock)) {
                c = line.addCell();
                c.add("").setUrl("#lock=" + conflict.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId()).setImage().setSource("images/error.png").addStyle("cursor: pointer; padding-right: 5px; vertical-align: bottom;").setTitle(MSG.titleCourseNotLocked(conflict.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseName()));
                c.add(conflict.getClassName()).setTitle(conflict.getClassTitle());
            } else {
                line.addCell(conflict.getClassName()).setTitle(conflict.getClassTitle());
            }
            line.addCell(conflict.getLeadingInstructorNames(", "));
            TableInterface.CellInterface d = line.addCell();
            d.setNoWrap(true);
            d.addItem(conflict.getDate().toCell()).add(" \u2192 ");
            d.add(MSG.notAssigned()).setColor(PreferenceLevel.prolog2color("P")).addStyle("font-style: italic;");
            TableInterface.CellInterface t = line.addCell();
            t.setNoWrap(true);
            t.addItem(conflict.getTime().toCell()).add(" \u2192 ");
            t.add(MSG.notAssigned()).setColor(PreferenceLevel.prolog2color("P")).addStyle("font-style: italic;");
            TableInterface.CellInterface r = line.addCell();
            r.setNoWrap(true);
            r.addItem(conflict.toRoomCell()).add(" \u2192 ");
            r.add(MSG.notAssigned()).setColor(PreferenceLevel.prolog2color("P")).addStyle("font-style: italic;");
        }
        return table;
    }

    public TableInterface generateStudentConflicts(ClassProposedChange change) {
        TableInterface table = new TableInterface();
        table.setName(MSG.sectionTitleStudentConflicts());
        HashSet<CallSite> ids = new HashSet<CallSite>();
        TreeSet<ClassAssignmentInfo.StudentConflict> ret = new TreeSet<ClassAssignmentInfo.StudentConflict>();
        for (ClassAssignmentInfo assignment : change.getAssignments()) {
            for (ClassAssignmentInfo.StudentConflict conf : assignment.getStudentConflicts()) {
                String id = assignment.getClassId().compareTo(conf.getOtherClass().getClassId()) < 0 ? assignment.getClassId() + ":" + conf.getOtherClass().getClassId() : conf.getOtherClass().getClassId() + ":" + assignment.getClassId();
                if (!ids.add((CallSite)((Object)id))) continue;
                ret.add(conf);
            }
        }
        TableInterface.LineInterface header = table.addHeader();
        header.addCell(MSG.columnStudentConflicts());
        header.addCell(MSG.columnClass());
        header.addCell(MSG.columnAssignedDatePattern());
        header.addCell(MSG.columnAssignedTime());
        header.addCell(MSG.columnAssignedRoom());
        for (TableInterface.CellInterface h : header.getCells()) {
            h.setClassName("WebTableHeader");
        }
        for (ClassAssignmentInfo.StudentConflict conf : ret) {
            TableInterface.LineInterface line = table.addLine();
            line.setURL("#id=" + conf.getOtherClass().getClassId());
            line.addCell(String.valueOf(conf.getConflictingStudents().size())).setColor(PreferenceLevel.prolog2color("P")).addStyle("font-weight:bold;");
            TableInterface.CellInterface n = line.addCell();
            n.setNoWrap(true);
            n.add(conf.getThisClass().getClassName()).setTitle(conf.getThisClass().getClassTitle()).setInline(false);
            n.add(conf.getOtherClass().getClassName()).setTitle(conf.getOtherClass().getClassTitle()).setInline(false);
            TableInterface.CellInterface d = line.addCell();
            d.setNoWrap(true);
            d.addItem(conf.getThisClass().getDate().toCell().setInline(false));
            d.addItem(conf.getOtherClass().getDate().toCell().setInline(false));
            TableInterface.CellInterface t = line.addCell();
            t.setNoWrap(true);
            t.addItem(conf.getThisClass().getTime().toCell().setInline(false));
            t.addItem(conf.getOtherClass().getTime().toCell().setInline(false));
            TableInterface.CellInterface r = line.addCell();
            r.setNoWrap(true);
            r.addItem(conf.getThisClass().toRoomCell().setInline(false));
            r.addItem(conf.getOtherClass().toRoomCell().setInline(false));
        }
        if (!table.hasLines()) {
            table.addLine().addCell(MSG.messageNoStudentConflicts()).setColSpan(5).addStyle("font-style: italic;");
        }
        return table;
    }

    public void update(ClassProposedChange change, ClassInfo classInfo, boolean unassignConflictingAssignments, boolean isUseRealStudents) {
        if (change == null) {
            return;
        }
        Vector<ClassAssignmentInfo> assignments = new Vector<ClassAssignmentInfo>(change.getAssignments());
        Hashtable<Long, ClassAssignment> table = change.getAssignmentTable();
        change.getAssignments().clear();
        for (ClassAssignment classAssignment : assignments) {
            change.getAssignments().add(new ClassAssignmentInfo(classAssignment.getClazz(), classAssignment.getTime(), classAssignment.getDate(), classAssignment.getRooms(), table, isUseRealStudents, null));
        }
        if (assignments.isEmpty()) {
            Iterator<ClassAssignment> i = change.getConflicts().iterator();
            while (i.hasNext()) {
                ClassAssignment classAssignment = i.next();
                if (classAssignment != null && classAssignment.getClassId().equals(classInfo.getClassId())) continue;
                i.remove();
            }
        } else {
            change.getConflicts().clear();
        }
        for (ClassAssignment classAssignment : change.getAssignments()) {
            Class_ class_;
            Assignment a;
            if (!classAssignment.hasTime()) continue;
            if (unassignConflictingAssignments) {
                if (classAssignment.getRooms() != null) {
                    for (ClassRoomInfo room : classAssignment.getRooms()) {
                        if (!room.isIgnoreRoomChecks()) {
                            for (Assignment assignment : room.getLocation().getCommitedAssignments()) {
                                if (assignment.getClazz().isCancelled().booleanValue() || !classAssignment.getTime().overlaps(new ClassTimeInfo(assignment)) || assignment.getClazz().canShareRoom(classAssignment.getClazz()) || change.getCurrent(assignment.getClassId()) != null || change.getConflict(assignment.getClassId()) != null) continue;
                                change.getConflicts().add(new ClassAssignment(assignment));
                            }
                        }
                        if (!(room.getLocation() instanceof Room)) continue;
                        Room r = (Room)room.getLocation(RoomDAO.getInstance().getSession());
                        if (r.getParentRoom() != null && !r.getParentRoom().isIgnoreRoomCheck().booleanValue()) {
                            for (Assignment a2 : r.getParentRoom().getCommitedAssignments()) {
                                if (a2.getClazz().isCancelled().booleanValue() || !classAssignment.getTime().overlaps(new ClassTimeInfo(a2)) || a2.getClazz().canShareRoom(classAssignment.getClazz()) || change.getCurrent(a2.getClassId()) != null || change.getConflict(a2.getClassId()) != null) continue;
                                change.getConflicts().add(new ClassAssignment(a2));
                            }
                        }
                        for (Object p : r.getPartitions()) {
                            if (((BaseLocation)p).isIgnoreRoomCheck().booleanValue()) continue;
                            for (Assignment a4 : ((Location)p).getCommitedAssignments()) {
                                if (a4.getClazz().isCancelled().booleanValue() || !classAssignment.getTime().overlaps(new ClassTimeInfo(a4)) || a4.getClazz().canShareRoom(classAssignment.getClazz()) || change.getCurrent(a4.getClassId()) != null || change.getConflict(a4.getClassId()) != null) continue;
                                change.getConflicts().add(new ClassAssignment(a4));
                            }
                        }
                    }
                }
                if (classAssignment.getInstructors() != null) {
                    for (ClassInstructorInfo instructor : classAssignment.getInstructors()) {
                        if (!instructor.isLead()) continue;
                        for (DepartmentalInstructor departmentalInstructor : DepartmentalInstructor.getAllForInstructor(instructor.getInstructor().getInstructor())) {
                            Object p;
                            p = departmentalInstructor.getClasses().iterator();
                            while (p.hasNext()) {
                                ClassInstructor ci = (ClassInstructor)p.next();
                                if (ci.equals(instructor.getInstructor()) || !ci.isLead().booleanValue() || (a = ci.getClassInstructing().getCommittedAssignment()) == null || a.getClazz().isCancelled().booleanValue() || classAssignment.getTime() == null || !classAssignment.getTime().overlaps(new ClassTimeInfo(a)) || a.getClazz().canShareInstructor(classAssignment.getClazz()) || change.getCurrent(a.getClassId()) != null || change.getConflict(a.getClassId()) != null) continue;
                                change.getConflicts().add(new ClassAssignment(a));
                            }
                        }
                    }
                }
            }
            Class_ clazz = classAssignment.getClazz(Class_DAO.getInstance().getSession());
            for (Class_ parent = clazz.getParentClass(); parent != null; parent = parent.getParentClass()) {
                Assignment a5;
                if (change.getCurrent(parent.getUniqueId()) != null || change.getConflict(parent.getUniqueId()) != null || (a5 = parent.getCommittedAssignment()) == null || a5.getClazz().isCancelled().booleanValue() || !classAssignment.getTime().overlaps(new ClassTimeInfo(a5))) continue;
                change.getConflicts().add(new ClassAssignment(a5));
            }
            LinkedList<Class_> children = new LinkedList<Class_>();
            try {
                children.addAll(clazz.getChildClasses());
            }
            catch (LazyInitializationException lazyInitializationException) {
                sLog.error((Object)("Failed to get child classes: " + lazyInitializationException.getMessage()), (Throwable)lazyInitializationException);
                Class_ c = (Class_)Class_DAO.getInstance().get(classAssignment.getClassId());
                children.addAll(c.getChildClasses());
            }
            Object var12_26 = null;
            while ((class_ = (Class_)children.poll()) != null) {
                Assignment a3;
                if (change.getCurrent(class_.getUniqueId()) == null && change.getConflict(class_.getUniqueId()) == null && (a3 = class_.getCommittedAssignment()) != null && !a3.getClazz().isCancelled().booleanValue() && classAssignment.getTime().overlaps(new ClassTimeInfo(a3))) {
                    change.getConflicts().add(new ClassAssignment(a3));
                }
                if (class_.getChildClasses().isEmpty()) continue;
                children.addAll(class_.getChildClasses());
            }
            for (SchedulingSubpart ss : clazz.getSchedulingSubpart().getInstrOfferingConfig().getSchedulingSubparts()) {
                if (ss.getClasses().size() != 1) continue;
                Class_ class_2 = ss.getClasses().iterator().next();
                if (change.getCurrent(class_2.getUniqueId()) == null && change.getConflict(class_2.getUniqueId()) == null && (a = class_2.getCommittedAssignment()) != null && !a.getClazz().isCancelled().booleanValue() && classAssignment.getTime().overlaps(new ClassTimeInfo(a))) {
                    change.getConflicts().add(new ClassAssignment(a));
                }
                if (class_2.getChildClasses().isEmpty()) continue;
                children.addAll(class_2.getChildClasses());
            }
        }
    }

    public Collection<ClassAssignment> getDates(ClassInfo classInfo, boolean showStudentConflicts, boolean useRealStudents, Map<ClassAssignment, Set<Long>> conflicts) {
        ClassTimeInfo time;
        Class_ clazz = classInfo.getClazz();
        DatePattern datePattern = clazz.effectiveDatePattern();
        if (datePattern == null) {
            return null;
        }
        ArrayList<ClassAssignment> dates = new ArrayList<ClassAssignment>();
        ClassTimeInfo classTimeInfo = time = classInfo instanceof ClassAssignment ? ((ClassAssignment)classInfo).getTime() : null;
        if (datePattern.isPatternSet()) {
            Set<DatePatternPref> datePatternPrefs = clazz.effectivePreferences(DatePatternPref.class);
            boolean hasReq = false;
            for (DatePatternPref p : datePatternPrefs) {
                if (!PreferenceLevel.sRequired.equals(p.getPrefLevel().getPrefProlog())) continue;
                hasReq = true;
                break;
            }
            for (DatePattern child : datePattern.findChildren()) {
                String pr = PreferenceLevel.sNeutral;
                for (DatePatternPref p : datePatternPrefs) {
                    if (!p.getDatePattern().equals(child)) continue;
                    pr = p.getPrefLevel().getPrefProlog();
                }
                int prVal = 0;
                if (!PreferenceLevel.sNeutral.equals(pr) && !PreferenceLevel.sRequired.equals(pr)) {
                    prVal = PreferenceLevel.prolog2int(pr);
                }
                if (hasReq && !PreferenceLevel.sRequired.equals(pr)) {
                    prVal += 100;
                }
                if (PreferenceLevel.sProhibited.equals(pr)) {
                    prVal += 100;
                }
                if (showStudentConflicts && time != null) {
                    dates.add(new ClassAssignmentInfo(clazz, time, new ClassDateInfo(child.getUniqueId(), clazz.getUniqueId(), child.getName(), child.getPatternBitSet(), prVal), null, useRealStudents, conflicts));
                    continue;
                }
                dates.add(new ClassAssignment(clazz, null, new ClassDateInfo(child.getUniqueId(), clazz.getUniqueId(), child.getName(), child.getPatternBitSet(), prVal), null));
            }
        } else if (showStudentConflicts && time != null) {
            dates.add(new ClassAssignmentInfo(clazz, time, new ClassDateInfo(datePattern.getUniqueId(), clazz.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), PreferenceLevel.sIntLevelNeutral), null, useRealStudents, conflicts));
        } else {
            dates.add(new ClassAssignment(clazz, null, new ClassDateInfo(datePattern.getUniqueId(), clazz.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), PreferenceLevel.sIntLevelNeutral), null));
        }
        return dates;
    }

    /*
     * WARNING - void declaration
     */
    public Collection<ClassAssignment> getTimes(ClassInfo classInfo, ClassDateInfo date, boolean showStudentConflicts, boolean useRealStudents, Map<ClassAssignment, Set<Long>> conflicts, ClassProposedChange proposed) {
        RoomAvailabilityInterface.TimeBlock time;
        ClassAssignment ca;
        Collection<RoomAvailabilityInterface.TimeBlock> blocks;
        Class_ clazz = classInfo.getClazz();
        Set<TimePref> timePrefs = clazz.effectivePreferences(TimePref.class);
        if (timePrefs.isEmpty()) {
            return null;
        }
        if (date == null) {
            Collection<ClassAssignment> dates;
            ClassDateInfo classDateInfo = date = classInfo instanceof ClassAssignment ? ((ClassAssignment)classInfo).getDate() : null;
            if (date == null && (dates = this.getDates(classInfo, showStudentConflicts, useRealStudents, conflicts)) != null && !dates.isEmpty()) {
                date = dates.iterator().next().getDate();
            }
        }
        if (date == null) {
            return null;
        }
        DatePattern datePattern = date.getDatePattern();
        Vector<ClassAssignment> times = new Vector<ClassAssignment>();
        boolean onlyReq = false;
        for (TimePref timePref : timePrefs) {
            TimePatternModel pattern = timePref.getTimePatternModel();
            if (!pattern.isExactTime() && pattern.countPreferences(PreferenceLevel.sRequired) <= 0) continue;
            onlyReq = true;
        }
        if (onlyReq) {
            sLog.debug((Object)("Class " + classInfo.getClassName() + " has required times"));
        }
        DurationModel dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
        EventDateMapping.Class2EventDateMap class2eventDates = EventDateMapping.getMapping(clazz.getSessionId());
        for (TimePref timePref : timePrefs) {
            List<Date> dates;
            TimePatternModel pattern = timePref.getTimePatternModel();
            if (pattern.isExactTime()) {
                int minsPerMeeting = dm.getExactTimeMinutesPerMeeting(clazz.getSchedulingSubpart().getMinutesPerWk(), datePattern, pattern.getExactDays());
                int length = ExactTimeMins.getNrSlotsPerMtg(minsPerMeeting);
                int breakTime = ExactTimeMins.getBreakTime(minsPerMeeting);
                dates = dm.getDates(clazz.getSchedulingSubpart().getMinutesPerWk(), datePattern, pattern.getExactDays(), minsPerMeeting, class2eventDates);
                ClassTimeInfo time2 = new ClassTimeInfo(clazz.getUniqueId(), pattern.getExactDays(), pattern.getExactStartSlot(), length, minsPerMeeting, PreferenceLevel.sIntLevelNeutral, timePref.getTimePattern(), date, breakTime, dates);
                if (showStudentConflicts) {
                    times.add(new ClassAssignmentInfo(clazz, time2, date, null, proposed == null ? null : proposed.getAssignmentTable(), useRealStudents, conflicts));
                    continue;
                }
                times.add(new ClassAssignment(clazz, time2, date, null));
                continue;
            }
            for (int time3 = 0; time3 < pattern.getNrTimes(); ++time3) {
                block3: for (int day = 0; day < pattern.getNrDays(); ++day) {
                    if (!dm.isValidSelection(clazz.getSchedulingSubpart().getMinutesPerWk(), datePattern, timePref.getTimePattern(), pattern.getDayCode(day))) continue;
                    String pref = pattern.getPreference(day, time3);
                    if (onlyReq && !pref.equals(PreferenceLevel.sRequired)) {
                        pref = PreferenceLevel.sProhibited;
                    }
                    dates = dm.getDates(clazz.getSchedulingSubpart().getMinutesPerWk(), datePattern, pattern.getDayCode(day), timePref.getTimePattern().getMinPerMtg(), class2eventDates);
                    ClassTimeInfo loc = new ClassTimeInfo(clazz.getUniqueId(), pattern.getDayCode(day), pattern.getStartSlot(time3), pattern.getSlotsPerMtg(), timePref.getTimePattern().getMinPerMtg(), PreferenceLevel.prolog2int(pref), timePref.getTimePattern(), date, pattern.getBreakTime(), dates);
                    if (proposed != null) {
                        for (ClassAssignment classAssignment : proposed.getAssignments()) {
                            if (classAssignment.getClassId().equals(classInfo.getClassId())) continue;
                            boolean canConflict = false;
                            if (classAssignment.getParents().contains(classInfo.getClassId())) {
                                canConflict = true;
                            }
                            if (classInfo.getParents().contains(classAssignment.getClassId())) {
                                canConflict = true;
                            }
                            if (classAssignment.getConfligId().equals(classInfo.getConfligId()) && classAssignment.isSingleClass()) {
                                canConflict = true;
                            }
                            if (classAssignment.shareInstructor(classInfo)) {
                                canConflict = true;
                            }
                            if (!canConflict || !loc.overlaps(classAssignment.getTime())) continue;
                            continue block3;
                        }
                    }
                    if (showStudentConflicts) {
                        times.add(new ClassAssignmentInfo(clazz, loc, date, null, proposed == null ? null : proposed.getAssignmentTable(), useRealStudents, conflicts));
                        continue;
                    }
                    times.add(new ClassAssignment(clazz, loc, date, null));
                }
            }
        }
        Date[] bounds = DatePattern.getBounds(clazz.getSessionId());
        boolean changePast = ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue();
        boolean ignorePast = ApplicationProperty.ClassAssignmentIgnorePastMeetings.isTrue();
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(new Date());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date today = cal.getTime();
        String nameFormat = "last-first";
        if (RoomAvailability.getInstance() != null) {
            for (ClassInstructor ci : clazz.getClassInstructors()) {
                if (!ci.getLead().booleanValue() || (blocks = RoomAvailability.getInstance().getInstructorAvailability(ci.getInstructor().getUniqueId(), bounds[0], bounds[1], RoomAvailabilityInterface.sClassType)) == null || blocks.isEmpty()) continue;
                Object var23_31 = null;
                if (!changePast || ignorePast) {
                    Vector<RoomAvailabilityInterface.TimeBlock> vector = new Vector<RoomAvailabilityInterface.TimeBlock>();
                    for (RoomAvailabilityInterface.TimeBlock time2 : blocks) {
                        if (time2.getEndTime().before(today)) continue;
                        vector.add(time2);
                    }
                } else {
                    Collection<RoomAvailabilityInterface.TimeBlock> collection = blocks;
                }
                Iterator<ClassAssignment> i = times.iterator();
                while (i.hasNext()) {
                    void var23_34;
                    ca = i.next();
                    time = ca.getTime().overlaps((Collection<RoomAvailabilityInterface.TimeBlock>)var23_34);
                    if (time == null) continue;
                    sLog.info((Object)MSG.messageInstructroNotAvailable(ci.getInstructor().getName(nameFormat), ca.getTime().getLongName(), time.getEventName()));
                    i.remove();
                }
            }
        }
        for (ClassInstructor ci : clazz.getClassInstructors()) {
            if (!ci.getLead().booleanValue() || !ci.getInstructor().hasUnavailabilities() || (blocks = ci.getInstructor().listUnavailableDays()) == null || blocks.isEmpty()) continue;
            Object var23_36 = null;
            if (!changePast || ignorePast) {
                Vector<RoomAvailabilityInterface.TimeBlock> vector = new Vector<RoomAvailabilityInterface.TimeBlock>();
                for (RoomAvailabilityInterface.TimeBlock time4 : blocks) {
                    if (time4.getEndTime().before(today)) continue;
                    vector.add(time4);
                }
            } else {
                Collection<RoomAvailabilityInterface.TimeBlock> collection = blocks;
            }
            Iterator<Serializable> i = times.iterator();
            while (i.hasNext()) {
                void var23_39;
                ca = (ClassAssignment)i.next();
                time = ca.getTime().overlaps((Collection<RoomAvailabilityInterface.TimeBlock>)var23_39);
                if (time == null) continue;
                sLog.info((Object)MSG.messageInstructroNotAvailable(ci.getInstructor().getName(nameFormat), ca.getTime().getLongName(), time.getEventName()));
                i.remove();
            }
        }
        return times;
    }

    /*
     * WARNING - void declaration
     */
    public Collection<ClassRoomInfo> getRooms(ClassInfo classInfo, ClassTimeInfo period, boolean allowConflicts, EventInterface.RoomFilterRpcRequest filter, SessionContext context, ClassProposedChange proposed, final ClassAssignmentPageInterface.RoomOrder ord) {
        int prefInt;
        Class_ clazz = classInfo.getClazz();
        Long departmentId = clazz.getManagingDept().getUniqueId();
        if (clazz.getNbrRooms() == null || clazz.getNbrRooms() == 0) {
            return null;
        }
        ArrayList<ClassRoomInfo> rooms = new ArrayList<ClassRoomInfo>();
        List<Location> allRooms = new RoomFilterBackend().locations(context.getUser().getCurrentAcademicSessionId(), filter, -1, new HashMap<Long, Double>(), new EventAction.EventContext(context, context.getUser().getCurrentAcademicSessionId()));
        Set<Location> availRooms = clazz.getAvailableRooms();
        int minClassLimit = clazz.getExpectedCapacity();
        int maxClassLimit = clazz.getMaxExpectedCapacity();
        if (maxClassLimit < minClassLimit) {
            maxClassLimit = minClassLimit;
        }
        float room2limitRatio = clazz.getRoomRatio().floatValue();
        int roomCapacity = Math.round(minClassLimit <= 0 ? room2limitRatio : room2limitRatio * (float)minClassLimit);
        int discouragedCapacity = (int)Math.round(0.99 * (double)roomCapacity);
        int stronglyDiscouragedCapacity = (int)Math.round(0.98 * (double)roomCapacity);
        Set<RoomGroupPref> groupPrefs = clazz.effectivePreferences(RoomGroupPref.class);
        Set<RoomPref> roomPrefs = clazz.effectivePreferences(RoomPref.class);
        Set<BuildingPref> bldgPrefs = clazz.effectivePreferences(BuildingPref.class);
        Set<RoomFeaturePref> featurePrefs = clazz.effectivePreferences(RoomFeaturePref.class);
        Hashtable<Location, Integer> filteredRooms = new Hashtable<Location, Integer>();
        HashSet<Long> permIds = new HashSet<Long>();
        block0: for (Location room : allRooms) {
            RoomSharingModel sharingModel;
            SumPreferenceCombination pref = new SumPreferenceCombination();
            if (!availRooms.contains(room)) {
                pref.addPreferenceProlog(PreferenceLevel.sProhibited);
            }
            if ((sharingModel = room.getRoomSharingModel()) != null) {
                block1: for (int d = 0; d < Constants.NR_DAYS; ++d) {
                    if ((Constants.DAY_CODES[d] & period.getDayCode()) == 0) continue;
                    int startTime = period.getStartSlot();
                    int endTime = period.getStartSlot() + period.getLength() - 1;
                    for (int t = startTime; t <= endTime; ++t) {
                        Long px = Long.valueOf(sharingModel.getPreference(d, t));
                        if (px.equals(RoomSharingModel.sNotAvailablePref)) {
                            if (allowConflicts) {
                                pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                                break block1;
                            }
                            if (allRooms.size() != 1) continue block0;
                            throw new GwtRpcException("Room " + room.getLabel() + " is not available for " + period.getLongName() + " due to the room sharing preferences.");
                        }
                        if (px.equals(RoomSharingModel.sFreeForAllPref) || departmentId.equals(px)) continue;
                        if (allowConflicts) {
                            pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                            break block1;
                        }
                        if (allRooms.size() != 1) continue block0;
                        throw new GwtRpcException("Room " + room.getLabel() + " is not available for " + period.getLongName() + " due to the room sharing preferences.");
                    }
                }
            }
            PreferenceCombination groupPref = PreferenceCombination.getDefault();
            boolean reqGroup = false;
            for (RoomGroupPref p : groupPrefs) {
                if (p.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sRequired)) {
                    reqGroup = true;
                }
                if (!p.getRoomGroup().getRooms().contains(room)) continue;
                groupPref.addPreferenceProlog(p.getPrefLevel().getPrefProlog());
            }
            if (reqGroup) {
                if (!PreferenceLevel.sRequired.equals(groupPref.getPreferenceProlog())) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                }
            } else {
                pref.addPreferenceProlog(groupPref.getPreferenceProlog());
            }
            String roomPref = null;
            BasePreferenceLevel roomPreference = null;
            for (RoomPref roomPref2 : clazz.getManagingDept().getPreferences(RoomPref.class)) {
                if (!room.equals(roomPref2.getRoom())) continue;
                roomPreference = roomPref2.getPrefLevel();
                break;
            }
            if (roomPreference != null) {
                roomPref = roomPreference.getPrefProlog();
            }
            boolean reqRoom = false;
            for (RoomPref p : roomPrefs) {
                if (p.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sRequired)) {
                    reqRoom = true;
                }
                if (!room.equals(p.getRoom())) continue;
                roomPref = p.getPrefLevel().getPrefProlog();
            }
            if (reqRoom) {
                if (!PreferenceLevel.sRequired.equals(roomPref)) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                }
            } else if (roomPref != null) {
                pref.addPreferenceProlog(roomPref);
            }
            Building building = room instanceof Room ? ((Room)room).getBuilding() : null;
            boolean reqBldg = false;
            String bldgPref = null;
            for (BuildingPref p : bldgPrefs) {
                if (p.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sRequired)) {
                    reqBldg = true;
                }
                if (building == null || !building.equals(p.getBuilding())) continue;
                bldgPref = p.getPrefLevel().getPrefProlog();
            }
            if (reqBldg) {
                if (!PreferenceLevel.sRequired.equals(bldgPref)) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                }
            } else if (bldgPref != null) {
                pref.addPreferenceProlog(bldgPref);
            }
            boolean acceptableFeatures = true;
            MinMaxPreferenceCombination featurePref = new MinMaxPreferenceCombination();
            for (RoomFeaturePref roomFeaturePref : featurePrefs) {
                RoomFeature feature = roomFeaturePref.getRoomFeature();
                Iterator<Comparable<Long>> p = roomFeaturePref.getPrefLevel().getPrefProlog();
                boolean bl = feature.getRooms().contains(room);
                if (((String)((Object)p)).equals(PreferenceLevel.sProhibited) && bl) {
                    acceptableFeatures = false;
                }
                if (((String)((Object)p)).equals(PreferenceLevel.sRequired) && !bl) {
                    acceptableFeatures = false;
                }
                if (p == null || !bl || ((String)((Object)p)).equals(PreferenceLevel.sProhibited) || ((String)((Object)p)).equals(PreferenceLevel.sRequired)) continue;
                featurePref.addPreferenceProlog(p);
            }
            pref.addPreferenceInt(featurePref.getPreferenceInt());
            if (!acceptableFeatures) {
                pref.addPreferenceProlog(PreferenceLevel.sProhibited);
            }
            if (clazz.getNbrRooms() <= 1 || !Boolean.TRUE.equals(clazz.isRoomsSplitAttendance())) {
                if (room.getCapacity() < stronglyDiscouragedCapacity) {
                    pref.addPreferenceInt(1000);
                } else if (room.getCapacity() < discouragedCapacity) {
                    pref.addPreferenceProlog(PreferenceLevel.sStronglyDiscouraged);
                } else if (room.getCapacity() < roomCapacity) {
                    pref.addPreferenceProlog(PreferenceLevel.sDiscouraged);
                }
            }
            prefInt = pref.getPreferenceInt();
            filteredRooms.put(room, prefInt);
            permIds.add(room.getPermanentId());
        }
        boolean changePast = ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue();
        boolean ignorePast = ApplicationProperty.ClassAssignmentIgnorePastMeetings.isTrue();
        boolean includeSuffix = ApplicationProperty.SolverShowClassSufix.isTrue();
        boolean includeConfig = ApplicationProperty.SolverShowConfiguratioName.isTrue();
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(new Date());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date today = cal.getTime();
        List<Object> datesToCheck = null;
        if (ignorePast || !changePast) {
            datesToCheck = new ArrayList();
            for (Date aDate : period.getDates()) {
                if (aDate.compareTo(today) <= 0) continue;
                datesToCheck.add(aDate);
            }
        } else {
            datesToCheck = period.getDates();
        }
        Hashtable<Long, Set<Long>> room2classIds = Location.findClassLocationTable(clazz.getSessionId(), permIds, period.getStartSlot(), period.getLength(), changePast ? period.getDates() : datesToCheck);
        Hashtable<Long, Set<Event>> room2events = null;
        if (RoomAvailability.getInstance() != null && RoomAvailability.getInstance() instanceof DefaultRoomAvailabilityService) {
            room2events = Location.findEventTable(clazz.getSessionId(), permIds, period.getStartSlot(), period.getLength(), datesToCheck);
        }
        Object var34_52 = null;
        if ((proposed == null || proposed.getConflict(classInfo) == null) && classInfo instanceof ClassAssignmentInfo) {
            ClassAssignmentInfo classAssignmentInfo = (ClassAssignmentInfo)classInfo;
        }
        Date[] bounds = DatePattern.getBounds(clazz.getSessionId());
        block9: for (Map.Entry entry : filteredRooms.entrySet()) {
            Collection<RoomAvailabilityInterface.TimeBlock> times;
            void var34_54;
            Location room = (Location)entry.getKey();
            prefInt = (Integer)entry.getValue();
            String note = null;
            if (room.isIgnoreRoomCheck().booleanValue()) {
                rooms.add(new ClassRoomInfo(room, prefInt, note));
                continue;
            }
            Set<Long> classIds = room2classIds.get(room.getPermanentId());
            if (classIds == null) {
                classIds = new HashSet<Long>();
            }
            if (var34_54 != null && var34_54.hasRoom(room.getUniqueId()) && var34_54.getTime().overlaps(period)) {
                classIds.remove(var34_54.getClassId());
            }
            if (proposed != null) {
                for (ClassAssignment classAssignment : proposed.getConflicts()) {
                    if (!classAssignment.hasRoom(room.getUniqueId()) || !classAssignment.getTime().overlaps(period)) continue;
                    classIds.remove(classAssignment.getClassId());
                }
                for (ClassAssignment classAssignment : proposed.getAssignments()) {
                    ClassAssignment initial = proposed.getInitial(classAssignment);
                    if (initial == null || !initial.hasRoom(room.getUniqueId()) || !initial.getTime().overlaps(period)) continue;
                    classIds.remove(initial.getClassId());
                }
                for (ClassAssignment classAssignment : proposed.getAssignments()) {
                    if (classInfo.getClassId().equals(classAssignment.getClassId()) || !classAssignment.hasRoom(room.getUniqueId()) || !classAssignment.getTime().overlaps(period)) continue;
                    classIds.add(classAssignment.getClassId());
                }
            }
            if (!allowConflicts && classIds != null && !classIds.isEmpty()) {
                for (Long l : classIds) {
                    if (clazz.canShareRoom(l)) continue;
                    if (allRooms.size() != 1) continue block9;
                    throw new GwtRpcException(MSG.messageRoomNotAvailable(room.getLabel(), period.getLongName(), ((Class_)Class_DAO.getInstance().get(l)).getClassLabel(includeSuffix, includeConfig)));
                }
            }
            if (allowConflicts && classIds != null && !classIds.isEmpty()) {
                for (Long l : classIds) {
                    if (clazz.canShareRoom(l)) continue;
                    prefInt += 10000;
                    note = "Conflicts with " + ((Class_)Class_DAO.getInstance().get(l)).getClassLabel(includeSuffix, includeConfig);
                    break;
                }
            }
            if (classIds != null && proposed != null) {
                for (Long l : classIds) {
                    if (proposed.getCurrent(l) == null || clazz.canShareRoom(l)) continue;
                    if (allRooms.size() != 1) continue block9;
                    throw new GwtRpcException(MSG.messageRoomNotAvailable(room.getLabel(), period.getLongName(), ((Class_)Class_DAO.getInstance().get(l)).getClassLabel(includeSuffix, includeConfig)));
                }
            }
            if (room2events != null) {
                Set<Event> conflicts = room2events.get(room.getPermanentId());
                if (conflicts != null && !conflicts.isEmpty()) {
                    sLog.info((Object)MSG.messageRoomNotAvailable2(room.getLabel(), period.getLongName(), conflicts.iterator().next().getEventName()));
                    if (allRooms.size() != 1) continue;
                    throw new GwtRpcException(MSG.messageRoomNotAvailable2(room.getLabel(), period.getLongName(), conflicts.iterator().next().getEventName()));
                }
            } else if (RoomAvailability.getInstance() != null && (times = RoomAvailability.getInstance().getRoomAvailability(room.getUniqueId(), bounds[0], bounds[1], RoomAvailabilityInterface.sClassType)) != null && !times.isEmpty()) {
                void var43_78;
                RoomAvailabilityInterface.TimeBlock time;
                Object var43_75 = null;
                if (!changePast || ignorePast) {
                    Vector<RoomAvailabilityInterface.TimeBlock> vector = new Vector<RoomAvailabilityInterface.TimeBlock>();
                    for (RoomAvailabilityInterface.TimeBlock timeBlock : times) {
                        if (timeBlock.getEndTime().before(today)) continue;
                        vector.add(timeBlock);
                    }
                } else {
                    Collection<RoomAvailabilityInterface.TimeBlock> collection = times;
                }
                if ((time = period.overlaps((Collection<RoomAvailabilityInterface.TimeBlock>)var43_78)) != null) {
                    if (allRooms.size() == 1) {
                        throw new GwtRpcException(MSG.messageRoomNotAvailable2(room.getLabel(), period.getLongName(), time.getEventName()));
                    }
                    sLog.info((Object)MSG.messageRoomNotAvailable2(room.getLabel(), period.getLongName(), time.getEventName()));
                    continue;
                }
            }
            if (room instanceof Room) {
                Room r = (Room)room;
                if (r.getParentRoom() != null && !r.getParentRoom().isIgnoreRoomCheck().booleanValue()) {
                    Collection<RoomAvailabilityInterface.TimeBlock> collection;
                    if (room2events != null) {
                        Set<Event> set = room2events.get(r.getParentRoom().getPermanentId());
                        if (set != null && !set.isEmpty()) {
                            if (allRooms.size() == 1) {
                                throw new GwtRpcException(MSG.messageRoomNotAvailable2(room.getLabel(), period.getLongName(), set.iterator().next().getEventName()));
                            }
                            sLog.info((Object)MSG.messageRoomNotAvailable2(room.getLabel(), period.getLongName(), set.iterator().next().getEventName()));
                            continue;
                        }
                    } else if (RoomAvailability.getInstance() != null && (collection = RoomAvailability.getInstance().getRoomAvailability(r.getParentRoom().getUniqueId(), bounds[0], bounds[1], RoomAvailabilityInterface.sClassType)) != null && !collection.isEmpty()) {
                        RoomAvailabilityInterface.TimeBlock timeBlock;
                        Collection<RoomAvailabilityInterface.TimeBlock> timesToCheck = null;
                        if (!changePast || ignorePast) {
                            timesToCheck = new Vector<RoomAvailabilityInterface.TimeBlock>();
                            for (RoomAvailabilityInterface.TimeBlock time : collection) {
                                if (time.getEndTime().before(today)) continue;
                                timesToCheck.add(time);
                            }
                        } else {
                            timesToCheck = collection;
                        }
                        if ((timeBlock = period.overlaps(timesToCheck)) != null) {
                            if (allRooms.size() == 1) {
                                throw new GwtRpcException(MSG.messageRoomNotAvailable2(room.getLabel(), period.getLongName(), timeBlock.getEventName()));
                            }
                            sLog.info((Object)MSG.messageRoomNotAvailable2(room.getLabel(), period.getLongName(), timeBlock.getEventName()));
                            continue;
                        }
                    }
                }
                for (Room p : r.getPartitions()) {
                    RoomAvailabilityInterface.TimeBlock time;
                    Collection<RoomAvailabilityInterface.TimeBlock> collection;
                    if (p.isIgnoreRoomCheck().booleanValue()) continue;
                    if (room2events != null) {
                        Set<Event> set = room2events.get(p.getPermanentId());
                        if (set == null || set.isEmpty()) continue;
                        if (allRooms.size() == 1) {
                            throw new GwtRpcException(MSG.messageRoomNotAvailable2(room.getLabel(), period.getLongName(), set.iterator().next().getEventName()));
                        }
                        sLog.info((Object)MSG.messageRoomNotAvailable2(room.getLabel(), period.getLongName(), set.iterator().next().getEventName()));
                        continue block9;
                    }
                    if (RoomAvailability.getInstance() == null || (collection = RoomAvailability.getInstance().getRoomAvailability(p.getUniqueId(), bounds[0], bounds[1], RoomAvailabilityInterface.sClassType)) == null || collection.isEmpty()) continue;
                    Collection<RoomAvailabilityInterface.TimeBlock> timesToCheck = null;
                    if (!changePast || ignorePast) {
                        timesToCheck = new Vector<RoomAvailabilityInterface.TimeBlock>();
                        for (RoomAvailabilityInterface.TimeBlock time3 : collection) {
                            if (time3.getEndTime().before(today)) continue;
                            timesToCheck.add(time3);
                        }
                    } else {
                        timesToCheck = collection;
                    }
                    if ((time = period.overlaps(timesToCheck)) == null) continue;
                    if (allRooms.size() == 1) {
                        throw new GwtRpcException(MSG.messageRoomNotAvailable2(room.getLabel(), period.getLongName(), time.getEventName()));
                    }
                    sLog.info((Object)MSG.messageRoomNotAvailable2(room.getLabel(), period.getLongName(), time.getEventName()));
                    continue block9;
                }
            }
            rooms.add(new ClassRoomInfo(room, prefInt, note));
        }
        Collections.sort(rooms, new Comparator<ClassRoomInfo>(){

            @Override
            public int compare(ClassRoomInfo r1, ClassRoomInfo r2) {
                switch (ord) {
                    case NAME_ASC: {
                        return TableInterface.NaturalOrderComparator.compare(r1.getName(), r2.getName());
                    }
                    case NAME_DESC: {
                        return TableInterface.NaturalOrderComparator.compare(r2.getName(), r1.getName());
                    }
                    case SIZE_ASC: {
                        if (r1.getCapacity() != r2.getCapacity()) {
                            return r1.getCapacity() < r2.getCapacity() ? -1 : 1;
                        }
                        return TableInterface.NaturalOrderComparator.compare(r1.getName(), r2.getName());
                    }
                    case SIZE_DESC: {
                        if (r1.getCapacity() != r2.getCapacity()) {
                            return r1.getCapacity() > r2.getCapacity() ? -1 : 1;
                        }
                        return TableInterface.NaturalOrderComparator.compare(r1.getName(), r2.getName());
                    }
                }
                return TableInterface.NaturalOrderComparator.compare(r1.getName(), r2.getName());
            }
        });
        return rooms;
    }

    public boolean getCanAssign(ClassProposedChange proposed, SessionContext context) {
        if (proposed == null) {
            return false;
        }
        for (ClassAssignment classAssignment : proposed.getAssignments()) {
            if (!classAssignment.isValid()) {
                return false;
            }
            if (context.hasPermission(classAssignment.getClazz(), Right.ClassAssignment)) continue;
            return false;
        }
        for (ClassAssignment classAssignment : proposed.getConflicts()) {
            if (context.hasPermission(classAssignment.getClazz(), Right.ClassAssignment)) continue;
            return false;
        }
        return !ApplicationProperty.ClassAssignmentAllowUnassignments.isFalse() || proposed.getConflicts().isEmpty();
    }

    public String assign(ClassProposedChange proposed, SessionContext context) {
        List<Long> classIds;
        Object m;
        Class_ clazz;
        if (proposed == null) {
            return MSG.errorNothingToAssign();
        }
        if (ApplicationProperty.ClassAssignmentAllowUnassignments.isFalse() && !proposed.getConflicts().isEmpty()) {
            return MSG.errorNotAllowedToKeepClassUnassigned();
        }
        sLog.info((Object)("About to be assigned: " + String.valueOf(proposed)));
        org.hibernate.Session hibSession = Class_DAO.getInstance().getSession();
        String message = null;
        Hashtable touchedOfferingIds = new Hashtable();
        for (ClassAssignment classAssignment : proposed.getConflicts()) {
            try {
                Long offeringId2;
                clazz = classAssignment.getClazz(hibSession);
                m = clazz.unassignCommited(context.getUser(), hibSession);
                if (m != null) {
                    message = (String)(message == null ? "" : message + "\n") + (String)m;
                }
                if ((classIds = (ArrayList<Long>)touchedOfferingIds.get(offeringId2 = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId())) == null) {
                    classIds = new ArrayList<Long>();
                    touchedOfferingIds.put(offeringId2, classIds);
                }
                classIds.add(clazz.getUniqueId());
            }
            catch (Exception e) {
                sLog.error((Object)MSG.errorUnassignmentFailed(classAssignment.getClassName(), e.getMessage()), (Throwable)e);
                message = (String)(message == null ? "" : message + "\n") + MSG.errorUnassignmentFailed(classAssignment.getClassName(), e.getMessage());
            }
        }
        for (ClassAssignmentInfo classAssignmentInfo : proposed.getAssignments()) {
            try {
                Long offeringId;
                clazz = classAssignmentInfo.getClazz(hibSession);
                m = clazz.assignCommited(classAssignmentInfo, context.getUser(), hibSession);
                if (m != null) {
                    message = (String)(message == null ? "" : message + "\n") + (String)m;
                }
                if ((classIds = (List)touchedOfferingIds.get(offeringId = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId())) == null) {
                    classIds = new ArrayList();
                    touchedOfferingIds.put(offeringId, classIds);
                }
                classIds.add(clazz.getUniqueId());
            }
            catch (Exception e) {
                sLog.error((Object)MSG.errorAssignmentFailed(classAssignmentInfo.getClassName(), classAssignmentInfo.getTime().getName() + " " + classAssignmentInfo.getRoomNames(", "), e.getMessage()), (Throwable)e);
                message = (String)(message == null ? "" : message + "\n") + MSG.errorAssignmentFailed(classAssignmentInfo.getClassName(), classAssignmentInfo.getTime().getName() + " " + classAssignmentInfo.getRoomNames(", "), e.getMessage());
            }
        }
        Long sessionId = context.getUser().getCurrentAcademicSessionId();
        Session session = (Session)SessionDAO.getInstance().get(sessionId, hibSession);
        if (!session.getStatusType().isTestSession()) {
            if (session.getStatusType().canOnlineSectionStudents()) {
                ArrayList<Long> unlockedOfferings = new ArrayList<Long>();
                for (Long offeringId : touchedOfferingIds.keySet()) {
                    if (session.isOfferingLocked(offeringId)) continue;
                    unlockedOfferings.add(offeringId);
                }
                if (!unlockedOfferings.isEmpty()) {
                    StudentSectioningQueue.offeringChanged(hibSession, context.getUser(), sessionId, unlockedOfferings);
                }
            } else if (session.getStatusType().canSectionAssistStudents()) {
                for (Map.Entry entry : touchedOfferingIds.entrySet()) {
                    if (session.isOfferingLocked((Long)entry.getKey())) continue;
                    StudentSectioningQueue.classAssignmentChanged(hibSession, context.getUser(), sessionId, (Collection)entry.getValue());
                }
            }
        }
        hibSession.flush();
        return message;
    }
}

