/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.base.BaseSubjectArea;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.InstructionalOfferingTableBuilder;
import org.unitime.timetable.solver.CachedClassAssignmentProxy;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.webutil.Navigation;

public class ClassesTableBuilder
extends InstructionalOfferingTableBuilder {
    public ClassesTableBuilder(SessionContext context, String backType, String backId) {
        super(context, backType, backId);
    }

    protected String additionalNote() {
        return "";
    }

    public void generateTableForClasses(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TableInterface.FilterInterface filter, String[] subjectAreaIds, List<TableInterface> tables) {
        this.setVisibleColumns(filter);
        this.setShowProjectedDemand(false);
        this.setShowMinPerWk(false);
        this.setShowCredit(false);
        this.setShowSubpartCredit(false);
        this.setShowConsent(false);
        this.setShowTitle(false);
        TreeSet classes = ClassesTableBuilder.getClasses(filter, subjectAreaIds, classAssignment);
        Navigation.set(this.getSessionContext(), Navigation.sClassLevel, classes);
        if (this.isShowTimetable()) {
            boolean hasTimetable = false;
            if (this.getSessionContext().hasPermission(Right.ClassAssignments) && classAssignment != null) {
                try {
                    if (classAssignment instanceof CachedClassAssignmentProxy) {
                        ((CachedClassAssignmentProxy)classAssignment).setCache(classes);
                    }
                    for (Object[] o : classes) {
                        Class_ clazz = (Class_)o[0];
                        if (classAssignment.getAssignment(clazz) == null) continue;
                        hasTimetable = true;
                        break;
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            this.setDisplayTimetable(hasTimetable);
        }
        if (this.isShowExam()) {
            this.setShowExamTimetable(examAssignment != null || Exam.hasTimetable(this.getCurrentAcademicSessionId()));
        }
        TableInterface table = null;
        BaseSubjectArea subjectArea = null;
        String prevLabel = null;
        int ct = 0;
        for (Object o : classes) {
            Class_ c = (Class_)((Object[])o)[0];
            CourseOffering co = (CourseOffering)((Object[])o)[1];
            if (subjectArea == null || !subjectArea.getUniqueId().equals(co.getSubjectArea().getUniqueId())) {
                subjectArea = co.getSubjectArea();
                table = this.initTable(this.getCurrentAcademicSessionId());
                table.setName(subjectArea.getSubjectAreaAbbreviation() + (String)(filter.getParameterValue("courseNbr", "").isEmpty() ? "" : " " + filter.getParameterValue("courseNbr", "")) + " - " + subjectArea.getSession().getLabel() + this.additionalNote());
                tables.add(table);
                ct = 0;
            }
            this.buildClassRow(classAssignment, examAssignment, ++ct, table, co, c, 0, prevLabel);
            prevLabel = c.getClassLabel(co);
        }
    }

    public TableInterface generateTableForSubpart(ClassAssignmentProxy classAssignment, SchedulingSubpart subpart) {
        if (CommonValues.Yes.eq(this.getUser().getProperty(UserProperty.ClassesKeepSort))) {
            this.setClassComparator(new ClassCourseComparator(this.getUser().getProperty("InstructionalOfferingList.sortBy", ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME)), classAssignment, false));
        }
        this.setDisplayDistributionPrefs(false);
        this.setShowLabel(true);
        this.setShowDemand(this.sessionHasEnrollments(this.getCurrentAcademicSessionId()));
        this.setShowProjectedDemand(false);
        this.setShowMinPerWk(true);
        this.setShowLimit(true);
        this.setShowSnapshotLimit(subpart.getInstrOfferingConfig().getInstructionalOffering().getSession().getCurrentSnapshotDate() != null);
        this.setShowRoomRatio(true);
        this.setShowFundingDepartment(false);
        if (ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue()) {
            for (Class_ c : subpart.getClasses()) {
                if (c.getFundingDept() == null) continue;
                this.setShowFundingDepartment(true);
                break;
            }
        }
        this.setShowManager(true);
        this.setShowDatePattern(true);
        this.setShowTimePattern(true);
        this.setShowPreferences(true);
        this.setShowInstructor(true);
        this.setShowTimetable(true);
        this.setShowCredit(false);
        this.setShowNote(false);
        this.setShowConsent(false);
        this.setShowTitle(false);
        this.setShowExam(false);
        this.setShowLms(LearningManagementSystemInfo.isLmsInfoDefinedForSession(this.getCurrentAcademicSessionId()));
        this.setShowWaitlistMode(false);
        this.setDisplayConflicts(true);
        if (this.isShowTimetable()) {
            boolean hasTimetable;
            block11: {
                hasTimetable = false;
                if (this.getSessionContext().hasPermission(Right.ClassAssignments) && classAssignment != null) {
                    try {
                        if (classAssignment instanceof CachedClassAssignmentProxy) {
                            Vector<Class_> allClasses = new Vector<Class_>();
                            for (Class_ clazz : subpart.getClasses()) {
                                allClasses.add(clazz);
                            }
                            ((CachedClassAssignmentProxy)classAssignment).setCache(allClasses);
                            hasTimetable = !classAssignment.getAssignmentTable(allClasses).isEmpty();
                            break block11;
                        }
                        for (Class_ clazz : subpart.getClasses()) {
                            if (classAssignment.getAssignment(clazz) == null) continue;
                            hasTimetable = true;
                            break;
                        }
                    }
                    catch (Exception l) {
                        // empty catch block
                    }
                }
            }
            this.setDisplayTimetable(hasTimetable);
        }
        this.setShowDivSec(false);
        this.setShowInstructorAssignment(false);
        this.setShowSchedulePrintNote(false);
        this.setShowSubpartCredit(false);
        TreeSet<Class_> classes = new TreeSet<Class_>(this.getClassComparator());
        classes.addAll(subpart.getClasses());
        Navigation.set(this.getSessionContext(), Navigation.sClassLevel, classes);
        TableInterface table = this.initTable(this.getCurrentAcademicSessionId());
        String prevLabel = null;
        int ct = 0;
        CourseOffering co = subpart.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
        for (Class_ c : classes) {
            this.buildClassRow(classAssignment, null, ++ct, table, co, c, 0, prevLabel);
            prevLabel = c.getClassLabel(co);
        }
        return table;
    }

    public static TreeSet getClasses(TableInterface.FilterInterface filter, String[] subjectIds, ClassAssignmentProxy classAssignmentProxy) {
        Session hibSession = InstructionalOfferingDAO.getInstance().getSession();
        HashSet<Long> filterManagers = new HashSet<Long>();
        if (!filter.getParameterValue("filterManager", "").isEmpty()) {
            for (String filterManager : filter.getParameterValue("filterManager").split(",")) {
                filterManagers.add(Long.valueOf(filterManager));
            }
        }
        if (subjectIds != null && subjectIds.length > 0) {
            StringBuffer query = new StringBuffer();
            query.append("select c, co from Class_ as c ");
            query.append("left join fetch c.childClasses as cc ");
            query.append("left join fetch c.schedulingSubpart as ss ");
            query.append("left join fetch ss.childSubparts as css ");
            query.append("left join fetch ss.instrOfferingConfig as ioc ");
            query.append("left join fetch ioc.instructionalOffering as io ");
            query.append("left join fetch io.courseOfferings as cox ");
            query.append("inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as co ");
            query.append(" where co.subjectArea.uniqueId in ( ");
            boolean first = true;
            for (int i = 0; i < subjectIds.length; ++i) {
                if (!first) {
                    query.append(", ");
                } else {
                    first = false;
                }
                query.append(subjectIds[i]);
            }
            query.append(") ");
            String courseNbr = filter.getParameterValue("courseNbr");
            if (ApplicationProperty.CourseOfferingTitleSearch.isTrue() && courseNbr != null && courseNbr.length() > 2) {
                if (courseNbr.indexOf(42) >= 0) {
                    query.append(" and (co.courseNbr like :courseNbr or lower(co.title) like lower(:courseNbr))");
                } else {
                    query.append(" and (co.courseNbr = :courseNbr or lower(co.title) like ('%' || lower(:courseNbr) || '%'))");
                }
            } else if (courseNbr != null && courseNbr.length() > 0) {
                if (courseNbr.indexOf(42) >= 0) {
                    query.append(" and co.courseNbr like :courseNbr ");
                } else {
                    query.append(" and co.courseNbr = :courseNbr ");
                }
            }
            boolean hasDeptIds = false;
            if (!filterManagers.isEmpty()) {
                if (filterManagers.contains(-2L) && filterManagers.size() == 1) {
                    query.append(" and c.managingDept = co.subjectArea.department");
                } else if (filterManagers.contains(-2L)) {
                    query.append(" and (c.managingDept = co.subjectArea.department or c.managingDept.uniqueId in :deptIds)");
                    hasDeptIds = true;
                } else {
                    query.append(" and c.managingDept.uniqueId in :deptIds");
                    hasDeptIds = true;
                }
            }
            if (!"1".equals(filter.getParameterValue("showCrossListedClasses"))) {
                query.append(" and co.isControl = true ");
            }
            if (!"1".equals(filter.getParameterValue("includeCancelledClasses")) || "1".equals(filter.getParameterValue("filterNeedInstructor"))) {
                query.append(" and c.cancelled = false");
            }
            if ("1".equals(filter.getParameterValue("filterNeedInstructor"))) {
                query.append(" and (select sum(tr.teachingRequest.nbrInstructors) from TeachingClassRequest tr where tr.assignInstructor = true and  tr.teachingClass = c) > 0");
            }
            Query q = hibSession.createQuery(query.toString(), Object[].class);
            q.setFetchSize(1000);
            if (courseNbr != null && courseNbr.length() > 0) {
                if (ApplicationProperty.CourseOfferingNumberUpperCase.isTrue()) {
                    courseNbr = courseNbr.toUpperCase();
                }
                q.setParameter("courseNbr", (Object)courseNbr.replace('*', '%'));
            }
            if (hasDeptIds) {
                q.setParameterList("deptIds", filterManagers);
            }
            q.setCacheable(true);
            TreeSet<Object[]> ts = new TreeSet<Object[]>(new ClassCourseComparator(filter.getParameterValue("sortBy", "NAME"), classAssignmentProxy, "1".equals(filter.getParameterValue("sortByKeepSubparts"))));
            long sTime = new Date().getTime();
            boolean doFilterInstructor = !filter.getParameterValue("filterInstructor", "").isEmpty();
            String filterInstructor = doFilterInstructor ? filter.getParameterValue("filterInstructor", "").toUpperCase() : null;
            boolean doFilterAssignedRoom = !filter.getParameterValue("filterAssignedRoom", "").isEmpty();
            String filterAssignedRoom = doFilterAssignedRoom ? filter.getParameterValue("filterAssignedRoom", "").toUpperCase() : null;
            boolean doFilterIType = !filter.getParameterValue("filterIType", "").isEmpty();
            String filterIType = doFilterIType ? filter.getParameterValue("filterIType", "") : null;
            String filterDayCode = filter.getParameterValue("filterDayCode", "0");
            boolean doFilterAssignedTime = !filterDayCode.isEmpty() && !"0".equals(filterDayCode) || !filter.getParameterValue("filterStartTime", "").isEmpty() || !filter.getParameterValue("filterEndTime", "").isEmpty();
            TimeLocation filterAssignedTime = null;
            if (doFilterAssignedTime) {
                String filterStartTime;
                int dayCode;
                int n = dayCode = filterDayCode.isEmpty() ? 255 : Integer.parseInt(filter.getParameterValue("filterDayCode", "255"));
                if (dayCode == 0) {
                    dayCode = 255;
                }
                int startTime = (filterStartTime = filter.getParameterValue("filterStartTime", "")).isEmpty() ? 0 : Integer.parseInt(filterStartTime);
                String filterEndTime = filter.getParameterValue("filterEndTime", "");
                int endTime = filterEndTime.isEmpty() ? 288 : Integer.parseInt(filterEndTime);
                filterAssignedTime = new TimeLocation(dayCode, startTime, endTime - startTime, 0, 0.0, null, null, null, 0);
            }
            Debug.debug(" --- Filter classes ---");
            for (Object[] o : q.list()) {
                ClassAssignmentProxy.AssignmentInfo a;
                Class_ c = (Class_)o[0];
                if (doFilterInstructor) {
                    boolean filterLine = true;
                    for (ClassInstructor ci : c.getClassInstructors()) {
                        StringTokenizer stk = new StringTokenizer(filterInstructor, " ,");
                        boolean containsInstructor = true;
                        while (stk.hasMoreTokens()) {
                            String token = stk.nextToken();
                            boolean containsToken = false;
                            if (ci.getInstructor().getFirstName() != null && ci.getInstructor().getFirstName().toUpperCase().indexOf(token) >= 0) {
                                containsToken = true;
                            }
                            if (!containsToken && ci.getInstructor().getMiddleName() != null && ci.getInstructor().getMiddleName().toUpperCase().indexOf(token) >= 0) {
                                containsToken = true;
                            }
                            if (!containsToken && ci.getInstructor().getLastName() != null && ci.getInstructor().getLastName().toUpperCase().indexOf(token) >= 0) {
                                containsToken = true;
                            }
                            if (containsToken) continue;
                            containsInstructor = false;
                            break;
                        }
                        if (!containsInstructor) continue;
                        filterLine = false;
                        break;
                    }
                    if (filterLine) continue;
                }
                if (doFilterIType) {
                    boolean match = false;
                    for (ItypeDesc itype = c.getSchedulingSubpart().getItype(); !match && itype != null; itype = itype.getParent()) {
                        match = itype.getItype().toString().equals(filterIType);
                    }
                    if (!match) continue;
                }
                if (doFilterAssignedTime) {
                    try {
                        boolean overlap;
                        TimeLocation t;
                        Placement p;
                        a = classAssignmentProxy.getAssignment(c);
                        if (a == null || (p = a.getPlacement()) == null || (t = p.getTimeLocation()) == null) continue;
                        boolean bl = overlap = t.shareDays(filterAssignedTime) && t.shareHours(filterAssignedTime);
                        if (!overlap) {
                        }
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (doFilterAssignedRoom) {
                    try {
                        Placement p;
                        a = classAssignmentProxy.getAssignment(c);
                        if (a == null || (p = a.getPlacement()) == null || p.getNrRooms() <= 0) continue;
                        boolean filterLine = true;
                        if (p.isMultiRoom()) {
                            for (RoomLocation r : p.getRoomLocations()) {
                                if (r.getName().toUpperCase().indexOf(filterAssignedRoom) < 0) continue;
                                filterLine = false;
                                break;
                            }
                        } else if (p.getRoomLocation().getName().toUpperCase().indexOf(filterAssignedRoom) >= 0) {
                            filterLine = false;
                        }
                        if (filterLine) {
                        }
                    }
                    catch (Exception e) {}
                    continue;
                }
                ts.add(o);
            }
            long eTime = new Date().getTime();
            Debug.debug("fetch time = " + (eTime - sTime));
            Debug.debug("rows = " + ts.size());
            return ts;
        }
        return new TreeSet();
    }

    @Override
    protected TableInterface.CellInterface buildPrefGroupLabel(CourseOffering co, PreferenceGroup prefGroup, int indentSpaces, boolean isEditable, String prevLabel) {
        if (prefGroup instanceof Class_) {
            TableInterface.CellInterface cell = new TableInterface.CellInterface();
            if (indentSpaces > 0) {
                cell.setIndent(indentSpaces);
            }
            Class_ aClass = (Class_)prefGroup;
            if (!isEditable) {
                cell.setColor(this.disabledColor);
            }
            if ("PreferenceGroup".equals(this.getBackType()) && prefGroup.getUniqueId().toString().equals(this.getBackId())) {
                cell.addAnchor("back");
            }
            if (co.isIsControl().booleanValue()) {
                cell.addStyle("font-weight: bold;");
            }
            String label = aClass.getClassLabel(co);
            Object title = aClass.getClassLabelWithTitle(co);
            if (prevLabel != null && label.equals(prevLabel)) {
                label = "";
            }
            if (!aClass.isEnabledForStudentScheduling().booleanValue()) {
                title = (String)title + MSG.titleSuffixDoNotDisplay();
                cell.addStyle("font-style: italic;");
            }
            cell.setText(label);
            cell.setTitle((String)title);
            cell.setNoWrap(true);
            InstructionalMethod im = aClass.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod();
            if (im != null) {
                cell.add(" (" + im.getReference() + ")").setTitle(im.getLabel());
            }
            return cell;
        }
        return super.buildPrefGroupLabel(co, prefGroup, indentSpaces, isEditable, prevLabel);
    }

    @Override
    protected TreeSet getExams(Class_ clazz) {
        TreeSet<Exam> ret = new TreeSet<Exam>(Exam.findAll(3, clazz.getUniqueId()));
        SchedulingSubpart subpart = clazz.getSchedulingSubpart();
        if (subpart.getParentSubpart() != null) {
            return ret;
        }
        InstrOfferingConfig config = subpart.getInstrOfferingConfig();
        SchedulingSubpartComparator cmp = new SchedulingSubpartComparator();
        for (SchedulingSubpart s : config.getSchedulingSubparts()) {
            if (cmp.compare(s, subpart) >= 0) continue;
            return ret;
        }
        InstructionalOffering offering = config.getInstructionalOffering();
        ret.addAll(Exam.findAll(2, config.getUniqueId()));
        ret.addAll(Exam.findAll(0, offering.getUniqueId()));
        for (CourseOffering co : offering.getCourseOfferings()) {
            ret.addAll(Exam.findAll(1, co.getUniqueId()));
        }
        return ret;
    }
}

