/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ContactCategory;
import org.unitime.timetable.model.dao.ContactCategoryDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=contactCategory]")
public class ContactCategories
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageContactCategory(), MESSAGES.pageContactCategories());
    }

    @Override
    @PreAuthorize(value="checkPermission('ContactCategories')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldMessage(), SimpleEditInterface.FieldType.textarea, 100, 10, 2048, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldHasRole(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldEmailAddress(), SimpleEditInterface.FieldType.textarea, 50, 3, 1000, new SimpleEditInterface.Flag[0]));
        data.setSortBy(0);
        for (ContactCategory cc : ContactCategoryDAO.getInstance().getSession().createQuery("from ContactCategory order by reference", ContactCategory.class).list()) {
            SimpleEditInterface.Record r = data.addRecord(cc.getUniqueId());
            r.setField(0, cc.getReference());
            r.setField(1, cc.getLabel());
            r.setField(2, cc.getMessage());
            r.setField(3, cc.isHasRole() != false ? "true" : "false");
            r.setField(4, cc.getEmail());
        }
        data.setEditable(context.hasPermission(Right.ContactCategoryEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('ContactCategoryEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (ContactCategory cc : ContactCategoryDAO.getInstance().findAll(hibSession)) {
            SimpleEditInterface.Record r = data.getRecord(cc.getUniqueId());
            if (r == null) {
                this.delete(cc, context, hibSession);
                continue;
            }
            this.update(cc, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('ContactCategoryEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        ContactCategory cc = new ContactCategory();
        cc.setReference(record.getField(0));
        cc.setLabel(record.getField(1));
        cc.setMessage(record.getField(2));
        cc.setHasRole("true".equalsIgnoreCase(record.getField(3)));
        cc.setEmail(record.getField(4));
        hibSession.persist((Object)cc);
        record.setUniqueId(cc.getUniqueId());
        ChangeLog.addChange(hibSession, context, cc, cc.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(ContactCategory cc, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (cc == null) {
            return;
        }
        if (ToolBox.equals((Object)cc.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)cc.getLabel(), (Object)record.getField(1)) && ToolBox.equals((Object)cc.getMessage(), (Object)record.getField(2)) && ToolBox.equals((Object)cc.getHasRole(), (Object)"true".equalsIgnoreCase(record.getField(3))) && ToolBox.equals((Object)cc.getEmail(), (Object)record.getField(4))) {
            return;
        }
        cc.setReference(record.getField(0));
        cc.setLabel(record.getField(1));
        cc.setMessage(record.getField(2));
        cc.setHasRole("true".equalsIgnoreCase(record.getField(3)));
        cc.setEmail(record.getField(4));
        hibSession.merge((Object)cc);
        ChangeLog.addChange(hibSession, context, cc, cc.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('ContactCategoryEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((ContactCategory)ContactCategoryDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(ContactCategory cc, SessionContext context, Session hibSession) {
        if (cc == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, cc, cc.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)cc);
    }

    @Override
    @PreAuthorize(value="checkPermission('ContactCategoryEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((ContactCategory)ContactCategoryDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

