/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.base.BasePosMinor;
import org.unitime.timetable.model.dao.PosMinorDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="pos_minor")
public class PosMinor
extends BasePosMinor {
    private static final long serialVersionUID = 1L;

    public PosMinor() {
    }

    public PosMinor(Long uniqueId) {
        super(uniqueId);
    }

    public static PosMinor findByCode(Long sessionId, String code) {
        return (PosMinor)PosMinorDAO.getInstance().getSession().createQuery("select a from PosMinor a where a.session.uniqueId=:sessionId and a.code=:code", PosMinor.class).setParameter("sessionId", (Object)sessionId).setParameter("code", (Object)code).setCacheable(true).uniqueResult();
    }

    public static PosMinor findByCodeAcadAreaId(Long sessionId, String code, Long areaId) {
        if (areaId == null) {
            return PosMinor.findByCode(sessionId, code);
        }
        return (PosMinor)PosMinorDAO.getInstance().getSession().createQuery("select p from PosMinor p inner join p.academicAreas a where p.session.uniqueId=:sessionId and a.uniqueId=:areaId and p.code=:code", PosMinor.class).setParameter("sessionId", (Object)sessionId).setParameter("areaId", (Object)areaId).setParameter("code", (Object)code).setCacheable(true).uniqueResult();
    }

    public static PosMinor findByCodeAcadAreaAbbv(Long sessionId, String code, String areaAbbv) {
        if (areaAbbv == null || areaAbbv.trim().length() == 0) {
            return PosMinor.findByCode(sessionId, code);
        }
        return (PosMinor)PosMinorDAO.getInstance().getSession().createQuery("select p from PosMinor p inner join p.academicAreas a where p.session.uniqueId=:sessionId and a.academicAreaAbbreviation=:areaAbbv and p.code=:code", PosMinor.class).setParameter("sessionId", (Object)sessionId).setParameter("areaAbbv", (Object)areaAbbv).setParameter("code", (Object)code).setCacheable(true).uniqueResult();
    }

    public Object clone() {
        PosMinor m = new PosMinor();
        m.setExternalUniqueId(this.getExternalUniqueId());
        m.setCode(this.getCode());
        m.setName(this.getName());
        return m;
    }
}

