/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.base.BaseInstructorCoursePref;

@Entity
@Table(name="course_pref")
public class InstructorCoursePref
extends BaseInstructorCoursePref {
    private static final long serialVersionUID = 2827106681341764953L;

    @Override
    public String preferenceText() {
        return this.getCourse().getCourseName();
    }

    @Override
    public String preferenceAbbv() {
        return this.getCourse().getCourseName();
    }

    @Override
    public Object clone() {
        InstructorCoursePref pref = new InstructorCoursePref();
        pref.setPrefLevel(this.getPrefLevel());
        pref.setCourse(this.getCourse());
        return pref;
    }

    @Override
    public boolean isSame(Preference other) {
        if (other == null || !(other instanceof InstructorCoursePref)) {
            return false;
        }
        return ToolBox.equals((Object)this.getCourse(), (Object)((InstructorCoursePref)other).getCourse());
    }

    @Override
    public String preferenceTitle() {
        return this.getPrefLevel().getPrefName() + " " + this.getCourse().getCourseName();
    }

    @Override
    public int compareTo(Object o) {
        if (o == null || !(o instanceof InstructorCoursePref)) {
            return super.compareTo(o);
        }
        InstructorCoursePref p = (InstructorCoursePref)o;
        int cmp = this.getCourse().compareTo(p.getCourse());
        if (cmp != 0) {
            return cmp;
        }
        return super.compareTo(o);
    }

    @Override
    @Transient
    public Preference.Type getType() {
        return Preference.Type.COURSE;
    }
}

