/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.ImageResourceRenderer;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.events.SingleDateSelector;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageHeader;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.solver.SolverLogPage;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.MenuInterface;
import org.unitime.timetable.gwt.shared.SolverInterface;

public class SolverPage
extends SimpleForm {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    protected static DateTimeFormat sLoadDateFormat = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormat());
    private Map<String, SolverInterface.SolverConfiguration> iConfigurations;
    private SolverInterface.SolverType iType;
    private int iLoadDateRow;
    private int iSolverStatusRow;
    private int iSolverProgressRow;
    private int iSolverConfigRow;
    private int iButtonsRow;
    private UniTimeHeaderPanel iSolverHeader;
    private UniTimeHeaderPanel iSolverButtons;
    private Label iLoadDate = null;
    private Label iSolverProgress = null;
    private SolverStatus iSolverStatus = null;
    private ListBox iSolverConfig = null;
    private List<Parameter> iParameters = null;
    private ListBox iSolverOwner = null;
    private ListBox iSolverHost = null;

    public SolverPage() {
        this.addStyleName("unitime-SolverPage");
        this.iType = SolverInterface.SolverType.valueOf(Window.Location.getParameter((String)"type").toUpperCase());
        switch (this.iType) {
            case COURSE: {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageCourseTimetablingSolver());
                break;
            }
            case EXAM: {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageExaminationTimetablingSolver());
                break;
            }
            case INSTRUCTOR: {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageInstructorSchedulingSolver());
                break;
            }
            case STUDENT: {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageStudentSchedulingSolver());
            }
        }
        this.iSolverHeader = new UniTimeHeaderPanel(CONSTANTS.solverType()[this.iType.ordinal()]);
        this.addHeaderRow((Widget)this.iSolverHeader);
        this.iSolverButtons = new UniTimeHeaderPanel();
        this.iSolverButtons.addButton("load", MESSAGES.opSolverLoad(), this.createClickHandler(SolverInterface.SolverOperation.LOAD));
        this.iSolverButtons.addButton("start", MESSAGES.opSolverStart(), this.createClickHandler(SolverInterface.SolverOperation.START));
        this.iSolverButtons.addButton("stop", MESSAGES.opSolverStop(), this.createClickHandler(SolverInterface.SolverOperation.STOP));
        this.iSolverButtons.addButton("sectioning", MESSAGES.opSolverStudentSectioning(), this.createClickHandler(SolverInterface.SolverOperation.STUDENT_SECTIONING));
        this.iSolverButtons.addButton("reload", MESSAGES.opSolverReload(), this.createClickHandler(SolverInterface.SolverOperation.RELOAD));
        this.iSolverButtons.addButton("validate", MESSAGES.opSolverValidate(), this.createClickHandler(SolverInterface.SolverOperation.VALIDATE));
        this.iSolverButtons.addButton("publish", MESSAGES.opSolverPublish(), this.createClickHandler(SolverInterface.SolverOperation.PUBLISH));
        this.iSolverButtons.addButton("clone", MESSAGES.opSolverClone(), this.createClickHandler(SolverInterface.SolverOperation.CLONE));
        this.iSolverButtons.addButton("save", MESSAGES.opSolverSave(), this.createClickHandler(SolverInterface.SolverOperation.SAVE));
        this.iSolverButtons.addButton("save new", MESSAGES.opSolverSaveAsNew(), this.createClickHandler(SolverInterface.SolverOperation.SAVE_AS_NEW));
        this.iSolverButtons.addButton("commit", MESSAGES.opSolverSaveCommit(), this.createClickHandler(SolverInterface.SolverOperation.SAVE_COMMIT));
        this.iSolverButtons.addButton("uncommit", MESSAGES.opSolverSaveUncommit(), this.createClickHandler(SolverInterface.SolverOperation.SAVE_UNCOMMIT));
        this.iSolverButtons.addButton("clear", MESSAGES.opSolverClear(), this.createClickHandler(SolverInterface.SolverOperation.CLEAR));
        this.iSolverButtons.addButton("csv", MESSAGES.opSolverExportCSV(), this.createClickHandler(SolverInterface.SolverOperation.EXPORT_CSV));
        this.iSolverButtons.addButton("unload", MESSAGES.opSolverUnload(), this.createClickHandler(SolverInterface.SolverOperation.UNLOAD));
        this.iSolverButtons.addButton("unpublish", MESSAGES.opSolverUnpublish(), this.createClickHandler(SolverInterface.SolverOperation.UNPUBLISH));
        this.iSolverButtons.addButton("refresh", MESSAGES.opSolverRefresh(), this.createClickHandler(SolverInterface.SolverOperation.CHECK));
        this.execute(SolverInterface.SolverOperation.INIT);
    }

    protected ClickHandler createClickHandler(final SolverInterface.SolverOperation operation) {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                SolverPage.this.execute(operation);
            }
        };
    }

    protected void execute(final SolverInterface.SolverOperation operation) {
        switch (operation) {
            case EXPORT_CSV: {
                ToolBox.open(GWT.getHostPageBaseURL() + "export?output=solution.csv&type=" + this.iType.name());
                return;
            }
            case EXPORT_XML: {
                ToolBox.open(GWT.getHostPageBaseURL() + "export?output=solution.xml&type=" + this.iType.name());
                return;
            }
        }
        final SolverInterface.SolverPageRequest request = new SolverInterface.SolverPageRequest(this.iType, operation);
        if (this.iSolverOwner != null && this.iSolverOwner.isEnabled()) {
            if (this.iSolverOwner.isMultipleSelect()) {
                for (int i = 0; i < this.iSolverOwner.getItemCount(); ++i) {
                    if (!this.iSolverOwner.isItemSelected(i)) continue;
                    request.addOwnerId(Long.valueOf(this.iSolverOwner.getValue(i)));
                }
                if (!request.hasOwerIds() && operation != SolverInterface.SolverOperation.CHECK) {
                    this.iSolverHeader.setErrorMessage(MESSAGES.errorSolverNoOwnerSelected());
                    return;
                }
            } else {
                request.addOwnerId(Long.valueOf(this.iSolverOwner.getValue(this.iSolverOwner.getSelectedIndex())));
            }
        }
        if (this.iSolverHost != null && this.iSolverHost.isEnabled()) {
            request.setHost(this.iSolverHost.getItemText(this.iSolverHost.getSelectedIndex()));
        }
        if (this.iSolverConfig != null && this.iSolverConfig.isEnabled()) {
            request.setConfigurationId(Long.valueOf(this.iSolverConfig.getValue(this.iSolverConfig.getSelectedIndex())));
        }
        if (this.iParameters != null) {
            for (Parameter p : this.iParameters) {
                if (!p.isEnabled()) continue;
                request.addParameter(p.getParameterId(), p.getParameterValue());
            }
        }
        String confirmation = null;
        switch (operation) {
            case UNLOAD: {
                if (this.iType == SolverInterface.SolverType.STUDENT) {
                    confirmation = MESSAGES.confirmStudentSolverUnload();
                    break;
                }
                confirmation = MESSAGES.confirmSolverUnload();
                break;
            }
            case UNPUBLISH: {
                confirmation = MESSAGES.confirmStudentSolverUnpublish();
                break;
            }
            case CLEAR: {
                if (this.iType == SolverInterface.SolverType.STUDENT) {
                    confirmation = MESSAGES.confirmStudentSolverClear();
                    break;
                }
                confirmation = MESSAGES.confirmSolverClear();
                break;
            }
            case SAVE: {
                if (this.iType == SolverInterface.SolverType.STUDENT) {
                    confirmation = MESSAGES.confirmStudentSolverSave();
                    break;
                }
                confirmation = MESSAGES.confirmSolverSave();
                break;
            }
            case SAVE_AS_NEW: {
                if (this.iType == SolverInterface.SolverType.STUDENT) {
                    confirmation = MESSAGES.confirmStudentSolverSaveAsNew();
                    break;
                }
                confirmation = MESSAGES.confirmSolverSaveAsNew();
                break;
            }
            case SAVE_COMMIT: {
                confirmation = MESSAGES.confirmSolverSaveCommit();
                break;
            }
            case SAVE_AS_NEW_COMMIT: {
                confirmation = MESSAGES.confirmSolverSaveAsNewCommit();
                break;
            }
            case SAVE_UNCOMMIT: {
                confirmation = MESSAGES.confirmSolverSaveUncommit();
            }
        }
        Command command = new Command(){

            public void execute() {
                if (operation == SolverInterface.SolverOperation.INIT || operation == SolverInterface.SolverOperation.CHECK) {
                    SolverPage.this.iSolverHeader.showLoading();
                } else {
                    LoadingWidget.showLoading(MESSAGES.waitSolverExecution());
                }
                RPC.execute(request, new AsyncCallback<SolverInterface.SolverPageResponse>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.hideLoading();
                        ToolBox.checkAccess(caught);
                        UniTimeNotifications.error(caught.getMessage());
                        SolverPage.this.iSolverHeader.setErrorMessage(caught.getMessage());
                    }

                    public void onSuccess(SolverInterface.SolverPageResponse result) {
                        LoadingWidget.hideLoading();
                        SolverPage.this.iSolverHeader.clearMessage();
                        SolverPage.this.populate(result);
                        UniTimePageHeader.getInstance().reloadSolverInfo();
                    }
                });
            }
        };
        if (confirmation == null) {
            command.execute();
        } else {
            UniTimeConfirmationDialog.confirm(confirmation, command);
        }
    }

    protected void populate(SolverInterface.SolverPageResponse response) {
        RootPanel cpm;
        int i;
        if (this.iLoadDate == null) {
            this.clear();
            this.addHeaderRow((Widget)this.iSolverHeader);
            this.iLoadDate = new Label();
            this.iLoadDateRow = this.addRow(MESSAGES.propSolverLoadDate(), (Widget)this.iLoadDate);
            this.iSolverStatus = new SolverStatus();
            this.iSolverStatusRow = this.addRow(MESSAGES.propSolverStatus(), (Widget)this.iSolverStatus);
            this.iSolverProgress = new Label();
            this.iSolverProgressRow = this.addRow(MESSAGES.propSolverProgress(), (Widget)this.iSolverProgress);
            if (response.hasSolverOwners()) {
                this.iSolverOwner = new ListBox();
                if (response.isAllowMultipleOwners()) {
                    this.iSolverOwner.setMultipleSelect(true);
                    this.iSolverOwner.setVisibleItemCount(response.getSolverOwners().size() < 5 ? response.getSolverOwners().size() : 5);
                } else {
                    this.iSolverOwner.setMultipleSelect(false);
                }
                for (SolverInterface.SolverOwner owner : response.getSolverOwners()) {
                    this.iSolverOwner.addItem(owner.getName(), owner.getId().toString());
                }
            }
            if (this.iType == SolverInterface.SolverType.EXAM && this.iSolverOwner != null) {
                this.addRow(MESSAGES.propExamSolverOwner(), (Widget)this.iSolverOwner);
            }
            this.iSolverConfig = new ListBox();
            this.iSolverConfigRow = this.addRow(MESSAGES.propSolverConfiguration(), (Widget)this.iSolverConfig);
            this.iConfigurations = new HashMap<String, SolverInterface.SolverConfiguration>();
            if (response.hasConfigurations()) {
                for (SolverInterface.SolverConfiguration config : response.getConfigurations()) {
                    this.iSolverConfig.addItem(config.getName(), config.getId().toString());
                    this.iConfigurations.put(config.getId().toString(), config);
                }
                this.iSolverConfig.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        SolverInterface.SolverConfiguration config = SolverPage.this.iConfigurations.get(SolverPage.this.iSolverConfig.getValue(SolverPage.this.iSolverConfig.getSelectedIndex()));
                        Iterator<Parameter> iterator = SolverPage.this.iParameters.iterator();
                        while (iterator.hasNext()) {
                            Parameter p;
                            String value = config.getParameter((p = iterator.next()).getParameterId());
                            p.setParameterValue(value != null ? value : p.getParameterDefaultValue());
                        }
                    }
                });
            }
            this.iParameters = new ArrayList<Parameter>();
            if (response.hasParameters()) {
                for (SolverInterface.SolverParameter parameter : response.getParameters()) {
                    Parameter p = null;
                    p = "boolean".equalsIgnoreCase(parameter.getType()) ? new BooleanParameter(parameter) : ("double".equalsIgnoreCase(parameter.getType()) ? new DoubleParameter(parameter) : ("integer".equalsIgnoreCase(parameter.getType()) ? new IntegerParameter(parameter) : ("date".equalsIgnoreCase(parameter.getType()) ? new DateParameter(parameter) : (parameter.getType() != null && parameter.getType().toLowerCase().startsWith("enum(") && parameter.getType().endsWith(")") ? new EnumParameter(parameter) : new TextParameter(parameter)))));
                    this.iParameters.add(p);
                    this.addRow(parameter.getName() + ":", (Widget)p);
                }
            }
            if (this.iType != SolverInterface.SolverType.EXAM && this.iSolverOwner != null) {
                this.addRow(MESSAGES.propSolverOwner(), (Widget)this.iSolverOwner);
            }
            if (response.hasHosts()) {
                this.iSolverHost = new ListBox();
                for (String host : response.getHosts()) {
                    this.iSolverHost.addItem(host);
                }
                this.addRow(MESSAGES.propSolverHost(), (Widget)this.iSolverHost);
            }
            this.iButtonsRow = this.addBottomRow((Widget)this.iSolverButtons);
        }
        if (response.getLoadDate() == null) {
            this.getRowFormatter().setVisible(this.iLoadDateRow, false);
        } else {
            this.getRowFormatter().setVisible(this.iLoadDateRow, true);
            this.iLoadDate.setText(sLoadDateFormat.format(response.getLoadDate()));
        }
        if (response.getSolverStatus() == null) {
            this.getRowFormatter().setVisible(this.iSolverStatusRow, false);
        } else {
            this.getRowFormatter().setVisible(this.iSolverStatusRow, true);
            this.iSolverStatus.setStatus(response.getSolverStatus());
        }
        if (response.getSolverProgress() == null) {
            this.getRowFormatter().setVisible(this.iSolverProgressRow, false);
        } else {
            this.getRowFormatter().setVisible(this.iSolverProgressRow, true);
            this.iSolverProgress.setText(response.getSolverProgress());
        }
        if (this.iSolverConfig.getItemCount() == 0) {
            this.getRowFormatter().setVisible(this.iSolverConfigRow, false);
        } else {
            this.getRowFormatter().setVisible(this.iSolverConfigRow, true);
            this.iSolverConfig.setEnabled(!response.isWorking());
            if (response.isRefresh()) {
                if (response.getConfigurationId() != null) {
                    for (int i2 = 0; i2 < this.iSolverConfig.getItemCount(); ++i2) {
                        if (!this.iSolverConfig.getValue(i2).equals(response.getConfigurationId().toString())) continue;
                        this.iSolverConfig.setSelectedIndex(i2);
                        break;
                    }
                } else {
                    this.iSolverConfig.setSelectedIndex(0);
                }
            }
        }
        for (i = 0; i < this.iParameters.size(); ++i) {
            Parameter p = this.iParameters.get(i);
            p.setEnabled(!response.isWorking());
            if (!response.isRefresh()) continue;
            SolverInterface.SolverParameter parameter = response.getParameter(p.getParameterId());
            p.setParameterValue(parameter != null ? (parameter.getValue() != null ? parameter.getValue() : parameter.getDefaultValue()) : p.getParameterDefaultValue());
        }
        if (this.iSolverOwner != null) {
            this.iSolverOwner.setEnabled(!response.isWorking() && response.getLoadDate() == null);
            if (response.isRefresh()) {
                if (this.iSolverOwner.isMultipleSelect()) {
                    for (i = 0; i < this.iSolverOwner.getItemCount(); ++i) {
                        this.iSolverOwner.setItemSelected(i, response.hasOwerIds() && response.getOwnerIds().contains(Long.valueOf(this.iSolverOwner.getValue(i))));
                    }
                } else {
                    for (i = 0; i < this.iSolverOwner.getItemCount(); ++i) {
                        if (!response.hasOwerIds() || !response.getOwnerIds().contains(Long.valueOf(this.iSolverOwner.getValue(i)))) continue;
                        this.iSolverOwner.setSelectedIndex(i);
                        break;
                    }
                }
            }
        }
        if (this.iSolverHost != null) {
            this.iSolverHost.setEnabled(!response.isWorking() && response.getLoadDate() == null);
            if (response.isRefresh()) {
                for (i = 0; i < this.iSolverHost.getItemCount(); ++i) {
                    if (!this.iSolverHost.getValue(i).equals(response.getHost())) continue;
                    this.iSolverHost.setSelectedIndex(i);
                    break;
                }
            }
        }
        this.iSolverButtons.setEnabled("load", response.canExecute(SolverInterface.SolverOperation.LOAD));
        this.iSolverButtons.setEnabled("start", response.canExecute(SolverInterface.SolverOperation.START));
        this.iSolverButtons.setEnabled("stop", response.canExecute(SolverInterface.SolverOperation.STOP));
        this.iSolverButtons.setEnabled("sectioning", response.canExecute(SolverInterface.SolverOperation.STUDENT_SECTIONING));
        this.iSolverButtons.setEnabled("reload", response.canExecute(SolverInterface.SolverOperation.RELOAD));
        this.iSolverButtons.setEnabled("validate", response.canExecute(SolverInterface.SolverOperation.VALIDATE));
        this.iSolverButtons.setEnabled("publish", response.canExecute(SolverInterface.SolverOperation.PUBLISH));
        this.iSolverButtons.setEnabled("clone", response.canExecute(SolverInterface.SolverOperation.CLONE));
        this.iSolverButtons.setEnabled("save", this.iType != SolverInterface.SolverType.COURSE && response.canExecute(SolverInterface.SolverOperation.SAVE));
        this.iSolverButtons.setEnabled("save new", this.iType != SolverInterface.SolverType.COURSE && response.canExecute(SolverInterface.SolverOperation.SAVE_AS_NEW));
        this.iSolverButtons.setEnabled("commit", this.iType != SolverInterface.SolverType.COURSE && response.canExecute(SolverInterface.SolverOperation.SAVE_COMMIT));
        this.iSolverButtons.setEnabled("uncommit", this.iType != SolverInterface.SolverType.COURSE && response.canExecute(SolverInterface.SolverOperation.SAVE_UNCOMMIT));
        this.iSolverButtons.setEnabled("clear", response.canExecute(SolverInterface.SolverOperation.CLEAR));
        this.iSolverButtons.setEnabled("csv", response.canExecute(SolverInterface.SolverOperation.EXPORT_CSV));
        this.iSolverButtons.setEnabled("unload", response.canExecute(SolverInterface.SolverOperation.UNLOAD));
        this.iSolverButtons.setEnabled("unpublish", response.canExecute(SolverInterface.SolverOperation.UNPUBLISH));
        this.iSolverButtons.setEnabled("refresh", response.canExecute(SolverInterface.SolverOperation.CHECK));
        for (int row = this.getRowCount() - 1; row > this.iButtonsRow; --row) {
            this.removeRow(row);
        }
        if (response.hasBestSolution()) {
            this.addHeaderRow(this.iType == SolverInterface.SolverType.STUDENT ? MESSAGES.sectStudentSolverBestSolution() : MESSAGES.sectSolverBestSolution());
            for (SolverInterface.InfoPair pair : response.getBestSolution().getPairs()) {
                this.addRow((Widget)new HTML(pair.getName()), (Widget)new HTML(pair.getValue()));
            }
            if (this.iType == SolverInterface.SolverType.COURSE && (response.canExecute(SolverInterface.SolverOperation.SAVE) || response.canExecute(SolverInterface.SolverOperation.SAVE_AS_NEW))) {
                UniTimeHeaderPanel buttons = new UniTimeHeaderPanel();
                if (response.canExecute(SolverInterface.SolverOperation.SAVE)) {
                    buttons.addButton("save", MESSAGES.opSolverSave(), this.createClickHandler(SolverInterface.SolverOperation.SAVE));
                }
                if (response.canExecute(SolverInterface.SolverOperation.SAVE_AS_NEW)) {
                    buttons.addButton("save new", MESSAGES.opSolverSaveAsNew(), this.createClickHandler(SolverInterface.SolverOperation.SAVE_AS_NEW));
                }
                if (response.canExecute(SolverInterface.SolverOperation.SAVE_COMMIT)) {
                    buttons.addButton("commit", MESSAGES.opSolverSaveCommit(), this.createClickHandler(SolverInterface.SolverOperation.SAVE_COMMIT));
                }
                if (response.canExecute(SolverInterface.SolverOperation.SAVE_AS_NEW_COMMIT)) {
                    buttons.addButton("new commit", MESSAGES.opSolverSaveAsNewCommit(), this.createClickHandler(SolverInterface.SolverOperation.SAVE_AS_NEW_COMMIT));
                }
                if (response.canExecute(SolverInterface.SolverOperation.SAVE_UNCOMMIT)) {
                    buttons.addButton("uncommit", MESSAGES.opSolverSaveUncommit(), this.createClickHandler(SolverInterface.SolverOperation.SAVE_UNCOMMIT));
                }
                this.addBottomRow((Widget)buttons);
            }
        }
        if (response.hasCurrentSolution()) {
            this.addHeaderRow(this.iType == SolverInterface.SolverType.STUDENT ? MESSAGES.sectStudentSolverCurrentSolution() : MESSAGES.sectSolverCurrentSolution());
            for (SolverInterface.InfoPair pair : response.getCurrentSolution().getPairs()) {
                this.addRow((Widget)new HTML(pair.getName()), (Widget)new HTML(pair.getValue()));
            }
            if (response.canExecute(SolverInterface.SolverOperation.SAVE_BEST) || response.canExecute(SolverInterface.SolverOperation.RESTORE_BEST) || response.canExecute(SolverInterface.SolverOperation.EXPORT_XML)) {
                UniTimeHeaderPanel buttons = new UniTimeHeaderPanel();
                if (response.canExecute(SolverInterface.SolverOperation.SAVE_BEST)) {
                    buttons.addButton("save best", MESSAGES.opSolverSaveBest(), this.createClickHandler(SolverInterface.SolverOperation.SAVE_BEST));
                }
                if (response.canExecute(SolverInterface.SolverOperation.RESTORE_BEST)) {
                    buttons.addButton("restore best", MESSAGES.opSolverRestorBest(), this.createClickHandler(SolverInterface.SolverOperation.RESTORE_BEST));
                }
                if (response.canExecute(SolverInterface.SolverOperation.EXPORT_XML)) {
                    buttons.addButton("xml", MESSAGES.opSolverExportXML(), this.createClickHandler(SolverInterface.SolverOperation.EXPORT_XML));
                }
                this.addBottomRow((Widget)buttons);
            }
        }
        if (response.hasLog()) {
            this.addHeaderRow(MESSAGES.sectSolverWarnings());
            this.addRow((Widget)new SolverLogPage.ProgressLog(response.getLog()));
        }
        if (response.hasSelectedSolutions()) {
            for (SolverInterface.SolutionInfo selected : response.getSelectedSolutions()) {
                this.addHeaderRow(MESSAGES.sectSolverSelectedSolution(selected.getName()));
                for (SolverInterface.InfoPair pair : selected.getPairs()) {
                    this.addRow((Widget)new HTML(pair.getName()), (Widget)new HTML(pair.getValue()));
                }
                if (!selected.hasLog()) continue;
                this.addHeaderRow(MESSAGES.sectSolverSelectedWarnings(selected.getName()));
                this.addRow((Widget)new SolverLogPage.ProgressLog(selected.getLog()));
            }
        }
        if ((cpm = RootPanel.get((String)"UniTimeGWT:CustomPageMessages")) != null) {
            cpm.clear();
            if (response.hasPageMessages()) {
                for (final SolverInterface.PageMessage pm : response.getPageMessages()) {
                    P p = new P(pm.getType() == SolverInterface.PageMessageType.ERROR ? "unitime-PageError" : (pm.getType() == SolverInterface.PageMessageType.WARNING ? "unitime-PageWarn" : "unitime-PageMessage"));
                    p.setHTML(pm.getMessage());
                    if (pm.hasUrl()) {
                        p.addStyleName("unitime-ClickablePageMessage");
                        p.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                if (pm.hasUrl() && !pm.getUrl().startsWith("solver")) {
                                    ToolBox.open(GWT.getHostPageBaseURL() + pm.getUrl());
                                } else {
                                    SolverPage.this.execute(SolverInterface.SolverOperation.CHECK);
                                }
                            }
                        });
                    }
                    cpm.add((Widget)p);
                }
            }
        }
    }

    @Override
    public int addHeaderRow(String text) {
        int row = super.addHeaderRow(text);
        this.getRowFormatter().addStyleName(row, "row-above");
        return row;
    }

    @Override
    public int addBottomRow(Widget widget) {
        int row = super.addBottomRow(widget, false);
        this.getFlexCellFormatter().removeStyleName(row, 0, "unitime-TopLine");
        return row;
    }

    public static class SolverStatus
    extends P {
        private P iStatus = new P("status-label");
        private Anchor iIcon = new Anchor(new ImageResourceRenderer().render(RESOURCES.helpIcon()), "", "_blank");

        public SolverStatus() {
            super("unitime-SolverStatus");
            this.iIcon.addStyleName("status-icon");
            this.iIcon.setVisible(false);
            this.add((Widget)this.iStatus);
            this.add((Widget)this.iIcon);
            RPC.execute(new MenuInterface.PageNameRpcRequest("Solver Status"), new AsyncCallback<MenuInterface.PageNameInterface>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(MenuInterface.PageNameInterface result) {
                    iIcon.setTitle(MESSAGES.pageHelp(result.getName()));
                    iIcon.setVisible(true);
                    iIcon.setHref(result.getHelpUrl());
                }
            });
        }

        public void setStatus(String status) {
            this.iStatus.setText(status);
        }
    }

    protected static interface Parameter
    extends HasEnabled {
        public Long getParameterId();

        public String getParameterValue();

        public String getParameterDefaultValue();

        public void setParameterValue(String var1);
    }

    public static class BooleanParameter
    extends CheckBox
    implements Parameter {
        private SolverInterface.SolverParameter iParameter;

        public BooleanParameter(SolverInterface.SolverParameter parameter) {
            this.iParameter = parameter;
            this.addStyleName("parameter-text");
            this.setParameterValue(parameter.getValue() != null ? parameter.getValue() : parameter.getDefaultValue());
        }

        @Override
        public Long getParameterId() {
            return this.iParameter.getId();
        }

        @Override
        public String getParameterValue() {
            return super.getValue() != false ? "true" : "false";
        }

        @Override
        public void setParameterValue(String value) {
            this.setValue("true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value));
        }

        @Override
        public String getParameterDefaultValue() {
            return this.iParameter.getDefaultValue();
        }
    }

    public static class DoubleParameter
    extends NumberBox
    implements Parameter {
        private SolverInterface.SolverParameter iParameter;

        public DoubleParameter(SolverInterface.SolverParameter parameter) {
            this.iParameter = parameter;
            this.addStyleName("parameter-number");
            this.setDecimal(true);
            this.setNegative(true);
            this.setParameterValue(parameter.getValue() != null ? parameter.getValue() : parameter.getDefaultValue());
        }

        @Override
        public Long getParameterId() {
            return this.iParameter.getId();
        }

        @Override
        public String getParameterValue() {
            return this.getText();
        }

        @Override
        public void setParameterValue(String value) {
            this.setText(value == null ? "" : value);
        }

        @Override
        public String getParameterDefaultValue() {
            return this.iParameter.getDefaultValue();
        }
    }

    public static class IntegerParameter
    extends NumberBox
    implements Parameter {
        private SolverInterface.SolverParameter iParameter;

        public IntegerParameter(SolverInterface.SolverParameter parameter) {
            this.iParameter = parameter;
            this.addStyleName("parameter-number");
            this.setDecimal(false);
            this.setNegative(true);
            this.setParameterValue(parameter.getValue() != null ? parameter.getValue() : parameter.getDefaultValue());
        }

        @Override
        public Long getParameterId() {
            return this.iParameter.getId();
        }

        @Override
        public String getParameterValue() {
            return this.getText();
        }

        @Override
        public void setParameterValue(String value) {
            this.setText(value == null ? "" : value);
        }

        @Override
        public String getParameterDefaultValue() {
            return this.iParameter.getDefaultValue();
        }
    }

    public static class DateParameter
    extends SingleDateSelector
    implements Parameter {
        private SolverInterface.SolverParameter iParameter;
        private DateTimeFormat iFormat = DateTimeFormat.getFormat((String)"yyyy-MM-dd");

        public DateParameter(SolverInterface.SolverParameter parameter) {
            this.iParameter = parameter;
            this.addStyleName("parameter-date");
            this.setParameterValue(parameter.getValue() != null ? parameter.getValue() : parameter.getDefaultValue());
        }

        @Override
        public Long getParameterId() {
            return this.iParameter.getId();
        }

        @Override
        public String getParameterValue() {
            Date date = super.getValue();
            if (date == null) {
                return "";
            }
            return this.iFormat.format(date);
        }

        @Override
        public void setParameterValue(String value) {
            if (value == null || value.isEmpty()) {
                this.setValue(null);
            } else {
                try {
                    this.setValue(this.iFormat.parse(value));
                }
                catch (Exception e) {
                    this.setValue(null);
                }
            }
        }

        @Override
        public String getParameterDefaultValue() {
            return this.iParameter.getDefaultValue();
        }
    }

    public static class EnumParameter
    extends ListBox
    implements Parameter {
        private SolverInterface.SolverParameter iParameter;

        public EnumParameter(SolverInterface.SolverParameter parameter) {
            this.iParameter = parameter;
            this.addStyleName("parameter-list");
            for (String item : parameter.getType().substring(parameter.getType().indexOf(40) + 1, parameter.getType().lastIndexOf(41)).split(",")) {
                this.addItem(item);
            }
            this.setParameterValue(parameter.getValue() != null ? parameter.getValue() : parameter.getDefaultValue());
        }

        @Override
        public Long getParameterId() {
            return this.iParameter.getId();
        }

        @Override
        public String getParameterValue() {
            if (this.getSelectedIndex() < 0) {
                return null;
            }
            return this.getValue(this.getSelectedIndex());
        }

        @Override
        public void setParameterValue(String value) {
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (!this.getValue(i).equals(value)) continue;
                this.setSelectedIndex(i);
                break;
            }
        }

        @Override
        public String getParameterDefaultValue() {
            return this.iParameter.getDefaultValue();
        }
    }

    public static class TextParameter
    extends TextBox
    implements Parameter {
        private SolverInterface.SolverParameter iParameter;

        public TextParameter(SolverInterface.SolverParameter parameter) {
            this.iParameter = parameter;
            this.setStyleName("unitime-TextBox");
            this.addStyleName("parameter-text");
            this.setParameterValue(parameter.getValue() != null ? parameter.getValue() : parameter.getDefaultValue());
        }

        @Override
        public Long getParameterId() {
            return this.iParameter.getId();
        }

        @Override
        public String getParameterValue() {
            return this.getText();
        }

        @Override
        public void setParameterValue(String value) {
            this.setText(value == null ? "" : value);
        }

        @Override
        public String getParameterDefaultValue() {
            return this.iParameter.getDefaultValue();
        }
    }
}

