/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.rooms.GoogleMap;
import org.unitime.timetable.gwt.client.rooms.LeafletMap;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.shared.RoomInterface;

public abstract class MapWidget
extends AbsolutePanel
implements HasEnabled {
    protected static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    protected TextBox iX;
    protected TextBox iY;
    private boolean iInitialized = false;
    protected AbsolutePanel iMapControl;

    protected MapWidget(TextBox x, TextBox y) {
        this.iX = x;
        this.iX.getElement().setId("coordX");
        this.iY = y;
        this.iY.getElement().setId("coordY");
        this.iX.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                MapWidget.this.setMarker();
            }
        });
        this.iY.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                MapWidget.this.setMarker();
            }
        });
    }

    protected static MapWidget createMap(TextBox x, TextBox y, RoomInterface.MapPropertiesInterface result) {
        if (result.isGoogleMap()) {
            return new GoogleMap(x, y, result.getGoogleMapApiKey());
        }
        if (result.isLeafletMap()) {
            return new LeafletMap(x, y, result.getLeafletMapTiles(), result.getLeafletMapAttribution());
        }
        return null;
    }

    public boolean isEnabled() {
        return this.iMapControl != null && this.iMapControl.isVisible();
    }

    public void setEnabled(boolean enabled) {
        if (this.iMapControl != null) {
            this.iMapControl.setVisible(enabled);
        }
    }

    public void onShow() {
        if (!this.isVisible()) {
            return;
        }
        if (!this.iInitialized) {
            this.iInitialized = true;
            this.setup();
        } else if (this.iMapControl != null) {
            this.setMarker();
        }
    }

    protected abstract void setup();

    public abstract void setMarker();

    public static void createWidget(final TextBox x, final TextBox y, final AsyncCallback<MapWidget> callback) {
        RPC.execute(new RoomInterface.MapPropertiesRequest(), new AsyncCallback<RoomInterface.MapPropertiesInterface>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(RoomInterface.MapPropertiesInterface result) {
                MapWidget map = MapWidget.createMap(x, y, result);
                callback.onSuccess((Object)map);
            }
        });
    }

    public static void insert(final RootPanel panel) {
        RPC.execute(new RoomInterface.MapPropertiesRequest(), new AsyncCallback<RoomInterface.MapPropertiesInterface>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(RoomInterface.MapPropertiesInterface result) {
                MapWidget map = MapWidget.createMap(TextBox.wrap((Element)Document.get().getElementById("coordX")), TextBox.wrap((Element)Document.get().getElementById("coordY")), result);
                if (map != null) {
                    panel.add((Widget)map);
                    panel.setVisible(true);
                    map.onShow();
                }
            }
        });
    }
}

