/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.rooms;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.client.rooms.RoomFeaturesComparator;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.server.rooms.RoomFeaturesBackend;

@Service(value="org.unitime.timetable.export.Exporter:roomfeatures.csv")
public class RoomFeaturesExportCSV
implements Exporter {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public String reference() {
        return "roomfeatures.csv";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId);
        if (session == null) {
            throw new IllegalArgumentException("Given academic session no longer exists.");
        }
        RoomInterface.SearchRoomFeaturesRequest request = new RoomInterface.SearchRoomFeaturesRequest();
        request.setFilter(new EventInterface.RoomFilterRpcRequest());
        Enumeration<String> e = helper.getParameterNames();
        while (e.hasMoreElements()) {
            String command = e.nextElement();
            if (command.equals("r:text")) {
                request.getFilter().setText(helper.getParameter("r:text"));
                continue;
            }
            if (!command.startsWith("r:")) continue;
            for (String value : helper.getParameterValues(command)) {
                request.getFilter().addOption(command.substring(2), value);
            }
        }
        request.getFilter().setSessionId(sessionId);
        EventAction.EventContext context = new EventAction.EventContext(helper.getSessionContext(), helper.getSessionContext().getUser(), sessionId);
        if (context.isAuthenticated() && context.getUser().getExternalUserId() != null) {
            request.getFilter().setOption("user", context.getUser().getExternalUserId());
        }
        GwtRpcResponseList<RoomInterface.FeatureInterface> features = new RoomFeaturesBackend().execute(request, (SessionContext)context);
        int dm = 0;
        if (helper.getParameter("dm") != null) {
            dm = Integer.parseInt(helper.getParameter("dm"));
        }
        if (helper.getParameter("sort") != null) {
            RoomFeaturesComparator cmp = null;
            try {
                int sort = Integer.parseInt(helper.getParameter("sort"));
                if (sort > 0) {
                    cmp = new RoomFeaturesComparator(RoomInterface.RoomFeaturesColumn.values()[sort - 1], true);
                } else if (sort < 0) {
                    cmp = new RoomFeaturesComparator(RoomInterface.RoomFeaturesColumn.values()[-1 - sort], false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cmp != null) {
                Collections.sort(features, cmp);
            }
        }
        this.print(helper, features, dm, request.getFilter().getOption("department"));
    }

    protected void print(ExportHelper helper, List<RoomInterface.FeatureInterface> features, int dm, String department) throws IOException {
        CSVPrinter out = new CSVPrinter(helper, false);
        helper.setup(out.getContentType(), this.reference(), false);
        this.print(out, features, dm, department);
        out.flush();
        out.close();
    }

    protected void printHeader(Exporter.Printer out) throws IOException {
        out.printHeader(MESSAGES.colName(), MESSAGES.colAbbreviation(), MESSAGES.colType(), MESSAGES.colDepartment(), MESSAGES.colDescription(), MESSAGES.colRooms());
    }

    protected void print(Exporter.Printer out, List<RoomInterface.FeatureInterface> features, int dm, String department) throws IOException {
        this.printHeader(out);
        for (RoomInterface.FeatureInterface feature : features) {
            if (feature.isDepartmental()) continue;
            this.printLine(out, feature, dm);
        }
        for (RoomInterface.FeatureInterface feature : features) {
            if (!feature.isDepartmental() || department != null && !department.equals(feature.getDepartment().getDeptCode()) || department == null && !feature.hasRooms()) continue;
            this.printLine(out, feature, dm);
        }
    }

    protected void printLine(Exporter.Printer out, RoomInterface.FeatureInterface feature, int dm) throws IOException {
        String[] line = new String[5 + (feature.hasRooms() ? feature.getRooms().size() : 0)];
        int idx = 0;
        line[idx++] = feature.getLabel();
        line[idx++] = feature.getAbbreviation();
        line[idx++] = feature.getType() == null ? "" : feature.getType().getAbbreviation();
        line[idx++] = feature.isDepartmental() ? this.dept2string(feature.getDepartment(), dm) : "";
        line[idx++] = feature.getDescription();
        if (feature.hasRooms()) {
            for (EventInterface.FilterRpcResponse.Entity room : feature.getRooms()) {
                line[idx++] = this.name(room);
            }
        }
        out.printLine(line);
    }

    protected String dept2string(RoomInterface.DepartmentInterface d, int dm) {
        if (d == null) {
            return "";
        }
        switch (dm) {
            case 0: {
                return d.getDeptCode();
            }
            case 1: {
                return d.getExtAbbreviationWhenExist();
            }
            case 2: {
                return d.getExtLabelWhenExist();
            }
            case 3: {
                return d.getExtAbbreviationWhenExist() + " - " + d.getExtLabelWhenExist();
            }
            case 4: {
                return d.getDeptCode() + " - " + d.getExtLabelWhenExist();
            }
        }
        return d.getDeptCode();
    }

    protected String name(EventInterface.FilterRpcResponse.Entity room) {
        return room.getAbbreviation() != null && !room.getAbbreviation().isEmpty() ? MESSAGES.label(room.getName(), room.getAbbreviation()) : room.getName();
    }
}

