/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.fileupload2.core.FileItem;
import org.hibernate.Transaction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.events.EventDetailBackend;
import org.unitime.timetable.events.EventEmail;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseEvent;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.RelatedCourseInfo;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SpecialEvent;
import org.unitime.timetable.model.SponsoringOrganization;
import org.unitime.timetable.model.UnavailableEvent;
import org.unitime.timetable.model.base.BaseLocation;
import org.unitime.timetable.model.base.BaseMeeting;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.EventServiceProviderDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SponsoringOrganizationDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.CalendarUtils;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

@GwtRpcImplements(value=EventInterface.SaveEventRpcRequest.class)
public class SaveEventBackend
extends EventAction<EventInterface.SaveEventRpcRequest, EventInterface.SaveOrApproveEventRpcResponse> {
    @Override
    public EventInterface.SaveOrApproveEventRpcResponse execute(EventInterface.SaveEventRpcRequest request, EventAction.EventContext context) {
        block132: {
            block131: {
                if (request.getEvent().hasContact() && (request.getEvent().getContact().getExternalId() == null || !request.getEvent().getContact().getExternalId().equals(context.getUser().getExternalUserId()))) {
                    switch (request.getEvent().getType()) {
                        case Special: 
                        case Course: 
                        case Unavailabile: {
                            context.checkPermission(Right.EventLookupContact);
                        }
                    }
                }
                if (request.getEvent().getId() != null) break block131;
                switch (request.getEvent().getType()) {
                    case Special: {
                        context.checkPermission(Right.EventAddSpecial);
                        break block132;
                    }
                    case Course: {
                        context.checkPermission(Right.EventAddCourseRelated);
                        break block132;
                    }
                    case Unavailabile: {
                        context.checkPermission(Right.EventAddUnavailable);
                        break block132;
                    }
                    default: {
                        throw context.getException();
                    }
                }
            }
            context.checkPermission(request.getEvent().getId(), "Event", Right.EventEdit);
        }
        if (request.getEvent().hasContact() && request.getEvent().getContact().hasEmail()) {
            try {
                new InternetAddress(request.getEvent().getContact().getEmail(), true);
            }
            catch (AddressException e) {
                throw new GwtRpcException(MESSAGES.badEmailAddress(request.getEvent().getContact().getEmail(), e.getMessage()));
            }
        }
        if (request.getEvent().hasEmail()) {
            String suffix = ApplicationProperty.EmailDefaultAddressSuffix.value();
            for (String address : request.getEvent().getEmail().split("[\n,]")) {
                Object email = address.trim();
                if (((String)email).isEmpty()) continue;
                if (suffix != null && ((String)email).indexOf(64) < 0) {
                    email = (String)email + suffix;
                }
                try {
                    new InternetAddress((String)email, true);
                }
                catch (AddressException e) {
                    throw new GwtRpcException(MESSAGES.badEmailAddress(address, e.getMessage()));
                }
            }
        }
        org.hibernate.Session hibSession = SessionDAO.getInstance().getSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            EventInterface.NoteInterface n;
            Object location;
            Object meeting;
            Session session = (Session)SessionDAO.getInstance().get(request.getSessionId(), hibSession);
            Date now = new Date();
            Event event = null;
            if (request.getEvent().getId() != null) {
                event = (Event)EventDAO.getInstance().get(request.getEvent().getId(), hibSession);
            } else {
                switch (request.getEvent().getType()) {
                    case Special: {
                        event = new SpecialEvent();
                        break;
                    }
                    case Course: {
                        event = new CourseEvent();
                        break;
                    }
                    case Unavailabile: {
                        event = new UnavailableEvent();
                        break;
                    }
                    default: {
                        throw new GwtRpcException(MESSAGES.failedSaveEventWrongType(request.getEvent().getType().getName(CONSTANTS)));
                    }
                }
            }
            EventInterface.SaveOrApproveEventRpcResponse response = new EventInterface.SaveOrApproveEventRpcResponse();
            event.setEventName(request.getEvent().getName());
            if (event.getEventName() == null || event.getEventName().isEmpty() && request.getEvent().getType() == EventInterface.EventType.Unavailabile) {
                event.setEventName(MESSAGES.unavailableEventDefaultName());
            }
            event.setEmail(request.getEvent().getEmail());
            if (context.hasPermission(Right.EventSetExpiration) || event.getExpirationDate() != null) {
                event.setExpirationDate(request.getEvent().getExpirationDate());
            }
            event.setSponsoringOrganization(request.getEvent().hasSponsor() ? (SponsoringOrganization)SponsoringOrganizationDAO.getInstance().get(request.getEvent().getSponsor().getUniqueId()) : null);
            if (!(event instanceof UnavailableEvent) && event instanceof SpecialEvent) {
                event.setMinCapacity(request.getEvent().getMaxCapacity());
                event.setMaxCapacity(request.getEvent().getMaxCapacity());
            }
            if (event.getAdditionalContacts() == null) {
                event.setAdditionalContacts(new HashSet<EventContact>());
            }
            if (context.hasPermission(Right.EventLookupContact)) {
                HashSet<EventContact> existingContacts = new HashSet<EventContact>(event.getAdditionalContacts());
                event.getAdditionalContacts().clear();
                if (request.getEvent().hasAdditionalContacts()) {
                    for (EventInterface.ContactInterface c : request.getEvent().getAdditionalContacts()) {
                        if (c.getExternalId() == null) continue;
                        EventContact contact = null;
                        for (EventContact x : existingContacts) {
                            if (!c.getExternalId().equals(x.getExternalUniqueId())) continue;
                            contact = x;
                            break;
                        }
                        if (contact == null) {
                            contact = (EventContact)hibSession.createQuery("from EventContact where externalUniqueId = :externalId", EventContact.class).setParameter("externalId", (Object)c.getExternalId()).setMaxResults(1).uniqueResult();
                        }
                        if (contact == null) {
                            contact = new EventContact();
                            contact.setExternalUniqueId(c.getExternalId());
                            contact.setFirstName(c.getFirstName());
                            contact.setMiddleName(c.getMiddleName());
                            contact.setLastName(c.getLastName());
                            contact.setAcademicTitle(c.getAcademicTitle());
                            contact.setEmailAddress(c.getEmail());
                            contact.setPhone(c.getPhone());
                            hibSession.persist((Object)contact);
                        }
                        event.getAdditionalContacts().add(contact);
                    }
                }
            }
            if (event.getRequestedServices() == null) {
                event.setRequestedServices(new HashSet<EventServiceProvider>());
            }
            HashSet<EventServiceProvider> services = new HashSet<EventServiceProvider>(event.getRequestedServices());
            if (request.getEvent().hasRequestedServices()) {
                block38: for (EventInterface.EventServiceProviderInterface provider : request.getEvent().getRequestedServices()) {
                    if (provider.getId() == null) continue;
                    Iterator i = services.iterator();
                    while (i.hasNext()) {
                        EventServiceProvider p = (EventServiceProvider)i.next();
                        if (!p.getUniqueId().equals(provider.getId())) continue;
                        i.remove();
                        continue block38;
                    }
                    EventServiceProvider p = (EventServiceProvider)EventServiceProviderDAO.getInstance().get(provider.getId(), hibSession);
                    if (p == null) continue;
                    event.getRequestedServices().add(p);
                    response.addService(provider);
                }
            }
            for (EventServiceProvider p : services) {
                EventInterface.EventServiceProviderInterface provider = new EventInterface.EventServiceProviderInterface();
                provider.setId(p.getUniqueId());
                provider.setReference(p.getReference());
                provider.setLabel(p.getLabel());
                provider.setMessage(p.getNote());
                provider.setEmail(p.getEmail());
                response.removeService(provider);
                event.getRequestedServices().remove(p);
            }
            EventContact main = event.getMainContact();
            if (!(main != null && main.getExternalUniqueId() != null && main.getExternalUniqueId().equals(request.getEvent().getContact().getExternalId()) || (main = (EventContact)hibSession.createQuery("from EventContact where externalUniqueId = :externalId", EventContact.class).setParameter("externalId", (Object)request.getEvent().getContact().getExternalId()).setMaxResults(1).uniqueResult()) != null)) {
                main = new EventContact();
                main.setExternalUniqueId(request.getEvent().getContact().getExternalId());
            }
            main.setFirstName(request.getEvent().getContact().getFirstName());
            main.setMiddleName(request.getEvent().getContact().getMiddleName());
            main.setLastName(request.getEvent().getContact().getLastName());
            main.setAcademicTitle(request.getEvent().getContact().getAcademicTitle());
            main.setEmailAddress(request.getEvent().getContact().getEmail());
            main.setPhone(request.getEvent().getContact().getPhone());
            if (main.getUniqueId() == null) {
                hibSession.persist((Object)main);
            } else {
                hibSession.merge((Object)main);
            }
            event.setMainContact(main);
            if (event.getNotes() == null) {
                event.setNotes(new HashSet<EventNote>());
            }
            if (event.getMeetings() == null) {
                event.setMeetings(new HashSet<Meeting>());
            }
            HashSet<Meeting> remove = new HashSet<Meeting>(event.getMeetings());
            TreeSet<Meeting> createdMeetings = new TreeSet<Meeting>();
            TreeSet<Meeting> cancelledMeetings = new TreeSet<Meeting>();
            TreeSet<Meeting> updatedMeetings = new TreeSet<Meeting>();
            TreeSet<Meeting> approvedMeetings = new TreeSet<Meeting>();
            boolean updateMeetingContacts = context.hasPermission(Right.EventCanEditMeetingContacts);
            for (EventInterface.MeetingInterface meetingInterface : request.getEvent().getMeetings()) {
                meeting = null;
                if (meetingInterface.getApprovalStatus() == EventInterface.ApprovalStatus.Deleted) {
                    if (context.hasPermission(meeting, Right.EventMeetingDelete) || !context.hasPermission(meeting, Right.EventMeetingCancel)) continue;
                    meetingInterface.setApprovalStatus(EventInterface.ApprovalStatus.Cancelled);
                }
                if (meetingInterface.getId() != null) {
                    Iterator i = remove.iterator();
                    while (i.hasNext()) {
                        Meeting x = (Meeting)i.next();
                        if (!meetingInterface.getId().equals(x.getUniqueId())) continue;
                        meeting = x;
                        i.remove();
                        break;
                    }
                }
                if (meeting != null) {
                    if (meetingInterface.getApprovalStatus().ordinal() != ((BaseMeeting)meeting).getApprovalStatus().intValue()) {
                        switch (meetingInterface.getApprovalStatus()) {
                            case Cancelled: {
                                switch (((BaseMeeting)meeting).getEvent().getEventType()) {
                                    case 1: 
                                    case 2: {
                                        if (context.hasPermission(meeting, Right.EventMeetingCancelExam)) break;
                                        throw new GwtRpcException(MESSAGES.failedApproveEventNoRightsToCancel(SaveEventBackend.toString((Meeting)meeting)));
                                    }
                                    case 0: {
                                        if (context.hasPermission(meeting, Right.EventMeetingCancelClass)) break;
                                        throw new GwtRpcException(MESSAGES.failedApproveEventNoRightsToCancel(SaveEventBackend.toString((Meeting)meeting)));
                                    }
                                    default: {
                                        if (context.hasPermission(meeting, Right.EventMeetingCancel)) break;
                                        throw new GwtRpcException(MESSAGES.failedApproveEventNoRightsToCancel(SaveEventBackend.toString((Meeting)meeting)));
                                    }
                                }
                                ((Meeting)meeting).setStatus(Meeting.Status.CANCELLED);
                                ((BaseMeeting)meeting).setApprovalDate(now);
                                hibSession.merge(meeting);
                                cancelledMeetings.add((Meeting)meeting);
                                response.addCancelledMeeting(meetingInterface);
                            }
                        }
                    } else if (meetingInterface.getStartOffset() != (((BaseMeeting)meeting).getStartOffset() == null ? 0 : ((BaseMeeting)meeting).getStartOffset()) || meetingInterface.getEndOffset() != (((BaseMeeting)meeting).getStopOffset() == null ? 0 : ((BaseMeeting)meeting).getStopOffset())) {
                        if (!context.hasPermission(meeting, Right.EventMeetingEdit)) {
                            throw new GwtRpcException(MESSAGES.failedSaveEventCanNotEditMeeting(SaveEventBackend.toString((Meeting)meeting)));
                        }
                        ((BaseMeeting)meeting).setStartOffset(meetingInterface.getStartOffset());
                        ((BaseMeeting)meeting).setStopOffset(meetingInterface.getEndOffset());
                        hibSession.merge(meeting);
                        response.addUpdatedMeeting(meetingInterface);
                        updatedMeetings.add((Meeting)meeting);
                    }
                } else {
                    List<EventInterface.MeetingConflictInterface> conflicts;
                    response.addCreatedMeeting(meetingInterface);
                    meeting = new Meeting();
                    ((BaseMeeting)meeting).setEvent(event);
                    location = null;
                    if (meetingInterface.hasLocation()) {
                        if (meetingInterface.getLocation().getId() != null) {
                            location = (Location)LocationDAO.getInstance().get(meetingInterface.getLocation().getId(), hibSession);
                        } else if (meetingInterface.getLocation().getName() != null) {
                            location = Location.findByName(hibSession, request.getSessionId(), meetingInterface.getLocation().getName());
                        }
                    }
                    if (location == null) {
                        throw new GwtRpcException(MESSAGES.failedSaveEventNoLocation(SaveEventBackend.toString(meetingInterface)));
                    }
                    ((BaseMeeting)meeting).setLocationPermanentId(((BaseLocation)location).getPermanentId());
                    ((Meeting)meeting).setStatus(Meeting.Status.PENDING);
                    ((BaseMeeting)meeting).setApprovalDate(null);
                    if (!context.hasPermission(location, Right.EventLocation)) {
                        throw new GwtRpcException(MESSAGES.failedSaveEventWrongLocation(meetingInterface.getLocationName()));
                    }
                    if (request.getEvent().getType() == EventInterface.EventType.Unavailabile && !context.hasPermission(location, Right.EventLocationUnavailable)) {
                        throw new GwtRpcException(MESSAGES.failedSaveCannotMakeUnavailable(meetingInterface.getLocationName()));
                    }
                    if (meetingInterface.getApprovalStatus() == EventInterface.ApprovalStatus.Approved && context.hasPermission(location, Right.EventLocationApprove)) {
                        ((Meeting)meeting).setStatus(Meeting.Status.APPROVED);
                        ((BaseMeeting)meeting).setApprovalDate(now);
                    }
                    if (((Location)location).getEffectiveEventStatus().isAutomaticApproval()) {
                        ((Meeting)meeting).setStatus(Meeting.Status.APPROVED);
                        ((BaseMeeting)meeting).setApprovalDate(now);
                    }
                    if (context.isPastOrOutside(meetingInterface.getMeetingDate())) {
                        throw new GwtRpcException(MESSAGES.failedSaveEventPastOrOutside(SaveEventBackend.getDateFormat().format(meetingInterface.getMeetingDate())));
                    }
                    if (!context.hasPermission(location, Right.EventLocationOverbook) && !(conflicts = this.computeConflicts(hibSession, meetingInterface, event.getUniqueId())).isEmpty()) {
                        throw new GwtRpcException(MESSAGES.failedSaveEventConflict(SaveEventBackend.toString(meetingInterface), SaveEventBackend.toString(conflicts.get(0))));
                    }
                    meetingInterface.setApprovalDate(((BaseMeeting)meeting).getApprovalDate());
                    meetingInterface.setApprovalStatus(((BaseMeeting)meeting).getApprovalStatus());
                    ((BaseMeeting)meeting).setStartPeriod(meetingInterface.getStartSlot());
                    ((BaseMeeting)meeting).setStopPeriod(meetingInterface.getEndSlot());
                    ((BaseMeeting)meeting).setStartOffset(meetingInterface.getStartOffset());
                    ((BaseMeeting)meeting).setStopOffset(meetingInterface.getEndOffset());
                    ((BaseMeeting)meeting).setClassCanOverride(true);
                    ((BaseMeeting)meeting).setMeetingDate(meetingInterface.getMeetingDate());
                    event.getMeetings().add((Meeting)meeting);
                    createdMeetings.add((Meeting)meeting);
                    if (((Meeting)meeting).getStatus() == Meeting.Status.APPROVED) {
                        response.addApprovedMeeting(meetingInterface);
                        approvedMeetings.add((Meeting)meeting);
                    }
                }
                if (((BaseMeeting)meeting).getApprovalDate() == null) {
                    switch (request.getEvent().getType()) {
                        case Unavailabile: 
                        case Class: 
                        case FinalExam: 
                        case MidtermExam: {
                            ((Meeting)meeting).setStatus(Meeting.Status.APPROVED);
                            ((BaseMeeting)meeting).setApprovalDate(now);
                        }
                    }
                }
                if (!updateMeetingContacts) continue;
                if (((BaseMeeting)meeting).getMeetingContacts() == null) {
                    ((BaseMeeting)meeting).setMeetingContacts(new HashSet<EventContact>());
                }
                HashSet<EventContact> existingContacts = new HashSet<EventContact>(((BaseMeeting)meeting).getMeetingContacts());
                boolean contactsChanged = false;
                if (meetingInterface.hasMeetingContacts()) {
                    block43: for (EventInterface.ContactInterface c : meetingInterface.getMeetingContacts()) {
                        if (c.getExternalId() == null) continue;
                        Iterator i = existingContacts.iterator();
                        while (i.hasNext()) {
                            EventContact x = (EventContact)i.next();
                            if (!c.getExternalId().equals(x.getExternalUniqueId())) continue;
                            i.remove();
                            continue block43;
                        }
                        EventContact contact = (EventContact)hibSession.createQuery("from EventContact where externalUniqueId = :externalId", EventContact.class).setParameter("externalId", (Object)c.getExternalId()).setMaxResults(1).uniqueResult();
                        if (contact == null) {
                            contact = new EventContact();
                            contact.setExternalUniqueId(c.getExternalId());
                            contact.setFirstName(c.getFirstName());
                            contact.setMiddleName(c.getMiddleName());
                            contact.setLastName(c.getLastName());
                            contact.setAcademicTitle(c.getAcademicTitle());
                            contact.setEmailAddress(c.getEmail());
                            contact.setPhone(c.getPhone());
                            hibSession.persist((Object)contact);
                        }
                        ((BaseMeeting)meeting).getMeetingContacts().add(contact);
                        contactsChanged = true;
                    }
                    if (!existingContacts.isEmpty()) {
                        ((BaseMeeting)meeting).getMeetingContacts().removeAll(existingContacts);
                        contactsChanged = true;
                    }
                } else if (!((BaseMeeting)meeting).getMeetingContacts().isEmpty()) {
                    ((BaseMeeting)meeting).getMeetingContacts().clear();
                    contactsChanged = true;
                }
                if (!contactsChanged) continue;
                response.addUpdatedMeeting(meetingInterface);
                updatedMeetings.add((Meeting)meeting);
            }
            if (!remove.isEmpty()) {
                Iterator i = remove.iterator();
                while (i.hasNext()) {
                    Meeting meeting2 = (Meeting)i.next();
                    if (!context.hasPermission(meeting2, Right.EventMeetingDelete)) {
                        if (meeting2.getStatus() == Meeting.Status.CANCELLED || meeting2.getStatus() == Meeting.Status.REJECTED) {
                            i.remove();
                            continue;
                        }
                        throw new GwtRpcException(MESSAGES.failedSaveEventCanNotDeleteMeeting(SaveEventBackend.toString(meeting2)));
                    }
                    meeting = new EventInterface.MeetingInterface();
                    ((EventInterface.MeetingInterface)meeting).setId(meeting2.getUniqueId());
                    ((EventInterface.MeetingInterface)meeting).setMeetingDate(meeting2.getMeetingDate());
                    ((EventInterface.MeetingInterface)meeting).setDayOfWeek(Constants.getDayOfWeek(meeting2.getMeetingDate()));
                    ((EventInterface.MeetingInterface)meeting).setStartTime(meeting2.getStartTime().getTime());
                    ((EventInterface.MeetingInterface)meeting).setStopTime(meeting2.getStopTime().getTime());
                    ((EventInterface.MeetingInterface)meeting).setDayOfYear(CalendarUtils.date2dayOfYear(session.getSessionStartYear(), meeting2.getMeetingDate()));
                    ((EventInterface.MeetingInterface)meeting).setStartSlot(meeting2.getStartPeriod());
                    ((EventInterface.MeetingInterface)meeting).setEndSlot(meeting2.getStopPeriod());
                    ((EventInterface.MeetingInterface)meeting).setStartOffset(meeting2.getStartOffset() == null ? 0 : meeting2.getStartOffset());
                    ((EventInterface.MeetingInterface)meeting).setEndOffset(meeting2.getStopOffset() == null ? 0 : meeting2.getStopOffset());
                    ((EventInterface.MeetingInterface)meeting).setPast(context.isPastOrOutside(meeting2.getStartTime()));
                    ((EventInterface.MeetingInterface)meeting).setApprovalDate(meeting2.getApprovalDate());
                    ((EventInterface.MeetingInterface)meeting).setApprovalStatus(meeting2.getApprovalStatus());
                    if (meeting2.getLocation() != null) {
                        location = new EventInterface.ResourceInterface();
                        ((EventInterface.ResourceInterface)location).setType(EventInterface.ResourceType.ROOM);
                        ((EventInterface.ResourceInterface)location).setId(meeting2.getLocation().getUniqueId());
                        ((EventInterface.ResourceInterface)location).setName(meeting2.getLocation().getLabel());
                        ((EventInterface.ResourceInterface)location).setSize(meeting2.getLocation().getCapacity());
                        ((EventInterface.ResourceInterface)location).setRoomType(meeting2.getLocation().getRoomTypeLabel());
                        ((EventInterface.ResourceInterface)location).setBreakTime(meeting2.getLocation().getEffectiveBreakTime());
                        ((EventInterface.ResourceInterface)location).setMessage(meeting2.getLocation().getEventMessage());
                        ((EventInterface.ResourceInterface)location).setIgnoreRoomCheck(meeting2.getLocation().isIgnoreRoomCheck());
                        ((EventInterface.ResourceInterface)location).setDisplayName(meeting2.getLocation().getDisplayName());
                        ((EventInterface.ResourceInterface)location).setPartitionParentId(meeting2.getLocation().getPartitionParentId());
                        ((EventInterface.ResourceInterface)location).setEventEmail(meeting2.getLocation().getEventEmail());
                        ((EventInterface.MeetingInterface)meeting).setLocation((EventInterface.ResourceInterface)location);
                    }
                    response.addDeletedMeeting((EventInterface.MeetingInterface)meeting);
                }
                event.getMeetings().removeAll(remove);
            }
            EventInterface.DateFormatter df = new EventInterface.DateFormatter(){
                Formats.Format<Date> dfShort = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
                Formats.Format<Date> dfLong = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_LONG);

                @Override
                public String formatFirstDate(Date date) {
                    return this.dfShort.format(date);
                }

                @Override
                public String formatLastDate(Date date) {
                    return this.dfLong.format(date);
                }
            };
            FileItem fileItem = (FileItem)context.getAttribute(SessionAttribute.LastUploadedFile);
            boolean attached = false;
            int firstDayOfWeek = ApplicationProperty.EventGridStartDay.intValue();
            if (response.hasCreatedMeetings()) {
                EventNote note = new EventNote();
                note.setEvent(event);
                note.setNoteType(event.getUniqueId() == null ? 0 : 1);
                note.setTimeStamp(now);
                note.setUser(context.getUser().getTrueName());
                note.setUserId(context.getUser().getTrueExternalUserId());
                if (request.hasMessage()) {
                    note.setTextNote(request.getMessage());
                }
                if (note.getTextNote() != null && note.getTextNote().length() > 2000) {
                    note.setTextNote(note.getTextNote().substring(0, 2000));
                }
                note.setMeetings(EventInterface.toString(firstDayOfWeek, response.getCreatedMeetings(), CONSTANTS, "\n", df));
                note.setAffectedMeetings(createdMeetings);
                event.getNotes().add(note);
                n = new EventInterface.NoteInterface();
                n.setDate(now);
                n.setMeetings(note.getMeetings());
                n.setUser(context.getUser().getTrueName());
                n.setType(EventInterface.NoteInterface.NoteType.values()[note.getNoteType()]);
                n.setNote(note.getTextNote());
                if (fileItem != null) {
                    note.setAttachedName(fileItem.getName());
                    note.setAttachedFile(fileItem.get());
                    note.setAttachedContentType(fileItem.getContentType());
                    attached = true;
                    n.setAttachment(fileItem.getName());
                }
                response.addNote(n);
            }
            if (response.hasUpdatedMeetings() || !response.hasCreatedMeetings() && !response.hasDeletedMeetings() && !response.hasCancelledMeetings()) {
                EventNote note = new EventNote();
                note.setEvent(event);
                note.setNoteType(5);
                note.setTimeStamp(now);
                note.setUser(context.getUser().getTrueName());
                note.setUserId(context.getUser().getTrueExternalUserId());
                note.setAffectedMeetings(updatedMeetings);
                if (request.hasMessage()) {
                    note.setTextNote(request.getMessage());
                }
                if (note.getTextNote() != null && note.getTextNote().length() > 2000) {
                    note.setTextNote(note.getTextNote().substring(0, 2000));
                }
                if (response.hasUpdatedMeetings()) {
                    note.setMeetings(EventInterface.toString(firstDayOfWeek, response.getUpdatedMeetings(), CONSTANTS, "\n", df));
                }
                event.getNotes().add(note);
                n = new EventInterface.NoteInterface();
                n.setDate(now);
                n.setMeetings(note.getMeetings());
                n.setUser(context.getUser().getTrueName());
                n.setType(EventInterface.NoteInterface.NoteType.values()[note.getNoteType()]);
                n.setNote(note.getTextNote());
                if (fileItem != null && !attached) {
                    note.setAttachedName(fileItem.getName());
                    note.setAttachedFile(fileItem.get());
                    note.setAttachedContentType(fileItem.getContentType());
                    attached = true;
                    n.setAttachment(fileItem.getName());
                }
                response.addNote(n);
            }
            if (response.hasDeletedMeetings()) {
                EventNote note = new EventNote();
                note.setEvent(event);
                note.setNoteType(4);
                note.setTimeStamp(now);
                note.setUser(context.getUser().getTrueName());
                note.setUserId(context.getUser().getTrueExternalUserId());
                if (request.hasMessage()) {
                    note.setTextNote(request.getMessage());
                }
                if (note.getTextNote() != null && note.getTextNote().length() > 2000) {
                    note.setTextNote(note.getTextNote().substring(0, 2000));
                }
                note.setMeetings(EventInterface.toString(firstDayOfWeek, response.getDeletedMeetings(), CONSTANTS, "\n", df));
                event.getNotes().add(note);
                n = new EventInterface.NoteInterface();
                n.setDate(now);
                n.setMeetings(note.getMeetings());
                n.setUser(context.getUser().getTrueName());
                n.setType(EventInterface.NoteInterface.NoteType.values()[note.getNoteType()]);
                n.setNote(note.getTextNote());
                if (fileItem != null && !attached) {
                    note.setAttachedName(fileItem.getName());
                    note.setAttachedFile(fileItem.get());
                    note.setAttachedContentType(fileItem.getContentType());
                    attached = true;
                    n.setAttachment(fileItem.getName());
                }
                response.addNote(n);
            }
            if (response.hasCancelledMeetings()) {
                EventNote note = new EventNote();
                note.setEvent(event);
                note.setNoteType(7);
                note.setTimeStamp(now);
                note.setUser(context.getUser().getTrueName());
                note.setUserId(context.getUser().getTrueExternalUserId());
                note.setAffectedMeetings(cancelledMeetings);
                if (request.hasMessage()) {
                    note.setTextNote(request.getMessage());
                }
                if (note.getTextNote() != null && note.getTextNote().length() > 2000) {
                    note.setTextNote(note.getTextNote().substring(0, 2000));
                }
                note.setMeetings(EventInterface.toString(firstDayOfWeek, response.getCancelledMeetings(), CONSTANTS, "\n", df));
                event.getNotes().add(note);
                n = new EventInterface.NoteInterface();
                n.setDate(now);
                n.setMeetings(note.getMeetings());
                n.setUser(context.getUser().getTrueName());
                n.setType(EventInterface.NoteInterface.NoteType.values()[note.getNoteType()]);
                n.setNote(note.getTextNote());
                if (fileItem != null && !attached) {
                    note.setAttachedName(fileItem.getName());
                    note.setAttachedFile(fileItem.get());
                    note.setAttachedContentType(fileItem.getContentType());
                    attached = true;
                    n.setAttachment(fileItem.getName());
                }
                response.addNote(n);
            }
            if (response.hasApprovedMeetings()) {
                EventNote note = new EventNote();
                note.setEvent(event);
                note.setNoteType(2);
                note.setTimeStamp(now);
                note.setUser(context.getUser().getTrueName());
                note.setUserId(context.getUser().getTrueExternalUserId());
                note.setAffectedMeetings(approvedMeetings);
                if (request.hasMessage()) {
                    note.setTextNote(request.getMessage());
                }
                if (note.getTextNote() != null && note.getTextNote().length() > 2000) {
                    note.setTextNote(note.getTextNote().substring(0, 2000));
                }
                note.setMeetings(EventInterface.toString(firstDayOfWeek, response.getApprovedMeetings(), CONSTANTS, "\n", df));
                event.getNotes().add(note);
                n = new EventInterface.NoteInterface();
                n.setDate(now);
                n.setMeetings(note.getMeetings());
                n.setUser(context.getUser().getTrueName());
                n.setType(EventInterface.NoteInterface.NoteType.values()[note.getNoteType()]);
                n.setNote(note.getTextNote());
                if (fileItem != null && !attached) {
                    note.setAttachedName(fileItem.getName());
                    note.setAttachedFile(fileItem.get());
                    note.setAttachedContentType(fileItem.getContentType());
                    attached = true;
                    n.setAttachment(fileItem.getName());
                }
                response.addNote(n);
            }
            if (request.getEvent().getType() == EventInterface.EventType.Course) {
                CourseEvent ce = (CourseEvent)event;
                ce.setReqAttendance(request.getEvent().hasRequiredAttendance());
                if (ce.getRelatedCourses() == null) {
                    ce.setRelatedCourses(new HashSet<RelatedCourseInfo>());
                } else {
                    ce.getRelatedCourses().clear();
                }
                if (request.getEvent().hasRelatedObjects()) {
                    for (EventInterface.RelatedObjectInterface r : request.getEvent().getRelatedObjects()) {
                        RelatedCourseInfo related = new RelatedCourseInfo();
                        related.setEvent(ce);
                        if (r.getSelection() != null) {
                            related.setOwnerId(r.getUniqueId());
                            related.setOwnerType(r.getType().ordinal());
                            related.setCourse((CourseOffering)CourseOfferingDAO.getInstance().get(r.getSelection()[1], hibSession));
                        } else {
                            switch (r.getType()) {
                                case Course: {
                                    related.setOwner((CourseOffering)CourseOfferingDAO.getInstance().get(r.getUniqueId()));
                                    break;
                                }
                                case Class: {
                                    related.setOwner((Class_)Class_DAO.getInstance().get(r.getUniqueId()));
                                    break;
                                }
                                case Config: {
                                    related.setOwner((InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(r.getUniqueId()));
                                    break;
                                }
                                case Offering: {
                                    related.setOwner((InstructionalOffering)InstructionalOfferingDAO.getInstance().get(r.getUniqueId()));
                                }
                            }
                        }
                        ce.getRelatedCourses().add(related);
                    }
                }
            }
            if (event.getUniqueId() == null) {
                hibSession.persist((Object)event);
                response.setEvent(EventDetailBackend.getEventDetail((Session)SessionDAO.getInstance().get(request.getSessionId(), hibSession), event, context));
            } else if (event.getMeetings().isEmpty()) {
                response.setEvent(EventDetailBackend.getEventDetail((Session)SessionDAO.getInstance().get(request.getSessionId(), hibSession), event, context));
                response.getEvent().setId(null);
                hibSession.remove((Object)event);
            } else {
                hibSession.merge((Object)event);
                response.setEvent(EventDetailBackend.getEventDetail((Session)SessionDAO.getInstance().get(request.getSessionId(), hibSession), event, context));
            }
            tx.commit();
            new EventEmail(request, response).send(context);
            return response;
        }
        catch (Exception ex) {
            tx.rollback();
            if (ex instanceof GwtRpcException) {
                throw (GwtRpcException)ex;
            }
            throw new GwtRpcException(ex.getMessage(), ex);
        }
    }

    private List<EventInterface.MeetingConflictInterface> computeConflicts(org.hibernate.Session hibSession, EventInterface.MeetingInterface meeting, Long eventId) {
        ArrayList<EventInterface.MeetingConflictInterface> conflicts = new ArrayList<EventInterface.MeetingConflictInterface>();
        for (Meeting m : hibSession.createQuery("select m from Meeting m, Location l where m.startPeriod < :stopTime and m.stopPeriod > :startTime and l.ignoreRoomCheck = false and m.locationPermanentId = l.permanentId and l.uniqueId = :locationdId and m.meetingDate = :meetingDate and m.uniqueId != :meetingId and m.event.uniqueId != :eventId and m.approvalStatus <= 1", Meeting.class).setParameter("startTime", (Object)meeting.getStartSlot()).setParameter("stopTime", (Object)meeting.getEndSlot()).setParameter("meetingDate", (Object)meeting.getMeetingDate()).setParameter("locationdId", (Object)meeting.getLocation().getId()).setParameter("meetingId", (Object)(meeting.getId() == null ? -1L : meeting.getId())).setParameter("eventId", (Object)(eventId == null ? -1L : eventId)).list()) {
            EventInterface.MeetingConflictInterface conflict = new EventInterface.MeetingConflictInterface();
            conflict.setEventId(m.getEvent().getUniqueId());
            conflict.setName(m.getEvent().getEventName());
            conflict.setType(EventInterface.EventType.values()[m.getEvent().getEventType()]);
            conflict.setId(m.getUniqueId());
            conflict.setMeetingDate(m.getMeetingDate());
            conflict.setDayOfYear(meeting.getDayOfYear());
            conflict.setStartSlot(m.getStartPeriod());
            conflict.setEndSlot(m.getStopPeriod());
            conflict.setStartOffset(m.getStartOffset() == null ? 0 : m.getStartOffset());
            conflict.setEndOffset(m.getStopOffset() == null ? 0 : m.getStopOffset());
            conflict.setApprovalDate(m.getApprovalDate());
            conflict.setApprovalStatus(m.getApprovalStatus());
            conflicts.add(conflict);
        }
        return conflicts;
    }
}

