/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Connection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.hibernate.engine.spi.SessionImplementor;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.util.RoomAvailabilityService;

public class BlobRoomAvailabilityService
extends RoomAvailabilityService {
    private static Log sLog = LogFactory.getLog(RoomAvailabilityInterface.class);
    private String iRequestSql = ApplicationProperty.BlobRoomAvailabilityRequestSQL.value();
    private String iResponseSql = ApplicationProperty.BlobRoomAvailabilityResponseSQL.value();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendRequest(Document request) throws IOException {
        try {
            StringWriter writer = new StringWriter();
            new XMLWriter((Writer)writer, OutputFormat.createPrettyPrint()).write(request);
            writer.flush();
            writer.close();
            SessionImplementor session = (SessionImplementor)HibernateUtil.getSession();
            Connection connection = session.getJdbcConnectionAccess().obtainConnection();
            try {
                CallableStatement call = connection.prepareCall(this.iRequestSql);
                call.setString(1, writer.getBuffer().toString());
                call.execute();
                call.close();
            }
            finally {
                session.getJdbcConnectionAccess().releaseConnection(connection);
            }
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to send request: " + e.getMessage()), (Throwable)e);
        }
        finally {
            HibernateUtil.closeCurrentThreadSessions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Document receiveResponse() throws IOException, DocumentException {
        try {
            CallableStatement call;
            SessionImplementor session = (SessionImplementor)HibernateUtil.getSession();
            Connection connection = session.getJdbcConnectionAccess().obtainConnection();
            String response = null;
            try {
                call = connection.prepareCall(this.iResponseSql);
                call.registerOutParameter(1, 2005);
                call.execute();
                response = call.getString(1);
                call.close();
            }
            finally {
                session.getJdbcConnectionAccess().releaseConnection(connection);
            }
            if (response == null || response.length() == 0) {
                call = null;
                return call;
            }
            StringReader reader = new StringReader(response);
            Document document = new SAXReader().read((Reader)reader);
            reader.close();
            Document document2 = document;
            return document2;
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to receive response: " + e.getMessage()), (Throwable)e);
            Document document = null;
            return document;
        }
        finally {
            HibernateUtil.closeCurrentThreadSessions();
        }
    }
}

