/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.specreg;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomSpecialRegistrationHolder;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public class SpecialRegistrationSubmit
implements OnlineSectioningAction<SpecialRegistrationInterface.SubmitSpecialRegistrationResponse> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private SpecialRegistrationInterface.SubmitSpecialRegistrationRequest iRequest;

    public SpecialRegistrationSubmit withRequest(SpecialRegistrationInterface.SubmitSpecialRegistrationRequest request) {
        this.iRequest = request;
        return this;
    }

    public SpecialRegistrationInterface.SubmitSpecialRegistrationRequest getRequest() {
        return this.iRequest;
    }

    public Collection<ClassAssignmentInterface.ClassAssignment> getAssignment() {
        return this.iRequest.getClassAssignments();
    }

    public Long getStudentId() {
        return this.iRequest.getStudentId();
    }

    public CourseRequestInterface getCourses() {
        return this.iRequest.getCourses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpecialRegistrationInterface.SubmitSpecialRegistrationResponse execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        HashSet<Long> offeringIds = new HashSet<Long>();
        for (ClassAssignmentInterface.ClassAssignment ca : this.getAssignment()) {
            if (ca == null || ca.isFreeTime() || ca.isDummy() || ca.isTeachingAssignment()) continue;
            XCourse course = server.getCourse(ca.getCourseId());
            if (course == null) {
                throw new SectioningException(MSG.exceptionEnrollNotAvailable(MSG.clazz(ca.getSubject(), ca.getCourseNbr(), ca.getSubpart(), ca.getSection())));
            }
            if (server.isOfferingLocked(course.getOfferingId())) continue;
            offeringIds.add(course.getOfferingId());
        }
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), offeringIds, this.name());
        try {
            SpecialRegistrationInterface.SubmitSpecialRegistrationResponse response;
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            if (this.getRequest().getStudentId() != null) {
                action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getStudentId()));
            }
            OnlineSectioningLog.Enrollment.Builder requested = OnlineSectioningLog.Enrollment.newBuilder();
            requested.setType(OnlineSectioningLog.Enrollment.EnrollmentType.REQUESTED);
            Hashtable<Long, OnlineSectioningLog.CourseRequestOption.Builder> options = new Hashtable<Long, OnlineSectioningLog.CourseRequestOption.Builder>();
            for (ClassAssignmentInterface.ClassAssignment assignment : this.getAssignment()) {
                if (assignment == null) continue;
                OnlineSectioningLog.Section s = OnlineSectioningHelper.toProto(assignment);
                requested.addSection(s);
                if (assignment.isFreeTime() || assignment.isDummy() || assignment.isTeachingAssignment()) continue;
                OnlineSectioningLog.CourseRequestOption.Builder option = (OnlineSectioningLog.CourseRequestOption.Builder)options.get(assignment.getCourseId());
                if (option == null) {
                    option = OnlineSectioningLog.CourseRequestOption.newBuilder().setType(OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT);
                    options.put(assignment.getCourseId(), option);
                }
                option.addSection(s);
            }
            action.addEnrollment(requested);
            if (this.getCourses() != null) {
                for (OnlineSectioningLog.Request r : OnlineSectioningHelper.toProto(this.getCourses())) {
                    action.addRequest(r);
                }
            }
            XStudent student = server.getStudent(this.getStudentId());
            action.getStudentBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName());
            SpecialRegistrationInterface.SubmitSpecialRegistrationResponse submitSpecialRegistrationResponse = response = CustomSpecialRegistrationHolder.getProvider().submitRegistration(server, helper, student, this.getRequest());
            return submitSpecialRegistrationResponse;
        }
        finally {
            lock.release();
        }
    }

    @Override
    public String name() {
        return "specreg-submit";
    }
}

