/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom;

import java.util.Comparator;
import org.cpsolver.ifs.util.DataProperties;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.WaitListComparatorProvider;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequestComparator;

public class DefaultSectioningRequestComparatorProvider
implements WaitListComparatorProvider {
    @Override
    public Comparator<SectioningRequest> getComparator(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        return new DefaultSectioningRequestComparator(server.getConfig());
    }

    public class DefaultSectioningRequestComparator
    extends SectioningRequestComparator {
        private boolean iConsiderRequestPriority = true;
        private boolean iConsiderStudentPriority = true;
        private boolean iStudentPriorityIsMoreImportant = false;

        public DefaultSectioningRequestComparator(DataProperties properties) {
            this.iConsiderRequestPriority = properties.getPropertyBoolean("Sectioning.UseCriticalCoursesSelection", this.iConsiderRequestPriority);
            this.iConsiderStudentPriority = properties.getPropertyBoolean("Sectioning.PriorityStudentsFirstSelection", this.iConsiderStudentPriority);
            this.iStudentPriorityIsMoreImportant = properties.getPropertyBoolean("Sectioning.PriorityStudentsFirstSelection.AllIn", this.iStudentPriorityIsMoreImportant);
        }

        @Override
        protected int compareBothAssignedOrNotAssigned(SectioningRequest s, SectioningRequest r) {
            if (this.iStudentPriorityIsMoreImportant) {
                if (this.iConsiderStudentPriority && s.getStudentPriority() != r.getStudentPriority()) {
                    return s.getStudentPriority().ordinal() < r.getStudentPriority().ordinal() ? -1 : 1;
                }
                if (this.iConsiderRequestPriority && s.getRequestPriority() != r.getRequestPriority()) {
                    return s.getRequestPriority().ordinal() < r.getRequestPriority().ordinal() ? -1 : 1;
                }
            } else {
                if (this.iConsiderRequestPriority && s.getRequestPriority() != r.getRequestPriority()) {
                    return s.getRequestPriority().ordinal() < r.getRequestPriority().ordinal() ? -1 : 1;
                }
                if (this.iConsiderStudentPriority && s.getStudentPriority() != r.getStudentPriority()) {
                    return s.getStudentPriority().ordinal() < r.getStudentPriority().ordinal() ? -1 : 1;
                }
            }
            return 0;
        }
    }
}

