/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseRoomGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private String iAbbv;
    private String iDescription;
    private Boolean iGlobal;
    private Boolean iDefaultGroup;
    private Department iDepartment;
    private Session iSession;
    private Set<Location> iRooms;

    public BaseRoomGroup() {
    }

    public BaseRoomGroup(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="room_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="name", nullable=false, length=60)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="abbv", nullable=false, length=60)
    public String getAbbv() {
        return this.iAbbv;
    }

    public void setAbbv(String abbv) {
        this.iAbbv = abbv;
    }

    @Column(name="description", nullable=true, length=1000)
    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String description) {
        this.iDescription = description;
    }

    @Column(name="global", nullable=false)
    public Boolean isGlobal() {
        return this.iGlobal;
    }

    @Transient
    public Boolean getGlobal() {
        return this.iGlobal;
    }

    public void setGlobal(Boolean global) {
        this.iGlobal = global;
    }

    @Column(name="default_group", nullable=false)
    public Boolean isDefaultGroup() {
        return this.iDefaultGroup;
    }

    @Transient
    public Boolean getDefaultGroup() {
        return this.iDefaultGroup;
    }

    public void setDefaultGroup(Boolean defaultGroup) {
        this.iDefaultGroup = defaultGroup;
    }

    @ManyToOne(optional=true, fetch=FetchType.EAGER)
    @JoinColumn(name="department_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Department getDepartment() {
        return this.iDepartment;
    }

    public void setDepartment(Department department) {
        this.iDepartment = department;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToMany(mappedBy="roomGroups")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Location> getRooms() {
        return this.iRooms;
    }

    public void setRooms(Set<Location> rooms) {
        this.iRooms = rooms;
    }

    public void addToRooms(Location location) {
        if (this.iRooms == null) {
            this.iRooms = new HashSet<Location>();
        }
        this.iRooms.add(location);
    }

    @Deprecated
    public void addTorooms(Location location) {
        this.addToRooms(location);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RoomGroup)) {
            return false;
        }
        if (this.getUniqueId() == null || ((RoomGroup)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((RoomGroup)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "RoomGroup[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "RoomGroup[\n\tAbbv: " + this.getAbbv() + "\n\tDefaultGroup: " + this.getDefaultGroup() + "\n\tDepartment: " + String.valueOf(this.getDepartment()) + "\n\tDescription: " + this.getDescription() + "\n\tGlobal: " + this.getGlobal() + "\n\tName: " + this.getName() + "\n\tSession: " + String.valueOf(this.getSession()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

