/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.rooms.RoomFilterBox;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.client.tables.TableWidget;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.ClassAssignmentPageInterface;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class ClassAssignmentPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final CourseMessages COURSE = (CourseMessages)GWT.create(CourseMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimplePanel iRootPanel;
    private SimpleForm iPanel;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private ClassAssignmentPageInterface.ClassAssignmentPageRequest iRequest;
    private CheckBox iKeepConflicts = new CheckBox();
    private CheckBox iAllowRoomConflicts = new CheckBox();
    private CheckBox iShowStudentConflicts = new CheckBox();
    private ListBox iRoomOrder = new ListBox();
    private RoomFilterBox iRoomFilter = null;
    private Long iLastClassId = null;

    public ClassAssignmentPage() {
        this.iPanel = new SimpleForm(2);
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-ClassAssignmentPage");
        this.initWidget((Widget)this.iRootPanel);
        this.iHeader = new UniTimeHeaderPanel();
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        if (ClassAssignmentPage.hasParent()) {
            this.iHeader.addButton("close", MESSAGES.buttonClose(), new ClickHandler(){

                public void onClick(ClickEvent e) {
                    ClassAssignmentPage.closeDialog();
                }
            });
        } else {
            this.iHeader.addButton("close", MESSAGES.buttonBack(), new ClickHandler(){

                public void onClick(ClickEvent e) {
                    ToolBox.open(GWT.getHostPageBaseURL() + "clazz?id=" + ClassAssignmentPage.this.iRequest.getSelectedClassId());
                }
            });
        }
        this.iKeepConflicts.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> e) {
                ToolBox.setSessionCookie("ClassAssignment.KeepConflicts", (Boolean)e.getValue() != false ? "1" : "0");
                ClassAssignmentPage.this.load(ClassAssignmentPageInterface.Operation.UPDATE);
            }
        });
        this.iShowStudentConflicts.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> e) {
                ToolBox.setSessionCookie("ClassAssignment.ShowStudentConflicts", (Boolean)e.getValue() != false ? "1" : "0");
                ClassAssignmentPage.this.load(ClassAssignmentPageInterface.Operation.UPDATE);
            }
        });
        if ("1".equals(ToolBox.getSessionCookie("ClassAssignment.ShowStudentConflicts"))) {
            this.iShowStudentConflicts.setValue(Boolean.valueOf(true));
        }
        this.iFooter = this.iHeader.clonePanel();
        this.iRoomOrder.addItem(COURSE.sortRoomNameAsc(), ClassAssignmentPageInterface.RoomOrder.NAME_ASC.name());
        this.iRoomOrder.addItem(COURSE.sortRoomNameDesc(), ClassAssignmentPageInterface.RoomOrder.NAME_DESC.name());
        this.iRoomOrder.addItem(COURSE.sortRoomSizeAsc(), ClassAssignmentPageInterface.RoomOrder.SIZE_ASC.name());
        this.iRoomOrder.addItem(COURSE.sortRoomSizeDesc(), ClassAssignmentPageInterface.RoomOrder.SIZE_DESC.name());
        this.iRoomOrder.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                ClassAssignmentPage.this.iRequest.setRoomOrder(ClassAssignmentPageInterface.RoomOrder.valueOf(ClassAssignmentPage.this.iRoomOrder.getSelectedValue()));
                ToolBox.setSessionCookie("ClassAssignment.RoomOrder", ClassAssignmentPage.this.iRoomOrder.getSelectedValue());
            }
        });
        String selectedRoomOrder = ToolBox.getSessionCookie("ClassAssignment.RoomOrder");
        if (selectedRoomOrder == null || selectedRoomOrder.isEmpty()) {
            selectedRoomOrder = ClassAssignmentPageInterface.RoomOrder.NAME_ASC.name();
        }
        for (int i = 0; i < this.iRoomOrder.getItemCount(); ++i) {
            if (!this.iRoomOrder.getValue(i).equals(selectedRoomOrder)) continue;
            this.iRoomOrder.setSelectedIndex(i);
            break;
        }
        if ("1".equals(ToolBox.getSessionCookie("ClassAssignment.AllowConflicts"))) {
            this.iAllowRoomConflicts.setValue(Boolean.valueOf(true));
        }
        this.iAllowRoomConflicts.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> e) {
                ToolBox.setSessionCookie("ClassAssignment.AllowConflicts", (Boolean)e.getValue() != false ? "1" : "0");
            }
        });
        String id = Window.Location.getParameter((String)"id");
        if (id == null) {
            id = Window.Location.getParameter((String)"classId");
        }
        if (id == null || id.isEmpty()) {
            LoadingWidget.getInstance().hide();
            this.iHeader.setErrorMessage(COURSE.errorNoClassId());
        } else {
            this.iRequest = new ClassAssignmentPageInterface.ClassAssignmentPageRequest();
            this.iRequest.setSelectedClassId(Long.valueOf(id));
            this.load(ClassAssignmentPageInterface.Operation.INIT);
        }
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ClassAssignmentPageInterface.Operation op = ClassAssignmentPageInterface.Operation.UPDATE;
                for (String token : ((String)event.getValue()).split("&")) {
                    if (token.indexOf(61) < 0) continue;
                    String key = token.substring(0, token.indexOf(61));
                    String val = token.substring(token.indexOf(61) + 1);
                    if ("time".equals(key)) {
                        ClassAssignmentPage.this.iRequest.getChange(ClassAssignmentPage.this.iRequest.getSelectedClassId()).setTime(val);
                        continue;
                    }
                    if ("date".equals(key)) {
                        ClassAssignmentPage.this.iRequest.getChange(ClassAssignmentPage.this.iRequest.getSelectedClassId()).setDate(val);
                        continue;
                    }
                    if ("room".equals(key)) {
                        ClassAssignmentPage.this.iRequest.getChange(ClassAssignmentPage.this.iRequest.getSelectedClassId()).setRoom(val);
                        continue;
                    }
                    if ("class".equals(key) || "id".equals(key)) {
                        ClassAssignmentPage.this.iRequest.setSelectedClassId(Long.valueOf(val));
                        continue;
                    }
                    if ("delete".equals(key)) {
                        ClassAssignmentPage.this.iRequest.removeChange(Long.valueOf(val));
                        if (ClassAssignmentPage.this.iRequest.hasChange(ClassAssignmentPage.this.iRequest.getSelectedClassId()) || !ClassAssignmentPage.this.iRequest.hasChanges()) continue;
                        ClassAssignmentPage.this.iRequest.setSelectedClassId(ClassAssignmentPage.this.iRequest.getChanges().get(0).getClassId());
                        continue;
                    }
                    if (!"lock".equals(key) || !Window.confirm((String)COURSE.confirmCourseLock())) continue;
                    ClassAssignmentPage.this.iRequest.setOfferingId(Long.valueOf(val));
                    op = ClassAssignmentPageInterface.Operation.LOCK;
                }
                ClassAssignmentPage.this.load(op);
            }
        });
        ClassAssignmentPage.checkParent();
    }

    protected void load(final ClassAssignmentPageInterface.Operation op) {
        GwtHint.hideHint();
        final Timer timer = new Timer(){

            public void run() {
                LoadingWidget.getInstance().show(op == ClassAssignmentPageInterface.Operation.ASSIGN ? MESSAGES.waitSavingData() : MESSAGES.waitLoadingData());
            }
        };
        timer.schedule(200);
        this.iRequest.setOperation(op);
        this.iRequest.setPreviousClassId(this.iLastClassId);
        this.iRequest.setKeepConflictingAssignments(this.iKeepConflicts.getValue());
        this.iRequest.setRoomAllowConflicts(this.iAllowRoomConflicts.getValue());
        if (ToolBox.getSessionCookie("ClassAssignment.ShowStudentConflicts") != null) {
            this.iRequest.setShowStudentConflicts("1".equals(ToolBox.getSessionCookie("ClassAssignment.ShowStudentConflicts")));
        }
        if (this.iRoomFilter != null) {
            this.iRequest.setRoomFilter((EventInterface.RoomFilterRpcRequest)this.iRoomFilter.getElementsRequest());
        } else {
            String rf = ToolBox.getSessionCookie("ClassAssignment.RoomFilter");
            if (rf != null && !rf.isEmpty()) {
                RoomInterface.RoomFilterRpcRequest filter = new RoomInterface.RoomFilterRpcRequest();
                filter.setText(rf);
                this.iRequest.setRoomFilter(filter);
            }
        }
        RPC.execute(this.iRequest, new AsyncCallback<ClassAssignmentPageInterface.ClassAssignmentPageResponse>(){

            public void onFailure(Throwable caught) {
                timer.cancel();
                LoadingWidget.getInstance().hide();
                ClassAssignmentPage.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(final ClassAssignmentPageInterface.ClassAssignmentPageResponse response) {
                P error;
                int r;
                UniTimeHeaderPanel hp;
                if (response.hasUrl()) {
                    if (ClassAssignmentPage.hasParent()) {
                        ClassAssignmentPage.closeDialog();
                        ClassAssignmentPage.openParent(GWT.getHostPageBaseURL() + response.getUrl());
                    } else {
                        ToolBox.open(GWT.getHostPageBaseURL() + response.getUrl());
                    }
                    return;
                }
                timer.cancel();
                LoadingWidget.getInstance().hide();
                ClassAssignmentPage.this.iPanel.clear();
                ClassAssignmentPage.this.iPanel.addHeaderRow((Widget)ClassAssignmentPage.this.iHeader);
                if (response.isShowStudentConflicts() != ClassAssignmentPage.this.iShowStudentConflicts.getValue().booleanValue()) {
                    ClassAssignmentPage.this.iShowStudentConflicts.setValue(Boolean.valueOf(response.isShowStudentConflicts()));
                    ToolBox.setSessionCookie("ClassAssignment.ShowStudentConflicts", response.isShowStudentConflicts() ? "1" : "0");
                }
                ClassAssignmentPage.this.iHeader.getHeaderTitlePanel().clear();
                Anchor anchor = new Anchor(COURSE.sectClass(response.getClassName()));
                anchor.setHref("clazz?id=" + response.getSelectedClassId());
                anchor.setTitle(COURSE.titleOpenClassDetail(response.getClassName()));
                anchor.setStyleName("l8");
                anchor.setTarget("_blank");
                ClassAssignmentPage.this.iHeader.getHeaderTitlePanel().add((Widget)anchor);
                ClassAssignmentPage.this.iHeader.clearMessage();
                if (response.hasErrorMessage()) {
                    ClassAssignmentPage.this.iHeader.setErrorMessage(response.getErrorMessage());
                }
                if (response.hasProperties()) {
                    for (TableInterface.PropertyInterface property : response.getProperties().getProperties()) {
                        ClassAssignmentPage.this.iPanel.addRow(property.getName(), (Widget)new TableWidget.CellWidget(property.getCell(), true));
                    }
                }
                ClassAssignmentPage.this.iKeepConflicts.setValue(Boolean.valueOf(response.isKeepConflictingAssignments()));
                if (response.hasAssignments()) {
                    hp = new UniTimeHeaderPanel(response.getAssignments().getName());
                    ClassAssignmentPage.this.iPanel.addHeaderRow((Widget)hp);
                    ClassAssignmentPage.this.iPanel.addRow((Widget)new TableWidget(response.getAssignments()));
                    ClassAssignmentPage.this.iPanel.addRow(COURSE.toggleDoNotUnassignConflictingClasses(), (Widget)ClassAssignmentPage.this.iKeepConflicts);
                    if (response.isCanAssign()) {
                        hp.addButton("assign", COURSE.actionClassAssign(), new ClickHandler(){

                            public void onClick(ClickEvent e) {
                                UniTimeConfirmationDialog.confirm(COURSE.confirmClassAssignment(), new Command(){

                                    public void execute() {
                                        ClassAssignmentPage.this.load(ClassAssignmentPageInterface.Operation.ASSIGN);
                                    }
                                });
                            }
                        });
                    }
                }
                if (response.hasStudentConflicts() && ClassAssignmentPage.this.iShowStudentConflicts.getValue().booleanValue()) {
                    hp = new UniTimeHeaderPanel(response.getStudentConflicts().getName());
                    ClassAssignmentPage.this.iPanel.addHeaderRow((Widget)hp);
                    ClassAssignmentPage.this.iPanel.addRow((Widget)new TableWidget(response.getStudentConflicts()));
                    if (response.isUseRealStudents()) {
                        a = new Label(COURSE.studentConflictsShowingActualConflicts());
                        a.setStyleName("unitime-ClassAssignmentLink");
                        a.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent e) {
                                ClassAssignmentPage.this.iRequest.setUseRealStudents(false);
                                ClassAssignmentPage.this.load(ClassAssignmentPageInterface.Operation.UPDATE);
                            }
                        });
                        r = ClassAssignmentPage.this.iPanel.addRow((Widget)a);
                        ClassAssignmentPage.this.iPanel.getRowFormatter().getElement(r).getStyle().setTextAlign(Style.TextAlign.CENTER);
                    } else {
                        a = new Label(COURSE.studentConflictsShowingSolutionConflicts());
                        a.setStyleName("unitime-ClassAssignmentLink");
                        a.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent e) {
                                ClassAssignmentPage.this.iRequest.setUseRealStudents(true);
                                ClassAssignmentPage.this.load(ClassAssignmentPageInterface.Operation.UPDATE);
                            }
                        });
                        r = ClassAssignmentPage.this.iPanel.addRow((Widget)a);
                        ClassAssignmentPage.this.iPanel.getRowFormatter().getElement(r).getStyle().setTextAlign(Style.TextAlign.CENTER);
                    }
                }
                if (response.hasDates() || response.hasDatesErrorMessage()) {
                    hp = new UniTimeHeaderPanel(COURSE.sectionTitleAvailableDatesForClass(response.getClassName()));
                    ClassAssignmentPage.this.iPanel.addHeaderRow((Widget)hp);
                    if (response.hasDates()) {
                        Items dates = new Items(response.getDates(), 1, "date");
                        ClassAssignmentPage.this.iPanel.addRow((Widget)dates);
                        if (dates.hasSelection()) {
                            ClassAssignmentPage.this.iRequest.getChange(response.getSelectedClassId()).setDate(dates.getSelection());
                        }
                    }
                    if (response.hasErrorMessage()) {
                        error = new P("unitime-ErrorMessage");
                        error.setText(response.getDatesErrorMessage());
                        r = ClassAssignmentPage.this.iPanel.addRow((Widget)error);
                        ClassAssignmentPage.this.iPanel.getRowFormatter().getElement(r).getStyle().setTextAlign(Style.TextAlign.CENTER);
                    }
                }
                if (response.hasTimes() || response.hasTimesErrorMessage()) {
                    hp = new UniTimeHeaderPanel(COURSE.sectionTitleAvailableTimesForClass(response.getClassName()));
                    ClassAssignmentPage.this.iPanel.addHeaderRow((Widget)hp);
                    if (response.hasTimes()) {
                        Items times = new Items(response.getTimes(), 1, "time");
                        ClassAssignmentPage.this.iPanel.addRow((Widget)times);
                        if (times.hasSelection()) {
                            ClassAssignmentPage.this.iRequest.getChange(response.getSelectedClassId()).setTime(times.getSelection());
                        }
                    }
                    if (response.hasTimesErrorMessage()) {
                        error = new P("unitime-ErrorMessage");
                        error.setText(response.getTimesErrorMessage());
                        r = ClassAssignmentPage.this.iPanel.addRow((Widget)error);
                        ClassAssignmentPage.this.iPanel.getRowFormatter().getElement(r).getStyle().setTextAlign(Style.TextAlign.CENTER);
                    }
                    ClassAssignmentPage.this.iPanel.addRow(COURSE.propertyShowStudentConflicts(), (Widget)ClassAssignmentPage.this.iShowStudentConflicts);
                }
                if (response.hasRooms() || response.hasRoomsErrorMessage()) {
                    hp = new UniTimeHeaderPanel(COURSE.sectionTitleAvailableRoomsForClass(response.getClassName()));
                    ClassAssignmentPage.this.iPanel.addHeaderRow((Widget)hp);
                    Label selected = null;
                    if (response.getNbrRooms() > 1 && Boolean.TRUE.equals(response.isRoomSplitAttendance())) {
                        selected = new Label();
                        selected.addStyleName("selected-total");
                        hp.getHeaderTitlePanel().add((Widget)selected);
                    }
                    if (ClassAssignmentPage.this.iRoomFilter == null) {
                        AcademicSessionProvider session = new AcademicSessionProvider(){

                            @Override
                            public Long getAcademicSessionId() {
                                return response.getSessionId();
                            }

                            @Override
                            public String getAcademicSessionName() {
                                return "Current Session";
                            }

                            @Override
                            public void addAcademicSessionChangeHandler(AcademicSessionProvider.AcademicSessionChangeHandler handler) {
                            }

                            @Override
                            public void selectSession(Long sessionId, AsyncCallback<Boolean> callback) {
                            }

                            @Override
                            public AcademicSessionProvider.AcademicSessionInfo getAcademicSessionInfo() {
                                return null;
                            }
                        };
                        ClassAssignmentPage.this.iRoomFilter = new RoomFilterBox(session);
                        String f = ToolBox.getSessionCookie("ClassAssignment.RoomFilter");
                        if (f != null && !f.isEmpty()) {
                            ClassAssignmentPage.this.iRoomFilter.setValue(f);
                        }
                        ClassAssignmentPage.this.iRoomFilter.addChip(new FilterBox.Chip("department", response.getManagingDeptCode()), false);
                        if (!(response.getMinRoomCapacity() == null || response.getNbrRooms() > 1 && Boolean.TRUE.equals(response.isRoomSplitAttendance()))) {
                            ClassAssignmentPage.this.iRoomFilter.addChip(new FilterBox.Chip("size", ">=" + response.getMinRoomCapacity()), false);
                        }
                        ClassAssignmentPage.this.iRoomFilter.addValueChangeHandler(new ValueChangeHandler<String>(){

                            public void onValueChange(ValueChangeEvent<String> e) {
                                Object ret = "";
                                for (FilterBox.Chip chip : ClassAssignmentPage.this.iRoomFilter.getChips(null)) {
                                    if ("department".equals(chip.getCommand()) || "size".equals(chip.getCommand())) continue;
                                    ret = (String)ret + chip.toString() + " ";
                                }
                                ret = (String)ret + ClassAssignmentPage.this.iRoomFilter.getText();
                                ToolBox.setSessionCookie("ClassAssignment.RoomFilter", (String)ret);
                            }
                        });
                    } else if (ClassAssignmentPage.this.iLastClassId != null && !ClassAssignmentPage.this.iLastClassId.equals(response.getSelectedClassId())) {
                        FilterBox.Chip size;
                        FilterBox.Chip dept = ClassAssignmentPage.this.iRoomFilter.getChip("department");
                        if (dept != null && !dept.getValue().equals(response.getManagingDeptCode())) {
                            ClassAssignmentPage.this.iRoomFilter.removeChip(dept, false);
                            ClassAssignmentPage.this.iRoomFilter.addChip(new FilterBox.Chip("department", response.getManagingDeptCode()), false);
                        }
                        if ((size = ClassAssignmentPage.this.iRoomFilter.getChip("size")) != null) {
                            ClassAssignmentPage.this.iRoomFilter.removeChip(size, false);
                        }
                        if (!(response.getMinRoomCapacity() == null || response.getNbrRooms() > 1 && Boolean.TRUE.equals(response.isRoomSplitAttendance()))) {
                            ClassAssignmentPage.this.iRoomFilter.addChip(new FilterBox.Chip("size", ">=" + response.getMinRoomCapacity()), false);
                        }
                    }
                    ClassAssignmentPage.this.iLastClassId = response.getSelectedClassId();
                    ClassAssignmentPage.this.iPanel.addRow(COURSE.properyRoomFilter(), (Widget)ClassAssignmentPage.this.iRoomFilter);
                    hp.addButton("apply", COURSE.buttonApply(), new ClickHandler(){

                        public void onClick(ClickEvent e) {
                            ClassAssignmentPage.this.load(ClassAssignmentPageInterface.Operation.UPDATE);
                        }
                    });
                    ClassAssignmentPage.this.iPanel.addRow(COURSE.properyRoomAllowConflicts(), (Widget)ClassAssignmentPage.this.iAllowRoomConflicts);
                    ClassAssignmentPage.this.iPanel.addRow(COURSE.propertyRoomOrder(), (Widget)ClassAssignmentPage.this.iRoomOrder);
                    if (response.hasRooms()) {
                        Items rooms = new Items(response.getRooms(), response.getNbrRooms(), "room", selected, response.getMinRoomCapacity());
                        ClassAssignmentPage.this.iPanel.addRow((Widget)rooms);
                        if (rooms.hasSelection(response.getNbrRooms())) {
                            ClassAssignmentPage.this.iRequest.getChange(response.getSelectedClassId()).setRoom(rooms.getSelection());
                        }
                    }
                    if (response.hasRoomsErrorMessage()) {
                        P error2 = new P("unitime-ErrorMessage");
                        error2.setText(response.getRoomsErrorMessage());
                        int r2 = ClassAssignmentPage.this.iPanel.addRow((Widget)error2);
                        ClassAssignmentPage.this.iPanel.getRowFormatter().getElement(r2).getStyle().setTextAlign(Style.TextAlign.CENTER);
                    }
                }
                ClassAssignmentPage.this.iPanel.addBottomRow((Widget)ClassAssignmentPage.this.iFooter);
            }
        });
    }

    public static native void checkParent();

    public static native boolean hasParent();

    public static native void closeDialog();

    public static native void openParent(String var0);

    static class Item
    extends P {
        ClassAssignmentPageInterface.DomainItem iItem;

        Item(ClassAssignmentPageInterface.DomainItem item) {
            super(new String[0]);
            this.iItem = item;
            this.setStyleName("domain-item");
            P first = new P("domain-item-label");
            first.add((Widget)new TableWidget.CellWidget(item.getCell()));
            this.add((Widget)first);
            if (this.iItem.isAssigned()) {
                first.getElement().getStyle().setTextDecoration(Style.TextDecoration.UNDERLINE);
            }
            if (item.getExtra() != null) {
                P extra = new P("domain-item-extra");
                extra.add((Widget)new TableWidget.CellWidget(item.getExtra()));
                this.add((Widget)extra);
                if (this.iItem.isAssigned()) {
                    extra.getElement().getStyle().setTextDecoration(Style.TextDecoration.UNDERLINE);
                }
            }
            if (this.iItem.isSelected()) {
                this.getElement().getStyle().setBackgroundColor("#92c1f0");
            }
            this.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent e) {
                    this.getElement().getStyle().setBackgroundColor("#d0e4f6");
                }
            });
            this.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent e) {
                    if (iItem.isSelected()) {
                        this.getElement().getStyle().setBackgroundColor("#92c1f0");
                    } else {
                        this.getElement().getStyle().clearBackgroundColor();
                    }
                }
            });
        }

        public ClassAssignmentPageInterface.DomainItem getValue() {
            return this.iItem;
        }

        public boolean isSelected() {
            return this.iItem.isSelected();
        }

        public void setSelected(boolean selected) {
            this.iItem.setSelected(selected);
            if (!"#92c1f0".equals(this.getElement().getStyle().getBackgroundColor())) {
                if (this.iItem.isSelected()) {
                    this.getElement().getStyle().setBackgroundColor("#92c1f0");
                } else {
                    this.getElement().getStyle().clearBackgroundColor();
                }
            }
        }
    }

    class Items
    extends P {
        int iCount;
        String iKey;
        List<Item> iSelection;
        Label iTotal;
        Integer iDesired;

        Items(List<ClassAssignmentPageInterface.DomainItem> items, int count, String key) {
            this(items, count, key, null, null);
        }

        Items(List<ClassAssignmentPageInterface.DomainItem> items, int count, final String key, Label total, Integer desired) {
            super(new String[0]);
            this.iSelection = new ArrayList<Item>();
            this.iKey = key;
            this.iCount = count;
            this.iTotal = total;
            this.iDesired = desired;
            this.setStyleName("domain-items");
            for (ClassAssignmentPageInterface.DomainItem item : items) {
                final Item w = new Item(item);
                this.add((Widget)w);
                if (w.isSelected()) {
                    this.iSelection.add(w);
                }
                w.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent e) {
                        if (w.isSelected()) {
                            w.setSelected(false);
                            Items.this.iSelection.remove((Object)w);
                            Items.this.updateTotal();
                            return;
                        }
                        if (Items.this.iSelection.size() >= Items.this.iCount) {
                            for (Item x : Items.this.iSelection) {
                                x.setSelected(false);
                            }
                            Items.this.iSelection.clear();
                        }
                        w.setSelected(true);
                        Items.this.iSelection.add(w);
                        Items.this.updateTotal();
                        if (Items.this.iSelection.size() == Items.this.iCount) {
                            if ("date".equals(key)) {
                                ClassAssignmentPage.this.iRequest.getChange(ClassAssignmentPage.this.iRequest.getSelectedClassId()).setDate(Items.this.getSelection());
                            }
                            if ("time".equals(key)) {
                                ClassAssignmentPage.this.iRequest.getChange(ClassAssignmentPage.this.iRequest.getSelectedClassId()).setTime(Items.this.getSelection());
                                ClassAssignmentPage.this.iRequest.getChange(ClassAssignmentPage.this.iRequest.getSelectedClassId()).setRoom(null);
                                if ("null".equals(Items.this.getSelection())) {
                                    ClassAssignmentPage.this.iRequest.getChange(ClassAssignmentPage.this.iRequest.getSelectedClassId()).setDate(null);
                                }
                            }
                            if ("room".equals(key)) {
                                ClassAssignmentPage.this.iRequest.getChange(ClassAssignmentPage.this.iRequest.getSelectedClassId()).setRoom(Items.this.getSelection());
                            }
                            ClassAssignmentPage.this.load(ClassAssignmentPageInterface.Operation.UPDATE);
                        }
                    }
                });
            }
            this.updateTotal();
        }

        public String getSelection() {
            Object id = null;
            for (Item x : this.iSelection) {
                if (id == null) {
                    id = x.getValue().getId();
                    continue;
                }
                id = (String)id + ":" + x.getValue().getId();
            }
            return id;
        }

        public boolean hasSelection(int count) {
            return this.iSelection.size() == count;
        }

        public boolean hasSelection() {
            return !this.iSelection.isEmpty();
        }

        void updateTotal() {
            if (this.iTotal == null) {
                return;
            }
            if (this.iSelection.isEmpty()) {
                this.iTotal.setText("");
                return;
            }
            int total = 0;
            for (Item s : this.iSelection) {
                total += s.getValue().getValue().intValue();
            }
            this.iTotal.setText("(" + COURSE.messageSelectedSize() + " " + total + (String)(this.iDesired == null ? "" : " " + COURSE.messageSelectedSizeOf() + " " + this.iDesired) + ")");
        }
    }
}

