/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.CourseFinderDialog;
import org.unitime.timetable.gwt.client.widgets.CourseFinderMultipleCourses;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

public class SelectAllCourseFinderDialog
extends CourseFinderDialog {
    AriaButton iFilterSelectAll = new AriaButton(MESSAGES.buttonSelectAll());

    public SelectAllCourseFinderDialog() {
        this.iFilterSelectAll.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CourseRequestInterface.RequestedCourse rc;
                CourseFinderMultipleCourses courses;
                CourseFinder.CourseFinderTab tab = SelectAllCourseFinderDialog.this.getSelectedTab();
                if (tab != null && tab instanceof CourseFinderMultipleCourses && (courses = (CourseFinderMultipleCourses)tab).isAllowMultiSelection()) {
                    ArrayList<ClassAssignmentInterface.CourseAssignment> selected = new ArrayList<ClassAssignmentInterface.CourseAssignment>();
                    for (ClassAssignmentInterface.CourseAssignment ca : courses.getCourses()) {
                        if (ca.getSelection() == null) continue;
                        selected.add(ca);
                    }
                    if (!selected.isEmpty()) {
                        Collections.sort(selected);
                        for (ClassAssignmentInterface.CourseAssignment ca : selected) {
                            courses.selectCourse(ca);
                        }
                    }
                }
                if ((rc = (CourseRequestInterface.RequestedCourse)(tab == null ? null : tab.getValue())) != null) {
                    SelectAllCourseFinderDialog.this.iFilter.setValue(rc.toString(CONSTANTS));
                }
                SelectAllCourseFinderDialog.this.hide();
                SelectionEvent.fire((HasSelectionHandlers)SelectAllCourseFinderDialog.this, (Object)SelectAllCourseFinderDialog.this.getValue());
            }
        });
        this.iFilterSelectAll.setEnabled(false);
        this.iFilterSelectAll.setVisible(false);
        P filterButton = new P("button");
        filterButton.add((Widget)this.iFilterSelectAll);
        this.iFilterPanel.insert((Widget)filterButton, 0);
    }

    public void checkSelectAll() {
        CourseFinder.CourseFinderTab tab = this.getSelectedTab();
        if (tab != null && tab instanceof CourseFinderMultipleCourses) {
            CourseFinderMultipleCourses course = (CourseFinderMultipleCourses)tab;
            if (course.isAllowMultiSelection()) {
                int nrCourses = 0;
                int nrSelect = 0;
                for (ClassAssignmentInterface.CourseAssignment ca : course.getCourses()) {
                    ++nrCourses;
                    if (ca.getSelection() == null) continue;
                    ++nrSelect;
                }
                if (nrSelect > 0) {
                    if (nrSelect == nrCourses) {
                        this.iFilterSelectAll.setHTML(MESSAGES.buttonSelectAll());
                    } else {
                        this.iFilterSelectAll.setHTML(MESSAGES.buttonPickN(nrSelect));
                    }
                    this.iFilterSelectAll.setEnabled(true);
                    this.iFilterSelectAll.setVisible(true);
                    return;
                }
            }
            this.iFilterSelectAll.setEnabled(false);
            this.iFilterSelectAll.setVisible(false);
        } else {
            this.iFilterSelectAll.setEnabled(false);
            this.iFilterSelectAll.setVisible(false);
        }
    }

    @Override
    public void setTabs(CourseFinder.CourseFinderTab ... tabs) {
        super.setTabs(tabs);
        for (CourseFinder.CourseFinderTab tab : tabs) {
            if (!(tab instanceof CourseFinderMultipleCourses)) continue;
            tab.addResponseHandler(new CourseFinder.ResponseHandler(){

                @Override
                public void onResponse(CourseFinder.ResponseEvent event) {
                    SelectAllCourseFinderDialog.this.checkSelectAll();
                }
            });
        }
        if (this.iTabPanel != null) {
            this.iTabPanel.addSelectionHandler(new SelectionHandler<Integer>(){

                public void onSelection(SelectionEvent<Integer> event) {
                    SelectAllCourseFinderDialog.this.checkSelectAll();
                }
            });
        }
    }
}

