/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.admin.ScriptPage;
import org.unitime.timetable.gwt.client.events.SessionDatesSelector;
import org.unitime.timetable.gwt.client.events.SingleDateSelector;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.ServerDateTimeFormat;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeFileUpload;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.shared.ScriptInterface;
import org.unitime.timetable.gwt.shared.TaskInterface;

public class TaskEditor
extends UniTimeDialogBox {
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private TaskInterface.TaskOptionsInterface iOptions;
    private SimpleForm iDialogForm;
    private TaskInterface iTask;
    private TextBox iName;
    private SessionDatesSelector iDates;
    private TimeSelector iTime;
    private ListBox iScript;
    private UniTimeHeaderPanel iBottom;
    private int iDescriptionRow = -1;
    private HTML iDescription;
    private CheckBox iSendEmail;
    private TextArea iEmailAddresses;
    private VerticalPanel iEmailPanel;
    private SimpleForm iForm;
    private ScrollPanel iScroll;
    private boolean iHasPastExecutions = false;

    public TaskEditor(TaskInterface task, TaskInterface.TaskOptionsInterface options) {
        super(false, true);
        this.iOptions = options;
        this.addStyleName("unitime-PeriodicTaskEditor");
        this.iTask = task;
        if (task == null) {
            this.iTask = new TaskInterface();
        }
        this.setText(this.iTask.getId() == null ? MESSAGES.dialogAddTask() : MESSAGES.dialogEditTask(this.iTask.getName()));
        this.iDialogForm = new SimpleForm(2);
        this.iForm = new SimpleForm();
        this.iForm.removeStyleName("unitime-NotPrintableBottomLine");
        this.iScroll = new ScrollPanel((Widget)this.iForm);
        this.iScroll.setStyleName("unitime-VerticalScrollPanel");
        this.iDialogForm.addRow((Widget)this.iScroll);
        this.iName = new TextBox();
        if (this.iTask.getName() != null) {
            this.iName.setText(this.iTask.getName());
        }
        this.iName.setStyleName("unitime-TextBox");
        this.iName.setWidth("400px");
        this.iName.setMaxLength(128);
        this.iName.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                TaskEditor.this.iBottom.clearMessage();
            }
        });
        this.iForm.addRow(MESSAGES.propName(), (Widget)this.iName);
        if (this.iTask.getOwner() != null) {
            this.iForm.addRow(MESSAGES.propTaskOwner(), (Widget)new Label(this.iTask.getOwner().getFormattedName(false)));
        }
        this.iDates = new SessionDatesSelector(this.iOptions.getSessionMonths());
        if (this.iTask.hasExecutions()) {
            ArrayList<Date> dates = new ArrayList<Date>();
            for (TaskInterface.TaskExecutionInterface e : this.iTask.getExecutions()) {
                if (e.getStatus() == TaskInterface.ExecutionStatus.CREATED) {
                    dates.add(ServerDateTimeFormat.toLocalDate(e.getExecutionDate()));
                    continue;
                }
                this.iHasPastExecutions = true;
            }
            this.iDates.setValue(dates);
        }
        this.iForm.addRow(MESSAGES.propTaskExecutionDates(), (Widget)this.iDates);
        this.iDates.addValueChangeHandler(new ValueChangeHandler<List<Date>>(){

            public void onValueChange(ValueChangeEvent<List<Date>> event) {
                TaskEditor.this.iBottom.clearMessage();
            }
        });
        this.iTime = new TimeSelector();
        if (this.iTask.hasExecutions()) {
            this.iTime.setValue(this.iTask.getExecutions().last().getSlot());
        }
        this.iForm.addRow(MESSAGES.propTaskStartTime(), (Widget)this.iTime);
        this.iTime.addValueChangeHandler(new ValueChangeHandler<Integer>(){

            public void onValueChange(ValueChangeEvent<Integer> event) {
                TaskEditor.this.iBottom.clearMessage();
            }
        });
        if (this.iTask.getScript() != null) {
            this.iForm.addRow(MESSAGES.propScript(), (Widget)new Label(this.iTask.getScript().getName()));
        } else {
            this.iScript = new ListBox();
            this.iScript.addItem(MESSAGES.itemSelect(), "-1");
            this.iScript.setSelectedIndex(0);
            for (ScriptInterface script : this.iOptions.getScripts()) {
                if (!script.canExecute() && !script.canEdit() && !script.canDelete()) continue;
                this.iScript.addItem(script.getName(), script.getId().toString());
            }
            this.iForm.addRow(MESSAGES.propScript(), (Widget)this.iScript);
            this.iScript.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    TaskEditor.this.scriptChanged(true);
                    TaskEditor.this.iBottom.clearMessage();
                }
            });
        }
        this.iDescription = new HTML();
        this.iDescriptionRow = this.iForm.addRow(MESSAGES.propDescription(), (Widget)this.iDescription);
        if (this.iTask.getScript() != null) {
            this.iDescription.setHTML(this.iTask.getScript().getDescription());
        }
        this.iSendEmail = new CheckBox(MESSAGES.scriptSendEmailCheckbox());
        this.iSendEmail.setValue(Boolean.valueOf(false));
        this.iEmailAddresses = new TextArea();
        this.iEmailAddresses.setStyleName("unitime-TextArea");
        this.iEmailAddresses.setVisibleLines(3);
        this.iEmailAddresses.setCharacterWidth(80);
        this.iEmailPanel = new VerticalPanel();
        this.iEmailPanel.add((Widget)this.iSendEmail);
        this.iEmailPanel.setCellHorizontalAlignment((Widget)this.iSendEmail, HasHorizontalAlignment.ALIGN_LEFT);
        this.iEmailPanel.add((Widget)this.iEmailAddresses);
        this.iEmailAddresses.setVisible(false);
        this.iSendEmail.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                TaskEditor.this.iEmailAddresses.setVisible(((Boolean)event.getValue()).booleanValue());
            }
        });
        if (this.iTask.getEmail() != null) {
            this.iSendEmail.setValue(Boolean.valueOf(true));
            this.iEmailAddresses.setVisible(true);
            this.iEmailAddresses.setText(this.iTask.getEmail());
        }
        if (this.iTask.getId() == null && this.iOptions != null && this.iOptions.getManager() != null && this.iOptions.getManager().getEmail() != null) {
            this.iEmailAddresses.setText(this.iOptions.getManager().getEmail());
        }
        this.iForm.addRow(MESSAGES.propEmail(), (Widget)this.iEmailPanel);
        this.iBottom = new UniTimeHeaderPanel();
        this.iBottom.addButton("save", this.iTask.getId() == null ? MESSAGES.opTaskSave() : MESSAGES.opTaskUpdate(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!TaskEditor.this.validate()) {
                    return;
                }
                TaskEditor.this.hide();
                TaskEditor.this.doSave(TaskEditor.this.iTask);
            }
        });
        this.iBottom.addButton("back", MESSAGES.opTaskBack(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                TaskEditor.this.hide();
            }
        });
        this.iDialogForm.addBottomRow((Widget)this.iBottom);
        this.setWidget((Widget)this.iDialogForm);
        if (this.iTask.getScript() != null) {
            this.scriptChanged(false);
        }
        ToolBox.setMaxHeight(this.iScroll.getElement().getStyle(), Window.getClientHeight() - 100 + "px");
    }

    protected void doSave(TaskInterface task) {
    }

    protected void setErrorMessage(String message) {
        this.iBottom.setErrorMessage(message);
    }

    private boolean validate() {
        ScriptInterface script = this.getScript();
        if (this.iName.getText().isEmpty()) {
            this.iBottom.setErrorMessage(MESSAGES.errorNameIsRequired());
            return false;
        }
        this.iTask.setName(this.iName.getText());
        if (script == null) {
            this.iBottom.setErrorMessage(MESSAGES.errorItemNotSelected(MESSAGES.colTaskScript()));
            return false;
        }
        this.iTask.setScript(script);
        List<Integer> dates = this.iDates.getSelectedDays();
        if (dates == null || !this.iHasPastExecutions && dates.isEmpty()) {
            this.iBottom.setErrorMessage(MESSAGES.errorNoDateSelected());
            return false;
        }
        Integer slot = this.iTime.getValue();
        if (slot == null) {
            this.iBottom.setErrorMessage(MESSAGES.errorNoStartTime());
            return false;
        }
        this.iTask.clearExecutions();
        for (Integer date : dates) {
            TaskInterface.TaskExecutionInterface e = new TaskInterface.TaskExecutionInterface();
            e.setDayOfYear(date);
            e.setSlot(slot);
            this.iTask.addExecution(e);
        }
        this.iTask.setEmail(this.iSendEmail.getValue() != false && !this.iEmailAddresses.getText().isEmpty() ? this.iEmailAddresses.getText() : null);
        this.iBottom.clearMessage();
        return true;
    }

    private ScriptInterface getScript() {
        if (this.iOptions != null && this.iScript != null) {
            for (ScriptInterface s : this.iOptions.getScripts()) {
                if (!s.getId().toString().equals(this.iScript.getValue(this.iScript.getSelectedIndex()))) continue;
                return s;
            }
        }
        return this.iTask.getScript();
    }

    private void scriptChanged(boolean clear) {
        ScriptInterface script = this.getScript();
        if (script == null) {
            this.iForm.getRowFormatter().setVisible(this.iDescriptionRow, false);
            while (this.iForm.getRowCount() > this.iDescriptionRow + 2) {
                this.iForm.removeRow(1 + this.iDescriptionRow);
            }
            this.iBottom.setEnabled("save", false);
            this.iTask.clearParameters();
        } else {
            this.iDescription.setHTML(script.getDescription());
            this.iForm.getRowFormatter().setVisible(this.iDescriptionRow, script.getDescription() != null && !script.getDescription().isEmpty());
            this.iBottom.setEnabled("save", script.canExecute());
            if (clear) {
                this.iTask.clearParameters();
            }
            while (this.iForm.getRowCount() > this.iDescriptionRow + 2) {
                this.iForm.removeRow(1 + this.iDescriptionRow);
            }
            if (script.hasParameters()) {
                for (final ScriptInterface.ScriptParameterInterface param : script.getParameters()) {
                    String defaultValue;
                    if (param.getValue() != null) {
                        this.iTask.setParameter(param.getName(), param.getValue());
                    }
                    if ((defaultValue = this.iTask.getParameter(param.getName())) == null) {
                        defaultValue = param.getValue();
                    }
                    if (defaultValue == null) {
                        defaultValue = param.getDefaultValue();
                    }
                    Object widget = null;
                    if (param.hasOptions()) {
                        final ListBox list = new ListBox();
                        list.setMultipleSelect(param.isMultiSelect());
                        if (!param.isMultiSelect()) {
                            list.addItem(MESSAGES.itemSelect());
                        }
                        block3: for (ScriptInterface.ListItem item : param.getOptions()) {
                            list.addItem(item.getText(), item.getValue());
                            if (defaultValue == null) continue;
                            if (param.isMultiSelect()) {
                                for (String id : defaultValue.split(",")) {
                                    if (id.isEmpty() || !id.equalsIgnoreCase(item.getValue()) && !id.equalsIgnoreCase(item.getText()) && !item.getText().startsWith(id + " - ")) continue;
                                    list.setItemSelected(list.getItemCount() - 1, true);
                                    continue block3;
                                }
                                continue;
                            }
                            if (!defaultValue.equalsIgnoreCase(item.getValue()) && !defaultValue.equalsIgnoreCase(item.getText()) && !item.getText().startsWith(defaultValue + " - ")) continue;
                            list.setSelectedIndex(list.getItemCount() - 1);
                        }
                        list.addChangeHandler(new ChangeHandler(){

                            public void onChange(ChangeEvent event) {
                                if (param.isMultiSelect()) {
                                    Object value = "";
                                    for (int i = 0; i < list.getItemCount(); ++i) {
                                        if (!list.isItemSelected(i)) continue;
                                        value = (String)value + (((String)value).isEmpty() ? "" : ",") + list.getValue(i);
                                    }
                                    TaskEditor.this.iTask.setParameter(param.getName(), (String)value);
                                } else {
                                    TaskEditor.this.iTask.setParameter(param.getName(), list.getValue(list.getSelectedIndex()));
                                }
                            }
                        });
                        widget = list;
                    } else if ("boolean".equalsIgnoreCase(param.getType())) {
                        CheckBox ch = new CheckBox();
                        ch.setValue(Boolean.valueOf("true".equalsIgnoreCase(defaultValue)));
                        ch.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                            public void onValueChange(ValueChangeEvent<Boolean> event) {
                                TaskEditor.this.iTask.setParameter(param.getName(), (Boolean)event.getValue() != false ? "true" : "false");
                            }
                        });
                        widget = ch;
                    } else if ("file".equalsIgnoreCase(param.getType())) {
                        UniTimeFileUpload upload = new UniTimeFileUpload();
                        upload.reset();
                        widget = upload;
                    } else if ("textarea".equalsIgnoreCase(param.getType())) {
                        TextArea textarea = new TextArea();
                        textarea.setStyleName("unitime-TextArea");
                        textarea.setVisibleLines(5);
                        textarea.setCharacterWidth(80);
                        if (defaultValue != null) {
                            textarea.setText(defaultValue);
                        }
                        textarea.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                            public void onValueChange(ValueChangeEvent<String> event) {
                                TaskEditor.this.iTask.setParameter(param.getName(), (String)event.getValue());
                            }
                        });
                        widget = textarea;
                    } else if ("integer".equalsIgnoreCase(param.getType()) || "int".equalsIgnoreCase(param.getType()) || "long".equalsIgnoreCase(param.getType()) || "short".equalsIgnoreCase(param.getType()) || "byte".equalsIgnoreCase(param.getType())) {
                        text = new NumberBox();
                        ((NumberBox)text).setDecimal(false);
                        ((NumberBox)text).setNegative(true);
                        if (defaultValue != null) {
                            text.setText(defaultValue);
                        }
                        text.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                            public void onValueChange(ValueChangeEvent<String> event) {
                                TaskEditor.this.iTask.setParameter(param.getName(), (String)event.getValue());
                            }
                        });
                        widget = text;
                    } else if ("number".equalsIgnoreCase(param.getType()) || "float".equalsIgnoreCase(param.getType()) || "double".equalsIgnoreCase(param.getType())) {
                        text = new NumberBox();
                        ((NumberBox)text).setDecimal(true);
                        ((NumberBox)text).setNegative(true);
                        if (defaultValue != null) {
                            text.setText(defaultValue);
                        }
                        text.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                            public void onValueChange(ValueChangeEvent<String> event) {
                                TaskEditor.this.iTask.setParameter(param.getName(), (String)event.getValue());
                            }
                        });
                        widget = text;
                    } else if ("date".equalsIgnoreCase(param.getType())) {
                        text = new SingleDateSelector();
                        if (defaultValue != null) {
                            ((SingleDateSelector)text).setText(defaultValue);
                        }
                        final DateTimeFormat format = DateTimeFormat.getFormat((String)CONSTANTS.eventDateFormat());
                        ((SingleDateSelector)text).addValueChangeHandler(new ValueChangeHandler<Date>(){

                            public void onValueChange(ValueChangeEvent<Date> event) {
                                TaskEditor.this.iTask.setParameter(param.getName(), format.format((Date)event.getValue()));
                            }
                        });
                        widget = text;
                    } else if ("slot".equalsIgnoreCase(param.getType()) || "time".equalsIgnoreCase(param.getType())) {
                        text = new TimeSelector();
                        if (defaultValue != null) {
                            ((TimeSelector)((Object)text)).setText(defaultValue);
                        }
                        ((TimeSelector)((Object)text)).addValueChangeHandler(new ValueChangeHandler<Integer>(){

                            public void onValueChange(ValueChangeEvent<Integer> event) {
                                TaskEditor.this.iTask.setParameter(param.getName(), ((Integer)event.getValue()).toString());
                            }
                        });
                        widget = text;
                    } else if ("datetime".equalsIgnoreCase(param.getType()) || "timestamp".equalsIgnoreCase(param.getType())) {
                        text = new ScriptPage.DateTimeBox();
                        if (defaultValue != null) {
                            ((ScriptPage.DateTimeBox)((Object)text)).setText(defaultValue);
                        }
                        ((ScriptPage.DateTimeBox)((Object)text)).addValueChangeHandler(new ValueChangeHandler<String>(){

                            public void onValueChange(ValueChangeEvent<String> event) {
                                TaskEditor.this.iTask.setParameter(param.getName(), (String)event.getValue());
                            }
                        });
                        widget = text;
                    } else {
                        text = new TextBox();
                        text.setStyleName("unitime-TextBox");
                        text.setWidth("400px");
                        if (defaultValue != null) {
                            text.setText(defaultValue);
                        }
                        text.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                            public void onValueChange(ValueChangeEvent<String> event) {
                                TaskEditor.this.iTask.setParameter(param.getName(), (String)event.getValue());
                            }
                        });
                        widget = text;
                    }
                    int row = this.iForm.insertRow(this.iForm.getRowCount() - 1);
                    this.iForm.setWidget(row, 0, (Widget)new Label((param.getLabel() == null || param.getLabel().isEmpty() ? param.getName() : param.getLabel()) + ":", false));
                    this.iForm.setWidget(row, 1, (Widget)widget);
                }
            }
        }
        if (this.isShowing()) {
            this.center();
        }
    }
}

