/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import jakarta.servlet.http.HttpSession;
import java.util.Collection;
import java.util.Set;
import java.util.Vector;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.solver.exam.ui.ExamInfoModel;
import org.unitime.timetable.util.ComboBoxLookup;
import org.unitime.timetable.webutil.timegrid.ExamGridTable;

public class ExamInfoForm
implements UniTimeForm {
    private static final long serialVersionUID = 424087977258798931L;
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    protected static final CourseMessages CMSG = Localization.create(CourseMessages.class);
    private String iOp;
    private ExamInfoModel iModel;
    private String iMessage;
    private String iMinRoomSize = null;
    private String iMaxRoomSize = null;
    private String iRoomFilter = null;
    private boolean iAllowRoomConflict = false;
    private String iRoomOrder = null;
    private boolean iComputeSuggestions = false;
    private String iFilter = null;
    private int iDepth = 2;
    private long iTimeout = 5000L;
    private int iLimit = 30;
    private Long[] iRoomFeatures = null;
    private Long[] iRoomTypes = null;
    private Long[] iRoomGroups = null;
    private Long iSessionId = null;
    private Long iExamTypeId = null;

    @Override
    public void reset() {
        this.iOp = null;
        this.iModel = null;
        this.iMessage = null;
        this.iMinRoomSize = null;
        this.iMaxRoomSize = null;
        this.iRoomFilter = null;
        this.iAllowRoomConflict = false;
        this.iRoomOrder = OrderBy.SizeDesc.name();
        this.iComputeSuggestions = false;
        this.iFilter = null;
        this.iDepth = 2;
        this.iTimeout = 5000L;
        this.iLimit = 30;
        this.iRoomTypes = null;
        this.iRoomFeatures = null;
        this.iRoomGroups = null;
    }

    @Override
    public void validate(UniTimeAction action) {
    }

    public void load(HttpSession session) {
        this.iRoomOrder = (String)session.getAttribute("ExamInfo.RoomOrd");
        this.iMinRoomSize = (String)session.getAttribute("ExamInfo.MinRoomSize");
        this.iMaxRoomSize = (String)session.getAttribute("ExamInfo.MaxRoomSize");
        this.iRoomFilter = (String)session.getAttribute("ExamInfo.RoomFilter");
        this.iAllowRoomConflict = "true".equals(session.getAttribute("ExamInfo.AllowRoomConflict"));
        this.iFilter = (String)session.getAttribute("ExamInfo.Filter");
        if (session.getAttribute("ExamInfo.Limit") != null) {
            this.iLimit = (Integer)session.getAttribute("ExamInfo.Limit");
        }
        if (session.getAttribute("ExamInfo.Depth") != null) {
            this.iDepth = (Integer)session.getAttribute("ExamInfo.Depth");
        }
        if (session.getAttribute("ExamInfo.Timeout") != null) {
            this.iTimeout = (Long)session.getAttribute("ExamInfo.Timeout");
        }
        if (session.getAttribute("ExamInfo.ComputeSuggestions") != null) {
            this.iComputeSuggestions = (Boolean)session.getAttribute("ExamInfo.ComputeSuggestions");
        }
        this.iRoomTypes = (Long[])session.getAttribute("ExamInfo.RoomTypes");
        this.iRoomGroups = (Long[])session.getAttribute("ExamInfo.RoomGroups");
        this.iRoomFeatures = (Long[])session.getAttribute("ExamInfo.RoomFeatures");
    }

    public void save(HttpSession session) {
        if (this.iRoomOrder == null) {
            session.removeAttribute("ExamInfo.RoomOrd");
        } else {
            session.setAttribute("ExamInfo.RoomOrd", (Object)this.iRoomOrder);
        }
        if (this.iMinRoomSize == null) {
            session.removeAttribute("ExamInfo.MinRoomSize");
        } else {
            session.setAttribute("ExamInfo.MinRoomSize", (Object)this.iMinRoomSize);
        }
        if (this.iMaxRoomSize == null) {
            session.removeAttribute("ExamInfo.MaxRoomSize");
        } else {
            session.setAttribute("ExamInfo.MaxRoomSize", (Object)this.iMaxRoomSize);
        }
        if (this.iRoomFilter == null) {
            session.removeAttribute("ExamInfo.RoomFilter");
        } else {
            session.setAttribute("ExamInfo.RoomFilter", (Object)this.iRoomFilter);
        }
        session.setAttribute("ExamInfo.AllowRoomConflict", (Object)(this.iAllowRoomConflict ? "true" : "false"));
        if (this.iFilter == null) {
            session.removeAttribute("ExamInfo.Filter");
        } else {
            session.setAttribute("ExamInfo.Filter", (Object)this.iFilter);
        }
        session.setAttribute("ExamInfo.Depth", (Object)this.iDepth);
        session.setAttribute("ExamInfo.Timeout", (Object)this.iTimeout);
        session.setAttribute("ExamInfo.Limit", (Object)this.iLimit);
        session.setAttribute("ExamInfo.ComputeSuggestions", (Object)this.iComputeSuggestions);
        if (this.iRoomTypes == null) {
            session.removeAttribute("ExamInfo.RoomTypes");
        } else {
            session.setAttribute("ExamInfo.RoomTypes", (Object)this.iRoomTypes);
        }
        if (this.iRoomGroups == null) {
            session.removeAttribute("ExamInfo.RoomGroups");
        } else {
            session.setAttribute("ExamInfo.RoomGroups", (Object)this.iRoomGroups);
        }
        if (this.iRoomFeatures == null) {
            session.removeAttribute("ExamInfo.RoomFeatures");
        } else {
            session.setAttribute("ExamInfo.RoomFeatures", (Object)this.iRoomFeatures);
        }
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public ExamInfoModel getModel() {
        return this.iModel;
    }

    public void setModel(ExamInfoModel model) {
        this.iModel = model;
    }

    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    public String getMinRoomSize() {
        return this.iMinRoomSize;
    }

    public void setMinRoomSize(String minRoomSize) {
        this.iMinRoomSize = minRoomSize;
    }

    public String getMaxRoomSize() {
        return this.iMaxRoomSize;
    }

    public void setMaxRoomSize(String maxRoomSize) {
        this.iMaxRoomSize = maxRoomSize;
    }

    public String getRoomFilter() {
        return this.iRoomFilter;
    }

    public void setRoomFilter(String roomFilter) {
        this.iRoomFilter = roomFilter;
    }

    public boolean getAllowRoomConflict() {
        return this.iAllowRoomConflict;
    }

    public void setAllowRoomConflict(boolean allowRoomConflict) {
        this.iAllowRoomConflict = allowRoomConflict;
    }

    public String getRoomOrder() {
        return this.iRoomOrder;
    }

    public void setRoomOrder(String ord) {
        this.iRoomOrder = ord;
    }

    public Vector<ComboBoxLookup> getRoomOrders() {
        Vector<ComboBoxLookup> ret = new Vector<ComboBoxLookup>();
        for (ExamGridTable.OrderBy o : ExamGridTable.OrderBy.values()) {
            ret.addElement(new ComboBoxLookup(o.getLabel(), o.name()));
        }
        return ret;
    }

    public boolean getComputeSuggestions() {
        return this.iComputeSuggestions;
    }

    public void setComputeSuggestions(boolean computeSuggestions) {
        this.iComputeSuggestions = computeSuggestions;
    }

    public int getLimit() {
        return this.iLimit;
    }

    public void setLimit(int limit) {
        this.iLimit = limit;
    }

    public int getDepth() {
        return this.iDepth;
    }

    public void setDepth(int depth) {
        this.iDepth = depth;
    }

    public long getTimeout() {
        return this.iTimeout;
    }

    public void setTimeout(long timeout) {
        this.iTimeout = timeout;
    }

    public String getFilter() {
        return this.iFilter;
    }

    public void setFilter(String filter) {
        this.iFilter = filter;
    }

    public Long[] getRoomTypes() {
        return this.iRoomTypes;
    }

    public void setRoomTypes(Long[] rts) {
        this.iRoomTypes = rts;
    }

    public Long[] getRoomGroups() {
        return this.iRoomGroups;
    }

    public void setRoomGroups(Long[] rgs) {
        this.iRoomGroups = rgs;
    }

    public Long[] getRoomFeatures() {
        return this.iRoomFeatures;
    }

    public void setRoomFeatures(Long[] rfs) {
        this.iRoomFeatures = rfs;
    }

    public Collection<RoomFeatureType> getRoomFeatureTypes() {
        Set<RoomFeatureType> types = RoomFeatureType.getRoomFeatureTypes(this.iSessionId, this.iExamTypeId);
        if (RoomFeatureType.hasRoomFeatureWithNoType(this.iSessionId, this.iExamTypeId)) {
            RoomFeatureType f = new RoomFeatureType();
            f.setUniqueId(-1L);
            f.setReference("Features");
            f.setLabel(CMSG.labelRoomfeatures());
            types.add(f);
        }
        return types;
    }

    public Collection<GlobalRoomFeature> getAllRoomFeatures(String featureType) {
        return RoomFeature.getAllGlobalRoomFeatures(this.iSessionId, featureType == null || featureType.isEmpty() ? null : Long.valueOf(featureType));
    }

    public Collection<RoomGroup> getAllRoomGroups() {
        return RoomGroup.getAllGlobalRoomGroups(this.iSessionId);
    }

    public Collection<RoomType> getAllRoomTypes() {
        return RoomType.findAll(this.iSessionId);
    }

    public Long getSessionId() {
        return this.iSessionId;
    }

    public void setSessionId(Long sessionId) {
        this.iSessionId = sessionId;
    }

    public Long getExamTypeId() {
        return this.iExamTypeId;
    }

    public void setExamTypeId(long examTypeId) {
        this.iExamTypeId = examTypeId;
    }

    public static enum OrderBy {
        NameAsc,
        NameDesc,
        SizeAsc,
        SizeDesc;


        public String getLabel() {
            switch (this) {
                case NameAsc: {
                    return MSG.orderByNameAsc();
                }
                case NameDesc: {
                    return MSG.orderByNameDesc();
                }
                case SizeAsc: {
                    return MSG.orderBySizeAsc();
                }
                case SizeDesc: {
                    return MSG.orderBySizeDesc();
                }
            }
            return this.name();
        }
    }
}

