/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.springframework.security.core.context.SecurityContextHolder;
import org.unitime.commons.MultiComparable;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.RoleListForm;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;

@Action(value="selectPrimaryRole", results={@Result(name={"getUserSelectedRole"}, type="tiles", location="selectPrimaryRole.tiles"), @Result(name={"getDefaultAcadSession"}, type="tiles", location="selectAcadSession.tiles"), @Result(name={"success"}, type="redirect", location="/main.action"), @Result(name={"fail"}, type="tiles", location="selectPrimaryRole.tiles"), @Result(name={"loginRequired"}, type="redirect", location="/loginRequired.action"), @Result(name={"norole"}, type="redirect", location="/main.action")})
@TilesDefinitions(value={@TilesDefinition(name="selectPrimaryRole.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Select User Role"), @TilesPutAttribute(name="body", value="/selectPrimaryRole.jsp"), @TilesPutAttribute(name="checkRole", value="false")}), @TilesDefinition(name="selectAcadSession.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Select Academic Session"), @TilesPutAttribute(name="body", value="/selectPrimaryRole.jsp"), @TilesPutAttribute(name="checkRole", value="false")})})
public class RoleListAction
extends UniTimeAction<RoleListForm> {
    private static final long serialVersionUID = -1366311288296904417L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String list;
    private String target;

    public String getList() {
        return this.list;
    }

    public void setList(String list) {
        this.list = list;
    }

    public String getTraget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    /*
     * WARNING - void declaration
     */
    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new RoleListForm();
            ((RoleListForm)this.form).reset();
        }
        if (this.target != null) {
            ((RoleListForm)this.form).setTarget(this.target);
        }
        UserContext user = null;
        try {
            user = (UserContext)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (user == null) {
            return "loginRequired";
        }
        if (user.getAuthorities().isEmpty()) {
            return "norole";
        }
        if (((RoleListForm)this.form).getAuthority() != null) {
            UserAuthority authority = user.getAuthority(((RoleListForm)this.form).getAuthority());
            if (authority != null) {
                void var5_10;
                user.setCurrentAuthority(authority);
                SessionAttribute[] sessionAttributeArray = SessionAttribute.values();
                int n = sessionAttributeArray.length;
                boolean bl = false;
                while (var5_10 < n) {
                    SessionAttribute s = sessionAttributeArray[var5_10];
                    this.sessionContext.removeAttribute(s);
                    ++var5_10;
                }
            }
            if (((RoleListForm)this.form).getTarget() != null && !((RoleListForm)this.form).getTarget().isEmpty()) {
                this.response.sendRedirect(((RoleListForm)this.form).getTarget());
                return null;
            }
            return "success";
        }
        UserAuthority authority = this.setupAuthorities(this.request, user);
        if (!"Y".equals(this.list) && authority != null) {
            user.setCurrentAuthority(authority);
            if (((RoleListForm)this.form).getTarget() != null && !((RoleListForm)this.form).getTarget().isEmpty()) {
                this.response.sendRedirect(((RoleListForm)this.form).getTarget());
                return null;
            }
            return "success";
        }
        HashSet<String> roles = new HashSet<String>();
        for (UserAuthority userAuthority : user.getAuthorities()) {
            roles.add(userAuthority.getRole());
        }
        switch (roles.size()) {
            case 0: {
                return "norole";
            }
            case 1: {
                return "getDefaultAcadSession";
            }
        }
        return "getUserSelectedRole";
    }

    /*
     * WARNING - void declaration
     */
    private UserAuthority setupAuthorities(HttpServletRequest request, UserContext user) {
        void var5_7;
        WebTable.setOrder(this.sessionContext, "roleLists.ord", request.getParameter("ord"), -2);
        HashSet<String> roles = new HashSet<String>();
        for (UserAuthority userAuthority : user.getAuthorities()) {
            roles.add(userAuthority.getRole());
        }
        WebTable table = new WebTable(4, roles.size() > 1 ? MSG.sectSelectUserRoleAndSession() : MSG.sectSelectAcademicSession(), "selectPrimaryRole.action?list=Y&ord=%%", new String[]{MSG.columnUserRole(), MSG.columnAcademicSession(), MSG.columnAcademicInitiative(), MSG.columnAcademicSessionStatus()}, new String[]{"left", "left", "left", "left"}, new boolean[]{true, true, true, true});
        boolean bl = false;
        UserAuthority firstAuthority = null;
        for (UserAuthority userAuthority : user.getAuthorities()) {
            Session session;
            Session session2 = session = userAuthority.getAcademicSession() == null ? null : (Session)SessionDAO.getInstance().get((Long)userAuthority.getAcademicSession().getQualifierId());
            if (session == null) continue;
            String onClick = "onClick=\"document.getElementById('authority').value='" + userAuthority.getAuthority() + "';document.getElementById('form').submit();\"";
            String bgColor = userAuthority.equals(user.getCurrentAuthority()) ? "rgb(168,187,225)" : null;
            table.addLine(onClick, new String[]{userAuthority.getLabel(), session.getAcademicYear() + " " + session.getAcademicTerm(), session.getAcademicInitiative(), session.getStatusType() == null ? "" : session.getStatusType().getLabel()}, new Comparable[]{new MultiComparable((Comparable)((Object)userAuthority.toString()), session.getSessionBeginDateTime(), (Comparable)((Object)session.getAcademicInitiative())), new MultiComparable(session.getSessionBeginDateTime(), (Comparable)((Object)session.getAcademicInitiative()), (Comparable)((Object)userAuthority.toString())), new MultiComparable((Comparable)((Object)session.getAcademicInitiative()), session.getSessionBeginDateTime(), (Comparable)((Object)userAuthority.toString())), new MultiComparable(Integer.valueOf(session.getStatusType() == null ? -1 : session.getStatusType().getOrd()), (Comparable)((Object)session.getAcademicInitiative()), session.getSessionBeginDateTime(), (Comparable)((Object)userAuthority.toString()))}).setBgColor(bgColor);
            if (firstAuthority == null) {
                firstAuthority = userAuthority;
            }
            ++var5_7;
        }
        if (user.getCurrentAuthority() == null && var5_7 == false) {
            table.addLine(new String[]{"<i><font color='red'>" + MSG.warnNoRoleForUser(user.getName() == null ? user.getUsername() : user.getName()) + "</font></i>", null, null, null}, null);
        }
        if (var5_7 == true && firstAuthority != null) {
            user.setCurrentAuthority(firstAuthority);
        }
        request.setAttribute(Roles.USER_ROLES_ATTR_NAME, (Object)table.printTable(WebTable.getOrder(this.sessionContext, "roleLists.ord")));
        return user.getCurrentAuthority();
    }
}

