/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.component;

import biweekly.ICalVersion;
import biweekly.component.VFreeBusy;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.property.FreeBusy;
import biweekly.property.ICalProperty;
import biweekly.util.ICalDate;
import biweekly.util.Period;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class VFreeBusyScribe
extends ICalComponentScribe<VFreeBusy> {
    public VFreeBusyScribe() {
        super(VFreeBusy.class, "VFREEBUSY");
    }

    @Override
    public List<ICalProperty> getProperties(VFreeBusy component) {
        List<ICalProperty> properties = super.getProperties(component);
        ArrayList<FreeBusy> fb = new ArrayList<FreeBusy>(component.getFreeBusy());
        if (fb.isEmpty()) {
            return properties;
        }
        Collections.sort(fb, new FreeBusyStartDateComparator());
        int index = 0;
        for (ICalProperty prop : properties) {
            if (prop instanceof FreeBusy) break;
            ++index;
        }
        properties = new ArrayList<ICalProperty>(properties);
        for (FreeBusy f : fb) {
            properties.remove(f);
            properties.add(index++, f);
        }
        return properties;
    }

    @Override
    protected VFreeBusy _newInstance() {
        return new VFreeBusy();
    }

    @Override
    public Set<ICalVersion> getSupportedVersions() {
        return EnumSet.of(ICalVersion.V2_0_DEPRECATED, ICalVersion.V2_0);
    }

    private class FreeBusyStartDateComparator
    implements Comparator<FreeBusy> {
        private FreeBusyStartDateComparator() {
        }

        @Override
        public int compare(FreeBusy one, FreeBusy two) {
            Date oneStart = this.getEarliestStartDate(one);
            Date twoStart = this.getEarliestStartDate(two);
            if (oneStart == null && twoStart == null) {
                return 0;
            }
            if (oneStart == null) {
                return 1;
            }
            if (twoStart == null) {
                return -1;
            }
            return oneStart.compareTo(twoStart);
        }

        private Date getEarliestStartDate(FreeBusy fb) {
            ICalDate earliestDate = null;
            for (Period period : fb.getValues()) {
                ICalDate startDate = period.getStartDate();
                if (startDate == null || earliestDate != null && earliestDate.compareTo(startDate) <= 0) continue;
                earliestDate = startDate;
            }
            return earliestDate;
        }
    }
}

