/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online;

import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.constraint.FixInitialAssignments;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.online.expectations.AvoidUnbalancedWhenNoExpectations;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.cpsolver.studentsct.online.expectations.PercentageOverExpected;

public class OnlineSectioningModel
extends StudentSectioningModel {
    private static Logger sLog = LogManager.getLogger(OnlineSectioningModel.class);
    private OverExpectedCriterion iOverExpectedCriterion;

    public OnlineSectioningModel(DataProperties properties) {
        this(properties, null);
        try {
            Class<?> overExpectedCriterionClass = Class.forName(properties.getProperty("OverExpectedCriterion.Class", AvoidUnbalancedWhenNoExpectations.class.getName()));
            this.iOverExpectedCriterion = (OverExpectedCriterion)overExpectedCriterionClass.getConstructor(DataProperties.class).newInstance(properties);
        }
        catch (Exception e) {
            sLog.error("Unable to create custom over-expected criterion (" + e.getMessage() + "), using default.", (Throwable)e);
            this.iOverExpectedCriterion = new PercentageOverExpected(properties);
        }
    }

    public OnlineSectioningModel(DataProperties config, OverExpectedCriterion criterion) {
        super(config);
        this.iOverExpectedCriterion = criterion;
        if (this.isMPP() && super.getKeepInitialAssignments()) {
            for (GlobalConstraint c : this.globalConstraints()) {
                if (!(c instanceof FixInitialAssignments)) continue;
                this.removeGlobalConstraint(c);
                break;
            }
        }
    }

    @Override
    public boolean getKeepInitialAssignments() {
        return false;
    }

    public OverExpectedCriterion getOverExpectedCriterion() {
        return this.iOverExpectedCriterion;
    }

    public void setOverExpectedCriterion(OverExpectedCriterion overExpectedCriterion) {
        this.iOverExpectedCriterion = overExpectedCriterion;
    }

    public double getOverExpected(Assignment<Request, Enrollment> assignment, Section section, Request request) {
        return this.getOverExpectedCriterion().getOverExpected(assignment, section, request);
    }

    public double getOverExpected(Assignment<Request, Enrollment> assignment, Enrollment[] enrollment, int index, Section section, Request request) {
        if (this.getOverExpectedCriterion() instanceof OverExpectedCriterion.HasContext) {
            return ((OverExpectedCriterion.HasContext)((Object)this.getOverExpectedCriterion())).getOverExpected(assignment, enrollment, index, section, request);
        }
        return this.getOverExpectedCriterion().getOverExpected(assignment, section, request);
    }

    public double getOverExpected(Assignment<Request, Enrollment> assignment, Enrollment selection, Enrollment value, Set<Enrollment> conflicts) {
        if (this.getOverExpectedCriterion() instanceof OverExpectedCriterion.HasContext) {
            return ((OverExpectedCriterion.HasContext)((Object)this.getOverExpectedCriterion())).getOverExpected(assignment, selection, value, conflicts);
        }
        if (selection == null || !selection.isCourseRequest()) {
            return 0.0;
        }
        double penalty = 0.0;
        for (Section section : selection.getSections()) {
            penalty += this.getOverExpectedCriterion().getOverExpected(assignment, section, selection.getRequest());
        }
        return penalty;
    }
}

