/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AbstractClassWithContext;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.CanInheritContext;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.RequestGroup;

public class Course
extends AbstractClassWithContext<Request, Enrollment, CourseContext>
implements CanInheritContext<Request, Enrollment, CourseContext> {
    private long iId = -1L;
    private String iSubjectArea = null;
    private String iCourseNumber = null;
    private Offering iOffering = null;
    private int iLimit = 0;
    private int iProjected = 0;
    private Set<CourseRequest> iRequests = Collections.synchronizedSet(new HashSet());
    private String iNote = null;
    private Set<RequestGroup> iRequestGroups = new HashSet<RequestGroup>();
    private String iCredit = null;
    private Float iCreditValue = null;
    private String iTitle = null;
    private String iType = null;

    public Course(long id, String subjectArea, String courseNumber, Offering offering) {
        this.iId = id;
        this.iSubjectArea = subjectArea;
        this.iCourseNumber = courseNumber;
        this.iOffering = offering;
        this.iOffering.getCourses().add(this);
    }

    public Course(long id, String subjectArea, String courseNumber, Offering offering, int limit, int projected) {
        this.iId = id;
        this.iSubjectArea = subjectArea;
        this.iCourseNumber = courseNumber;
        this.iOffering = offering;
        this.iOffering.getCourses().add(this);
        this.iLimit = limit;
        this.iProjected = projected;
    }

    public long getId() {
        return this.iId;
    }

    public String getSubjectArea() {
        return this.iSubjectArea;
    }

    public String getCourseNumber() {
        return this.iCourseNumber;
    }

    public String getName() {
        return this.iSubjectArea + " " + this.iCourseNumber;
    }

    public String toString() {
        return this.getName();
    }

    public Offering getOffering() {
        return this.iOffering;
    }

    public int getLimit() {
        return this.iLimit;
    }

    public void setLimit(int limit) {
        this.iLimit = limit;
    }

    public int getProjected() {
        return this.iProjected;
    }

    public void assigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        ((CourseContext)this.getContext(assignment)).assigned(assignment, enrollment);
    }

    public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        ((CourseContext)this.getContext(assignment)).unassigned(assignment, enrollment);
    }

    public Set<CourseRequest> getRequests() {
        return this.iRequests;
    }

    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Course)) {
            return false;
        }
        return this.getId() == ((Course)o).getId();
    }

    public int hashCode() {
        return (int)(this.iId ^ this.iId >>> 32);
    }

    @Override
    public Model<Request, Enrollment> getModel() {
        return this.getOffering().getModel();
    }

    public double getEnrollmentWeight(Assignment<Request, Enrollment> assignment, Request excludeRequest) {
        return ((CourseContext)this.getContext(assignment)).getEnrollmentWeight(assignment, excludeRequest);
    }

    public Set<Enrollment> getEnrollments(Assignment<Request, Enrollment> assignment) {
        return ((CourseContext)this.getContext(assignment)).getEnrollments();
    }

    public double getMaxEnrollmentWeight(Assignment<Request, Enrollment> assignment) {
        return ((CourseContext)this.getContext(assignment)).getMaxEnrollmentWeight();
    }

    public double getMinEnrollmentWeight(Assignment<Request, Enrollment> assignment) {
        return ((CourseContext)this.getContext(assignment)).getMinEnrollmentWeight();
    }

    public void addRequestGroup(RequestGroup group) {
        this.iRequestGroups.add(group);
    }

    public void removeRequestGroup(RequestGroup group) {
        this.iRequestGroups.remove(group);
    }

    public Set<RequestGroup> getRequestGroups() {
        return this.iRequestGroups;
    }

    public void setCredit(String credit) {
        this.iCredit = credit;
        if (this.iCreditValue == null && credit != null) {
            int split = credit.indexOf(124);
            String abbv = null;
            abbv = split >= 0 ? credit.substring(0, split) : credit;
            Matcher m = Pattern.compile("(^| )(\\d+\\.?\\d*)([,-]?(\\d+\\.?\\d*))?($| )").matcher(abbv);
            if (m.find()) {
                this.iCreditValue = Float.valueOf(Float.parseFloat(m.group(2)));
            }
        }
    }

    public String getCredit() {
        return this.iCredit;
    }

    public boolean hasCreditValue() {
        return this.iCreditValue != null;
    }

    public void setCreditValue(Float creditValue) {
        this.iCreditValue = creditValue;
    }

    public Float getCreditValue() {
        return this.iCreditValue;
    }

    @Override
    public CourseContext createAssignmentContext(Assignment<Request, Enrollment> assignment) {
        return new CourseContext(assignment);
    }

    @Override
    public CourseContext inheritAssignmentContext(Assignment<Request, Enrollment> assignment, CourseContext parentContext) {
        return new CourseContext(parentContext);
    }

    public double getOnlineBound() {
        double bound = 1.0;
        for (Config config : this.getOffering().getConfigs()) {
            int online = config.getNrOnline();
            if (online == 0) {
                return 0.0;
            }
            double factor = (double)online / (double)config.getSubparts().size();
            if (!(factor < bound)) continue;
            bound = factor;
        }
        return bound;
    }

    public double getArrHrsBound() {
        double bound = 1.0;
        for (Config config : this.getOffering().getConfigs()) {
            int arrHrs = config.getNrArrHours();
            if (arrHrs == 0) {
                return 0.0;
            }
            double factor = (double)arrHrs / (double)config.getSubparts().size();
            if (!(factor < bound)) continue;
            bound = factor;
        }
        return bound;
    }

    public double getPastBound() {
        double bound = 1.0;
        for (Config config : this.getOffering().getConfigs()) {
            int past = config.getNrPast();
            if (past == 0) {
                return 0.0;
            }
            double factor = (double)past / (double)config.getSubparts().size();
            if (!(factor < bound)) continue;
            bound = factor;
        }
        return bound;
    }

    public String getTitle() {
        return this.iTitle;
    }

    public void setTitle(String title) {
        this.iTitle = title;
    }

    public String getType() {
        return this.iType;
    }

    public void setType(String type) {
        this.iType = type;
    }

    public class CourseContext
    implements AssignmentConstraintContext<Request, Enrollment> {
        private double iEnrollmentWeight = 0.0;
        private Set<Enrollment> iEnrollments = null;
        private double iMaxEnrollmentWeight = 0.0;
        private double iMinEnrollmentWeight = 0.0;
        private boolean iReadOnly = false;

        public CourseContext(Assignment<Request, Enrollment> assignment) {
            this.iEnrollments = new HashSet<Enrollment>();
            for (CourseRequest request : Course.this.getRequests()) {
                Enrollment enrollment = assignment.getValue(request);
                if (enrollment == null || !Course.this.equals(enrollment.getCourse())) continue;
                this.assigned(assignment, enrollment);
            }
        }

        public CourseContext(CourseContext parent) {
            this.iEnrollmentWeight = parent.iEnrollmentWeight;
            this.iMinEnrollmentWeight = parent.iMinEnrollmentWeight;
            this.iMaxEnrollmentWeight = parent.iMaxEnrollmentWeight;
            this.iEnrollments = parent.iEnrollments;
            this.iReadOnly = true;
        }

        @Override
        public void assigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            if (this.iReadOnly) {
                this.iEnrollments = new HashSet<Enrollment>(this.iEnrollments);
                this.iReadOnly = false;
            }
            if (this.iEnrollments.isEmpty()) {
                this.iMinEnrollmentWeight = this.iMaxEnrollmentWeight = enrollment.getRequest().getWeight();
            } else {
                this.iMaxEnrollmentWeight = Math.max(this.iMaxEnrollmentWeight, enrollment.getRequest().getWeight());
                this.iMinEnrollmentWeight = Math.min(this.iMinEnrollmentWeight, enrollment.getRequest().getWeight());
            }
            if (this.iEnrollments.add(enrollment) && (enrollment.getReservation() == null || !enrollment.getReservation().canBatchAssignOverLimit())) {
                this.iEnrollmentWeight += enrollment.getRequest().getWeight();
            }
        }

        @Override
        public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            if (this.iReadOnly) {
                this.iEnrollments = new HashSet<Enrollment>(this.iEnrollments);
                this.iReadOnly = false;
            }
            if (this.iEnrollments.remove(enrollment) && (enrollment.getReservation() == null || !enrollment.getReservation().canBatchAssignOverLimit())) {
                this.iEnrollmentWeight -= enrollment.getRequest().getWeight();
            }
            if (this.iEnrollments.isEmpty()) {
                this.iMaxEnrollmentWeight = 0.0;
                this.iMinEnrollmentWeight = 0.0;
            } else if (this.iMinEnrollmentWeight != this.iMaxEnrollmentWeight) {
                if (this.iMinEnrollmentWeight == enrollment.getRequest().getWeight()) {
                    double newMinEnrollmentWeight = Double.MAX_VALUE;
                    for (Enrollment e : this.iEnrollments) {
                        if (e.getRequest().getWeight() == this.iMinEnrollmentWeight) {
                            newMinEnrollmentWeight = this.iMinEnrollmentWeight;
                            break;
                        }
                        newMinEnrollmentWeight = Math.min(newMinEnrollmentWeight, e.getRequest().getWeight());
                    }
                    this.iMinEnrollmentWeight = newMinEnrollmentWeight;
                }
                if (this.iMaxEnrollmentWeight == enrollment.getRequest().getWeight()) {
                    double newMaxEnrollmentWeight = Double.MIN_VALUE;
                    for (Enrollment e : this.iEnrollments) {
                        if (e.getRequest().getWeight() == this.iMaxEnrollmentWeight) {
                            newMaxEnrollmentWeight = this.iMaxEnrollmentWeight;
                            break;
                        }
                        newMaxEnrollmentWeight = Math.max(newMaxEnrollmentWeight, e.getRequest().getWeight());
                    }
                    this.iMaxEnrollmentWeight = newMaxEnrollmentWeight;
                }
            }
        }

        public double getEnrollmentWeight(Assignment<Request, Enrollment> assignment, Request excludeRequest) {
            Enrollment enrollment;
            double weight = this.iEnrollmentWeight;
            if (excludeRequest != null && (enrollment = assignment.getValue(excludeRequest)) != null && this.iEnrollments.contains(enrollment) && (enrollment.getReservation() == null || !enrollment.getReservation().canBatchAssignOverLimit())) {
                weight -= excludeRequest.getWeight();
            }
            return weight;
        }

        public Set<Enrollment> getEnrollments() {
            return this.iEnrollments;
        }

        public double getMaxEnrollmentWeight() {
            return this.iMaxEnrollmentWeight;
        }

        public double getMinEnrollmentWeight() {
            return this.iMinEnrollmentWeight;
        }
    }
}

