/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.constraint;

import java.util.ArrayList;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.constraint.ConfigLimit;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class CourseLimit
extends GlobalConstraint<Request, Enrollment> {
    private static double sNominalWeight = 1.0E-5;
    private boolean iPreferDummyStudents = false;
    private boolean iPreferPriorityStudents = true;

    public CourseLimit(DataProperties cfg) {
        this.iPreferDummyStudents = cfg.getPropertyBoolean("CourseLimit.PreferDummyStudents", false);
        this.iPreferPriorityStudents = cfg.getPropertyBoolean("Sectioning.PriorityStudentsFirstSelection.AllIn", true);
    }

    public static double getEnrollmentWeight(Assignment<Request, Enrollment> assignment, Course course, Request request) {
        return course.getEnrollmentWeight(assignment, request) + request.getWeight() - Math.max(course.getMaxEnrollmentWeight(assignment), request.getWeight()) + sNominalWeight;
    }

    @Override
    public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<Enrollment> conflicts) {
        if (enrollment.getReservation() != null && enrollment.getReservation().canBatchAssignOverLimit()) {
            return;
        }
        Course course = enrollment.getCourse();
        if (course == null) {
            return;
        }
        if (enrollment.getSections() == null || enrollment.getSections().isEmpty()) {
            return;
        }
        if (course.getLimit() < 0) {
            return;
        }
        double enrlWeight = CourseLimit.getEnrollmentWeight(assignment, course, enrollment.getRequest());
        if (enrlWeight <= (double)course.getLimit()) {
            return;
        }
        ArrayList<Enrollment> adepts = new ArrayList<Enrollment>(course.getEnrollments(assignment).size());
        for (Enrollment e : course.getEnrollments(assignment)) {
            if (e.getRequest().equals(enrollment.getRequest()) || e.getReservation() != null && e.getReservation().canBatchAssignOverLimit()) continue;
            if (conflicts.contains(e)) {
                enrlWeight -= e.getRequest().getWeight();
                continue;
            }
            adepts.add(e);
        }
        while (enrlWeight > (double)course.getLimit()) {
            if (adepts.isEmpty()) {
                conflicts.add(enrollment);
                break;
            }
            Enrollment conflict = new ConfigLimit.Adepts(this.iPreferDummyStudents, this.iPreferPriorityStudents, adepts, assignment).get();
            adepts.remove(conflict);
            enrlWeight -= conflict.getRequest().getWeight();
            conflicts.add(conflict);
        }
    }

    @Override
    public boolean inConflict(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        if (enrollment.getReservation() != null && enrollment.getReservation().canBatchAssignOverLimit()) {
            return false;
        }
        Course course = enrollment.getCourse();
        if (course == null) {
            return false;
        }
        if (enrollment.getSections() == null || enrollment.getSections().isEmpty()) {
            return false;
        }
        if (course.getLimit() < 0) {
            return false;
        }
        double enrlWeight = CourseLimit.getEnrollmentWeight(assignment, course, enrollment.getRequest());
        return enrlWeight > (double)course.getLimit();
    }

    public String toString() {
        return "CourseLimit";
    }
}

