/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.constraint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class ConfigLimit
extends GlobalConstraint<Request, Enrollment> {
    private static double sNominalWeight = 1.0E-5;
    private boolean iPreferDummyStudents = false;
    private boolean iPreferPriorityStudents = true;

    public ConfigLimit(DataProperties cfg) {
        this.iPreferDummyStudents = cfg.getPropertyBoolean("ConfigLimit.PreferDummyStudents", false);
        this.iPreferPriorityStudents = cfg.getPropertyBoolean("Sectioning.PriorityStudentsFirstSelection.AllIn", true);
    }

    public static double getEnrollmentWeight(Assignment<Request, Enrollment> assignment, Config config, Request request) {
        return config.getEnrollmentWeight(assignment, request) + request.getWeight() - Math.max(config.getMaxEnrollmentWeight(assignment), request.getWeight()) + sNominalWeight;
    }

    @Override
    public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<Enrollment> conflicts) {
        if (enrollment.getReservation() != null && enrollment.getReservation().canBatchAssignOverLimit()) {
            return;
        }
        Config config = enrollment.getConfig();
        if (config == null) {
            return;
        }
        if (enrollment.getSections() == null || enrollment.getSections().isEmpty()) {
            return;
        }
        if (config.getLimit() < 0) {
            return;
        }
        double enrlWeight = ConfigLimit.getEnrollmentWeight(assignment, config, enrollment.getRequest());
        if (enrlWeight <= (double)config.getLimit()) {
            return;
        }
        ArrayList<Enrollment> adepts = new ArrayList<Enrollment>(config.getEnrollments(assignment).size());
        for (Enrollment e : config.getEnrollments(assignment)) {
            if (e.getRequest().equals(enrollment.getRequest()) || e.getReservation() != null && e.getReservation().canBatchAssignOverLimit()) continue;
            if (conflicts.contains(e)) {
                enrlWeight -= e.getRequest().getWeight();
                continue;
            }
            adepts.add(e);
        }
        while (enrlWeight > (double)config.getLimit()) {
            if (adepts.isEmpty()) {
                conflicts.add(enrollment);
                return;
            }
            Enrollment conflict = new Adepts(this.iPreferDummyStudents, this.iPreferPriorityStudents, adepts, assignment).get();
            adepts.remove(conflict);
            enrlWeight -= conflict.getRequest().getWeight();
            conflicts.add(conflict);
        }
    }

    @Override
    public boolean inConflict(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        if (enrollment.getReservation() != null && enrollment.getReservation().canBatchAssignOverLimit()) {
            return false;
        }
        Config config = enrollment.getConfig();
        if (config == null) {
            return false;
        }
        if (enrollment.getSections() == null || enrollment.getSections().isEmpty()) {
            return false;
        }
        if (config.getLimit() < 0) {
            return false;
        }
        double enrlWeight = ConfigLimit.getEnrollmentWeight(assignment, config, enrollment.getRequest());
        return enrlWeight > (double)config.getLimit();
    }

    public String toString() {
        return "ConfigLimit";
    }

    static class Adepts {
        private ArrayList<Enrollment> iEnrollments;
        private double iValue;
        private boolean iDummy;
        private Student.StudentPriority iPriority;
        private Request.RequestPriority iRequestPriority;
        private boolean iReservation;
        private boolean iConsiderDummy;
        private boolean iPriorityFirst;

        public Adepts(boolean preferDummy, boolean priorityFirst) {
            this.iConsiderDummy = preferDummy;
            this.iPriorityFirst = priorityFirst;
            this.iEnrollments = new ArrayList();
        }

        public Adepts(boolean preferDummy, boolean priorityFirst, int size) {
            this.iConsiderDummy = preferDummy;
            this.iPriorityFirst = priorityFirst;
            this.iEnrollments = new ArrayList(size);
        }

        public Adepts(boolean preferDummy, boolean priorityFirst, Collection<Enrollment> adepts, Assignment<Request, Enrollment> assignment) {
            this.iConsiderDummy = preferDummy;
            this.iPriorityFirst = priorityFirst;
            this.iEnrollments = new ArrayList(adepts.size());
            for (Enrollment adept : adepts) {
                this.add(adept, assignment);
            }
        }

        public void add(Enrollment enrollment, Assignment<Request, Enrollment> assignment) {
            double value = enrollment.toDouble(assignment, false);
            boolean dummy = enrollment.getStudent().isDummy();
            Student.StudentPriority priority = enrollment.getStudent().getPriority();
            boolean reservation = enrollment.getReservation() != null;
            Request.RequestPriority rp = enrollment.getRequest().getRequestPriority();
            if (this.iEnrollments.isEmpty()) {
                this.iValue = value;
                this.iDummy = dummy;
                this.iPriority = priority;
                this.iRequestPriority = rp;
                this.iReservation = reservation;
                this.iEnrollments.add(enrollment);
                return;
            }
            if (this.iConsiderDummy && this.iDummy != dummy) {
                if (!dummy) {
                    return;
                }
                this.iEnrollments.clear();
                this.iValue = value;
                this.iDummy = dummy;
                this.iPriority = priority;
                this.iRequestPriority = rp;
                this.iReservation = reservation;
                this.iEnrollments.add(enrollment);
                return;
            }
            if (this.iPriorityFirst) {
                if (this.iPriority != priority) {
                    if (priority.ordinal() < this.iPriority.ordinal()) {
                        return;
                    }
                    this.iEnrollments.clear();
                    this.iValue = value;
                    this.iDummy = dummy;
                    this.iPriority = priority;
                    this.iRequestPriority = rp;
                    this.iReservation = reservation;
                    this.iEnrollments.add(enrollment);
                    return;
                }
                if (this.iRequestPriority != rp) {
                    if (rp.ordinal() < this.iRequestPriority.ordinal()) {
                        return;
                    }
                    this.iEnrollments.clear();
                    this.iValue = value;
                    this.iDummy = dummy;
                    this.iPriority = priority;
                    this.iRequestPriority = rp;
                    this.iReservation = reservation;
                    this.iEnrollments.add(enrollment);
                    return;
                }
            } else {
                if (this.iRequestPriority != rp) {
                    if (rp.ordinal() < this.iRequestPriority.ordinal()) {
                        return;
                    }
                    this.iEnrollments.clear();
                    this.iValue = value;
                    this.iDummy = dummy;
                    this.iPriority = priority;
                    this.iRequestPriority = rp;
                    this.iReservation = reservation;
                    this.iEnrollments.add(enrollment);
                    return;
                }
                if (this.iPriority != priority) {
                    if (priority.ordinal() < this.iPriority.ordinal()) {
                        return;
                    }
                    this.iEnrollments.clear();
                    this.iValue = value;
                    this.iDummy = dummy;
                    this.iPriority = priority;
                    this.iRequestPriority = rp;
                    this.iReservation = reservation;
                    this.iEnrollments.add(enrollment);
                    return;
                }
            }
            if (this.iReservation != reservation) {
                if (reservation) {
                    return;
                }
                this.iEnrollments.clear();
                this.iValue = value;
                this.iDummy = dummy;
                this.iPriority = priority;
                this.iRequestPriority = rp;
                this.iReservation = reservation;
                this.iEnrollments.add(enrollment);
                return;
            }
            if (value > this.iValue) {
                this.iEnrollments.clear();
                this.iValue = value;
                this.iDummy = dummy;
                this.iPriority = priority;
                this.iRequestPriority = rp;
                this.iReservation = reservation;
                this.iEnrollments.add(enrollment);
            } else if (value == this.iValue) {
                this.iEnrollments.add(enrollment);
            }
        }

        public Enrollment get() {
            if (this.iEnrollments.isEmpty()) {
                return null;
            }
            return ToolBox.random(this.iEnrollments);
        }

        public boolean isEmpty() {
            return this.iEnrollments.isEmpty();
        }
    }
}

