/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.test;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.TreeSet;
import org.cpsolver.coursett.Constants;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.instructor.Test;
import org.cpsolver.instructor.model.Attribute;
import org.cpsolver.instructor.model.Course;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.Preference;
import org.cpsolver.instructor.model.Section;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;

public class ChmTest
extends Test {
    public ChmTest(DataProperties properties) {
        super(properties);
    }

    public String getAttributes(TeachingRequest req, String type) {
        TreeSet<String> attributes = new TreeSet<String>();
        for (Preference<Attribute> attribute : req.getAttributePreferences()) {
            if (!attribute.getTarget().getType().getTypeName().equals(type)) continue;
            attributes.add(attribute.getTarget().getAttributeName());
        }
        StringBuffer s = new StringBuffer();
        for (String attribute : attributes) {
            if (s.length() > 0) {
                s.append(",");
            }
            s.append(attribute);
        }
        return s.toString();
    }

    public String getAttributes(Instructor instructor, String type) {
        TreeSet<String> attributes = new TreeSet<String>();
        for (Attribute attribute : instructor.getAttributes()) {
            if (!attribute.getType().getTypeName().equals(type)) continue;
            attributes.add(attribute.getAttributeName());
        }
        StringBuffer s = new StringBuffer();
        if ("Qualification".equals(type)) {
            for (Preference preference : instructor.getCoursePreferences()) {
                attributes.remove(((Course)preference.getTarget()).getCourseName().substring(4));
            }
        }
        for (String string : attributes) {
            if (s.length() > 0) {
                s.append(",");
            }
            s.append(string);
        }
        return s.toString();
    }

    public String getCoursePrefs(Instructor instructor) {
        TreeSet<String> attributes = new TreeSet<String>();
        for (Preference<Course> p : instructor.getCoursePreferences()) {
            attributes.add(p.getTarget().getCourseName().substring(4));
        }
        StringBuffer s = new StringBuffer();
        for (String attribute : attributes) {
            if (s.length() > 0) {
                s.append(",");
            }
            s.append(attribute);
        }
        return s.toString();
    }

    public String getCoursePreference(TeachingRequest req, Instructor instructor) {
        Preference<Course> p = instructor.getCoursePreference(req.getCourse());
        if (p.getPreference() == 0) {
            return "";
        }
        String pref = Constants.preferenceLevel2preference(p.getPreference());
        if ("R".equals(pref)) {
            return "Yes (SUPER)";
        }
        if ("-2".equals(pref)) {
            return "Yes";
        }
        if ("-1".equals(pref)) {
            return "Organic Lab";
        }
        return pref;
    }

    public String getAttributes(TeachingRequest req, Instructor instructor, String type) {
        TreeSet<String> attributes = new TreeSet<String>();
        for (Preference<Attribute> attribute : req.getAttributePreferences()) {
            if (!instructor.getAttributes().contains(attribute.getTarget()) || !attribute.getTarget().getType().getTypeName().equals(type)) continue;
            attributes.add(attribute.getTarget().getAttributeName());
        }
        StringBuffer s = new StringBuffer();
        for (String attribute : attributes) {
            if (s.length() > 0) {
                s.append(",");
            }
            s.append(attribute);
        }
        if (attributes.isEmpty()) {
            s.append("no match");
        }
        return s.toString();
    }

    @Override
    protected void generateReports(File dir, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) throws IOException {
        PrintWriter out = new PrintWriter(new File(dir, "solution-assignments.csv"));
        out.println("Course,Sections,Time,Room,Skill,Qualification,Performance,Load,Student,Name,Not Available,Max Load,Skill,Qualification,Performance,Requested");
        for (TeachingRequest.Variable request : this.variables()) {
            out.print(request.getCourse().getCourseName());
            String sect = "";
            String time = "";
            String room = "";
            if (request.getId() < 0L) {
                out.print(",\"SUPER\",,");
            } else {
                for (Section section : request.getSections()) {
                    if (!sect.isEmpty()) {
                        sect = sect + ", ";
                        time = time + ", ";
                        room = room + ", ";
                    }
                    sect = sect + (section.isCommon() ? "(" : "") + section.getSectionType() + " " + section.getExternalId() + (section.isCommon() ? ")" : "");
                    time = time + (section.getTime() == null ? "-" : section.getTime().getDayHeader() + " " + section.getTime().getStartTimeHeader(true) + "-" + section.getTime().getEndTimeHeader(true));
                    room = room + (section.getRoom() == null ? "-" : section.getRoom());
                }
                out.print(",\"" + sect + "\",\"" + time + "\",\"" + room + "\"");
            }
            out.print(",\"" + this.getAttributes(request.getRequest(), "Skill") + "\"");
            out.print(",\"" + this.getAttributes(request.getRequest(), "Qualification") + "\"");
            out.print(",\"" + this.getAttributes(request.getRequest(), "Performance Level") + "\"");
            out.print("," + new DecimalFormat("0.0").format(request.getRequest().getLoad()));
            TeachingAssignment ta = assignment.getValue(request);
            if (ta != null) {
                Instructor instructor = ta.getInstructor();
                out.print("," + instructor.getExternalId());
                out.print(",\"" + instructor.getName() + "\"");
                out.print(",\"" + instructor.getAvailable() + "\"");
                out.print("," + new DecimalFormat("0.0").format(instructor.getMaxLoad()));
                out.print(",\"" + this.getAttributes(request.getRequest(), instructor, "Skill") + "\"");
                out.print(",\"" + this.getAttributes(request.getRequest(), instructor, "Qualification") + "\"");
                out.print(",\"" + this.getAttributes(request.getRequest(), instructor, "Performance Level") + "\"");
                out.print(",\"" + this.getCoursePreference(request.getRequest(), instructor) + "\"");
            }
            out.println();
        }
        out.flush();
        out.close();
        out = new PrintWriter(new File(dir, "solution-students.csv"));
        out.println("Student,Name,Not Available,Skill,Qualification,Performance,Requests,Max Load,Assigned Load,1st Assignment,2nd Assignment,Skill,Qualification,Performance,Requested");
        for (Instructor instructor : this.getInstructors()) {
            out.print(instructor.getExternalId());
            out.print(",\"" + instructor.getName() + "\"");
            out.print(",\"" + instructor.getAvailable() + "\"");
            out.print(",\"" + this.getAttributes(instructor, "Skill") + "\"");
            out.print(",\"" + this.getAttributes(instructor, "Qualification") + "\"");
            out.print(",\"" + this.getAttributes(instructor, "Performance Level") + "\"");
            out.print(",\"" + this.getCoursePrefs(instructor) + "\"");
            out.print("," + new DecimalFormat("0.0").format(instructor.getMaxLoad()));
            Instructor.Context context = (Instructor.Context)instructor.getContext(assignment);
            out.print("," + new DecimalFormat("0.0").format(context.getLoad()));
            TeachingRequest req = null;
            for (TeachingAssignment ta : context.getAssignments()) {
                String sect = "";
                if (req == null || req.getRequestId() < 0L) {
                    req = ((TeachingRequest.Variable)ta.variable()).getRequest();
                }
                if (((TeachingRequest.Variable)ta.variable()).getId() < 0L) {
                    sect = "SUPER";
                } else {
                    for (Section section : ((TeachingRequest.Variable)ta.variable()).getSections()) {
                        if (section.isCommon() && section.isAllowOverlap()) continue;
                        sect = sect + (sect.isEmpty() ? "" : ", ") + (section.isCommon() ? "(" : "") + section.getSectionType() + " " + section.getExternalId() + (section.getTime() == null ? "" : " " + section.getTime().getDayHeader() + " " + section.getTime().getStartTimeHeader(true) + "-" + section.getTime().getEndTimeHeader(true)) + (section.isCommon() ? ")" : "");
                    }
                }
                out.print(",\"" + ((TeachingRequest.Variable)ta.variable()).getCourse() + " " + sect + "\"");
            }
            if (req != null) {
                for (int i = context.getAssignments().size(); i < 2; ++i) {
                    out.print(",");
                }
                out.print(",\"" + this.getAttributes(req, instructor, "Skill") + "\"");
                out.print(",\"" + this.getAttributes(req, instructor, "Qualification") + "\"");
                out.print(",\"" + this.getAttributes(req, instructor, "Performance Level") + "\"");
                out.print(",\"" + this.getCoursePreference(req, instructor) + "\"");
            }
            out.println();
        }
        out.flush();
        out.close();
    }

    public static void main(String[] args) throws Exception {
        DataProperties config = new DataProperties();
        config.load(ChmTest.class.getClass().getResourceAsStream("/org/cpsolver/instructor/test/chm.properties"));
        config.putAll((Map<?, ?>)System.getProperties());
        ToolBox.configureLogging();
        new ChmTest(config).execute();
    }
}

