/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;

public abstract class InstructorSchedulingCriterion
extends AbstractCriterion<TeachingRequest.Variable, TeachingAssignment> {
    @Override
    public void getInfo(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Map<String, String> info) {
        double val = this.getValue(assignment);
        double[] bounds = this.getBounds(assignment);
        if (bounds[0] <= val && val <= bounds[1] && bounds[0] < bounds[1]) {
            info.put(this.getName(), this.getPerc(val, bounds[0], bounds[1]) + "% (" + sDoubleFormat.format(val) + ")");
        } else if (bounds[1] <= val && val <= bounds[0] && bounds[1] < bounds[0]) {
            info.put(this.getName(), this.getPercRev(val, bounds[1], bounds[0]) + "% (" + sDoubleFormat.format(val) + ")");
        } else if (bounds[0] != val || val != bounds[1]) {
            info.put(this.getName(), sDoubleFormat.format(val));
        }
    }

    @Override
    public void getInfo(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Map<String, String> info, Collection<TeachingRequest.Variable> variables) {
        double val = this.getValue(assignment, variables);
        double[] bounds = this.getBounds(assignment, variables);
        if (bounds[0] <= val && val <= bounds[1] && bounds[0] < bounds[1]) {
            info.put(this.getName(), this.getPerc(val, bounds[0], bounds[1]) + "% (" + sDoubleFormat.format(val) + ")");
        } else if (bounds[1] <= val && val <= bounds[0] && bounds[1] < bounds[0]) {
            info.put(this.getName(), this.getPercRev(val, bounds[1], bounds[0]) + "% (" + sDoubleFormat.format(val) + ")");
        } else if (bounds[0] != val || val != bounds[1]) {
            info.put(this.getName(), sDoubleFormat.format(val));
        }
    }

    public Set<Instructor> getInstructors(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Collection<TeachingRequest.Variable> variables) {
        HashSet<Instructor> instructors = new HashSet<Instructor>();
        for (TeachingRequest.Variable req : variables) {
            for (TeachingAssignment ta : req.values(assignment)) {
                instructors.add(ta.getInstructor());
            }
        }
        return instructors;
    }

    public Set<Instructor> getAssignedInstructors(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Collection<TeachingRequest.Variable> variables) {
        HashSet<Instructor> instructors = new HashSet<Instructor>();
        for (TeachingRequest.Variable req : variables) {
            TeachingAssignment ta = assignment.getValue(req);
            if (ta == null) continue;
            instructors.add(ta.getInstructor());
        }
        return instructors;
    }
}

