/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.criteria;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.instructor.criteria.InstructorSchedulingCriterion;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.InstructorSchedulingModel;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;

public class DifferentLecture
extends InstructorSchedulingCriterion {
    public DifferentLecture() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1000.0;
    }

    @Override
    public double getValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
        return value.getInstructor().differentLectures(assignment, value);
    }

    @Override
    public double getValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Collection<TeachingRequest.Variable> variables) {
        double value = 0.0;
        for (Instructor instructor : this.getAssignedInstructors(assignment, variables)) {
            value += ((Instructor.Context)instructor.getContext(assignment)).countDifferentLectures();
        }
        return value;
    }

    @Override
    protected double[] computeBounds(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        return new double[]{0.0, ((InstructorSchedulingModel)this.getModel()).getInstructors().size()};
    }

    @Override
    public double[] getBounds(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Collection<TeachingRequest.Variable> variables) {
        return new double[]{0.0, this.getInstructors(assignment, variables).size()};
    }

    @Override
    public String getAbbreviation() {
        return "DiffLecture";
    }

    @Override
    public void getInfo(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Map<String, String> info) {
        double val = this.getValue(assignment);
        double[] bounds = this.getBounds(assignment);
        if (bounds[0] <= val && val <= bounds[1] && bounds[0] < bounds[1]) {
            info.put("Same Lecture", this.getPerc(val, bounds[0], bounds[1]) + "% (" + sDoubleFormat.format(bounds[1] - val) + ")");
        }
    }

    @Override
    public void getInfo(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Map<String, String> info, Collection<TeachingRequest.Variable> variables) {
        double val = this.getValue(assignment, variables);
        double[] bounds = this.getBounds(assignment, variables);
        if (bounds[0] <= val && val <= bounds[1] && bounds[0] < bounds[1]) {
            info.put("Same Lecture", this.getPerc(val, bounds[0], bounds[1]) + "% (" + sDoubleFormat.format(bounds[1] - val) + ")");
        }
    }
}

