/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.util;

import java.io.File;
import java.io.PrintWriter;
import org.cpsolver.ifs.util.CSVFile;

public class Csv2Tex {
    public static void main(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                int j;
                File file = new File(args[i]);
                String name = file.getName();
                if (name.contains(".")) {
                    name = name.substring(0, name.indexOf(46));
                }
                CSVFile csv = new CSVFile(file);
                PrintWriter pw = new PrintWriter(new File(file.getParentFile(), name + ".txt"));
                pw.println("\\begin{table}[htb]");
                pw.println("\\renewcommand{\\arraystretch}{1.2}");
                String t = "l|";
                for (j = 1; j < csv.getHeader().size(); ++j) {
                    t = t + "c";
                }
                pw.println("\\begin{tabular}{" + t + "} \\hline \\hline");
                for (j = 0; j < csv.getHeader().size(); ++j) {
                    if (j > 0) {
                        pw.print(" \\ & \\ ");
                    }
                    pw.print(csv.getHeader().getField(j).toString());
                }
                pw.println(" \\ \\\\ \\hline");
                for (CSVFile.CSVLine line : csv.getLines()) {
                    for (int j2 = 0; j2 < line.size(); ++j2) {
                        if (j2 == 0) {
                            pw.print(line.getField(j2));
                            continue;
                        }
                        pw.print(" & " + (line.getField(j2) == null || line.getField(j2).isEmpty() ? "-" : "$" + line.getField(j2).toString().replace("%", "\\%") + "$"));
                    }
                    pw.println(" \\\\");
                }
                pw.println("\\hline \\hline");
                pw.println("\\end{tabular}");
                pw.println("\\caption{FIXME: Add caption here.}");
                pw.println("\\label{tab:" + name.toLowerCase() + "}");
                pw.println("\\end{table}");
                pw.flush();
                pw.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

