/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.model;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public abstract class LazyNeighbour<V extends Variable<V, T>, T extends Value<V, T>>
implements Neighbour<V, T> {
    private LazyNeighbourAcceptanceCriterion<V, T> iCriterion = null;

    public void setAcceptanceCriterion(LazyNeighbourAcceptanceCriterion<V, T> criterion) {
        this.iCriterion = criterion;
    }

    public LazyNeighbourAcceptanceCriterion<V, T> getAcceptanceCriterion() {
        return this.iCriterion;
    }

    @Override
    public void assign(Assignment<V, T> assignment, long iteration) {
        double before = this.getModel().getTotalValue(assignment);
        this.doAssign(assignment, iteration);
        double after = this.getModel().getTotalValue(assignment);
        if (!this.iCriterion.accept(assignment, this, after - before)) {
            this.undoAssign(assignment, iteration);
        }
    }

    @Override
    public double value(Assignment<V, T> assignment) {
        return -1.0;
    }

    protected abstract void doAssign(Assignment<V, T> var1, long var2);

    protected abstract void undoAssign(Assignment<V, T> var1, long var2);

    public abstract Model<V, T> getModel();

    public static interface LazyNeighbourAcceptanceCriterion<V extends Variable<V, T>, T extends Value<V, T>> {
        public boolean accept(Assignment<V, T> var1, LazyNeighbour<V, T> var2, double var3);
    }
}

