/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.ExtensionWithContext;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;

public class MacRevised<V extends Variable<V, T>, T extends Value<V, T>>
extends ExtensionWithContext<V, T, NoGood> {
    private static Logger sLogger = LogManager.getLogger(MacRevised.class);
    private boolean iDbt = false;
    private Progress iProgress;
    protected List<Constraint<V, T>> iConstraints = null;
    protected long iIteration = 0L;

    public MacRevised(Solver<V, T> solver, DataProperties properties) {
        super(solver, properties);
        this.iDbt = properties.getPropertyBoolean("MacRevised.Dbt", false);
    }

    public void addConstraint(Constraint<V, T> constraint) {
        if (this.iConstraints == null) {
            this.iConstraints = new ArrayList<Constraint<V, T>>();
        }
        this.iConstraints.add(constraint);
    }

    public boolean contains(Constraint<V, T> constraint) {
        if (this.iConstraints == null) {
            return true;
        }
        return this.iConstraints.contains(constraint);
    }

    @Override
    public void beforeAssigned(Assignment<V, T> assignment, long iteration, T value) {
        if (value == null) {
            return;
        }
        sLogger.debug("Before assign " + ((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName());
        this.iIteration = iteration;
        NoGood context = (NoGood)this.getContext(assignment);
        while (!context.isGood(value) && !context.noGood(value).isEmpty()) {
            if (this.iDbt) {
                sLogger.warn("Going to assign a no-good value " + value + " (noGood:" + context.noGood(value) + ").");
            }
            Value noGoodValue = (Value)context.noGood(value).iterator().next();
            assignment.unassign(iteration, noGoodValue.variable());
        }
        if (!context.isGood(value)) {
            sLogger.warn("Going to assign a bad value " + value + " with empty no-good.");
        }
    }

    @Override
    public void afterAssigned(Assignment<V, T> assignment, long iteration, T value) {
        sLogger.debug("After assign " + ((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName());
        this.iIteration = iteration;
        NoGood context = (NoGood)this.getContext(assignment);
        if (!context.isGood(value)) {
            sLogger.warn(((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName() + " -- not good value assigned (noGood:" + context.noGood(value) + ")");
            context.setGood(value);
        }
        HashSet<T> noGood = new HashSet<T>(1);
        noGood.add(value);
        ArrayList<Value> queue = new ArrayList<Value>();
        for (Value anotherValue : ((Variable)((Value)value).variable()).values(assignment)) {
            if (anotherValue.equals(value) || !context.isGood(anotherValue)) continue;
            context.setNoGood(anotherValue, noGood);
            queue.add(anotherValue);
        }
        context.propagate(assignment, queue);
    }

    @Override
    public void afterUnassigned(Assignment<V, T> assignment, long iteration, T value) {
        sLogger.debug("After unassign " + ((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName());
        this.iIteration = iteration;
        NoGood context = (NoGood)this.getContext(assignment);
        if (!context.isGood(value)) {
            sLogger.error(((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName() + " -- not good value unassigned (noGood:" + context.noGood(value) + ")");
        }
        ArrayList back = new ArrayList(context.supportValues(((Value)value).variable()));
        for (Value aValue : back) {
            T current = assignment.getValue(aValue.variable());
            if (current != null) {
                HashSet<T> noGood = new HashSet<T>(1);
                noGood.add(current);
                context.setNoGood(aValue, noGood);
                continue;
            }
            context.setGood(aValue);
        }
        ArrayList<Value> queue = new ArrayList<Value>();
        for (Value aValue : back) {
            if (context.isGood(aValue) && !context.revise(assignment, aValue)) continue;
            queue.add(aValue);
        }
        context.propagate(assignment, queue);
    }

    @Override
    public boolean init(Solver<V, T> solver) {
        return true;
    }

    private String expl2str(Set<T> expl) {
        StringBuffer sb = new StringBuffer("[");
        Iterator<T> i = expl.iterator();
        while (i.hasNext()) {
            Value value = (Value)i.next();
            sb.append(((Variable)value.variable()).getName() + "=" + value.getName());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private void checkExpl(Assignment<V, T> assignment, Set<T> expl) {
        sLogger.debug("    -- checking explanation: " + this.expl2str(expl));
        for (Value value : expl) {
            T current;
            if (value.equals(current = assignment.getValue(value.variable()))) continue;
            if (current == null) {
                sLogger.warn("      -- variable " + ((Variable)value.variable()).getName() + " unassigned");
                continue;
            }
            sLogger.warn("      -- variable " + ((Variable)value.variable()).getName() + " assigned to a different value " + ((Value)current).getName());
        }
    }

    private void printAssignments(Assignment<V, T> assignment) {
        sLogger.debug("    -- printing assignments: ");
        for (Variable variable : this.getModel().variables()) {
            T value = assignment.getValue(variable);
            if (value == null) continue;
            sLogger.debug("      -- " + variable.getName() + " = " + ((Value)value).getName());
        }
    }

    @Override
    public NoGood createAssignmentContext(Assignment<V, T> assignment) {
        return new NoGood(assignment);
    }

    public class NoGood
    implements AssignmentContext {
        private Map<V, Set<T>[]> iNoGood = new HashMap();
        private Map<V, Map<T, Set<T>>> iNoGoodVal = new HashMap();

        public NoGood(Assignment<V, T> assignment) {
            MacRevised.this.iProgress = Progress.getInstance(MacRevised.this.getModel());
            MacRevised.this.iProgress.save();
            MacRevised.this.iProgress.setPhase("Initializing propagation:", MacRevised.this.getModel().variables().size());
            for (Variable aVariable : MacRevised.this.getModel().variables()) {
                this.supportValues(aVariable).clear();
                this.goodValues(aVariable).clear();
            }
            ArrayList<Value> queue = new ArrayList<Value>();
            for (Variable aVariable : MacRevised.this.getModel().variables()) {
                for (Value aValue : aVariable.values(assignment)) {
                    this.initNoGood(aValue, null);
                    this.goodValues(aVariable).add(aValue);
                    Object current = assignment.getValue(aVariable);
                    if (this.revise(assignment, aValue)) {
                        queue.add(aValue);
                        continue;
                    }
                    if (current == null || aValue.equals(current)) continue;
                    HashSet noGood = new HashSet();
                    noGood.add(current);
                    this.setNoGood(aValue, noGood);
                    queue.add(aValue);
                }
                MacRevised.this.iProgress.incProgress();
            }
            this.propagate(assignment, queue);
            MacRevised.this.iProgress.restore();
        }

        public Set<T>[] getNoGood(V variable) {
            return this.iNoGood.get(variable);
        }

        public void setNoGood(V variable, Set<T>[] noGood) {
            if (noGood == null) {
                this.iNoGood.remove(variable);
            } else {
                this.iNoGood.put((Set<T>[])variable, noGood);
            }
        }

        public Set<T> getNoGood(T value) {
            Map ng = this.iNoGoodVal.get(((Value)value).variable());
            if (ng == null) {
                return null;
            }
            return ng.get(value);
        }

        public void setNoGood(T value, Set<T> noGood) {
            Map ng = this.iNoGoodVal.get(((Value)value).variable());
            if (ng == null) {
                ng = new HashMap();
                this.iNoGoodVal.put((Map)((Value)value).variable(), ng);
            }
            if (noGood == null) {
                ng.remove(value);
            } else {
                ng.put(value, noGood);
            }
        }

        private Set<T> supportValues(V variable) {
            Set<T>[] ret = this.getNoGood((V)variable);
            if (ret == null) {
                ret = new Set[]{new HashSet(1000), new HashSet()};
                this.setNoGood(variable, ret);
            }
            return ret[0];
        }

        public Set<T> goodValues(V variable) {
            Set<T>[] ret = this.getNoGood((V)variable);
            if (ret == null) {
                ret = new Set[]{new HashSet(1000), new HashSet()};
                this.setNoGood(variable, ret);
            }
            return ret[1];
        }

        private void goodnessChanged(T value) {
            if (this.isGood(value)) {
                this.goodValues(((Value)value).variable()).add(value);
            } else {
                this.goodValues(((Value)value).variable()).remove(value);
            }
        }

        private void removeSupport(V variable, T value) {
            this.supportValues(variable).remove(value);
        }

        private void addSupport(V variable, T value) {
            this.supportValues(variable).add(value);
        }

        public Set<T> noGood(T value) {
            return this.getNoGood((T)value);
        }

        public boolean isGood(T value) {
            return this.getNoGood((T)value) == null;
        }

        protected void setGood(T value) {
            sLogger.debug("    -- set good " + ((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName());
            Set noGood = this.noGood(value);
            if (noGood != null) {
                for (Value v : noGood) {
                    this.removeSupport(v.variable(), value);
                }
            }
            this.setNoGood(value, (Set<T>)null);
            this.goodnessChanged(value);
        }

        private void initNoGood(T value, Set<T> reason) {
            this.setNoGood(value, reason);
        }

        public void propagate(Assignment<V, T> assignment, List<T> queue) {
            int idx = 0;
            while (queue.size() > idx) {
                Value value = (Value)queue.get(idx++);
                sLogger.debug("  -- propagate " + ((Variable)value.variable()).getName() + " = " + value.getName() + " (noGood:" + this.noGood(value) + ")");
                if (this.goodValues(value.variable()).isEmpty()) {
                    sLogger.info("Empty domain detected for variable " + ((Variable)value.variable()).getName());
                    continue;
                }
                for (Constraint constraint : ((Variable)value.variable()).hardConstraints()) {
                    if (!MacRevised.this.contains(constraint)) continue;
                    this.propagate(assignment, constraint, value, queue);
                }
            }
        }

        public void propagate(Assignment<V, T> assignment, Constraint<V, T> constraint, T noGoodValue, List<T> queue) {
            for (Variable aVariable : constraint.variables()) {
                if (aVariable.equals(((Value)noGoodValue).variable())) continue;
                for (Value aValue : aVariable.values(assignment)) {
                    if (!this.isGood(aValue) || !constraint.isConsistent((Value)noGoodValue, aValue) || this.hasSupport(assignment, constraint, aValue, ((Value)noGoodValue).variable())) continue;
                    this.setNoGood(aValue, this.explanation(assignment, constraint, aValue, ((Value)noGoodValue).variable()));
                    queue.add(aValue);
                }
            }
        }

        public boolean revise(Assignment<V, T> assignment, T value) {
            sLogger.debug("  -- revise " + ((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName());
            for (Constraint constraint : ((Variable)((Value)value).variable()).hardConstraints()) {
                if (!MacRevised.this.contains(constraint) || !this.revise(assignment, constraint, value)) continue;
                return true;
            }
            return false;
        }

        public boolean revise(Assignment<V, T> assignment, Constraint<V, T> constraint, T value) {
            for (Variable aVariable : constraint.variables()) {
                if (aVariable.equals(((Value)value).variable()) || this.hasSupport(assignment, constraint, value, aVariable)) continue;
                this.setNoGood(value, this.explanation(assignment, constraint, value, aVariable));
                return true;
            }
            return false;
        }

        public Set<T> explanation(Assignment<V, T> assignment, Constraint<V, T> constraint, T value, V variable) {
            HashSet expl = new HashSet();
            for (Value aValue : ((Variable)variable).values(assignment)) {
                if (!constraint.isConsistent(aValue, (Value)value)) continue;
                expl.addAll(this.noGood(aValue));
            }
            return expl;
        }

        public Set<T> supports(Assignment<V, T> assignment, Constraint<V, T> constraint, T value, V variable) {
            HashSet<Value> sup = new HashSet<Value>();
            for (Value aValue : ((Variable)variable).values(assignment)) {
                if (!this.isGood(aValue) || !constraint.isConsistent(aValue, (Value)value)) continue;
                sup.add(aValue);
            }
            return sup;
        }

        public boolean hasSupport(Assignment<V, T> assignment, Constraint<V, T> constraint, T value, V variable) {
            for (Value aValue : ((Variable)variable).values(assignment)) {
                if (!this.isGood(aValue) || !constraint.isConsistent(aValue, (Value)value)) continue;
                return true;
            }
            return false;
        }

        public void setNoGood(Assignment<V, T> assignment, T value, Set<T> reason) {
            Set noGood;
            sLogger.debug("    -- set nogood " + ((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName() + "(expl:" + MacRevised.this.expl2str(reason) + ")");
            if (((Value)value).equals(assignment.getValue(((Value)value).variable()))) {
                try {
                    throw new Exception("An assigned value " + ((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName() + " become no good (noGood:" + reason + ")!!");
                }
                catch (Exception e) {
                    sLogger.warn(e.getMessage(), (Throwable)e);
                    MacRevised.this.checkExpl(assignment, reason);
                    MacRevised.this.printAssignments(assignment);
                }
            }
            if ((noGood = this.noGood(value)) != null) {
                for (Value v : noGood) {
                    this.removeSupport(v.variable(), value);
                }
            }
            this.setNoGood(value, reason);
            for (Value aValue : reason) {
                this.addSupport(aValue.variable(), value);
            }
            this.goodnessChanged(value);
        }
    }
}

