/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.rpp;

import org.cpsolver.ifs.example.rpp.Rectangle;
import org.cpsolver.ifs.model.Value;

public class Location
extends Value<Rectangle, Location> {
    private int iX;
    private int iY;

    public Location(Rectangle rectangle, int x, int y) {
        super(rectangle);
        this.iX = x;
        this.iY = y;
    }

    public int getX() {
        return this.iX;
    }

    public int getY() {
        return this.iY;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof Location)) {
            return false;
        }
        Location location = (Location)object;
        return ((Rectangle)this.variable()).equals(location.variable()) && location.getX() == this.getX() && location.getY() == this.getY();
    }

    @Override
    public String toString() {
        return ((Rectangle)this.variable()).getName() + "=[" + this.getX() + "," + this.getY() + "]";
    }

    @Override
    public String getName() {
        return "[" + this.getX() + "," + this.getY() + "]";
    }

    public boolean hasIntersection(Location anotherLocation) {
        if (this.getX() + ((Rectangle)this.variable()).getWidth() <= anotherLocation.getX()) {
            return false;
        }
        if (this.getY() + ((Rectangle)this.variable()).getHeight() <= anotherLocation.getY()) {
            return false;
        }
        if (anotherLocation.getX() + ((Rectangle)anotherLocation.variable()).getWidth() <= this.getX()) {
            return false;
        }
        return anotherLocation.getY() + ((Rectangle)anotherLocation.variable()).getHeight() > this.getY();
    }
}

