/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.assignment.context;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.AssignmentContextHelper;
import org.cpsolver.ifs.assignment.context.AssignmentContextReference;
import org.cpsolver.ifs.assignment.context.CanHoldContext;
import org.cpsolver.ifs.assignment.context.HasAssignmentContext;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;

public abstract class ExtensionWithContext<V extends Variable<V, T>, T extends Value<V, T>, C extends AssignmentContext>
extends Extension<V, T>
implements HasAssignmentContext<V, T, C>,
CanHoldContext {
    private AssignmentContextReference<V, T, C> iContextReference = null;
    private AssignmentContext[] iContext = new AssignmentContext[17];

    public ExtensionWithContext(Solver<V, T> solver, DataProperties properties) {
        super(solver, properties);
    }

    @Override
    public boolean init(Solver<V, T> solver) {
        this.iContextReference = solver.currentSolution().getModel().createReference(this);
        return super.init(solver);
    }

    @Override
    public C getContext(Assignment<V, T> assignment) {
        return AssignmentContextHelper.getContext(this, assignment);
    }

    @Override
    public AssignmentContextReference<V, T, C> getAssignmentContextReference() {
        return this.iContextReference;
    }

    @Override
    public void setAssignmentContextReference(AssignmentContextReference<V, T, C> reference) {
        this.iContextReference = reference;
    }

    @Override
    public AssignmentContext[] getContext() {
        return this.iContext;
    }

    @Override
    public void unregister(Model<V, T> model) {
        model.removeReference(this);
        super.unregister(model);
    }
}

