/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.assignment;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentAbstract;
import org.cpsolver.ifs.assignment.context.AssignmentContextHolder;
import org.cpsolver.ifs.assignment.context.DefaultParallelAssignmentContextHolder;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;

public class DefaultParallelAssignment<V extends Variable<V, T>, T extends Value<V, T>>
extends AssignmentAbstract<V, T> {
    private Map<V, Long> iAssignedVariables = new HashMap<V, Long>();
    private int iIndex;

    public DefaultParallelAssignment(int threadIndex) {
        super(new DefaultParallelAssignmentContextHolder(threadIndex));
        this.iIndex = threadIndex;
    }

    public DefaultParallelAssignment() {
        this(0);
    }

    public DefaultParallelAssignment(int threadIndex, Model<V, T> model, Assignment<V, T> assignment) {
        this(threadIndex);
        for (Variable variable : model.variables()) {
            this.setValueInternal(0L, variable, assignment != null ? (T)assignment.getValue(variable) : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultParallelAssignment(AssignmentContextHolder<V, T> contexts, int threadIndex, Solution<V, T> solution) {
        super(contexts);
        this.iIndex = threadIndex;
        Lock lock = solution.getLock().readLock();
        lock.lock();
        try {
            for (Variable variable : solution.getModel().variables()) {
                this.setValueInternal(0L, variable, solution.getAssignment().getValue(variable));
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public long getIteration(V variable) {
        Long it = this.iAssignedVariables.get(variable);
        return it == null ? 0L : it;
    }

    @Override
    public Collection<V> assignedVariables() {
        return this.iAssignedVariables.keySet();
    }

    @Override
    protected T getValueInternal(V variable) {
        return (T)((Variable)variable).getAssignments()[this.iIndex];
    }

    @Override
    protected void setValueInternal(long iteration, V variable, T value) {
        ((Variable)variable).getAssignments()[this.iIndex] = value;
        if (value == null) {
            this.iAssignedVariables.remove(variable);
        } else {
            this.iAssignedVariables.put((Long)variable, iteration);
        }
    }

    @Override
    public int getIndex() {
        return this.iIndex;
    }
}

