/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.assignment;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentAbstract;
import org.cpsolver.ifs.assignment.context.AssignmentContextHolder;
import org.cpsolver.ifs.assignment.context.AssignmentContextHolderMap;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public class AssignmentMap<V extends Variable<V, T>, T extends Value<V, T>>
extends AssignmentAbstract<V, T> {
    private Map<V, T> iAssignments = new LinkedHashMap<V, T>();
    private Map<V, Long> iIteration = new HashMap<V, Long>();

    public AssignmentMap(AssignmentContextHolder<V, T> contexts) {
        super(contexts);
    }

    public AssignmentMap() {
        this(new AssignmentContextHolderMap());
    }

    public AssignmentMap(Assignment<V, T> assignment) {
        super(new AssignmentContextHolderMap());
        for (Value value : assignment.assignedValues()) {
            this.iAssignments.put((Value)value.variable(), (T)value);
        }
    }

    @Override
    public long getIteration(V variable) {
        Long it = this.iIteration.get(variable);
        return it == null ? 0L : it;
    }

    @Override
    public Collection<V> assignedVariables() {
        return this.iAssignments.keySet();
    }

    @Override
    public Collection<T> assignedValues() {
        return this.iAssignments.values();
    }

    @Override
    public int nrAssignedVariables() {
        return this.iAssignments.size();
    }

    @Override
    protected T getValueInternal(V variable) {
        return (T)((Value)this.iAssignments.get(variable));
    }

    @Override
    protected void setValueInternal(long iteration, V variable, T value) {
        if (value == null) {
            this.iAssignments.remove(variable);
            this.iIteration.remove(variable);
        } else {
            this.iAssignments.put(variable, value);
            if (iteration > 0L) {
                this.iIteration.put((Long)variable, iteration);
            }
        }
    }
}

