/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.assignment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.cpsolver.ifs.assignment.AssignmentAbstract;
import org.cpsolver.ifs.assignment.context.AssignmentContextHolder;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public class AssignmentArray<V extends Variable<V, T>, T extends Value<V, T>>
extends AssignmentAbstract<V, T> {
    protected Object[] iAssignments = new Object[1000];
    protected Long[] iIteration = new Long[1000];

    public AssignmentArray(AssignmentContextHolder<V, T> contexts) {
        super(contexts);
    }

    @Override
    public long getIteration(V variable) {
        try {
            Long it = this.iIteration[((Variable)variable).getIndex()];
            return it == null ? 0L : it;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0L;
        }
    }

    @Override
    protected T getValueInternal(V variable) {
        try {
            return (T)((Value)this.iAssignments[((Variable)variable).getIndex()]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    protected void setValueInternal(long iteration, V variable, T value) {
        if (this.iAssignments.length <= ((Variable)variable).getIndex()) {
            this.iAssignments = Arrays.copyOf(this.iAssignments, ((Variable)variable).getIndex() + 1000);
            this.iIteration = Arrays.copyOf(this.iIteration, ((Variable)variable).getIndex() + 1000);
        }
        if (value == null) {
            this.iAssignments[((Variable)variable).getIndex()] = null;
            this.iIteration[((Variable)variable).getIndex()] = null;
        } else {
            this.iAssignments[((Variable)variable).getIndex()] = value;
            if (iteration > 0L) {
                this.iIteration[((Variable)variable).getIndex()] = iteration;
            }
        }
    }

    @Override
    public Collection<V> assignedVariables() {
        ArrayList variables = new ArrayList(this.iAssignments.length);
        for (Object value : this.iAssignments) {
            if (value == null) continue;
            variables.add(((Value)value).variable());
        }
        return variables;
    }

    @Override
    public Collection<T> assignedValues() {
        ArrayList<Value> values = new ArrayList<Value>(this.iAssignments.length);
        for (Object value : this.iAssignments) {
            if (value == null) continue;
            values.add((Value)value);
        }
        return values;
    }

    @Override
    public int nrAssignedVariables() {
        int ret = 0;
        for (Object value : this.iAssignments) {
            if (value == null) continue;
            ++ret;
        }
        return ret;
    }
}

