/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.neighbours;

import java.util.ArrayList;
import java.util.Set;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.neighbours.ExamRoomSwapNeighbour;
import org.cpsolver.exam.neighbours.ExamSimpleNeighbour;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class ExamRoomMove
implements NeighbourSelection<Exam, ExamPlacement> {
    private boolean iCheckStudentConflicts = false;
    private boolean iCheckDistributionConstraints = true;

    public ExamRoomMove(DataProperties properties) {
        this.iCheckStudentConflicts = properties.getPropertyBoolean("ExamRoomMove.CheckStudentConflicts", this.iCheckStudentConflicts);
        this.iCheckDistributionConstraints = properties.getPropertyBoolean("ExamRoomMove.CheckDistributionConstraints", this.iCheckDistributionConstraints);
    }

    @Override
    public void init(Solver<Exam, ExamPlacement> solver) {
    }

    @Override
    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        Set<ExamRoomPlacement> rooms;
        ExamPeriodPlacement period;
        ExamModel model = (ExamModel)solution.getModel();
        Assignment<Exam, ExamPlacement> assignment = solution.getAssignment();
        Exam exam = (Exam)ToolBox.random(model.variables());
        if (exam.getMaxRooms() <= 0) {
            return null;
        }
        ExamPlacement placement = assignment.getValue(exam);
        ExamPeriodPlacement examPeriodPlacement = period = placement != null ? placement.getPeriodPlacement() : ToolBox.random(exam.getPeriodPlacements());
        if (this.iCheckStudentConflicts && placement == null && exam.countStudentConflicts(assignment, period) > 0) {
            return null;
        }
        if (this.iCheckDistributionConstraints && placement == null && !exam.checkDistributionConstraints(assignment, period)) {
            return null;
        }
        Set<ExamRoomPlacement> set = rooms = placement != null ? placement.getRoomPlacements() : exam.findBestAvailableRooms(assignment, period);
        if (rooms == null || rooms.isEmpty()) {
            return null;
        }
        if (placement == null) {
            placement = new ExamPlacement(exam, period, rooms);
        }
        ArrayList<ExamRoomPlacement> roomVect = new ArrayList<ExamRoomPlacement>(rooms);
        int rx = ToolBox.random(roomVect.size());
        for (int r = 0; r < roomVect.size(); ++r) {
            ExamRoomPlacement current = (ExamRoomPlacement)roomVect.get((r + rx) % roomVect.size());
            int mx = ToolBox.random(exam.getRoomPlacements().size());
            for (int m = 0; m < exam.getRoomPlacements().size(); ++m) {
                ExamRoomPlacement swap = exam.getRoomPlacements().get((m + mx) % exam.getRoomPlacements().size());
                ExamRoomSwapNeighbour n = new ExamRoomSwapNeighbour(assignment, placement, current, swap);
                if (!n.canDo()) continue;
                return n;
            }
        }
        rooms = exam.findRoomsRandom(assignment, period);
        if (rooms == null) {
            return null;
        }
        return new ExamSimpleNeighbour(assignment, new ExamPlacement(exam, period, rooms));
    }
}

